robust.boot              package:GeneTS              R Documentation

_R_o_b_u_s_t _E_r_r_o_r _R_e_s_i_s_t_a_n_t _B_o_o_t_s_t_r_a_p _A_l_g_o_r_i_t_h_m

_D_e_s_c_r_i_p_t_i_o_n:

     'robust.boot' generates ordinary nonparametric bootstrap
     replicates. If an error occurs during the function evaluation
     (e.g., due to numerical problems) the bootstrap draw is repeated. 

     'robust.boot' offers only very limited bootstrap support, for much
     more advanced bootstrapping methods use 'boot'.

_U_s_a_g_e:

     robust.boot(data, statistic, R)

_A_r_g_u_m_e_n_t_s:

    data: data matrix or data frame (each row is considered as one
          multivariate observation)

statistic: A function which when applied to data returns a vector
          containing the statistic(s) of interest

       R: number of bootstrap replicates

_D_e_t_a_i_l_s:

     'robust.boot' is used in the functions 'bagged.cov', 'bagged.cov',
     and 'bagged.pcor'.

_V_a_l_u_e:

     A list with one component: 

       t: a matrix with 'R' rows each of which is a bootstrap replicate
          of 'statistic'.

_A_u_t_h_o_r(_s):

     Korbinian Strimmer (<URL:
     http://www.stat.uni-muenchen.de/~strimmer/>).

_S_e_e _A_l_s_o:

     'boot', 'bagged.pcor'.

_E_x_a_m_p_l_e_s:

     # load GeneTS library
     library(GeneTS)

     # small example data set 
     data(caulobacter)
     dat <- caulobacter[,1:15]
     dim(dat)

     # test statistic: vector of means 
     test.fun <- function(data, i)
     {
       res <- apply(data[i,], 2, mean) 
       if (runif(1) < .01) stop("Error!") # in 1 percent of cases an error occurs ... 
       return(res)
     }

     # perform bootstrap
     b.out <- robust.boot(dat, test.fun, 1000)

     # despite the errors bootstrapping has finished
     dim(b.out$t)

     # bootstrap means
     bag <- apply(b.out$t, 2, mean)
     bag

