### Name: stam.predict
### Title: Predict Classifications of New Data
### Aliases: stam.predict
### Keywords: classif

### ** Examples

## Don't show: 
  library(vsn)
  library(golubEsets)
  data(golubMerge)
  golubNorm <- vsn(golubMerge, describe.preprocessing=FALSE)
## End Don't show
# load and prepare data
golubTest <- golubNorm[,39:72]
data(golubTrain.fit)

# compute predictions
golubTest.pred <- stam.predict(golubTrain.fit, golubTest, 
                               pData(golubTest)[,"ALL.AML"])
golubMerge.pred <- stam.predict(golubTrain.fit, golubNorm, 
                                pData(golubNorm)[,"ALL.AML"], testset=39:72)

# further investigate
print(golubTest.pred)
plot(golubTest.pred)
## Not run: 
##D map <- image(golubMerge.pred, outfile="golubMerge")
##D cat("<HTML><BODY><MAP NAME='image_map'>", map, "</MAP>",
##D     "<IMG SRC='golubMerge_pred_img.png' USEMAP='#image_map'></BODY></HTML>\n", 
##D     file="pred_img.html")
##D browseURL(paste("file://", getwd(), "/pred_img.html", sep=""))
## End(Not run)


