### Name: find.a0
### Title: Computation of the Fudge Factor
### Aliases: find.a0
### Keywords: htest

### ** Examples
## Not run: 
##D     library(multtest)
##D     # Load the data of Golub et al. (1999). data(golub) contains
##D     # a 3051x38 gene expression matrix called golub, a vector of
##D     # length called golub.cl that consists of the 38 class labels,
##D     # and a matrix called golub.gnames whose third column contains
##D     # the gene names.
##D     data(golub)
##D     
##D     # Now the optimal value for the fudge factor a0 is computed,
##D     # where possible values of the a0 are 0 and the 0, 0.05 and
##D     # 0.1 quantile of the standard deviations of the genes. 
##D     # Setting rand=123 makes the results reproducible.
##D     
##D     find.out<-find.a0(golub,golub.cl,alpha=c(0,0.05,0.1),rand=123)
## End(Not run)


