### Name: hexbin
### Title: bivariate binning into hexagon cells
### Aliases: hexbin
### Keywords: dplot

### ** Examples

x <- rnorm(10000)
y <- rnorm(10000)
bin <- hexbin(x,y)

## Using plot method for hexbin objects:
plot(bin, style = "nested.lattice")

## lower resolution binning and overplotting with counts
bin <- hexbin(x,y,xbins=25)
screenpar <- plot.hexbin(bin, style="lattice", minarea=1, maxarea=1,
                   density=0, border=TRUE)
oldpar <- par(screenpar)     # reset graphics to the plot on the screen
xy <- hcell2xy(bin)
text(xy$x,xy$y,as.character(bin$cnt),adj=.5,cex=.3)
points(x,y)       # to show points rather than counts
par(oldpar)       #reset graphics

## Use (and 'check') IDs:
bin3 <- hexbin(x, y, IDs = TRUE)
tb <- table(bin3$cell.id)
stopifnot(bin3$cnt  == c(tb),
          bin3$cell == rownames(tb))



