### Name: clusterAnnotationChromosome-abp-class
### Title: Class "clusterAnnotationChromosome-abp", prepares the chromosome
###   annotation for subsequent statistical analysis.
### Aliases: clusterAnnotationChromosome-abp-class
###   config,clusterAnnotationChromosome-abp-method
###   execute,clusterAnnotationChromosome-abp-method
###   reset,clusterAnnotationChromosome-abp-method
###   setup<-,clusterAnnotationChromosome-abp-method
###   setup,clusterAnnotationChromosome-abp-method
### Keywords: classes

### ** Examples

## Predefined setup for goCluster
data(benomylsetup)

## Setup a new goCluster object
test <- new("goCluster")
setup(test) <- benomylsetup

## We only use the dataset from this object
data <- test@data

## The predefined configuration is set to retrieve the
## gene ontology information. We need to exchange this
## with chromosome annotation
anno <- new("clusterAnnotationChromosome-abp")
setup(anno) <- list(meta = "YEAST",
                    chromosomes = as.character(seq(1:16)),
                    trueid = "")
data@anno <- anno

## Get the annotation to the dataset
testAnnotation <- execute(data@anno, test)




