/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.QuantitationType;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioAssay.Channel;
import org.biomage.BioAssayData.QuantitationTypeMap;
import org.biomage.Common.Identifiable;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasChannel;
import org.biomage.Interface.HasConfidenceIndicators;
import org.biomage.Interface.HasDataType;
import org.biomage.Interface.HasQuantitationTypeMaps;
import org.biomage.Interface.HasScale;
import org.biomage.QuantitationType.ConfidenceIndicator;
import org.xml.sax.Attributes;

public abstract class QuantitationType
extends Identifiable
implements Serializable,
HasChannel,
HasQuantitationTypeMaps,
HasDataType,
HasScale,
HasConfidenceIndicators {
    Boolean isBackground;
    protected Channel channel;
    protected OntologyEntry scale;
    protected OntologyEntry dataType;
    protected HasConfidenceIndicators.ConfidenceIndicators_list confidenceIndicators = new HasConfidenceIndicators.ConfidenceIndicators_list();
    protected HasQuantitationTypeMaps.QuantitationTypeMaps_list quantitationTypeMaps = new HasQuantitationTypeMaps.QuantitationTypeMaps_list();

    public QuantitationType() {
    }

    public QuantitationType(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "isBackground");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.isBackground = new Boolean(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.isBackground != null) {
            out.write(" isBackground=\"" + this.isBackground + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.channel != null) {
            out.write("<Channel_assnref>");
            out.write("<" + this.channel.getModelClassName() + "_ref identifier=\"" + this.channel.getIdentifier() + "\"/>");
            out.write("</Channel_assnref>");
        }
        if (this.scale != null) {
            out.write("<Scale_assn>");
            this.scale.writeMAGEML(out);
            out.write("</Scale_assn>");
        }
        if (this.dataType != null) {
            out.write("<DataType_assn>");
            this.dataType.writeMAGEML(out);
            out.write("</DataType_assn>");
        }
        if (this.confidenceIndicators.size() > 0) {
            out.write("<ConfidenceIndicators_assnreflist>");
            for (i = 0; i < this.confidenceIndicators.size(); ++i) {
                modelClassName = ((ConfidenceIndicator)this.confidenceIndicators.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((ConfidenceIndicator)this.confidenceIndicators.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</ConfidenceIndicators_assnreflist>");
        }
        if (this.quantitationTypeMaps.size() > 0) {
            out.write("<QuantitationTypeMaps_assnreflist>");
            for (i = 0; i < this.quantitationTypeMaps.size(); ++i) {
                modelClassName = ((QuantitationTypeMap)this.quantitationTypeMaps.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((QuantitationTypeMap)this.quantitationTypeMaps.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</QuantitationTypeMaps_assnreflist>");
        }
    }

    public void setIsBackground(Boolean isBackground) {
        this.isBackground = isBackground;
    }

    public Boolean getIsBackground() {
        return this.isBackground;
    }

    public String getModelClassName() {
        return new String("QuantitationType");
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setScale(OntologyEntry scale) {
        this.scale = scale;
    }

    public OntologyEntry getScale() {
        return this.scale;
    }

    public void setDataType(OntologyEntry dataType) {
        this.dataType = dataType;
    }

    public OntologyEntry getDataType() {
        return this.dataType;
    }

    public void setConfidenceIndicators(HasConfidenceIndicators.ConfidenceIndicators_list confidenceIndicators) {
        this.confidenceIndicators = confidenceIndicators;
    }

    public HasConfidenceIndicators.ConfidenceIndicators_list getConfidenceIndicators() {
        return this.confidenceIndicators;
    }

    public void addToConfidenceIndicators(ConfidenceIndicator confidenceIndicator) {
        this.confidenceIndicators.add(confidenceIndicator);
    }

    public void addToConfidenceIndicators(int position, ConfidenceIndicator confidenceIndicator) {
        this.confidenceIndicators.add(position, confidenceIndicator);
    }

    public ConfidenceIndicator getFromConfidenceIndicators(int position) {
        return (ConfidenceIndicator)this.confidenceIndicators.get(position);
    }

    public void removeElementAtFromConfidenceIndicators(int position) {
        this.confidenceIndicators.removeElementAt(position);
    }

    public void removeFromConfidenceIndicators(ConfidenceIndicator confidenceIndicator) {
        this.confidenceIndicators.remove(confidenceIndicator);
    }

    public void setQuantitationTypeMaps(HasQuantitationTypeMaps.QuantitationTypeMaps_list quantitationTypeMaps) {
        this.quantitationTypeMaps = quantitationTypeMaps;
    }

    public HasQuantitationTypeMaps.QuantitationTypeMaps_list getQuantitationTypeMaps() {
        return this.quantitationTypeMaps;
    }

    public void addToQuantitationTypeMaps(QuantitationTypeMap quantitationTypeMap) {
        this.quantitationTypeMaps.add(quantitationTypeMap);
    }

    public void addToQuantitationTypeMaps(int position, QuantitationTypeMap quantitationTypeMap) {
        this.quantitationTypeMaps.add(position, quantitationTypeMap);
    }

    public QuantitationTypeMap getFromQuantitationTypeMaps(int position) {
        return (QuantitationTypeMap)this.quantitationTypeMaps.get(position);
    }

    public void removeElementAtFromQuantitationTypeMaps(int position) {
        this.quantitationTypeMaps.removeElementAt(position);
    }

    public void removeFromQuantitationTypeMaps(QuantitationTypeMap quantitationTypeMap) {
        this.quantitationTypeMaps.remove(quantitationTypeMap);
    }
}

