/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Description;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Common.Extendable;
import org.biomage.Description.DatabaseEntry;
import org.biomage.Interface.HasAssociations;
import org.biomage.Interface.HasOntologyReference;
import org.xml.sax.Attributes;

public class OntologyEntry
extends Extendable
implements Serializable,
HasOntologyReference,
HasAssociations {
    String category;
    String value;
    String description;
    protected DatabaseEntry ontologyReference;
    protected HasAssociations.Associations_list associations = new HasAssociations.Associations_list();

    public OntologyEntry() {
    }

    public OntologyEntry(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "category");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.category = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "value")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.value = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "description")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.description = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<OntologyEntry");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</OntologyEntry>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.category != null) {
            out.write(" category=\"" + this.category + "\"");
        }
        if (this.value != null) {
            out.write(" value=\"" + this.value + "\"");
        }
        if (this.description != null) {
            out.write(" description=\"" + this.description + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.ontologyReference != null) {
            out.write("<OntologyReference_assn>");
            this.ontologyReference.writeMAGEML(out);
            out.write("</OntologyReference_assn>");
        }
        if (this.associations.size() > 0) {
            out.write("<Associations_assnlist>");
            for (int i = 0; i < this.associations.size(); ++i) {
                ((OntologyEntry)this.associations.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Associations_assnlist>");
        }
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModelClassName() {
        return new String("OntologyEntry");
    }

    public void setOntologyReference(DatabaseEntry ontologyReference) {
        this.ontologyReference = ontologyReference;
    }

    public DatabaseEntry getOntologyReference() {
        return this.ontologyReference;
    }

    public void setAssociations(HasAssociations.Associations_list associations) {
        this.associations = associations;
    }

    public HasAssociations.Associations_list getAssociations() {
        return this.associations;
    }

    public void addToAssociations(OntologyEntry ontologyEntry) {
        this.associations.add(ontologyEntry);
    }

    public void addToAssociations(int position, OntologyEntry ontologyEntry) {
        this.associations.add(position, ontologyEntry);
    }

    public OntologyEntry getFromAssociations(int position) {
        return (OntologyEntry)this.associations.get(position);
    }

    public void removeElementAtFromAssociations(int position) {
        this.associations.removeElementAt(position);
    }

    public void removeFromAssociations(OntologyEntry ontologyEntry) {
        this.associations.remove(ontologyEntry);
    }
}

