/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Description;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.Common.Identifiable;
import org.biomage.Interface.HasContacts;
import org.xml.sax.Attributes;

public class Database
extends Identifiable
implements Serializable,
HasContacts {
    String version;
    String URI;
    protected HasContacts.Contacts_list contacts = new HasContacts.Contacts_list();

    public Database() {
    }

    public Database(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "version");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.version = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "URI")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.URI = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Database");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Database>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.version != null) {
            out.write(" version=\"" + this.version + "\"");
        }
        if (this.URI != null) {
            out.write(" URI=\"" + this.URI + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.contacts.size() > 0) {
            out.write("<Contacts_assnreflist>");
            for (int i = 0; i < this.contacts.size(); ++i) {
                String modelClassName = ((Contact)this.contacts.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Contact)this.contacts.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Contacts_assnreflist>");
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public String getURI() {
        return this.URI;
    }

    public String getModelClassName() {
        return new String("Database");
    }

    public void setContacts(HasContacts.Contacts_list contacts) {
        this.contacts = contacts;
    }

    public HasContacts.Contacts_list getContacts() {
        return this.contacts;
    }

    public void addToContacts(Contact contact) {
        this.contacts.add(contact);
    }

    public void addToContacts(int position, Contact contact) {
        this.contacts.add(position, contact);
    }

    public Contact getFromContacts(int position) {
        return (Contact)this.contacts.get(position);
    }

    public void removeElementAtFromContacts(int position) {
        this.contacts.removeElementAt(position);
    }

    public void removeFromContacts(Contact contact) {
        this.contacts.remove(contact);
    }
}

