/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioMaterial;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioEvent.BioEvent;
import org.biomage.BioMaterial.BioMaterialMeasurement;
import org.biomage.BioMaterial.CompoundMeasurement;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasAction;
import org.biomage.Interface.HasActionMeasurement;
import org.biomage.Interface.HasCompoundMeasurements;
import org.biomage.Interface.HasSourceBioMaterialMeasurements;
import org.biomage.Measurement.Measurement;
import org.xml.sax.Attributes;

public class Treatment
extends BioEvent
implements Serializable,
HasCompoundMeasurements,
HasSourceBioMaterialMeasurements,
HasActionMeasurement,
HasAction {
    Integer order;
    protected OntologyEntry action;
    protected Measurement actionMeasurement;
    protected HasCompoundMeasurements.CompoundMeasurements_list compoundMeasurements = new HasCompoundMeasurements.CompoundMeasurements_list();
    protected HasSourceBioMaterialMeasurements.SourceBioMaterialMeasurements_list sourceBioMaterialMeasurements = new HasSourceBioMaterialMeasurements.SourceBioMaterialMeasurements_list();

    public Treatment() {
    }

    public Treatment(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "order");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.order = new Integer(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Treatment");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Treatment>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.order != null) {
            out.write(" order=\"" + this.order + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.action != null) {
            out.write("<Action_assn>");
            this.action.writeMAGEML(out);
            out.write("</Action_assn>");
        }
        if (this.actionMeasurement != null) {
            out.write("<ActionMeasurement_assn>");
            this.actionMeasurement.writeMAGEML(out);
            out.write("</ActionMeasurement_assn>");
        }
        if (this.compoundMeasurements.size() > 0) {
            out.write("<CompoundMeasurements_assnlist>");
            for (i = 0; i < this.compoundMeasurements.size(); ++i) {
                ((CompoundMeasurement)this.compoundMeasurements.elementAt(i)).writeMAGEML(out);
            }
            out.write("</CompoundMeasurements_assnlist>");
        }
        if (this.sourceBioMaterialMeasurements.size() > 0) {
            out.write("<SourceBioMaterialMeasurements_assnlist>");
            for (i = 0; i < this.sourceBioMaterialMeasurements.size(); ++i) {
                ((BioMaterialMeasurement)this.sourceBioMaterialMeasurements.elementAt(i)).writeMAGEML(out);
            }
            out.write("</SourceBioMaterialMeasurements_assnlist>");
        }
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getModelClassName() {
        return new String("Treatment");
    }

    public void setAction(OntologyEntry action) {
        this.action = action;
    }

    public OntologyEntry getAction() {
        return this.action;
    }

    public void setActionMeasurement(Measurement actionMeasurement) {
        this.actionMeasurement = actionMeasurement;
    }

    public Measurement getActionMeasurement() {
        return this.actionMeasurement;
    }

    public void setCompoundMeasurements(HasCompoundMeasurements.CompoundMeasurements_list compoundMeasurements) {
        this.compoundMeasurements = compoundMeasurements;
    }

    public HasCompoundMeasurements.CompoundMeasurements_list getCompoundMeasurements() {
        return this.compoundMeasurements;
    }

    public void addToCompoundMeasurements(CompoundMeasurement compoundMeasurement) {
        this.compoundMeasurements.add(compoundMeasurement);
    }

    public void addToCompoundMeasurements(int position, CompoundMeasurement compoundMeasurement) {
        this.compoundMeasurements.add(position, compoundMeasurement);
    }

    public CompoundMeasurement getFromCompoundMeasurements(int position) {
        return (CompoundMeasurement)this.compoundMeasurements.get(position);
    }

    public void removeElementAtFromCompoundMeasurements(int position) {
        this.compoundMeasurements.removeElementAt(position);
    }

    public void removeFromCompoundMeasurements(CompoundMeasurement compoundMeasurement) {
        this.compoundMeasurements.remove(compoundMeasurement);
    }

    public void setSourceBioMaterialMeasurements(HasSourceBioMaterialMeasurements.SourceBioMaterialMeasurements_list sourceBioMaterialMeasurements) {
        this.sourceBioMaterialMeasurements = sourceBioMaterialMeasurements;
    }

    public HasSourceBioMaterialMeasurements.SourceBioMaterialMeasurements_list getSourceBioMaterialMeasurements() {
        return this.sourceBioMaterialMeasurements;
    }

    public void addToSourceBioMaterialMeasurements(BioMaterialMeasurement bioMaterialMeasurement) {
        this.sourceBioMaterialMeasurements.add(bioMaterialMeasurement);
    }

    public void addToSourceBioMaterialMeasurements(int position, BioMaterialMeasurement bioMaterialMeasurement) {
        this.sourceBioMaterialMeasurements.add(position, bioMaterialMeasurement);
    }

    public BioMaterialMeasurement getFromSourceBioMaterialMeasurements(int position) {
        return (BioMaterialMeasurement)this.sourceBioMaterialMeasurements.get(position);
    }

    public void removeElementAtFromSourceBioMaterialMeasurements(int position) {
        this.sourceBioMaterialMeasurements.removeElementAt(position);
    }

    public void removeFromSourceBioMaterialMeasurements(BioMaterialMeasurement bioMaterialMeasurement) {
        this.sourceBioMaterialMeasurements.remove(bioMaterialMeasurement);
    }
}

