/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioAssay;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioAssay.Channel;
import org.biomage.Common.Identifiable;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasChannels;
import org.biomage.Interface.HasFormat;
import org.xml.sax.Attributes;

public class Image
extends Identifiable
implements Serializable,
HasChannels,
HasFormat {
    String URI;
    protected HasChannels.Channels_list channels = new HasChannels.Channels_list();
    protected OntologyEntry format;

    public Image() {
    }

    public Image(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "URI");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.URI = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Image");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Image>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.URI != null) {
            out.write(" URI=\"" + this.URI + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.channels.size() > 0) {
            out.write("<Channels_assnreflist>");
            for (int i = 0; i < this.channels.size(); ++i) {
                String modelClassName = ((Channel)this.channels.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Channel)this.channels.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Channels_assnreflist>");
        }
        if (this.format != null) {
            out.write("<Format_assn>");
            this.format.writeMAGEML(out);
            out.write("</Format_assn>");
        }
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public String getURI() {
        return this.URI;
    }

    public String getModelClassName() {
        return new String("Image");
    }

    public void setChannels(HasChannels.Channels_list channels) {
        this.channels = channels;
    }

    public HasChannels.Channels_list getChannels() {
        return this.channels;
    }

    public void addToChannels(Channel channel) {
        this.channels.add(channel);
    }

    public void addToChannels(int position, Channel channel) {
        this.channels.add(position, channel);
    }

    public Channel getFromChannels(int position) {
        return (Channel)this.channels.get(position);
    }

    public void removeElementAtFromChannels(int position) {
        this.channels.removeElementAt(position);
    }

    public void removeFromChannels(Channel channel) {
        this.channels.remove(channel);
    }

    public void setFormat(OntologyEntry format) {
        this.format = format;
    }

    public OntologyEntry getFormat() {
        return this.format;
    }
}

