/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.text.CollationKey;
import java.text.Collator;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;

public abstract class NodeSortRecord {
    public static int COMPARE_STRING = 0;
    public static int COMPARE_NUMERIC = 1;
    public static int COMPARE_ASCENDING = 0;
    public static int COMPARE_DESCENDING = 1;
    protected static Collator _collator = Collator.getInstance();
    protected int _levels = 1;
    protected int[] _compareType;
    protected int[] _sortOrder;
    private AbstractTranslet _translet = null;
    private DOM _dom = null;
    private int _node;
    private int _last = 0;
    private int _scanned = 0;
    private Object[] _values;

    public NodeSortRecord(int node) {
        this._node = node;
    }

    public NodeSortRecord() {
        this(0);
    }

    public final void initialize(int node, int last, DOM dom, AbstractTranslet translet, int[] order, int[] type) {
        this._dom = dom;
        this._node = node;
        this._last = last;
        this._translet = translet;
        this._scanned = 0;
        this._levels = order.length;
        this._sortOrder = order;
        this._compareType = type;
        this._values = new Object[this._levels];
    }

    public final int getNode() {
        return this._node;
    }

    public final int compareDocOrder(NodeSortRecord other) {
        return this._node - other._node;
    }

    private final CollationKey stringValue(int level) {
        if (this._scanned <= level) {
            String str = this.extractValueFromDOM(this._dom, this._node, level, this._translet, this._last);
            CollationKey key = _collator.getCollationKey(str);
            this._values[this._scanned++] = key;
            return key;
        }
        return (CollationKey)this._values[level];
    }

    private final Double numericValue(int level) {
        if (this._scanned <= level) {
            Double num;
            String str = this.extractValueFromDOM(this._dom, this._node, level, this._translet, this._last);
            try {
                num = new Double(str);
            }
            catch (NumberFormatException e) {
                num = new Double(Double.NEGATIVE_INFINITY);
            }
            this._values[this._scanned++] = num;
            return num;
        }
        return (Double)this._values[level];
    }

    public int compareTo(NodeSortRecord other) {
        int level = 0;
        while (level < this._levels) {
            int cmp;
            Comparable<Double> their;
            Comparable<Double> our;
            if (this._compareType[level] == COMPARE_NUMERIC) {
                our = this.numericValue(level);
                their = other.numericValue(level);
                cmp = ((Double)our).compareTo((Double)their);
            } else {
                our = this.stringValue(level);
                their = other.stringValue(level);
                cmp = ((CollationKey)our).compareTo((CollationKey)their);
            }
            if (cmp != 0) {
                return this._sortOrder[level] == COMPARE_DESCENDING ? 0 - cmp : cmp;
            }
            ++level;
        }
        return this._node - other._node;
    }

    public Collator getCollator() {
        return _collator;
    }

    public abstract String extractValueFromDOM(DOM var1, int var2, int var3, AbstractTranslet var4, int var5);
}

