/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import java.util.Stack;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMBuilderFilter;
import org.w3c.dom.ls.DOMEntityResolver;
import org.w3c.dom.ls.DOMInputSource;

public class DOMBuilderImpl
extends AbstractDOMParser
implements DOMBuilder,
DOMConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String PSVI_AUGMENT = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected String fSchemaType = null;
    protected static final boolean DEBUG = false;

    public void reset() {
        super.reset();
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fRejectedElement.clear();
        this.fFilterReject = false;
        this.fSchemaType = null;
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    public DOMBuilderImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.IntegratedParserConfiguration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
    }

    public DOMBuilderImpl(XMLParserConfiguration config) {
        super(config);
        String[] domRecognizedFeatures = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "supported-mediatypes-only", "certified"};
        this.fConfiguration.addRecognizedFeatures(domRecognizedFeatures);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("cdata-sections", true);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("infoset", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("supported-mediatypes-only", false);
        this.fConfiguration.setFeature("certified", true);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
    }

    public DOMBuilderFilter getFilter() {
        return this.fDOMFilter;
    }

    public void setFilter(DOMBuilderFilter filter) {
        this.fDOMFilter = filter;
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equals("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("datatype-normalization")) {
            return this.fConfiguration.getFeature(NORMALIZE_DATA) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("whitespace-in-element-content")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("namespace-declarations") || name.equals("cdata-sections") || name.equals("canonical-form") || name.equals("supported-mediatypes-only") || name.equals("infoset") || name.equals("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(name) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("error-handler")) {
            if (this.fErrorHandler != null) {
                return this.fErrorHandler.getErrorHandler();
            }
            return null;
        }
        if (name.equals("entity-resolver")) {
            try {
                XMLEntityResolver entityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
                if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                    return ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
                }
                return null;
            }
            catch (XMLConfigurationException e) {}
        } else {
            if (name.equals("schema-type")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            }
            if (name.equals("schema-location")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaSource");
            }
            if (name.equals(SYMBOL_TABLE)) {
                return this.fConfiguration.getProperty(SYMBOL_TABLE);
            }
            if (name.equals("http://apache.org/xml/properties/dom/document-class-name")) {
                return this.fConfiguration.getProperty("http://apache.org/xml/properties/dom/document-class-name");
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value == Boolean.TRUE || value == Boolean.FALSE) {
            boolean state = value == Boolean.TRUE;
            try {
                if (name.equals("comments")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", state);
                    return;
                }
                if (name.equals("datatype-normalization")) {
                    this.fConfiguration.setFeature(NORMALIZE_DATA, state);
                    return;
                }
                if (name.equals("entities")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", state);
                    return;
                }
                if (name.equals("infoset") || name.equals("supported-mediatypes-only") || name.equals("canonical-form")) {
                    if (!state) return;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                if (name.equals("namespaces")) {
                    this.fConfiguration.setFeature(NAMESPACES, state);
                    return;
                }
                if (name.equals("cdata-sections") || name.equals("namespace-declarations")) {
                    if (state) return;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                if (name.equals("validate")) {
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, state);
                    if (this.fSchemaType != Constants.NS_DTD) {
                        this.fConfiguration.setFeature(XMLSCHEMA, state);
                    }
                    if (!state) return;
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    return;
                }
                if (name.equals("validate-if-schema")) {
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, state);
                    if (!state) return;
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, false);
                    return;
                }
                if (name.equals("whitespace-in-element-content")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", state);
                    return;
                }
                if (name.equals("psvi")) {
                    this.fConfiguration.setFeature(PSVI_AUGMENT, true);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.PSVIDocumentImpl");
                    return;
                }
                this.fConfiguration.setFeature(name, state);
                return;
            }
            catch (XMLConfigurationException e) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
                throw new DOMException(8, msg);
            }
        }
        if (name.equals("error-handler")) {
            if (value instanceof DOMErrorHandler) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)value);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("entity-resolver")) {
            if (value instanceof DOMEntityResolver) {
                try {
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper((DOMEntityResolver)value));
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("schema-location")) {
            if (value instanceof String) {
                try {
                    if (this.fSchemaType != Constants.NS_XMLSCHEMA) {
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                        throw new DOMException(9, msg);
                    }
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", value);
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("schema-type")) {
            if (value instanceof String) {
                try {
                    if (value.equals(Constants.NS_XMLSCHEMA)) {
                        this.fConfiguration.setFeature(XMLSCHEMA, true);
                        this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
                        this.fSchemaType = Constants.NS_XMLSCHEMA;
                        return;
                    }
                    if (!value.equals(Constants.NS_DTD)) return;
                    this.fConfiguration.setFeature(XMLSCHEMA, false);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                    this.fSchemaType = Constants.NS_DTD;
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("http://apache.org/xml/properties/dom/document-class-name")) {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", value);
            return;
        } else {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
    }

    public boolean canSetParameter(String name, Object value) {
        if (value == Boolean.TRUE || value == Boolean.FALSE) {
            boolean state;
            boolean bl = state = value == Boolean.TRUE;
            if (name.equals("infoset") || name.equals("supported-mediatypes-only") || name.equals("canonical-form")) {
                return !state;
            }
            if (name.equals("cdata-sections") || name.equals("namespace-declarations")) {
                return state;
            }
            if (name.equals("charset-overrides-xml-encoding") || name.equals("comments") || name.equals("datatype-normalization") || name.equals("entities") || name.equals("namespaces") || name.equals("validate") || name.equals("validate-if-schema") || name.equals("whitespace-in-element-content")) {
                return true;
            }
            try {
                this.fConfiguration.getFeature(name);
                return true;
            }
            catch (XMLConfigurationException e) {
                return false;
            }
        }
        if (name.equals("error-handler")) {
            return value instanceof DOMErrorHandler;
        }
        if (name.equals("entity-resolver")) {
            return value instanceof DOMEntityResolver;
        }
        if (name.equals("schema-type")) {
            return value instanceof String && (value.equals(Constants.NS_XMLSCHEMA) || value.equals(Constants.NS_DTD));
        }
        if (name.equals("schema-location")) {
            return value instanceof String;
        }
        return name.equals("http://apache.org/xml/properties/dom/document-class-name");
    }

    public DOMBuilderImpl(String configuration, String schemaType) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", configuration));
        if (schemaType != null) {
            if (schemaType.equals(Constants.NS_DTD)) {
                this.fConfiguration.setFeature(XMLSCHEMA, false);
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
            } else if (schemaType.equals(Constants.NS_XMLSCHEMA)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
            }
        }
    }

    public DOMBuilderImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.StandardParserConfiguration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
    }

    XMLInputSource dom2xmlInputSource(DOMInputSource is) {
        XMLInputSource xis = null;
        xis = is.getStringData() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16") : (is.getCharacterStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16") : (is.getByteStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding()) : new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI())));
        return xis;
    }

    public Document parseURI(String uri) {
        block2: {
            XMLInputSource source = new XMLInputSource(null, uri, null);
            try {
                this.parse(source);
            }
            catch (Exception e) {
                if (this.fErrorHandler == null) break block2;
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = (short)2;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
        }
        return this.getDocument();
    }

    public Document parse(DOMInputSource is) {
        block2: {
            XMLInputSource xmlInputSource = this.dom2xmlInputSource(is);
            try {
                this.parse(xmlInputSource);
            }
            catch (Exception e) {
                if (this.fErrorHandler == null) break block2;
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = (short)2;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
        }
        return this.getDocument();
    }

    public void parseWithContext(DOMInputSource is, Node cnode, short action) throws DOMException {
        throw new DOMException(9, "Not supported");
    }
}

