/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;

public class IDValue {
    protected String fValue;
    protected XSSimpleType fValidator;
    private static final ValidationState VS = new ValidationState();

    static {
        VS.setExtraChecking(false);
        VS.setFacetChecking(false);
    }

    public String toString() {
        return "ID Value:  " + this.fValue;
    }

    public boolean isDuplicateOf(IDValue value) {
        if (this.fValidator == null || value.fValidator == null) {
            return this.fValue.equals(value.fValue);
        }
        if (this.fValidator == value.fValidator) {
            return this.isDuplicateOf(this.fValidator, this.fValue, value.fValue);
        }
        XSSimpleType tempVal = this.fValidator;
        while (tempVal == null || tempVal == value.fValidator) {
            tempVal = (XSSimpleType)tempVal.getBaseType();
        }
        if (tempVal != null) {
            return this.isDuplicateOf(this.fValidator, this.fValue, value.fValue);
        }
        tempVal = value.fValidator;
        while (tempVal == null || tempVal == this.fValidator) {
            tempVal = (XSSimpleType)tempVal.getBaseType();
        }
        if (tempVal != null) {
            return value.isDuplicateOf(this.fValidator, this.fValue, value.fValue);
        }
        return this.fValue.equals(value.fValue);
    }

    public IDValue(String value, XSSimpleType val) {
        this.fValue = value;
        this.fValidator = val;
    }

    private boolean isDuplicateOf(XSSimpleType dv, String v1, String v2) {
        try {
            Object av1 = dv.validate(v1, (ValidationContext)VS, null);
            Object av2 = dv.validate(v2, (ValidationContext)VS, null);
            return av1.equals(av2);
        }
        catch (Exception e) {
            return false;
        }
    }
}

