/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAttributeDeclaration;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSModel;
import org.apache.xerces.impl.xs.psvi.XSModelGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItemList;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.NSItemListImpl;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.XMLSymbols;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 14;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private SymbolHash[] fTables;

    public XSModelImpl(SchemaGrammar[] grammars) {
        int len = grammars.length;
        this.fNamespaces = new String[Math.max(len + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(len + 1, 5)];
        boolean hasS4S = false;
        int i = 0;
        while (i < len) {
            this.fNamespaces[i] = grammars[i].getTargetNamespace();
            this.fGrammarList[i] = grammars[i];
            if (this.fNamespaces[i] == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
                hasS4S = true;
            }
            ++i;
        }
        if (!hasS4S) {
            this.fNamespaces[len] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[len++] = SchemaGrammar.SG_SchemaNS;
        }
        int i2 = 0;
        while (i2 < len) {
            SchemaGrammar sg1 = this.fGrammarList[i2];
            Vector gs = sg1.getImportedGrammars();
            int j = gs == null ? -1 : gs.size() - 1;
            while (j >= 0) {
                SchemaGrammar sg2 = (SchemaGrammar)gs.elementAt(j);
                int k = 0;
                while (k < len) {
                    if (sg2 == this.fGrammarList[k]) break;
                    ++k;
                }
                if (k == len) {
                    if (len == this.fGrammarList.length) {
                        String[] newSA = new String[len * 2];
                        System.arraycopy(this.fNamespaces, 0, newSA, 0, len);
                        this.fNamespaces = newSA;
                        SchemaGrammar[] newGA = new SchemaGrammar[len * 2];
                        System.arraycopy(this.fGrammarList, 0, newGA, 0, len);
                        this.fGrammarList = newGA;
                    }
                    this.fNamespaces[len] = sg2.getTargetNamespace();
                    this.fGrammarList[len] = sg2;
                    ++len;
                }
                --j;
            }
            ++i2;
        }
        this.fGrammarMap = new SymbolHash(len * 2);
        i2 = 0;
        while (i2 < len) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[i2]), this.fGrammarList[i2]);
            ++i2;
        }
        this.fGrammarCount = len;
        this.fGlobalComponents = new XSNamedMap[15];
        this.fNSComponents = new XSNamedMap[len][15];
        this.fTables = new SymbolHash[this.fGrammarCount];
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short objectType) {
        if (objectType <= 0 || objectType > 14 || !GLOBAL_COMP[objectType]) {
            return null;
        }
        if (this.fGlobalComponents[objectType] == null) {
            int i = 0;
            while (i < this.fGrammarCount) {
                switch (objectType) {
                    case 3: 
                    case 13: 
                    case 14: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalTypeDecls;
                        break;
                    }
                    case 1: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalAttrDecls;
                        break;
                    }
                    case 2: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalElemDecls;
                        break;
                    }
                    case 5: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalAttrGrpDecls;
                        break;
                    }
                    case 6: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalGroupDecls;
                        break;
                    }
                    case 11: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalNotationDecls;
                    }
                }
                ++i;
            }
            this.fGlobalComponents[objectType] = objectType == 13 || objectType == 14 ? new XSNamedMap4Types(this.fNamespaces, this.fTables, this.fGrammarCount, objectType) : new XSNamedMapImpl(this.fNamespaces, this.fTables, this.fGrammarCount);
        }
        return this.fGlobalComponents[objectType];
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public XSObjectList getAnnotations() {
        return null;
    }

    private static final String null2EmptyString(String str) {
        return str == null ? XMLSymbols.EMPTY_STRING : str;
    }

    public synchronized XSNamedMap getComponentsByNamespace(short objectType, String namespace) {
        if (objectType <= 0 || objectType > 14 || !GLOBAL_COMP[objectType]) {
            return null;
        }
        int i = 0;
        while (i < this.fGrammarCount) {
            if (this.fNamespaces[i] == namespace) break;
            ++i;
        }
        if (i == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[i][objectType] == null) {
            SymbolHash table = null;
            switch (objectType) {
                case 3: 
                case 13: 
                case 14: {
                    table = this.fGrammarList[i].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    table = this.fGrammarList[i].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    table = this.fGrammarList[i].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    table = this.fGrammarList[i].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    table = this.fGrammarList[i].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    table = this.fGrammarList[i].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[i][objectType] = objectType == 13 || objectType == 14 ? new XSNamedMap4Types(namespace, table, objectType) : new XSNamedMapImpl(namespace, table);
        }
        return this.fNSComponents[i][objectType];
    }

    public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeDeclaration)sg.fGlobalAttrDecls.get(name);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)sg.fGlobalAttrGrpDecls.get(name);
    }

    public XSElementDeclaration getElementDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSElementDeclaration)sg.fGlobalElemDecls.get(name);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSModelGroupDefinition)sg.fGlobalGroupDecls.get(name);
    }

    public XSNotationDeclaration getNotationDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSNotationDeclaration)sg.fGlobalNotationDecls.get(name);
    }

    public XSTypeDefinition getTypeDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSTypeDefinition)sg.fGlobalTypeDecls.get(name);
    }
}

