### Name: mergeCor
### Title: Class mergeCor, a class for storing data relevant to integrative
###   correlation coefficients.
### Aliases: mergeCor-class mergeCor cors pairwise.cors integrative.cors
###   cors,mergeCor-method pairwise.cors,mergeCor-method
###   integrative.cors,mergeCor-method plot,mergeCor-method
###   hist,mergeCor-method plot,list-method
### Keywords: classes

### ** Examples

  
  data(mergeData)
  merged  <- mergeExprs(sample1,sample2,sample3)
  intcor3  <-intCor(merged,method="pearson")
  plot(intcor3)
  intcor2  <-intCor(merged[1:2],method="kendall")
  plot(intcor2,pch=4,col=5)

  cors(intcor2)
  pairwise.cors(intcor3)
  integrative.cors(intcor3)
  integrative.cors(intcor2)["Hs.12101"]
  



