### Name: hem.fdr
### Title: FDR Evaluation
### Aliases: hem.fdr
### Keywords: models

### ** Examples


data(pbrain)

##construct a design matrix
cond <- c(1,1,1,1,1,1,2,2,2,2,2,2)
ind  <- c(1,1,2,2,3,3,1,1,2,2,3,3)
rep  <- c(1,2,1,2,1,2,1,2,1,2,1,2)
design <- data.frame(cond,ind,rep)

##normalization
pbrain.nor <- hem.preproc(pbrain[,2:13])

##take a subset for a testing purpose;
##use all genes for a practical purpose
pbrain.nor <- pbrain.nor[1:1000,]

##estimate hyperparameters of variances by LPE
pbrain.eb  <- hem.eb.prior(pbrain.nor, n.layer=2,  design=design,
                           method.var.e="neb", method.var.b="peb")     

##fit HEM with two layers of error
##using the small numbers of burn-ins and MCMC samples for a testing purpose;
##but increase the numbers for a practical purpose 
pbrain.hem <- hem(pbrain.nor, n.layer=2,  design=design,burn.ins=10, n.samples=30, 
              method.var.e="neb", method.var.b="peb", 
              var.e=pbrain.eb$var.e, var.b=pbrain.eb$var.b)

##Estimate FDR based on resampling 
pbrain.fdr <- hem.fdr(pbrain.nor, n.layer=2,  design=design, 
                  hem.out=pbrain.hem, eb.out=pbrain.eb)




