### Name: chrBreakpoints
### Title: Chromosomal breakpoints detection
### Aliases: chrBreakpoints chrBreakpoints.profileCGH


### ** Examples


data(snijders)
profileCGH <- list(profileValues=gm13330)
class(profileCGH) <- "profileCGH"


# Estimation of the piecewise constant function

res <- chrBreakpoints(profileCGH, smoothfunc="laws",
                      lkern="exponential", model="Gaussian",
                      qlambda=0.999, base=FALSE,bandwidth=10)

plot(LogRatio ~ PosOrder, data=res$profileValues, pch=20)


# Limit between chromosomes

LimitChr <- unique(res$profileValues$LimitChr)+0.5
abline(v=LimitChr, col="grey", lty=2)

lines(res$profileValues$Smoothing ~ res$profileValues$PosOrder, col="green")


# Breakpoints identified

indexBP <- which(res$profileValues$Breakpoints==1)
BP <- res$profileValues$PosOrder[indexBP]+0.5
abline(v=BP, col="red", lty=2)





