\name{#PKGNAME#UNIGENE}
\alias{#PKGNAME#UNIGENE}
\title{Mappings between probe identifiers and UniGene cluster identifiers}
\description{
  NCBI partitions sequences submitted to GenBank into non-redundant sets
  of clusters. Each cluster contains sequences that represent a unique
  gene and is assigned a unique UniGene id. #PKGNAME#UNIGENE maps probe
  identifiers to UniGene cluster identifiers for genes represented by
  the probe ids 
}
\details{
  A UniGene id represents a cluster of sequences of a gene. Using
  UniGene ids one can query the UniGene database for information about
  the sequences or the LocusLink database for information about the
  genes.  
  
  Mappings were based on data provided by:

  #LLSOURCE#

  Package built #DATE#
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/LocusLink}
}
\examples{
    # Convert the environment to a list
    xx <- as.list(#PKGNAME#UNIGENE)
    # Remove probe ids that do no map to any UniGene id
    xx <- xx[!is.null(xx)]
    if(length(xx) > 0){
        # The UniGene ids for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
    }
}

\keyword{datasets}

