\name{basicPW-class}
\docType{class}
\alias{basicPW-class}
\alias{wHeight<-}
\alias{wHeight}
\alias{wNotify<-}
\alias{wNotify}
\alias{wType<-}
\alias{wType}
\alias{wValue<-}
\alias{wValue}
\alias{wPostFun}
\alias{wPostFun<-}
\alias{wPreFun}
\alias{wPreFun<-}
\alias{wView<-}
\alias{wView}
\alias{wWidth<-}
\alias{wWidth}
\alias{wEnv}
\alias{wEnv<-}
\alias{wFuns}
\alias{wName}
\alias{wPreFun}
\alias{wPostFun<-}
\alias{wFuns<-}
\alias{wName<-}
\alias{wHeight<-,basicPW-method}
\alias{wHeight,basicPW-method}
\alias{wNotify<-,basicPW-method}
\alias{wNotify,basicPW-method}
\alias{wType<-,basicPW-method}
\alias{wType,basicPW-method}
\alias{wValue<-,basicPW-method}
\alias{wValue,basicPW-method}
\alias{wPostFun,basicPW-method}
\alias{wPreFun<-,basicPW-method}
\alias{wView<-,basicPW-method}
\alias{wView,basicPW-method}
\alias{wWidth<-,basicPW-method}
\alias{wWidth,basicPW-method}
\alias{wEnv,basicPW-method}
\alias{wFuns,basicPW-method}
\alias{wName,basicPW-method}
\alias{wPreFun,basicPW-method}
\alias{wPostFun<-,basicPW-method}
\alias{wFuns<-,basicPW-method}
\alias{wName<-,basicPW-method}
\alias{wEnv<-,basicPW-method}
\title{Class "basicPW", a basic class for primary widgets}
\description{This class defines the behavior shared by primary widget
  object used to build a GUI type interface}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("basicPW", ...)}.
    Constructors have been defined to create objects of this class for
    specific widgets such as buttons, list boxes, .. 
}
\section{Slots}{
  \describe{
    \item{\code{wName}:}{Object of class \code{"character"} - a string
      for the name of the object}
    \item{\code{wType}:}{Object of class \code{"character"} - a string
      defining the type of the primary widget. (e.g. button)}
    \item{\code{wValue}:}{Object of class \code{"ANY"} - the initial
      value to be associated with the object}
    \item{\code{wWidth}:}{Object of class \code{"numeric"} - an integer
      for the width of the object to be rendered (if applicable)}
    \item{\code{wHeight}:}{Object of class \code{"numeric"} - an integer
      for the height of the object to be rendered (if applicable)}
    \item{\code{wFuns}:}{Object of class \code{"list"} - a list of R
      functions to be executed before the widget is activated}
    \item{\code{wPreFun}:}{Object of class \code{"function"} - a list of
      functions to be executed before the value of the widget to be updated}
    \item{\code{wPostFun}:}{Object of class \code{"function"} - a list of
      functions to be executed before the value of the widget to be retrieved}
    \item{\code{wNotify}:}{Object of class \code{"list"} - a list of
      functions to be executed each time when the value of the widget changes}
    \item{\code{wEnv}:}{Object of class \code{"environment"} - an R
      environment object within which the value of the object is stored}
    \item{\code{wView}:}{Object of class \code{"widgetView"} - a object
      of the class widgetView to which the widget is rendered}
  }
}

\section{Methods}{
  \describe{
    \item{wEnv<-}{\code{signature(object = "basicPW")}: Set the value for
      wEnv slot}
    \item{wEnv}{\code{signature(object = "basicPW")}: Get the value for
      wEnv slot }
    \item{wFuns<-}{\code{signature(object = "basicPW")}: Set the value
      for wFuns slot}
    \item{wFuns}{\code{signature(object = "basicPW")}: Get the value for
      wFuns slot}
    \item{wHeight<-}{\code{signature(object = "basicPW")}: Set the value
      for wHeight slot}
    \item{wHeight}{\code{signature(object = "basicPW")}: Get the value
      for wHeight slot}
    \item{wName<-}{\code{signature(object = "basicPW")}: Set the value
      for wName slot}
    \item{wName}{\code{signature(object = "basicPW")}: Get the value for
      wName slot}
    \item{wNotify<-}{\code{signature(object = "basicPW")}: Set the value
      for wNotify slot}
    \item{wNotify}{\code{signature(object = "basicPW")}: Get the value
      for wNotify slot}
    \item{wPostFun<-}{\code{signature(object = "basicPW")}: Set the value
      for wPostFun slot} 
    \item{wPostFun}{\code{signature(object = "basicPW")}: Get the value
      for wPostFun slot}
    \item{wPreFun<-}{\code{signature(object = "basicPW")}: Set the value
      for wPreFun slot}
    \item{wPreFun}{\code{signature(object = "basicPW")}: Get the value
      for wPreFun slot}
    \item{wType<-}{\code{signature(object = "basicPW")}: Set the value
      for wType slot}
    \item{wType}{\code{signature(object = "basicPW")}: Get the value for
      wType slot}
    \item{wValue<-}{\code{signature(object = "basicPW")}: Set the value
      for wValue slot}
    \item{wValue}{\code{signature(object = "basicPW")}: Get the value for
      wValue slot} 
    \item{wView<-}{\code{signature(object = "basicPW")}: Set the value
      for wView slot }
    \item{view}{\code{signature(object = "basicPW")}: Get the value for
      wView slot }
    \item{wWidth<-}{\code{signature(object = "basicPW")}: Set the value
      for wWidth slot }
    \item{wWidth}{\code{signature(object = "basicPW")}: Get the value for
      wWidth slot}
  }
}
\references{Programming with data }
\author{Jianhua Zhang}
\note{This class is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{widgetView-class}},\code{\link{widget-class}} }

\examples{
# Create an R environment to store the values of primary widgets
PWEnv <- new.env(hash = TRUE, parent = parent.frame(1))

# Create a label
label1 <- label(wName = "label1", wValue = "File Name: ", wEnv = PWEnv)

# Create an entry box with "Feed me using brows" as the default value
entry1 <- entryBox(wName = "entry1", wValue = "Feed me using browse",
                   wEnv = PWEnv)
}
\keyword{classes}

\eof
\name{button}
\alias{button}
\alias{entryBox}
\alias{textBox}
\alias{listBox}
\alias{checkButton}
\alias{radioButton}
\alias{label}
\alias{widget}
\alias{widgetView}
\title{Functions to construct objects of primary widgets and render them}
\description{
  All the primary widgets such as button, text box, and so on are
  objects of basicPW class. The functions are constructors of primary
  widgets that are subjects of basicPW class with behaviors specific to
  primary widgets.  
}
\usage{
button(wName, wEnv, wValue = "", wWidth = 12, wHeight = 0, wFuns = list(),
wNotify = list(), wPreFun = function(x) x, wPostFun = function(x) x,
wView = new("widgetView") )
entryBox(wName, wEnv, wValue = "", wWidth = 50, wHeight = 0, wFuns = list(),
wNotify = list(), wPreFun = function (x) x, wPostFun = function(x) x,
wView = new("widgetView"))
textBox(wName, wEnv, wValue = "", wWidth = 25, wHeight = 12, wFuns = list(),
wNotify = list(), wPreFun = function (x) x, wPostFun = function(x) x,
wView = new("widgetView"))
listBox(wName, wEnv, wValue = "", wWidth = 25, wHeight = 10, wFuns = list(),
wNotify = list(), wPreFun = function (x) x, wPostFun = function(x) x,
wView = new("widgetView"))
checkButton(wName, wEnv, wValue, wWidth = 50, wFuns = list(), wNotify =
list(), wPreFun = function (x) x, wPostFun = function(x) x,
wView = new("widgetView"))
radioButton(wName, wEnv, wValue, wWidth = 50, wFuns = list(), wNotify =
list(), wPreFun = function (x) x, wPostFun = function(x) x,
wView = new("widgetView"))
label(wName, wEnv, wValue = "", wWidth = 0, wHeight = 0, wFuns = list(),
wNotify = list(), wPreFun = function (x) x, wPostFun = function(x) x,
wView = new("widgetView"))
widget(wTitle, pWidgets, funs = list(), preFun = function()
print("Hello"), postFun = function() print("Bye"), env, defaultNames =c(
"Finish", "Cancel"))
widgetView(WVTitle, vName, widgetids = list(), theWidget = new("widget"),
winid)
}
\arguments{
  \item{wName}{\code{wName} a character string for the name to be
    associated with a given primary widget}
  \item{vName}{\code{vName} same as wName but for a widget object}
  \item{wEnv}{\code{wEnv} an R environment object within which the
    original values for each primary widget will be stored and updating
    and retrieval of the values will take place}
  \item{env}{\code{env} same as wEnv but for a widget object}
  \item{wValue}{\code{wValue} the initial values to be associated with a
    given primary widget}
  \item{wWidth}{\code{wWidth} an integer for the width of the primary
    widget (if applicable)} 
  \item{wHeight}{\code{wHeight} an integer for the height of the primary
    widget (if applicable)}
  \item{wFuns}{\code{wFuns} a list of R functions that will be
    associated with a primary widget and invoked when an operation
    (e.g. click, get focus, ...) is applied to the primary widget}
  \item{funs}{\code{funs} same as wFuns but for a widget object}
  \item{wNotify}{\code{wNotify} a list of functions defining the actions to
    be performed when the value of the primary widget changes}
  \item{wPreFun}{\code{wPreFun} an R function that should be applied when
    the widget is activated}
  \item{preFun}{\code{preFun} same as wPreFun but for a view}
  \item{wPostFun}{\code{wPostFun} an R function that will be applied when
    the widget is inactivated}
  \item{postFun}{\code{postFun} same as wPostFun but for a view}
  \item{wTitle}{\code{wTitle} a character string for the title to be
    displayed when the widget is rendered}
  \item{pWidgets}{\code{pWidget} a list of primary widgets (e.g. button,
    list box, ...) to be rendered}
  \item{WVTitle}{\code{WVTitle} same as wTitle}
  \item{widgetids}{\code{widgetids} a list of tkwin ids for the primary
    widgets to be rendered}
  \item{theWidget}{\code{theWidget} a \code{\link{widget}} object to
    render the primary widgets}
  \item{wView}{\code{wView} an object of class widgetView}
  \item{winid}{\code{winid} an object of class winid}
  \item{defaultNames}{\code{defaultName} a vector of character string of
    length two for the text to be shown on the two default buttons. The
    first is to end the process and the second to abort the process}
}
\details{
  \code{\link{button}} constructs a button widget object.
  
  \code{\link{button}} constructs an entry box widget object.
  
  \code{\link{textBox}} constructs a text box widget object.
  
  \code{\link{listBox}} constructs a list box widget object. Value for
  a listbox object should be a named vector with names being the content 
  to be shown in the list box and values being TRUE (default value) or
  FALSE.

  \code{\link{checkButton}} constructs a group of check box widget
  objects. Value for check button objects should be a named vector
  with names being the content to be shown in the list box and values
  being TRUE (checked) or FALSE (not checked). 

  \code{\link{radioButton}} constructs a group of radio button widget
  objects. Value for radio button objects should be a named vector
  with names being the content to be shown in the list box and values
  being TRUE (default) or FALSE.

  \code{\link{label}} constructs a text label widget object with the
  value displayed as the text.

  \code{\link{widget}} constructs a widget object to render the primary
  widgets.

  \code{\link{widgetView}} constructs a widgetView object. This class is
  for internal use by class \code{\link{widget-class}}. Users trying to
  create GUI type widget do not need to use this class.
}
\value{
  Each constructor returns a tkwin object for the primary widget object.
}
\references{R tcltk}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{widget-class}}, \code{\link{basicPW-class}}}
\examples{
# Create an R environment to store the values of primary widgets
PWEnv <- new.env(hash = TRUE, parent = parent.frame(1))

# Create a label
label1 <- label(wName = "label1", wValue = "File Name: ", wEnv = PWEnv)

# Create an entry box with "Feed me using brows" as the default value
entry1 <- entryBox(wName = "entry1", wValue = "Feed me using browse",
                   wEnv = PWEnv)

# Create a button that will call the function browse2Entry1 when
# pressed.
browse2Entry1 <- function(){
    tempValue <- tclvalue(tkgetOpenFile())
    temp <- get(wName(entry1), env = PWEnv)
    wValue(temp) <- paste(tempValue, sep = "", collapse = ";")
    assign(wName(entry1), temp, env = PWEnv)
}
button1 <- button(wName = "button1", wValue = "Browse",
                     wFuns = list(command = browse2Entry1), wEnv = PWEnv)

# Create a list box with "Option1", "Option2", and "Option3" as the
# content and "Option1" selected
list1 <- listBox(wName = "list1", wValue = c(Option1 = TRUE, Option2 = FALSE,
                                 Option3 = FALSE), wEnv = PWEnv)

# Create a text box with "Feed me something" displayed
text1 <- textBox(wName = "text1", wValue = "Feed me something",
                 wEnv = PWEnv)

# Create a set of radio buttons with "radio1" as the default
label2 <- label(wName = "label2", wValue = "Select one:  ", wEnv = PWEnv)
radios1 <- radioButton(wName = "radios1", wValue = c(radio1 = TRUE,
                       radio2 = FALSE, radio3 = FALSE), wEnv = PWEnv)

# Create a set of check boxes with "check1" selected and "check2" and
# "check3" not selected
label3 <- label(wName = "label3", wValue = "Select one to many: ",
wEnv = PWEnv)
checks1 <- checkButton(wName = "checks1", wValue = c(check1 = TRUE,
                       check22 = FALSE, check3 = FALSE), wEnv = PWEnv)

# Please not that the name of the primary widget object (e.g. checks1)
# should be the same as the value of the name slot of the object
# (e. g. name = "checks1")

# Render the widgets
pWidgets <- list(topRow = list(label1 = label1, entry1 = entry1,
                 button1 = button1), textRow = list(list1 = list1,
                 text1 = text1), radGroup = list(label2 = label2,
                 radios1 = radios1), chkGroup = list(label3 = label3,
                                     checks1 = checks1))
\dontrun{
## These cannot be run by examples() but should be OK when pasted
## into an interactive R session with the widgetTools package loaded

aWidget <- widget(wTitle = "A test widget", pWidgets, funs = list(),
                 preFun = function() print("Hello"),
                 postFun = function() print("Bye"), env = PWEnv)
} 
}
\keyword{interface}

\eof
\name{dropdownList}
\alias{dropdownList}
\alias{getListOption}
\title{A widget to mimic a dropdown list}
\description{
  The current tcltk library does not support dropdown lists unless an
  extension is included. The function dropdownList provide an alternative.
}
\usage{
dropdownList(base, options, textvariable, width = 10, default, editable
= FALSE)
getListOption(targetWidget, options, height, vScroll = FALSE)
}
\arguments{
  \item{base}{\code{base} a tkwin object that is the parent frame of the
    dropdown list to be created}
  \item{options}{\code{options} a vector of character strings for the
    content of the dropdown list}
  \item{textvariable}{\code{textvariable} a tclVar object to be
    associated with the selected item of the dropdown list}
  \item{width}{\code{width} an integer for the width in number of
    characters of the selection containing part of the dropdown list}
  \item{default}{\code{default} a character string for the default
    selection that is going to be shown in the selection containing
    window of the dropdown list}
  \item{targetWidget}{\code{targetWidget} a tkwin object for an entry
    box to which a button will be associated to make the look of a
    dropdown list}
  \item{editable}{\code{editable} a boolean indicating whether the
    dropdown list will be editable or not}
  \item{height}{\code{height} an integer for the height of the dropdown
    list box. If missing, height will be assigned the length of the
    options to be shown in the list box}
  \item{vScroll}{\code{vScroll} a boolean indicating whether a vertical
    scroll bar will be associated with the dropdown list box}
}
\details{
  \code{base} can be a top window or a frame.

  The widget returns a frame that contains a dropdown list. The frame
  need to be placed using any of the layout methods of tcltk. The value
  of the selection will be accessed through the tclVar object passed to
  the function.

  getListOptions is called by dropdown list to get the selected item
}
\value{
  dropdownList returns a tkwin object for the frame that contains a
  dropdown list

  getListOptions returns a character string for the selected item
}
\references{tcltk}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{tooltip}}}
\examples{
\dontrun{
    ## These cannot be run by examples() but should be OK when pasted
    ## into an interactive R session with the widgetTools package loaded
    
    base <- tktoplevel()
    selection <- tclVar()
    dropdownList(base, c("Option 1", "Option 2", "Option 3"),
          selection, 15, "Option 2")
    tclvalue(selection)
    # Destroy toplevel widget
    # tkdestroy(base)
}
}
\keyword{misc}


\eof
\name{makeViewer}
\alias{makeViewer}
\title{Put a Scrollable List Box into a tkWidget.}
\description{
  This function associates a tk listbox with a scroll bar and then puts
  them into a given tk widget.
}
\usage{
makeViewer(target, vWidth = "", vHeight = "", hScroll = FALSE,
vScroll = TRUE, what = "list", side = "left", text = "")
}

\arguments{
  \item{target}{tk widget that can accommodate a list box.}
  \item{vWidth, vHeight}{integers giving width and height of the listbox.}
  \item{hScroll, vScroll}{logicals indicating whether a horizontal or
    vertical scroll bar should be associated with the list box.}
  \item{what}{A character string indicating the type of the viewer to be
    put on a widget. Valid types include "list" for list box, "canvas",
    and "text" for text box}
  \item{side}{A character string for the geometry management of the
    viewer on the widget. Valid values include "left", "right", "top",
    and "bottom"}
  \item{text}{A character string to be displayed}
}
\details{
  Tk list boxes (or canvas, text box) and scroll bars are separate
  widgets. This function provides a common interface to put them
  together and functionally associated. 
}
\value{
  This function does not return any value.
}
\author{Jianhua (John) Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through \R.}

\seealso{\code{\link[tcltk]{tklistbox}} (from the \file{tcltk} package).
}
\examples{
\dontrun{
    ## These cannot be run by examples() but should be OK when pasted
    ## into an interactive R session with the widgetTools package loaded
    
    # Create a top level window and put a list box in it
    base <- tktoplevel()
    listBox <- makeViewer(base)

    # Destroy toplevel widget
    # tkdestroy(base)
 }
}
\keyword{interface}












\eof
\name{oneVScrList}
\alias{oneVScrList}
\title{A function that creates a groups of list boxes sharing a single
  vertical scroll bar}
\description{
  This function creates a group of list boxes what share a common
  vertical scroll bar. Values in all the list boxes scroll up or down
  when the scroll bar is dragged
}
\usage{
oneVScrList(base, data)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{base}{\code{base} a tkwin object that will be the container of
    the list boxes to be created}
  \item{data}{\code{data} a matrix with data to be put in the list boxes} 
}
\details{
  The matrix should have names for its columns. The names of the list
  boxes to be created will be the same as the corresponding columns of
  the matrix.

  Data in the list boxes can be sorted based on values in any of the
  list boxes.
}
\value{
  This function returns a list containing the tkwin objects of the list
  boxes created.
}
\references{tcltk}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{dropdownList}}, \code{\link{tooltip}}}
\examples{
    \dontrun{
        ## These cannot be run by examples() but should be OK when pasted
        ## into an interactive R session with the widgetTools package loaded
        
        testData <- matrix(c(1:50, 100:51), ncol = 2)
        colnames(testData) <- c("Column 1", "Column 2")
        base <- tktoplevel()
        tt <- oneVScrList(base, testData)

        # Destroy toplevel widget
        # tkdestroy(base)
    }
}
\keyword{interface}


\eof
\name{safeFileOpen}
\alias{safeFileOpen}
\title{A function that checks to see if a connection can be made to a
  given file}
\description{
  This function checks to see if a given file name exists. If so, the
  function returns a connection to the file. Otherwise, it returns
  "fileName doest exist".
}
\usage{
safeFileOpen(fileName)
}

\arguments{
  \item{fileName}{\code{fileName} a character string for the name of a
    file to which a connection is to be oppened}
}
\details{
  When this function is used, users have to make sure to check to see if
  the returnd object inherits object "connection". Otherwise, the file
  doest not exist or a connection has not be made. 
}
\value{
  The function returns a connection object that inherits class
  "connection" if the file exists and is opend. Otherwise, the string
  "fileName doest not exist"
}
\author{Jianhua Zhang}
\note{This function is no placed here to be used by various
  widgets. May be mored to a more suitable place later}

\seealso{\code{\link{file}}}
\examples{
write("A test file", "testFile4safeFileOpen")
tt <- safeFileOpen("testFile4safeFileOpen")
inherits(tt, "connection")
unlink("testFile4safeFileOpen")
tt <- safeFileOpen("testFile4safeFileOpen")
inherits(tt, "connection")
}
\keyword{file}

\eof
\name{tooltip}
\alias{tooltip}
\title{A tcltk widget to mimic a tooltip}
\description{
  Current tcltk library does not support tooltip unless an extension is
  included. The function tooltip is implemented as an alternative. 
}
\usage{
tooltip(text, targetWidget, width = 350)
}
\arguments{
  \item{text}{\code{text} a character string for the content of the tooltip}
  \item{targetWidget}{\code{targetWidget} a tkwin object for the target
    tcltk widget to which a tool tip will be associated}
  \item{width}{\code{width} an integer for the width (in pixels) of the
    tooltip} 
}
\details{
  Given a target tcltk widget, a tooltip will be associated with the
  widget. The content of the tooltip will be shown when mouse moves over
  the widget and disappear when mouse moves out of the widget.
}
\value{
  This function returns invisible()
}
\references{tcltk}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{dropdownList}}}
\examples{
\dontrun{
    ## These cannot be run by examples() but should be OK when pasted
    ## into an interactive R session with the widgetTools package loaded
    
    base <- tktoplevel()
    but <- tkbutton(base, text = "Move Mouse Over Me")
    tkpack(but)
    tkbind(but, "<Enter>", expression(tooltip("Move mouse off me", but)))

    # Destroy toplevel widget
    # tkdestroy(base)
}
}
\keyword{misc}



\eof
\name{widget-class}
\docType{class}
\alias{widget-class}
\alias{env<-}
\alias{funs<-}
\alias{funs}
\alias{postFuns<-}
\alias{postFun}
\alias{preFuns<-}
\alias{preFun}
\alias{pWidgets<-}
\alias{pWidgets}
\alias{updateCheck}
\alias{updateList}
\alias{updateRadio}
\alias{updateText}
\alias{wTitle<-}
\alias{wTitle}
\alias{env<-,widget-method}
\alias{funs<-,widget-method}
\alias{funs,widget-method}
\alias{postFuns<-,widget-method}
\alias{postFun,widget-method}
\alias{preFuns<-,widget-method}
\alias{preFun,widget-method}
\alias{wEnv,widget-method}
\alias{pWidgets<-,widget-method}
\alias{pWidgets,widget-method}
\alias{updateCheck,widget-method}
\alias{updateList,widget-method}
\alias{updateRadio,widget-method}
\alias{updateText,widget-method}
\alias{wTitle<-,widget-method}
\alias{wTitle,widget-method}
\title{Class "widget" creates a widget with primary widgets contained in
the list pWidgets rendered}
\description{This class takes a list of primary widgets and then creates a
  "widgetView" object that renders the primary widgets}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("widget", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{wTitle}:}{Object of class \code{"character"} - a
      character string for the title of the widget to be created}
    \item{\code{pWidgets}:}{Object of class \code{"list"} - a list of
      "basicPW" objects representing widget elements to be rendered}
    \item{\code{env}:}{Object of class \code{"environment"} - an R
      environment for the object to work within}
    \item{\code{funs}:}{Object of class \code{"list"} - a list of
      functions that will be associated with buttons on the widget to be
      rendered. The name of the function in the list will be the text
      appears on the button and the function will be executed when the
      button is pressed} 
    \item{\code{preFun}:}{Object of class \code{"function"} - a function
      that will be executed before the widget is constructed}
    \item{\code{postFun}:}{Object of class \code{"function"} - a function
      that will be executed before the widget is destroyed}
  }
}

\section{Methods}{
  \describe{
    \item{env<-}{\code{signature(object = "widget")}: set the value for env}
    \item{wEnv}{\code{signature(object = "widget")}: get the value for env}
    \item{funs<-}{\code{signature(object = "widget")}: set the value for
      funs}
    \item{funs}{\code{signature(object = "widget")}: get the value for funs}
    \item{postFuns<-}{\code{signature(object = "widget")}: set the value
      for postFuns}
    \item{postFun}{\code{signature(object = "widget")}: get the value
      for postFuns}
    \item{preFuns<-}{\code{signature(object = "widget")}: set the value
      for preFun}
    \item{preFun}{\code{signature(object = "widget")}: get the value for
      preFun}
    \item{pWidgets<-}{\code{signature(object = "widget")}: set the value
      for pWidgets}
    \item{pWidgets}{\code{signature(object = "widget")}: get the value
      for pWidgets}
    \item{updateCheck}{\code{signature(object = "widget")}: update the
      value of check buttons of the widget to be rendered}
    \item{updateList}{\code{signature(object = "widget")}: update the
      value of list box/entry of the widget to be rendered}
    \item{updateRadio}{\code{signature(object = "widget")}: update the
      value of radio buttons of the widget to be rendered}
    \item{updateText}{\code{signature(object = "widget")}: update the
      value of text box of the widget to be rendered}
    \item{wTitle<-}{\code{signature(object = "widget")}: set the value
      of wTitle}
    \item{wTitle}{\code{signature(object = "widget")}: get the value of
      wTitle} 
  }
}
\references{Programming with data}
\author{Jianhua Zhang}
\note{This class is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{basicPW-class}}, \code{\link{widgetView-class}} }

\examples{
PWEnv <- new.env(hash = TRUE, parent = parent.frame(1))

label1 <- label(wName = "label1", wValue = "File Name: ", wEnv = PWEnv)
entry1 <- entryBox(wName = "entry1", wValue = "Feed me using browse",
                   wEnv = PWEnv)
browse2Entry1 <- function(){
    tempValue <- fileBrowser()
    temp <- get(wName(entry1), wEnv = PWEnv)
    wValue(temp) <- paste(tempValue, sep = "", collapse = ";")
    assign(wName(entry1), temp, env = PWEnv)
}
button1 <- button(wName = "button1", wValue = "Browse",
                     wFuns = list(command = browse2Entry1), wEnv = PWEnv)
list1 <- listBox(wName = "list1", wValue = c(Option1 = TRUE, Option2 = FALSE,
                                 Option3 = FALSE), wEnv = PWEnv)
text1 <- textBox(wName = "text1", wValue = "Feed me something",
                 wEnv = PWEnv)
label2 <- label(wName = "label2", wValue = "Select one:  ", wEnv = PWEnv)
radios1 <- radioButton(wName = "radios1", wValue = c(radio1 = TRUE,
                       radio2 = FALSE, radio3 = FALSE), wEnv = PWEnv)
label3 <- label(wName = "label3", wValue = "Select one to many: ",
wEnv = PWEnv)
checks1 <- checkButton(wName = "checks1", wValue = c(check1 = TRUE,
                       check22 = FALSE, check3 = FALSE), wEnv = PWEnv)
pWidgets <- list(topRow = list(label1 = label1, entry1 = entry1,
                 button1 = button1), textRow = list(list1 = list1,
                 text1 = text1), radGroup = list(label2 = label2,
                 radios1 = radios1), chkGroup = list(label3 = label3,
                                     checks1 = checks1))

\dontrun{
## These cannot be run by examples() but should be OK when pasted
## into an interactive R session with the widgetTools package loaded

aWidget <- widget(wTitle = "A test widget", pWidgets, funs = list(),
                 preFun = function() print("Hello"),
                 postFun = function() print("Bye"), env = PWEnv)
}
}
\keyword{classes}





\eof
\name{widgetView-class}
\docType{class}
\alias{widgetView-class}
\alias{killWin}
\alias{vName<-}
\alias{vName}
\alias{renderWidgets}
\alias{renewView}
\alias{theWidget<-}
\alias{theWidget}
\alias{updateDisplay}
\alias{widgetids<-}
\alias{widgetids}
\alias{winid<-}
\alias{winid}
\alias{winWait}
\alias{WVTitle}
\alias{killWin,widgetView-method}
\alias{vName<-,widgetView-method}
\alias{vName,widgetView-method}
\alias{renderWidgets,widgetView,list-method}
\alias{renewView,widgetView,list-method}
\alias{theWidget<-,widgetView-method}
\alias{theWidget,widgetView-method}
\alias{updateDisplay,widgetView-method}
\alias{widgetids<-,widgetView-method}
\alias{widgetids,widgetView-method}
\alias{winid<-,widgetView-method}
\alias{winid,widgetView-method}
\alias{winWait,widgetView-method}
\alias{WVTitle,widgetView-method}
\title{Class "widgetView", a class for a GUI type widget holding widget
  elements}
\description{"widgetView" renders element widgets}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("widgetView",
    ...)}. This class is for internal use by class
  \code{\link{widget-class}}. Users trying to create GUI type widget do
  not need to use this class.
  
}
\section{Slots}{
  \describe{
    \item{\code{WVTitle}:}{Object of class \code{"character"} - a
      character string that will be displayed as the title of the widget
      to be created}
    \item{\code{vName}:}{Object of class \code{"character"} - a character
      string for the vName of the widget}
    \item{\code{winid}:}{Object of class \code{"tkwin"} - a tkwin object
      for the id of the top window for the widget}
    \item{\code{widgetids}:}{Object of class \code{"list"} - a list of
      tkwin ids for element widgets}
    \item{\code{theWidget}:}{Object of class \code{"widget"} - a widget
      object that creates the widgetView}
  }
}

\section{Methods}{
  \describe{
    \item{killWin}{\code{signature(tkWidget = "widgetView")}: destroys
      the window representing the widgetView}
    \item{vName<-}{\code{signature(object = "widgetView")}: set the value
      for vName}
    \item{vName}{\code{signature(object = "widgetView")}: get the value
      for vName}
    \item{renderWidgets}{\code{signature(widgetView = "widgetView",
	pWidgets = "list")}: takes a list of "basicPW" objects
      (pWidgets) and  renders them accordingly} 
    \item{renewView}{\code{signature(widgetView = "widgetView", pWidgets
	= "list")}: using values contained by the "basicPW" objects of
      pWidgets to update the values of widget elements displayed}
    \item{theWidget<-}{\code{signature(object = "widgetView")}: set the
      value for theWidget}
    \item{theWidget}{\code{signature(object = "widgetView")}: get the
      value for theWidget}
    \item{updateDisplay}{\code{signature(widgetView = "widgetView")}:
      update the value of list box or text box element widgets}
    \item{widgetids<-}{\code{signature(object = "widgetView")}: set the
      value of widgetids}
    \item{widgetids}{\code{signature(object = "widgetView")}: get the
      value of widgetids}
    \item{winid<-}{\code{signature(object = "widgetView")}: set the
      value of winid}
    \item{winid}{\code{signature(object = "widgetView")}: set the value
      of winid}
    \item{winWait}{\code{signature(tkWidget = "widgetView")}: make
      widgetView modal}
    \item{WVTitle}{\code{signature(object = "widgetView")}: get the
      value for WVTitle}
  }
}
\references{Programming with data}
\author{Jianhua Zhang}
\note{This class is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}
\seealso{\code{\link{widget-class}},\code{\link{basicPW-class}} }
\examples{
\dontrun{
        ## These cannot be run by examples() but should be OK when pasted
        ## into an interactive R session with the widgetTools package loaded
        
	widgetView <- widgetView(WVTitle = "demo", vName = "widget1")
}
}
\keyword{classes}

\eof
\name{writeText}
\alias{writeText}
\alias{writeList}
\alias{getListValue}
\alias{getTextValue}
\alias{getEntryValue}

\title{Functions that read from and write to tcltk widgets}
\description{
  These functions provide some of the common read and write operations
  for tcltk widgets
}
\usage{
writeText(widget, value, clear = TRUE)
writeList(widget, value, clear = TRUE)
getListValue(which)
getTextValue(which)
getEntryValue(which)
}

\arguments{
  \item{widget}{\code{widget} a tkwin object for the tcltk widget to be
    read or written to}
  \item{value}{\code{value} the text of numerical value to be written to
    a tcltk widget}
  \item{clear}{\code{clear} a boolean to indicate whether a value will
    append to the existing one (FALSE)}
  \item{which}{\code{which}} a tkwin object for the tcltk widget whose
  value will be retrieved}
}
\details{
  \code{\link{writeText}} writes to a given tcltk text box widget.

  \code{\link{writeList}} writes to a given tcltk list or entry box
  widget.

  \code{\link{getListValue}} retrieves the selected value in a tcltk
  list widget.

  \code{\link{getTextValue}} retrieves the value of a text box.

  \code{\link{getEntryValue}} retrieves the value of an entry box.
}
\value{
  \code{\link{getListValue}} returns the selected value in a tcltk
  list widget.

  \code{\link{getTextValue}} returns the value of a text box.

  \code{\link{getEntryValue}} returns the value of an entry box.
}
\references{R tcltk}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at
  Dana-Farber Cancer Institute to provide Bioinformatics
  functionalities through R}

\seealso{\code{\link{basicPW-class}}, \code{\link{widget-class}}}
\examples{
\dontrun{
    ## These cannot be run by examples() but should be OK when pasted
    ## into an interactive R session with the widgetTools package loaded

    # Create the widgets
    base <- tktoplevel()
    list <- tklistbox(base, width = 20, height = 5)

    entry <- tkentry(base)
    text <- tktext(base, width = 20, height = 5)
    tkpack(list, entry, text)
    # Write and read from the widgets
    writeList(list, c("Option1", "Option2", "Option3"))
    writeList(entry, "An Entry box")
    writeText(text, "A text box")
    # Will be NULL if not selected
    getListValue(list)
    getTextValue(text)
    getEntryValue(entry)
# Destroy toplevel widget
#    tkdestroy(base)
}
}
\keyword{interface}

\eof
