\name{PairComp-class}
\docType{class}
\alias{PairComp-class}
\alias{[,PairComp-method}
\alias{[<-,PairComp-method}
\alias{calls,PairComp-method}
\alias{fc,PairComp-method}
\alias{group,PairComp-method}
\alias{means,PairComp-method}
\alias{members,PairComp-method}
\alias{pairwise.filter,PairComp-method}
\alias{tt,PairComp-method}
\alias{calls}
\alias{fc}
\alias{group}
\alias{means}
\alias{members}
\alias{tt}

\title{Class "PairComp" Represents the results of pairwise comparison between two experimental factors }
\description{  Holds fold-change, ttest p-score and detection p-value calls(if used) between a pair of experimental factors.}

\section{Slots}{
  \describe{
    \item{\code{means}:}{Object of class \code{"matrix"} Mean values for each of the experimental factors. }
    \item{\code{fc}:}{Object of class \code{"numeric"} Fold change between the means }
    \item{\code{tt}:}{Object of class \code{"numeric"} P-score between the factors }
    \item{\code{calls}:}{Object of class \code{"matrix"} Detection p-values for each probeset on each array }
    \item{\code{group}:}{Object of class \code{"character"} The name of the factor that was compared }
    \item{\code{members}:}{Object of class \code{"character"} A list containing the two levels compared between }
  }
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "PairComp")}: get the values for the specified gene(s) }
    \item{[<-}{\code{signature(x = "PairComp")}: not supported. }
    \item{calls}{\code{signature(object = "PairComp")}: the detection.p.values }
    \item{fc}{\code{signature(object = "PairComp")}: the fold-changes }
    \item{group}{\code{signature(object = "PairComp")}: the name of the group that was compared }
    \item{means}{\code{signature(object = "PairComp")}: the means of the two experimental factors that were compared}
    \item{members}{\code{signature(object = "PairComp")}: the members of that group that were compared }
    \item{pairwise.filter}{\code{signature(object = "PairComp")}: Take a \code{PairComp} object and filter it to yield probesets that pass the specified criteria }
    \item{tt}{\code{signature(object = "PairComp")}: the results of a ttest between groups }
  }
}

\author{ Crispin Miller }

 ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{

}
\keyword{classes}

\eof
\name{bioB}
\alias{bioB}
\alias{bioC}
\alias{bioD}
\alias{actin3}
\alias{actin35}
\alias{actin3M}
\alias{actin5}
\alias{actinM}
\alias{avbg}
\alias{creX}
\alias{gapdh3}
\alias{gapdh35}
\alias{gapdh5}
\alias{gapdhM}
\alias{gapdh3M}
\alias{maxbg}
\alias{minbg}
\alias{percent.present}
\alias{sfs}
\alias{target}
\title{ Accessor Methods for QCStats class }
\description{
  Get and set my slots
}
\usage{
bioB(object)
bioC(object)
bioD(object)
actin3(object)
actin35(object)
actin3M(object)
actin5(object)
actinM(object)
avbg(object)
creX(object)
gapdh3(object)
gapdh35(object)
gapdh5(object)
gapdhM(object)
gapdh3M(object)
maxbg(object)
minbg(object)
percent.present(object)
sfs(object)
target(object)
}

\arguments{
  \item{object}{ the QCStats object you want to access }
}

\seealso{
  type \code{showMethods("bioB")} etc. to find out more about what these accessors do
}


\author{ Crispin J Miller }

\keyword{ misc }

\eof
\name{QCStats-class}
\docType{class}
\alias{QCStats-class}
\alias{actin35,QCStats-method}
\alias{actin3,QCStats-method}
\alias{actin3M,QCStats-method}
\alias{actin5,QCStats-method}
\alias{actinM,QCStats-method}
\alias{avbg,QCStats-method}
\alias{bioB,QCStats-method}
\alias{bioC,QCStats-method}
\alias{bioD,QCStats-method}
\alias{creX,QCStats-method}
\alias{gapdh35,QCStats-method}
\alias{gapdh3,QCStats-method}
\alias{gapdh3M,QCStats-method}
\alias{gapdh5,QCStats-method}
\alias{gapdhM,QCStats-method}
\alias{maxbg,QCStats-method}
\alias{minbg,QCStats-method}
\alias{percent.present,QCStats-method}
\alias{sfs,QCStats-method}
\alias{target,QCStats-method}
\alias{actin35-methods}
\alias{actin3-methods}
\alias{actin3M-methods}
\alias{actin5-methods}
\alias{actinM-methods}
\alias{avbg-methods}
\alias{bioB-methods}
\alias{bioC-methods}
\alias{bioD-methods}
\alias{creX-methods}
\alias{gapdh35-methods}
\alias{gapdh3-methods}
\alias{gapdh3M-methods}
\alias{gapdh5-methods}
\alias{gapdhM-methods}
\alias{maxbg-methods}
\alias{minbg-methods}
\alias{percent.present-methods}
\alias{sfs-methods}
\alias{target-methods}

\title{Class "QCStats" }
\description{ Holds Quality Control data for a set of Affymetrix arrays }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{qc(AffyBatch)}.
}
\section{Slots}{
  \describe{
    \item{\code{scale.factors}:}{Object of class \code{"numeric"} Scale factors used to scale the chips to the specified target intensity }
    \item{\code{target}:}{Object of class \code{"numeric"} The target intensity to which the chips were scaled }
    \item{\code{percent.present}:}{Object of class \code{"numeric"} Number of genes called present }
    \item{\code{average.background}:}{Object of class \code{"numeric"} The average background for the arrays }
    \item{\code{minimum.background}:}{Object of class \code{"numeric"} The minimum background for the arrays }
    \item{\code{maximum.background}:}{Object of class \code{"numeric"} The maximum background for the arrays }
    \item{\code{bioB}:}{Object of class \code{"character"} bioB present call }
    \item{\code{bioC}:}{Object of class \code{"character"} bioC present call }
    \item{\code{bioD}:}{Object of class \code{"character"} bioD present call }
    \item{\code{creX}:}{Object of class \code{"character"} creX present call }
    \item{\code{gapdh3}:}{Object of class \code{"numeric"} gapdh 3' intensity }
    \item{\code{gapdhM}:}{Object of class \code{"numeric"} gapdh M  intensity }
    \item{\code{gapdh5}:}{Object of class \code{"numeric"} gapdh 5' intensity }
    \item{\code{actin3}:}{Object of class \code{"numeric"} beta actin 3' intensity }
    \item{\code{actinM}:}{Object of class \code{"numeric"} beta actin M  intensity }
    \item{\code{actin5}:}{Object of class \code{"numeric"} beta actin 5' intensity }
  }
}
\section{Methods}{
  \describe{
    \item{actin35}{\code{signature(object = "QCStats")}: beta actin 3' 5' ratio }
    \item{actin3}{\code{signature(object = "QCStats")}: beta actin 3' intensity }
    \item{actin3M}{\code{signature(object = "QCStats")}: beta actin 3' M ratio }
    \item{actin5}{\code{signature(object = "QCStats")}: beta actin 5' intensity }
    \item{actinM}{\code{signature(object = "QCStats")}: beta actin M intensity }
    \item{avbg}{\code{signature(object = "QCStats")}:  average background}
    \item{bioB}{\code{signature(object = "QCStats")}: bioB call }
    \item{bioC}{\code{signature(object = "QCStats")}: bioC call }
    \item{bioD}{\code{signature(object = "QCStats")}: bioD call }
    \item{creX}{\code{signature(object = "QCStats")}: creX call }
    \item{gapdh35}{\code{signature(object = "QCStats")}: gapdh 3' 5' ratio }
    \item{gapdh3}{\code{signature(object = "QCStats")}: gapdh 3' intensity }
    \item{gapdh3M}{\code{signature(object = "QCStats")}: gapdh 3' M ratio }
    \item{gapdh5}{\code{signature(object = "QCStats")}: gapdh 5' inensity }
    \item{gapdhM}{\code{signature(object = "QCStats")}: gapdh M  intensity }
    \item{maxbg}{\code{signature(object = "QCStats")}: maximum background }
    \item{minbg}{\code{signature(object = "QCStats")}: minimum background }
    \item{percent.present}{\code{signature(object = "QCStats")}: no probesets called present }
    \item{plot}{\code{signature(x = "QCStats")}: Plot a QCStats object }
    \item{sfs}{\code{signature(object = "QCStats")}: scale factors }
    \item{target}{\code{signature(object = "QCStats")}: target scaling }
  }
}

\author{ Crispin J Miller }

\seealso{

}

\keyword{classes}

\eof
\name{bg.correct.sa}
\alias{bg.correct.sa}


\title{ Simpleaffy Implementation of Mas5 Background Correction }
\description{
  Implements the MAS5.0 background correction functions as described in Affy's
  'Statistical Algorithms Description Document'.
}
\usage{
  bg.correct.sa(unnormalised,grid=c(4,4))
}

\arguments{
  \item{unnormalised}{ An unnormalised AffyBatch object }
  \item{grid}{The dimensions of the grid to divide the chip into for background correction.}
}

\value{
  An AffyBatch object
}

\references{ http://bioinformatics.picr.man.ac.uk/ }
\url{http://www.affymetrix.com/support/technical/technotes/statistical_reference_guide.pdf}

\author{ Crispin J Miller }


\examples { 
   \dontrun{
     eset.bg.mas <- bg.correct.sa(eset);   
   }
}

\seealso{\url{http://www.affymetrix.com/support/technical/technotes/statistical_reference_guide.pdf}}


\keyword{ misc }

\eof
\name{call.exprs}
\alias{call.exprs}
\title{ Generate Expression Summaries for Affymetrix Data }
\description{
  Generates expression summaries and normalizes Affymetrix data using either MAS5.0, GCRMA or RMA algorithms.
}
\usage{
call.exprs(x, algorithm = "rma", do.log = TRUE, sc = 100, method = NA)
}

\arguments{
  \item{x}{ an \code{AffyBatch} object }
  \item{algorithm}{ one of '"rma","rma-R","gcrma", "mas5", "mas5-R". "rma" and "mas5" make use of a native C-library and are faster than "rma-R" and "mas5-R". }
  \item{do.log}{ return logged data if true }
  \item{sc}{ if the mas5 algorithm is being used, sets the target intensity to which the chips should be scaled. }
  \item{method}{ The algorithm used to normalise the data. Has no effect for "rma", 
                 defaults to quantile normalisation for "rma" and no normalisation for "mas5" }
}
\details{

}
\value{
  An AffyBatch object containing expression summaries.
}
\url{http://bioinformatics.picr.man.ac.uk/}
\author{ Crispin J Miller }

\seealso{ \code{\link{read.affy}}, \code{\link{expresso}}, \code{\link{justRMA}}, \code{\link{justMAS}} }
\keyword{ misc }
\examples { 
  \dontrun{
    eset.rma  <- call.exprs(eset,"rma"); 
    eset.mas5 <- call.exprs(eset,"mas5"); 
  }
}

\eof
\name{detection.p.val}
\alias{detection.p.val}

\title{ Calculate Detection P Values  }
\description{
  Calculate detection p values and Present Marginal Absent calls, a la MAS5.0. This is an implementation based on the algorithm described in 
  Liu, Mei et al. (2002) 'Analysis of high density expression microarrays with signed-rank call algorimths', Bioinformatics 18(12) pp1593-1599.
}
\usage{
detection.p.val(x, tau = 0.015,calls=TRUE,alpha1=getAlpha1(cleancdfname(cdfName(x))),alpha2=getAlpha2(cleancdfname(cdfName(x))),ignore.saturated=TRUE)

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ An unnormalised AffyBatch object }
  \item{tau}{ Errrmmm... tau }
  \item{alpha1}{ Present-Marginal threshold }
  \item{alpha2}{ Marginal-Absent threshold }
  \item{calls}{ if true generate PMA calls }
  \item{ignore.saturated}{ if true do the saturation correction described in the paper, with a saturation level of 46000 }
}
\value{
  A list:
  \item{pval}{A matrix of detection p values}
  \item{call}{PMA calls}
}
\references{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }

 ~Make other sections like Warning with \section{Warning }{....} ~ 

\note{
  Alpha1 and Alpha2 are parameters that change according to the chip type you are using. see \code{\link{getQCParams}} for more details.
}
\seealso{
  \code{\link{getQCParams}}
}
\examples{
   \dontrun{
     dpv <- detection.p.val(eset);
   }
  }
}
\keyword{ misc }

\eof
\name{get.annotation}
\alias{get.annotation}
\alias{write.annotation}
\alias{results.summary}


\title{ Get annotation data for a gene list}
\description{
  Takes a vector of probeset names and a CDF name. Produces a table of
annotations, containing gene name, description, sequence accession
number and unigene accession number for each probeset. In addition,
write.annotation is a utility function that outputs the annotation
data in a form suitable for loading into excel and results.summary
takes the outut of pairwise.comparison or pairwise.filter and spits
out a table with the means of the replicates the fold-change between
them (log2) and t-test p-values. This is followed by a table of
annotation (produced by get.annotation).
}

\usage{
get.annotation(x, cdfname)
write.annotation(summary,file="results/annotation.table.xls")
results.summary(results,cdfname)
}

\arguments{
  \item{x}{ a vector of probe names }
  \item{cdfname}{ the name of the chip (as produced by cdfName(AffyBatch) }
  \item{summary}{ a table of data to write in a format appropriate to read into Excel }
  \item{file}{ a table delimited file }
  \item{results}{ a PairComp object, as produced by pairwise.comparison and pairwise.filter }
}

\value{
  A table containing annotation data
}
\references{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }


\examples{
 \dontrun{
   pw       <- pairwise.comparison(eset.rma,"group",c("A","P"))
   pw.filtered <- pairwise.filter(pw)
   summary     <- results.summary(pw.filtered,"hgu133a")
   write.annotation(file="spreadsheet.xls",summary)
  }
}
\keyword{ misc }

\eof
\name{get.array.subset}
\alias{get.array.subset}
\alias{get.array.subset,AffyBatch-method}
\alias{get.array.subset,exprSet-method}

\title{ Get a subset of arrays from an affybatch object, split by phnotypic data }
\description{
  Looks at a factor in the phenotypic data for an \code{AffyBatch} or \code{exprSet} object and
  uses it to select a subset of arrays, as defined by 'members'.
}


\usage{
get.array.subset(x,group,members)
}

\arguments{
  \item{x}{ An \code{exprSet} or \code{AffyBatch} object }
  \item{group}{ The name of the pData column to use. }
  \item{members}{ The labels within the pData column to match against. }
}

\author{ Crispin J Miller }

\seealso{ \code{\link{get.array.subset.affybatch}}  \code{\link{get.array.subset.exprset}} }

\examples{
  \dontrun{
    subset1 <- get.array.subset.affybatch(eset.rma,"group","A")
    subset2 <- get.array.subset.exprset(eset.rma,"group",c("A","P"))
    subset3 <- get.array.subset(eset.rma,"group","A")
  }
}

\keyword{ misc }

\eof
\name{get.array.subset.affybatch}
\alias{get.array.subset.affybatch}
\alias{get.array.subset.exprset}

\title{ Get a subset of arrays from an affybatch object, split by phnotypic data }
\description{
  Looks at a factor in the phenotypic data for an \code{AffyBatch} or \code{exprSet} object and
  uses it to select a subset of arrays, as defined by 'members'.
}
\usage{
  get.array.subset.affybatch(x, group, members)
  get.array.subset.exprset(x, group, members)
}

\arguments{
  \item{x}{ An \code{AffyBatch} or \code{exprSet} object }
  \item{group}{ The name of the pData column to use. }
  \item{members}{ The labels within the pData column to match against. }
}

\value{
  An \code{AffyBatch} or \code{exprSet} (as appropriate) containing the selected subset of chips. }
}

\details{
  Subsetting an \code{AffyBatch} object by array is achieved using \code{[x,]}, while the same is achieved for an \code{exprSet} by \code{[,x]}. Hence the two different functions. In general the generic method \code{\link{get.array.subset}} should be used - since it sorts this all out automatically.
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
    subset1 <- get.array.subset.affybatch(eset.rma,"group","A")
    subset2 <- get.array.subset.exprset(eset.rma,"group",c("A","P"))
    subset3 <- get.array.subset(eset.rma,"group","A")
  }
}
\keyword{ misc }

\eof
\name{get.fold.change.and.t.test}
\alias{get.fold.change.and.t.test}

\title{ Compute fold change and t-test statistics between two experimental groups }
\description{
  Generate fold changes (and possibly means) for a pair of experimental groups
}
\usage{
  get.fold.change.and.t.test(x,group,members,logged = TRUE,a.order=NULL,b.order=NULL,method=c("unlogged","logged","median"));
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ an exprSet object }
  \item{group}{ column in pData(x) }
  \item{members}{ labels in group }
  \item{logged}{ is the AffyBatch data logged? }
  \item{a.order}{ For a pairwise comparison the ordering of the first group of replicates}
  \item{b.order}{ For a pairwise comparison the ordering of the second group of replicates}
  \item{method}{ What method should be used to calculate the average for the fold-change - can be either "logged","unlogged","median" }
}
\details{

  Given an exprSet object, generate quick stats for pairwise
comparisons between a pair of experimental groups. If a.order and
b.order are specified then a paired sample t-test will be conducted
between the groups, with the arrays in each group sorted according to
the ordering specified.

  The fold-changes are computed from the average values across
replicates. By default this is done using the mean of the unlogged
values. The parameter, method allows the mean of the logged values or
the median to be used instead. T-tests are always computed with the
logged data.

}
\value{
  An object of class PairComp
}
\references{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }



\examples{
  \dontrun{
    pc <- get.fold.change.and.t.test(eset.rma,"group",c("A","P"))
  }
}


\keyword{ misc }

\eof
\name{getActin3}
\alias{getActin3}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getActin3(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getActin3(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getActin5}
\alias{getActin5}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getActin5(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getActin5(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getActinM}
\alias{getActinM}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getActinM(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getActinM(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getAlpha1}
\alias{getAlpha1}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getAlpha1(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getAlpha1(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getTao}
\alias{getTao}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getTao(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getTao(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getBioB}
\alias{getBioB}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getBioB(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getBioB(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getBioC}
\alias{getBioC}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getBioC(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getBioC(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getBioD}
\alias{getBioD}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getBioD(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getBioD(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getCreX}
\alias{getCreX}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getCreX(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getCreX(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getGapdh3}
\alias{getGapdh3}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getGapdh3(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getGapdh3(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getGapdh5}
\alias{getGapdh5}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getGapdh5(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getGapdh5(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getGapdhM}
\alias{getGapdhM}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getGapdhM(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getGapdhM(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{getQCParams-methods}
\docType{methods}
\alias{getQCParams-methods}
\alias{getQCParams,AffyBatch-method}
\alias{getQCParams}

\title{ Get Array Dependent QC Parameters }
\description{
  Gets Parameters associated with QC that are dependent on the particular array type being looked at. 
}
\section{Methods}{
\describe{

\item{x = "AffyBatch"}{ The AffyBatch object containing the arrays we care about }
}}

\keyword{methods}

\eof
\name{getAlpha2}
\alias{getAlpha2}

\title{ Gets the probesetid for the specified control probe }
\description{
  Gets the probesetid for the specified control probe
}
\usage{
  getAlpha2(name)
}

\arguments{
   \item{name}{ A valid (clean) cdf name for an array }
}

\value{
  A probesetid
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     probesetid <- getAlpha2(cleancdfname(cdfName((eset))))
  }
}

\keyword{ misc }

\eof
\name{journalpng}
\alias{journalpng}
\alias{screenpng}

\title{ Produce a device for producing artwork for presentations and journals }
\description{
  journalpng generates a device to print a 4 x 4 inch 300 dpi figure (by default).
  screenpng does the same, but 72dpi.
}

\usage{
journalpng(file="figure.png",width=4, height=4,res=300)
screenpng(file="figure.png",width=4, height=4,res=72)
}


\arguments{
  \item{file}{ the file to write the figure to }
  \item{width}{ the width of the figure }
  \item{height}{ its height }
  \item{res}{ resolution in dots-per-inch }
}

\value{
  A table containing annotation data
}
\references{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }


\examples{
   \dontrun{
     journalpng(file="results/figure1.png"); # starts a new device
     trad.scatter.plot(exprs(eset)[,1],exprs(eset)[,2])
     dev.off();    # writes the file at this point.
   }
  }
}
\keyword{ misc }

\eof
\name{justMAS}
\alias{justMAS}


\title{ Generate Expression calls using a C implementation of the MAS 5.0 Algorithm}
\description{
  Implements the MAS5.0 background correction, expression summary and scaling functions as described in Affy's
  'Statistical Algorithms Description Document'
}
\usage{
  justMAS(unnormalised,tgt=100,scale=TRUE)
}


\arguments{
  \item{unnormalised}{ An unnormalised AffyBatch object }
  \item{tgt}{The target intensity to scale array to, if scaling.}
  \item{scale}{Scale the data to the specified target intensity.}
}

\details{ 
  Uses a C code implementation of the MAS5.0 algorithm (As described in Affymetrix's 'Statistical Algorithms Reference Guide' - see 
  \url{http://www.affymetrix.com/support/technical/technotes/statistical_reference_guide.pdf}).
}
\value{
  An AffyBatch object, with, in addition, scale-factors for each array stored in the object's \code{description@preprocessing@sfs} slot, and the target intensity the arrays were scaled to in  \code{description@preprocessing@tgt}
}

\url{ http://bioinformatics.picr.man.ac.uk/ }

\author{ Crispin J Miller }

\examples { 
   \dontrun{
     eset.mas <- justMAS(eset.mas);    
   }
}

\seealso{\url{http://www.affymetrix.com/support/technical/technotes/statistical_reference_guide.pdf}}


\keyword{ misc }

\eof
\name{pairwise.comparison}
\alias{pairwise.comparison}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Compute pairwise comparison statistics between two experimental groups }
\description{
  Generate fold changes, t-tests and means for a pair of experimental groups
}
\usage{
  pairwise.comparison(x,group,members=NULL,spots=NULL,a.order=NULL,b.order=NULL,method="unlogged",logged=TRUE)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ an exprSet object }
  \item{group}{ column in pData(x) }
  \item{members}{ labels in group }
  \item{spots}{ unnormalised AffyBatch data for this experiment - if included, results in PMA calls and detection p-values being generated }
  \item{a.order}{ For a comparison with matched pairs, the ordering of the first group of replicates}
  \item{b.order}{ For a comparison with matched pairs, the ordering of the second group of replicates}
  \item{method}{ What method should be used to calculate the average for the fold-change - can be either "logged","unlogged","median" }
  \item{logged}{ Whether the input data is logged or not }
}
\details{
  Given an exprSet object, generate quick stats for pairwise
comparisons between a pair of experimental groups. If a.order and
b.order are specified then a paired sample t-test will be conducted
between the groups, with the arrays in each group sorted according to
the ordering specified. By default, the function assumes that the
expression values are logged (this can be changed with the parameter
"logged"). The fold-changes are computed from the average values
across replicates. Unless you specify otherwise, this is done using the mean of the
unlogged values (i.e. logged data is first unlogged, the mean
calculated, and the result re-logged). The parameter "method", allows
the mean of the logged values or their median to be used
instead. T-tests are always computed with the logged data.  
} 
\value{
  A Pairwise comparison object.
}
\references{ http://bioinformatics.picr.man.ac.uk/ } \author{ Crispin J Miller }

 ~Make other sections like Warning with \section{Warning }{....} ~ 



\examples { 
  \dontrun{
    pc <- pairwise.comparison(eset.rma,"group",c("A","P")) 
  }
}


\keyword{ misc }

\eof
\name{pairwise.filter}
\alias{pairwise.filter}

\title{ Filter pairwise comparison statistics between two experimental groups }
\description{
  Given the results of a pairwise.comparison, filter the resulting gene list on expression level, PMA calls (if available), fold change and t-test statistic
}

\usage {
  pairwise.filter(object,eset,min.exp=log2(100),min.exp.no=0,min.present.no=3,fc=1.0,tt=0.001)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{ a 'PairComp' object }
  \item{eset}{ an 'exprSet' object used to filter by intensity }
  \item{min.exp}{ Filter genes using a minimum expression cut off }
  \item{min.exp.no}{ A gene must have an expression intensity greater than 'min.exp' in at least this number of chips }
  \item{min.present.no}{ A gene must be called present on at least this number of chips }
  \item{fc}{ A gene must show a log2 fold change greater than this to be called significant }
  \item{tt}{ A gene must be changing with a p-score less than this to be called significant }
}
\value{
  A 'PairComp' object filtered to contain only the genes that pass the specified filter parameters.
}
\references{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }



\examples { 
  \dontrun{
    pc <- pairwise.comparison(eset.rma,"group",c("A","P"))
    pf <- pairwise.filter(pc,eset,tt=0.01);
  }
}

\keyword{ misc }

\eof
\name{plot.qc.stats}
\alias{plot.qc.stats}
\alias{plot,QCStats}
\alias{plot,QCStats-method}

\title{ Plots a QCStats object }
\description{
  Generates a visual summary of the various QC statistics recommended by Affymetrix in their 'Data Analysis Fundamentals' handbook.
}
\section{
plot.qc.stats(x, fc.line.col = "black", sf.ok.region = "light blue", chip.label.col = "black", sf.thresh = 3, gdh.thresh = 3, ba.thresh = 3, present.thresh = 10, bg.thresh = 20, label = NULL, ...)
}

\arguments{
  \item{x}{ A \code{QCStats} object }
  \item{fc.line.col}{ The colour to mark fold change lines with }
  \item{sf.ok.region}{ The colour to mark the region in which scale factors lie within appropriate bounds }
  \item{chip.label.col}{ The colour to label the chips with }
  \item{sf.thresh}{ Scale factors must be within this fold-range }
  \item{gdh.thresh}{ Gapdh ratios must be within this range }
  \item{ba.thresh}{ beta actin must be within this range }
  \item{present.thresh}{ The percentage of genes called present must lie within this range }
  \item{bg.thresh}{ Array backgrounds must lie within this range }
  \item{label}{ What to call the chips }
  \item{\dots}{ Other parameters to pass through to \code{plot} }
}
\details{
  A lot of information is presented in this one figure. The dotted
circles correspond to fold-change - the outer one, labelled '+3',
corresponds to a 3-fold up-scaling, the
middle to no change, and the inner to a 3-fold
down-scaling. The blue circle represents the region in which all
arrays have scale factors within, by default, three-fold of each other. Its
position is found by calculating the mean scale factor for all chips
and positioning the center of the region so that the borders
are -1.5 fold up or down from the mean value.

Each array is plotted as a line from the 0-fold circle to the point
that corresponds to its scale factor. If the ends of all of the lines
are in the blue region, their scale-factors are compatible. The lines
are coloured blue if OK, red if not.

The figure also shows GAPDH and beta-actin 3'/5' ratios. These are
represented as a pair of points for each chip. Affy state that they
should be within 3. Any that fall outside the three-fold line are
coloured red; the rest are blue. 

Written around the edge of the figure are the number of genes called
present on each array and the average background. These will vary
according to the samples being processed, and Affy's QC suggests
simply that they should be similar. If any chips have significantly
different values this is flagged in red, otherwise the numbers are
displayed in blue. By default, 'significant' means that \%-present are
within 10\% of each other; background intensity, 20 units. These last
numbers are somewhat arbitrary and may need some tweaking to find
values that suit the samples you're dealing with, and the overall
nature of your Affymetrix setup.

Finally, if BioB is not present on a chip, this will be flagged by
printing 'BioB' in red next to the scale-factor for that chip.

In short, everything in the figure should be blue - red highlights a problem!
}
\author{ Crispin J Miller }

\seealso{ \code{\link{qc}} }
\examples{
  \dontrun{
    qc <- qc(eset,eset.mas)
    plot(qc)
  }
}


\keyword{ misc }

\eof
\name{qc}
\alias{qc}
\alias{qc,AffyBatch-method}

\title{ Generate QC stats from an AffyBatch object }
\description{
  ...
}
\usage{
qc(unnormalised, ...)
}
\arguments{
  \item{unnormalised}{ An AffyBatch object with nowt done to it }
  \item{\dots}{ Any other parameters }
}

\author{ Crispin J Miller }

\seealso{ \code{\link{qc.affy}} }
\examples{
  \dontrun{
    qc <- qc(eset,eset.mas)
    plot(qc)
  }
}


\keyword{ misc }

\eof
\name{qc.affy}
\alias{qc.affy}

\title{ Generate Affymetrix Style QC Statistics }
\description{
  Generates Affymetrix style QC statistics as defined in Affymetrix' 'Data Analysis Fundamentals' handbook }
}
\usage{
qc.affy(unnormalised,normalised=NULL,logged=TRUE,
        tau=getTao(cleancdfname(cdfName(unnormalised))),
        alpha1=getAlpha1(cleancdfname(cdfName(unnormalised))),
        alpha2=getAlpha2(cleancdfname(cdfName(unnormalised))),
	bioB=getBioB(cleancdfname(cdfName(unnormalised))),
        bioC=getBioC(cleancdfname(cdfName(unnormalised))),
        bioD=getBioD(cleancdfname(cdfName(unnormalised))),
        creX=getCreX(cleancdfname(cdfName(unnormalised))),
        gapdh3=getGapdh3(cleancdfname(cdfName(unnormalised))),
        gapdhM=getGapdhM(cleancdfname(cdfName(unnormalised))),
        gapdh5=getGapdh5(cleancdfname(cdfName(unnormalised))),
        actin3=getActin3(cleancdfname(cdfName(unnormalised))),
        actinM=getActinM(cleancdfname(cdfName(unnormalised))),
        actin5=getActin5(cleancdfname(cdfName(unnormalised))))
}

\arguments{
  \item{unnormalised}{ An unnormalised raw \code{AffyBatch} object to call qc stats on }
  \item{normalised}{ The same one, processed using \code{\link{justMAS}} (contains scale factors etc.). If not supplied, then the object gets calculated internally. }
  \item{logged}{ True if the data is logged }
  \item{tau}{ Specify the tau value rather than the default for the arrays}
  \item{alpha1}{Specify the alpha1 value rather than the default for the arrays}
  \item{alpha2}{Specify the alpha2 value rather than the default for the arrays}
  \item{bioB}{Specify the bioB value rather than the default for the arrays}  
  \item{bioC}{Specify the bioC value rather than the default for the arrays}
  \item{bioD}{Specify the bioD value rather than the default for the arrays}  
  \item{creX}{Specify the crex value rather than the default for the arrays}  
  \item{gapdh3}{Specify the gapdh3 value rather than the default for the arrays}  
  \item{gapdhM}{Specify the gapdhM value rather than the default for the arrays}  
  \item{gapdh5}{Specify the gapdh5 value rather than the default for the arrays}  
  \item{actin3}{Specify the actin3 value rather than the default for the arrays}  
  \item{actinM}{Specify the actinM value rather than the default for the arrays}  
  \item{actin5}{Specify the actin5 value rather than the default for the arrays}
}

\value{
  A QCStats object describing the supplied \code{\link{AffyBatch}}
}

\author{ Crispin J Miller }

\examples{
  \dontrun{
     qc <- qc(eset,eset.mas)
  }
}

\keyword{ misc }

\eof
\name{read.affy}
\alias{read.affy}

\title{ Read a Set of .CEL Files and Phenotypic Data }
\description{
 Reads the specified file, which defines phenotypic data for a
 set of .CEL files. Reads the specified files into an \code{\link{AffyBatch}} object and
 then creates a \code{\link{phenoData}} object, defining the experimental factors 
 for those chips.
}
\usage{
read.affy(covdesc = "covdesc",path=".", ...)
}

\arguments{
  \item{covdesc}{ 
    A white space delimited file suitable for reading as a \code{\link{data.frame}}. The first column (with no column name)  
     contains the names(or paths to) the .CEL files to read. Remaining columns (with names) represent experimental factors
     for each chip. these become elements of the \code{\link{phenoData}} object.
  }
  \item{\dots}{ extra functions to pass on to \code{ReadAffy} }
  \item{path}{ The path to prefix the filenames with before calling \code{ReadAffy} }
}
\details{ }
\value{
  An AffyBatch object
}
\url{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }

\seealso{ \code{\link{ReadAffy}}, \code{\link{AffyBatch}} \code{\link{data.frame}} \code{\link{phenoData}}}
\keyword{ misc }
\examples { 
  \dontrun{
    eset <- read.affy(); # read a set of CEL files
  }
  eset.rma <- call.exprs(eset,"rma");   
}

\eof
\name{trad.scatter.plot}
\alias{trad.scatter.plot}

\title{ Does a Traditional Scatter Plot of Expression Data }
\description{
  Plots expression data as a scatter plot with optional fold-change lines
}
\usage{
trad.scatter.plot(x, y, add = FALSE, fc.lines = log2(c(2, 4, 6, 8)), draw.fc.lines = TRUE, draw.fc.line.labels = TRUE, fc.line.col = "lightgrey", pch = 20, ...)
}

\arguments{
  \item{x}{ x coords }
  \item{y}{ y coords }
  \item{add}{ add this data to an existing graph }
  \item{fc.lines}{ Vector of intervals at which to draw fold-change lines }
  \item{draw.fc.lines}{ Draw fold change lines? }
  \item{draw.fc.line.labels}{ Label the fold change lines with the fold changes they represent? }
  \item{fc.line.col}{ The colour to draw fold change lines }
  \item{pch}{ Plotting character to use for the scatter data (see \code{plot} for more details) }
  \item{\dots}{ Additional parameters to pass through to the underlying \code{plot} function }
}
\references{ http://bioinformatics.picr.man.ac.uk/ }
\author{ Crispin J Miller }

\seealso{ \code{\link{plot}}}


\examples{
  \dontrun{
    trad.scatter.plot(exprs(eset.rma)[,1],exprs(eset.rma)[,4])
  }
}

\keyword{ misc }

\eof
