### Name: sam.wilc
### Title: SAM Analysis using Wilcoxon Rank Sums
### Aliases: sam.wilc
### Keywords: htest

### ** Examples

    library(multtest)
    # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
    # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
    # and a matrix called golub.gnames whose third column contains the gene names.
    data(golub)
    
    # Performing a SAM-Wilc Analysis of the Golub data. Setting rand=123 makes the results reproducible.
    # The output is assigned to an object for further analyses.
    if (interactive()) {
    sam.output<-sam.wilc(golub,golub.cl,rand=123)
}



