### Name: sam.plot
### Title: SAM Analysis for a specific threshold
### Aliases: sam.plot
### Keywords: htest

### ** Examples

    library(multtest)
    # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
    # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
    # and a matrix called golub.gnames whose third column contains the gene names.
    data(golub)
    
    # Performing a SAM Analysis of the Golub data. Setting rand=123, to make the results reproducible,
    # and setting med.fdr=FALSE, such that the mean number instead of the median number of falsely called
    # genes is computed. The output is assigned to an object for further analyses.
    if (interactive()) {
    sam.output<-sam(golub,golub.cl,med.fdr=FALSE,rand=123)
    
    # Now sam.plot can be used to obtain the SAM plot and information about the differentially expressed
    # genes for a specified value of delta.
    
    sam.14<-sam.plot(sam.output,1.4,gene.names=golub.gnames[,3])
    
    # sam.plot can also be used in a SAM-Wilc analysis for a specific Delta. 
    
    # For further analyses, the row numbers of the differentially expressed genes can be obtained by
    
    sam.14$row.sig.genes
}



