### Name: sam.delta
### Title: Further SAM analysis
### Aliases: sam.delta
### Keywords: htest

### ** Examples

    library(multtest)
    # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
    # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
    # and a matrix called golub.gnames whose third column contains the gene names.
    data(golub)
    
    # Performing a SAM Analysis of the Golub data. Setting rand=123, to make the results reproducible,
    # and setting med.fdr=FALSE, such that the mean number instead of the median number of falsely called
    # genes is computed. The output is assigned to an object for further analyses.
    if (interactive()) {
    sam.output<-sam(golub,golub.cl,med.fdr=FALSE,rand=123)
    
    # Now the number of significant genes and the FDR should be computed for other values of the threshold
    # Delta. Let's say Delta from 0.6 to 0.8 in steps of length 0.01.
    
    sam.delta(sam.output,seq(0.6,0.8,0.01))
}



