### Name: sam
### Title: Significance Analysis of Microarrays
### Aliases: sam
### Keywords: htest

### ** Examples

    library(multtest)
    # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
    # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
    # and a matrix called golub.gnames whose third column contains the gene names.
    data(golub)
    
    # Performing a SAM Analysis of the Golub data. Setting rand=123, to make the results reproducible,
    # and setting med.fdr=FALSE, such that the mean number instead of the median number of falsely called
    # genes is computed. The output is assigned to an object for further analyses.
   if (interactive())  
    sam.output<-sam(golub,golub.cl,med.fdr=FALSE,rand=123)



