### Name: find.a0
### Title: Computation of the Fudge Factor
### Aliases: find.a0
### Keywords: htest

### ** Examples

    library(multtest)
    # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
    # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
    # and a matrix called golub.gnames whose third column contains the gene names.
    data(golub)
    
    # Now the optimal value for the fudge factor a0 is computed, where possible values of the a0 are
    # 0 and the 0, 0.05 and 0.1 quantile of the standard deviations of the genes. Setting rand=123
    # makes the results reproducible.
    
    find.out<-find.a0(golub,golub.cl,alpha=c(0,0.05,0.1),rand=123)



