### Name: ebam.wilc
### Title: Empirical Bayes Analysis using Wilcoxon Rank Sums
### Aliases: ebam.wilc
### Keywords: htest

### ** Examples

if (interactive()) {
    library(multtest)
    # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
    # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
    # and a matrix called golub.gnames whose third column contains the gene names.
    data(golub)
    
    # An EBAM-Wilc analysis of the Golub data is performed by
    
    ebam.wilc.out<-ebam.wilc(golub,golub.cl,gene.names=golub.gnames[,3],rand=123)
    
    # For further analyses, the row numbers of the differentially expressed genes are obtained by
    
    ebam.wilc.out$row.sig.genes
} 



