### eliminate "bad" fields
badfields <- read.table("/home/whuber/fctassays/reports/dorit16.txt",
                        as.is=TRUE, header=TRUE, sep="\t")

cs <- sub("dorit16_1", "", badfields$Experiment)
cs <- sub("c_1-2", "c12", cs)
cs <- sub("c_3-4", "c34", cs)

iw <- as.integer(sub("Well", "", badfields$Well))
stopifnot(!any(is.na(iw)))

pwid <- mapSub2Plate(cs, iw)

cat("QC: ")

del <- rep(FALSE, nrow(dat))
for(i in 1:nrow(badfields)) {
  sel <- (dat$expId=="dorit16" & dat$expRepeat==1 & dat$well==pwid[i] & dat$Field==(badfields$Position[i]+1))
  ## cat(badfields$Experiment[i], badfields$Well[i], pwid[i], badfields$Position[i], sum(sel), "\n")
  del <- del | sel
}
cat("removing", sum(del), "records from 'dat', ")
dat <- dat[!del,]
cat("keeping", nrow(dat), "\n")

