if ("package:prada" %in% search()) detach("package:prada")
library(prada)
options(error=recover)
options(warn=0)

datdir <- "/home/whuber/fctassays/data"
outdir <- "/home/whuber/fctassays/reports/fig.040502"
outdirsub <- "scp"

if(!exists("dat")) {
  load(file.path(datdir, "030909", "dat.Fri-Jan-30-12:23:29-2004.rda"))
  source("quality.control.R")
}

source("mapId.R")
dummy <- mapId(as.character(unique(dat$cloneId)))

stopifnot(file.exists(file.path(outdir, outdirsub)))

graphics.off()

rg.trsf    <- c(0, 7)
rg.nrcells <- c(0, 3000)
rg.delta   <- c(-1, 1)*4
rg.score   <- c(-6, 6)

setPradaPars(list(
  minRgTau   = unlist(list(cfp=60, yfp=15)),
  nrCellsTopBottom = 20,
  minNrCells = 100,
  debug      = TRUE))

pres <- NULL

for (eid in levels(dat$expId)) {
  for (er in unique(dat$expRepeat[dat$expId==eid])) {
    platename <- paste(eid, er, sep="_")

    datsel <- dat[dat$expId==eid & dat$expRepeat==er, ]

    ## crosstalk correction
    crosstalk <- estimateCrosstalkPlate(datsel,  
        plotfileprefix = file.path(outdir, paste(platename, "ct", sep="_")))
    if(getPradaPar("debug"))
      cat(platename, " crosstalk:", paste(names(crosstalk), signif(crosstalk, 2), 
           sep=":", collapse="\t"), "\n")
    dye <- getDye(as.character(datsel$cloneId))
    stopifnot(all(unique(dye) %in% names(crosstalk)))
    datsel$trsf <- datsel$trsf - crosstalk[dye] * datsel$dapi

    res <- analysePlate(datsel, wellcol="well", wellrange=1:96,
                         statfun="statWellLocfit", 
                         platename=platename,
                         plotdir=file.path(outdir, outdirsub),
                         plotwhat="mkpp", span=1)
    pres <- rbind(pres, res)
    
    con <- openHtmlPage(file.path(outdir, platename), platename)
    
    ## nrcells
    main <- paste(platename, ": nrcells", sep="")
    fnam <- paste(platename, "_nrc.png", sep="")
    col  <- brewer.pal(9, "YlOrBr")
    pp   <- plotPlate(res$nrcells, xrange=rg.nrcells, col=col, main=main, na.action="omit",
                      device="png", file=file.path(outdir, outdirsub, fnam), width=512)
    imageMap(con, file.path(outdirsub, fnam), pp$coord, 
             tooltips = paste(mapId(res$cloneId[pp$which]), ": ", res$nrcells[pp$which],
                              " cells", sep=""),
             url = file.path(outdirsub, res$plotfile[pp$which]))

    ## transfection
    main <- paste(platename, ": trsf", sep="")
    fnam <- paste(platename, "_trf.png", sep="")
    pp   <- plotPlate(res$trsfeff, xrange=rg.trsf, col=col, main=main, na.action="omit",
                      device="png", file=file.path(outdir, outdirsub, fnam), width=512)
    imageMap(con, file.path(outdirsub, fnam), pp$coord, 
             tooltips = paste(mapId(res$cloneId[pp$which]), ": ",
                              round(res$trsf[pp$which]), sep=""),
             url = file.path(outdirsub, res$plotfile[pp$which]))
    
    ## score
    main <- paste(platename, ": z-score", sep="")
    fnam <- paste(platename, "_zscore.png", sep="")
    col  <- brewer.pal(9, "RdBu")[9:1]
    col  <- c(col[1:4], rep(col[5], 5), col[6:9])
    pp   <- plotPlate(res$zscore, xrange=rg.score, col=col, main=main, na.action="omit",
                      device="png", file=file.path(outdir, outdirsub, fnam), width=512)
    imageMap(con, file.path(outdirsub, fnam), pp$coord, 
             tooltips = paste(mapId(res$cloneId[pp$which]), rep(": z-score=", length(pp$which)),
                        signif(res$zscore[pp$which], 3), sep=""),
             url = file.path(outdirsub, res$plotfile[pp$which]))

    ## delta
    main <- paste(platename, ": delta", sep="")
    fnam <- paste(platename, "_delta.png", sep="")
    pp   <- plotPlate(res$delta, xrange=rg.delta, col=col, main=main, na.action="omit",
                      device="png", file=file.path(outdir, outdirsub, fnam), width=512)
    imageMap(con, file.path(outdirsub, fnam), pp$coord, 
             tooltips = paste(mapId(res$cloneId[pp$which]), rep(": delta=", length(pp$which)),
                        signif(res$delta[pp$which], 3), sep=""),
             url = file.path(outdirsub, res$plotfile[pp$which]))

    closeHtmlPage(con)
  }
}

file <- file.path(outdir, paste("pres", gsub(" ", "-", date()), sep="."))
cat("Saving", file, "\n")
save(pres, file=paste(file, ".rda", sep=""))

write.table(pres, file=paste(file, ".txt", sep=""), sep="\t",
            row.names=FALSE, col.names=TRUE, quote=FALSE)
