## figures for dorit's paper on proliferation assay
if ("package:prada" %in% search()) detach("package:prada")
library(prada)
options(error=recover)

datdir <- "/home/whuber/fctassays/data/030909"

if(!exists("dat"))
  load(file.path(datdir, "dat.Mon-Oct-27-13:37:25-2003.rda"))
load("/home/whuber/fctassays/scripts/crosstalk.rda")

graphics.off()
## x11(width=9,height=4.5); par(mfrow=c(1,2))
x11()

setPradaPars(list(
  minRgTau   = unlist(list(cfp=60, yfp=15)),
  nrCellsTopBottom = 20,
  minNrCells = 100,
  debug      = TRUE))

doPlot <- function(eid, er, w, tit, ...) {
  datsel <- dat[dat$expId==eid & dat$expRepeat==er & dat$well==w, ]
  thedye <- unique(getDye(as.character(datsel$cloneId)))
  stopifnot(length(thedye)==1)
  ct     <- with(crosstalk, kappa[expId==eid & expRepeat==er & dye==thedye])
  stopifnot(length(ct)==1, !is.na(ct))

  res <- statWellLocfit(datsel,
     plotwhat="figscp", plotdir="fig", crosstalk=ct, ...)

  cat("\\textbf{", gsub("_", "\\\\_", paste(tit, paste(eid, er, w, sep="_"))), "}\\\\\n",
      "\\includegraphics[width=0.49\\textwidth]{", gsub(".tiff", ".eps", res$plotfull), "}\n",
      "\\includegraphics[width=0.49\\textwidth]{", gsub(".tiff", ".eps", res$plotzoom), "}\\\\\n",
      "{\\large $\\delta=", signif(res$delta, 2), "\\pm", signif(2*res$se.delta, 2),
      ",\\quad z=", signif(res$zscore, 2), "$}\\\\[2cm]\n",
      ## "\\end{figure}\n",
      sep="", file=tex)
}

tex = file("fig_scp.tex", open="w")
cat("\\documentclass[11pt]{article}\n\\usepackage{times}\n",
    "\\usepackage{graphicx}\n\\begin{document}\n",
    "\\title{Figures for Dorit's paper}\n",
    "\\date{\\today}\n\\maketitle\n",
    "Each page contains the plots of the data from one clone with YFP and CFP tags, respectively. ",
    "The axes of the plots on the left hand side were autoscaled to cover the range ",
    "from the 1\\%- to the 99\\%-percentiles of the data. In the plots on the right hand side ",
    "the upper limit of the $x$-axis was determined as $\\tau_0+2s_{\\mbox{\\small dye}}$, where ",
    "$\\tau_0$ is the shorth (peak) of the distribution of the transfection intensities ",
    "and $s_{\\mbox{\\small dye}}$ is 15 for YFP and 60 for CFP.\n\n",
    "\\begin{center}\n",
      sep="", file=tex)

cat("\\newpage\n", file=tex)
span=1
doPlot("dorit12",  1, 32, tit="YFP",  span=span)
doPlot("dorit12",  4, 61, tit="CFP",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit12",  3, 33, tit="YCA",   span=span) 
doPlot("dorit12",  4, 62, tit="CCA",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit12",  3, 46, tit="YPP2",  span=span) 
doPlot("dorit12",  4, 63, tit="CPP2",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit12",  2, 47, tit="YCDI",  span=span) 
doPlot("dorit12",  2, 95, tit="CCDI",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit9",   2, 16, tit="12i1",  span=span) 
doPlot("dorit9",   3, 52, tit="12i1",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit9",   1, 25, tit="16a24",  span=span) 
doPlot("dorit9",   3, 85, tit="16a24",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit6",   1,  7, tit="1p4",  span=span) 
doPlot("dorit7",   1, 52, tit="1p4",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit9",   1, 38, tit="16p15",  span=span) 
doPlot("dorit9",   3, 74, tit="16p15",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("doritwdh3", 1, 33, tit="22a1",  span=span) 
doPlot("doritwdh3", 1, 93, tit="22a1",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit10",  1, 16, tit="23i1",  span=span) 
doPlot("dorit10",  1, 52, tit="23i1",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit9",   1, 27, tit="23o8",  span=span) 
doPlot("dorit9",   3, 75, tit="23o8",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit10",   1, 18, tit="2a20",  span=span) 
doPlot("dorit10",   1, 66, tit="2a20",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit8",   1, 26, tit="2c18",  span=span) 
doPlot("dorit8",   1, 75, tit="2c18",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit8",   1, 67, tit="2d15",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit9",   1, 40, tit="64k1",  span=span) 
doPlot("dorit9",   3, 76, tit="64k1",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit11",   1,  8, tit="3f12",  span=span) 
doPlot("dorit11",   2, 68, tit="3f12",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit11",   2, 23, tit="3i13",  span=span) 
doPlot("dorit11",   1, 58, tit="3i13",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("doritwdh3", 1, 41, tit="46a6",  span=span) 
doPlot("doritwdh3", 1, 77, tit="46a6",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit11", 1, 25, tit="3k1",  span=span) 
doPlot("dorit11", 1, 73, tit="3k1",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit11", 1, 33, tit="15g14",  span=span) 
doPlot("dorit11", 1, 81, tit="15g14",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit11", 1, 35, tit="15i5",  span=span) 
doPlot("dorit11", 1, 95, tit="15i5",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit12", 3, 10, tit="19f19",  span=span) 
doPlot("dorit12", 3, 70, tit="19f19",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit12", 3, 20, tit="16i9",  span=span) 
doPlot("dorit12", 3, 68, tit="16i9",  span=span) 

cat("\\newpage\n", file=tex)
doPlot("dorit10", 1, 34, tit="21p24",  span=span) 
doPlot("dorit10", 1, 94, tit="21p24",  span=span) 

cat("\\end{center}\n\\end{document}\n", sep="", file=tex)
close(tex)

## BDEG 2003 Talk
## doPlot("dorit6",  1,  6, xmax=500,  span=1.1 ) ## Inhibitor
## doPlot("dorit10", 1, 51, xmax=800,  span=1 ) ## Neutral
## doPlot("dorit11", 1, 50, xmax=250,  span=0.6 ) ## Activator (CCA)
## doPlot("dorit11", 2, 87, xmax=1500, span=1.1) ## Inhibitor

