if ("package:prada" %in% search()) detach("package:prada")
library(prada)

if(!exists("dat")) {
  fn <- "/mga/project/fctassays/wolfgang/data/030909/dat.Mon-Oct-27-13:37:25-2003.rda"
  cat("Loading", fn, "\n")
  load(fn)
  dye <- getDye(as.character(dat$cloneId))
}

graphics.off()
par(ask=FALSE)

eid <- "dorit10"
er  <- 1

cols        <- c("#984ea3", "#4daf4a")
names(cols) <- c("cfp",     "yfp")

getq <- function(x) {
  if (length(x)<10) {
    return(as.numeric(NA))
  } else {
    return(min(x))
    ## return(quantile(x, probs=0))
  }
}
getd <- function(x) {
  x<- unique(x)
  stopifnot(length(x)==1)
  return(x)
}


for(thedye in names(cols)) {
  switch(thedye,
         yfp = {
           sub  <- c(rep("a", 32), rep("c12", 16))
           well <- c(1:32, 1:16)
         },
         cfp = {
           sub  <- c(rep("b", 32), rep("c34", 16))
           well <- c(1:32, 17:32)
         }, 
         error(thedye)
         )
  wellorder <- mapSub2Plate(sub, well)

  x    <- dat[dat$expId==eid & dat$expRepeat==er & dye==thedye, ]
  fac  <- list(factor(x$well), factor(x$Field))
  
  name = paste(eid, er, thedye, sep="_")
  cat(name, nrow(x), "\n")

  ## this will return a matrix with as many rows as wells,
  ## and as many columns as fields.
  q    <- tapply(x$trsf, fac, getq)
  inq  <- (paste(wellorder) %in% rownames(q))
  cat("wells", wellorder[!inq], "are empty!\n")
  
  sq <- q[paste(wellorder)[inq], ]
  
  nrFields <- rowSums(!is.na(sq))
  wellBnd  <- cumsum(nrFields)

  pq <- as.vector(t(sq))
  pq <- pq[!is.na(pq)]

  stopifnot(length(pq)==wellBnd[length(wellBnd)])

  iqu  <- c(1, ceiling(seq(1/6, 1, by=1/6)*length(pq)))
  ylim <- c(min(pq), quantile(pq, 0.95))
  par(mfrow=c(6,1))
  oldmai <- par("mai")
  par(mai=c(oldmai[1:2],0.01,0.01))
  for(i in 1:(length(iqu)-1)) {
    rg <- iqu[i]:iqu[i+1]
    plot(rg, pq[rg], col=cols[thedye],
         xlim=range(rg), ylim=ylim, xaxs="i", yaxs="i", pch=16, 
         main="", xlab="", ylab="")
    abline(v=wellBnd, col="red")
  }
  savetiff(paste("fig_bgfluct", name, sep="_"), width=10, asp=0.66)
}

