## This R script wil create the Figures 1-4 for Dorit's Paper
## Fig. 5: see fig_5.tex
## Fig. 6: see fig_6.ppt
## Fig. 7: see fig_7.tex
##
if ("package:prada" %in% search()) detach("package:prada")
library(prada)

## select here which figures to make
makefig <- c(1)

datdir <- function(...) file.path("/home/whuber/fctassays/data", ...)
capt   <- "fig_captions.txt"

if(!exists("dat"))
  load(datdir("030909", "dat.Fri-Jan-30-12:23:29-2004.rda"))
if(!exists("crosstalk"))
  load(datdir("crosstalk.031219.rda"))

setPradaPars(list(
  minRgTau   = unlist(list(cfp=60, yfp=15)),
  nrCellsTopBottom = 20,
  minNrCells = 100,
  debug      = TRUE))

##----------------------------------------------------------------------  
## Fig. 1: 
##----------------------------------------------------------------------  
if (1 %in% makefig){
  library(pixmap)
  source("read.pnm.R")

  if(!exists("datsel")) {
    datsel <- dat[ dat$expId=="dorit6" & dat$expRepeat==1 &
                   dat$well==19 & dat$Field==3, ]
    ## Note: we're counting fields staring from 1, while
    ## Urban (in his filenames) counted them from 0
  }

  mypolygon <- function(xl, xr, yt, yb, highlight, value) {
    polygon(c(xl, xr, xr, xl, xl),
            1024-c(yb, yb, yt, yt, yb),
            border=c("#a0a0a0", "#ffffff")[as.numeric(highlight)+1], lwd=4, col=NA)
    if(highlight) {
      cat("xl=", xl, "1024-yt=", 1024-yt, "value=", paste(round(value, 0)), "\n", sep="\t")
      ## text((xl+xr)/2, 1024-yt+8, paste(round(value, 0)), adj=c(0.5, 0),
      ##     col="#ffffff", cex=3, font=2)
    }
  }
  ## a: xl=     391     1024-yt=        485     value=  500
  ##    xl=     248     1024-yt=        459     value=  610
  ## b: xl=     391     1024-yt=        485     value=  232
  ##    xl=     248     1024-yt=        459     value=  66
  ## c: xl=     391     1024-yt=        485     value=  421
  ##    xl=     248     1024-yt=        459     value=  297

  thedir <- "/mga/project/fctassays/expro/raw-images/dorit-yfp-done/dorit6_1"
  imfiles <-  c("19-YFP_CyclinAMW W19P02SL00Q5F0.tif",    ## dapi,
                "19-YFP_CyclinAMW W19P02SL00Q6F0.tif",    ## trsf
                "19-YFP_CyclinAMW W19P02SL00Q4F0.tif")    ## brdu

  png("fig_1.png", width=3*1280, height=1024*1.08)
  par(mai=c(1, 0, 0, 0))
  par(mfrow=c(1,3))
  for (i in 1:3) {
    fn1 <- imfiles[i]
    fn2 <- gsub(" ", "-", fn1)
    fn3 <- gsub("tif$", "pgm", fn2)
    if(!file.exists(fn3)) {
      file.copy(file.path(thedir, fn1), fn2)
      cmd <- paste("convert", fn2, fn3)
      system(cmd)
    }
    im <- read.pnm(fn3)
    ## im@grey  <- im@grey-32768/65535
    im@grey  <- im@grey-min(im@grey)
    ## hist(im@grey*65535)
    im@grey <- sqrt(im@grey/max(im@grey))

    plot(im)
    for(jc in 1:nrow(datsel))
      with(datsel, 
        mypolygon(x1Left[jc], x2Right[jc], y1Top[jc], y2Bottom[jc],
                  highlight=(jc %in% c(42, 45)),
                  ## BUG IN URBAN'S DATA FILES!!!!
                  value=c(dapi[jc-1], trsf[jc-1], brdu[jc-1])[i]))
    ## text(512, -25, c("a", "b", "c")[i], adj=c(0.5, 1), xpd=NA, cex=3, font=2)
  }
  dev.off()
}
##----------------------------------------------------------------------  
## Fig. 2. Histogram of transfection efficiency, incl. `shorth': 13_3_45
##----------------------------------------------------------------------  
if (any(2:3 %in% makefig)) {
  eid <- "dorit13"
  er  <- as.integer(3)
  ew  <- as.integer(45)

  x  <- dat[(dat$expId==eid) & (dat$expRepeat==er) & (dat$well==ew), ]
  ct <- with(crosstalk, kappa[(expId==eid) & (expRepeat==er) & dye=="yfp"])
  stopifnot(all(getDye(as.character(x$cloneId))=="yfp"),
            length(ct)==1, !any(is.na(ct)))
  
  tau     <- x$trsf - ct * x$dapi
  tauzero <- shorth(tau)
  rgtau   <- round(range(tau), 0)
  taumax  <- 100
  ptau    <- tau
  ptau[ptau>taumax] <- taumax
  
  col <- "#000080"
  pdf(file="fig_2.pdf", width=5, height=5)
  hist(ptau, col=col, border=col, breaks=100, main="",
       xlab="Signal intensity (expression) ", ylab="frequency")
  abline(v=tauzero, col="#c0c0c0", lwd=3)
  dev.off()
  cat("Fig. 2:\n",
      "Histogram of the YFP fluorescence intensities (arbitrary units) from ",
      length(tau), " cells within ",
      "one well. The range of the data was from ", rgtau[1], " to ", rgtau[2],
      ". The vertical grey line shows the midpoint of the shorth, which is an ",
      "estimator of the mode of the distribution.\n\n",
      sep="", file=capt)
  
  ##----------------------------------------------------------------------  
  ## Fig. 3 Scatterplot: 13_3_45
  ##----------------------------------------------------------------------  
  span   <- 0.99
  taumax <- 155
  lxmax  <- 60
  res    <- statWellLocfit(x,
                         plotwhat="figscp", plotfile="fig_3", plotdir=".",
                         crosstalk=ct, span=span,
                         qxmax=sum(tau<=taumax)/length(tau),
                         qymax=0.98, lxmax = 100)
  rgtau <- getPradaPar("minRgTau")["yfp"]
  cat("Fig. 3:\n",
      "Scatterplot of the YFP fluorescence intensities (x-axis) versus BrdU intensities (y-axis) ",
      "from ", length(tau), " cells within one well. The solid lines corresponds to a local linear ",
      "regression. The estimated local slope at x=", signif(tauzero, 2), " was ",
      sprintf("%1.2f", res$delta/rgtau), " and its standard error ",
      sprintf("%1.2f", res$se.delta/rgtau), ", resulting in a z-score of ",
      sprintf("+%2.1f", res$delta/res$se.delta), ".\n\n",
      sep="", file=capt, append=TRUE)
  
  rm(tau, tauzero, x, er, eid, ew)
}

##----------------------------------------------------------------------  
## Fig. 4. Plate Plot
##----------------------------------------------------------------------  
if (4 %in% makefig) {
eid <- "dorit14"
er  <- as.integer(1)
platename <- paste(eid, er, sep="_")
res <- analysePlate(eid, er, stat="statWellLocfit", plotwhat="nothing", span=span)
stopifnot(all(res$well == 1:96))
col  <- brewer.pal(9, "RdBu")[9:1]
col  <- c(col[1:4], rep(col[5], 2), col[6:9])
rg.score <- c(-6, 6)
pp   <- plotPlate(res, stat="zscore", zlim=rg.score, col=col, main="z-score",
                  device="pdf", plotfile="fig_4.pdf", width=8)
cat("Fig. 4:\n",
"Overview over the z-scores from a 96-well plate. The color code is shown by the colorbar ",
"at the right. Positions A2, B2, C9 and D9 correspond to cyclin A with YFP-tag, ",
"E2, F2, G9 and H9 with CFP tag. ",
"The catalytic subunit of phoshpatase 2 is on positions A3, B3 (YFP-tag) and E3, F3 (CFP-tag). ",
"YFP alone is on positions A1, B1, ",
"CFP alone on E1, F1. The other positions correspond to various ORFs that were investigated ",
"in this study.\n\n",
    sep="", file=capt, append=TRUE)
}

##----------------------------------------------------------------------  
## Fig. 8 (not used for paper): 2 Scatterplots next to each other
##----------------------------------------------------------------------  
if (8 %in% makefig) {
span   <- 0.997
taumax <- 180

eid <- c("doritwdh2", "doritwdh3")
er  <- as.integer(c(1,   1))
ew  <- as.integer(c(75, 89))
n   <- length(eid)
stopifnot(is.character(eid), is.numeric(er), is.numeric(ew),
          length(er)==n, length(ew)==n)

pdf(file="fig_8.pdf", width=8, height=4.75)
par(mfrow=c(1,2))
for(i in 1:n) {
  x  <- dat[(dat$expId==eid[i]) & (dat$expRepeat==er[i]) & (dat$well==ew[i]), ]
  cloneid <- unique(as.character(x$cloneId))
  thedye  <- getDye(cloneid)
  stopifnot(length(thedye)==1)
  ct <- with(crosstalk, kappa[(expId==eid[i]) & (expRepeat==er[i]) & dye==thedye])
  stopifnot(length(ct)==1, !any(is.na(ct)))

  ## debug(statWellLocfit)
  
  res  <- statWellLocfit(x,
     plotwhat="screen", 
     crosstalk=ct, span=span,
     qymin = 0.001, qxmax = 0.995, qymax = 0.995)
  
  rgtau <- getPradaPar("minRgTau")[thedye]
  
  cat("Fig. 8", c("a","b","c")[i], ":\n",
    "Scatterplot of the ", toupper(thedye), " fluorescence intensities (x-axis) versus BrdU intensities (y-axis) ",
    "from ", nrow(x), " cells that were transfected with ", cloneid, ". The z-score is ",
    sprintf("%2.1f", res$delta/res$se.delta), ".\n\n",
    sep="", file=capt, append=TRUE)
}
dev.off()
}
