if ("package:prada" %in% search()) detach("package:prada")
library(prada)
options(error=recover)

outdir <- "/home/whuber/fctassays/reports/fig.031219"
if(!exists("dat"))
  load("/home/whuber/fctassays/data/030909/dat.Mon-Oct-27-13:37:25-2003.rda")

setPradaPars(list(
  minRgTau   = unlist(list(cfp=150, yfp=15)),
  nrCellsTopBottom = 20,                   
  minNrCells = 100,
  debug      = TRUE))

crosstalk <- NULL
for (expId in levels(dat$expId)) {
  dat1 <- dat[dat$expId==expId, ]
  for (expRepeat in unique(dat1$expRepeat)) {
    platename <- paste(expId, expRepeat, sep="_")
    cat(platename)
    ct <- estimateCrosstalkPlate(
      dat1[dat1$expRepeat==expRepeat, ],
      plotfileprefix = file.path(outdir, paste("ct_", platename, sep="")))
    cat("", paste(names(ct), signif(ct,3)), "\n")
    for (dye in names(ct))
      crosstalk <- rbind(crosstalk,
           data.frame(expId=I(expId), expRepeat=I(expRepeat), dye=I(dye), kappa=ct[dye]))
  }
}

save(crosstalk, file="crosstalk.rda")

par(mfrow=c(2,1))
cols        <- c("#984ea3", "#4daf4a")
names(cols) <- c("cfp",     "yfp")
for(i in 1:2)
  hist(crosstalk$kappa[crosstalk$dye==names(cols)[i]],
       breaks=seq(min(crosstalk$kappa)-0.01, max(crosstalk$kappa)+0.01, by=0.005),
       col=cols[i],
       main=names(cols)[i], xlab="kappa")
savepdf("crosstalk", width=6, height=8)
