### Name: matchprobes
### Title: A function to match a query sequence to the sequences of a set
###   of probes.
### Aliases: matchprobes
### Keywords: manip

### ** Examples

  ## The main intention for this function is together with the probe
  ## tables from the "probe" data packages, e.g.:
  ## > library(hgu95av2probe)
  ## > data(probe)
  ## > seq <- probe$sequence
  ##
  ## Since we do not want to be dependent on the presence of this 
  ## data package, for the sake of example we simply simulate some
  ## probe sequences:

  bases <- c("A", "C", "G", "T")
  seq   <- sapply(1:1000, function(x) paste(bases[ceiling(4*runif(256))], collapse=""))

  w1 <- seq[20:22]
  w2 <- complementSeq(w1, start=13, stop=13)
  w  <- c(w1, w2)

  matchprobes(w, seq)
  matchprobes(w, seq, probepos=TRUE)



