### Name: read.marrayRaw
### Title: Create objects of class "marrayRaw"
### Aliases: read.marrayRaw read.Spot read.GenePix read.SMD read.Agilent
###   widget.marrayRaw
### Keywords: file

### ** Examples

datadir <- system.file("swirldata", package="marray")

skip <-  grep("Row", readLines(file.path(datadir,"fish.gal"), n=100)) - 1

swirl.layout <- read.marrayLayout(ngr=4, ngc=4, nsr=22, nsc=24)

swirl.targets <- read.marrayInfo(file.path(datadir, "SwirlSample.txt"))

swirl.gnames <- read.marrayInfo(file.path(datadir, "fish.gal"),
                                info.id=4:5, labels=5, skip=skip)

x <-  maInfo(swirl.gnames)[,1]
y <- rep(0, maNspots(swirl.layout))
y[x == "control"] <- 1
slot(swirl.layout, "maControls") <- as.factor(y)

fnames <- dir(path=datadir,pattern=paste("*", "spot", sep="\."))
swirl<- read.Spot(fnames, path=datadir,
                       layout = swirl.layout,
                       gnames = swirl.gnames,
                       targets = swirl.targets)




