\name{bayesFun}
\alias{bayesFun}

\title{A function that calculates an odds ratio of each gene in a
  multi-slide microarray experiment}

\description{
  This is a wrapper function around stat.bay.est which takes
  independent, sufficient estimates of the  effect and its variance for
  each gene in a multi-slide microarray experiment and returns an odds
  ratio for each gene: log( Pr(the gene is differentially expressed) /
  Pr(the gene is not differentially expressed) ). 
}

\usage{
bayesFun(...)
}

\arguments{
  \item{...}{arguments for the fuction \code{lm.series} and \code{ebayes}}
}

\details{
  see \code{\link{ebayes}} for details.
}

\value{
  Returns a function.
}

\references{I. Lnnstedt and T. P. Speed.  Replicated Microarray Data.
  Statistical Sinica, Accepted, see
  http://www.stat.berkeley.edu/users/terry/zarray/Html/papersindex.html} 

\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{lm.series}},\code{\link{ebayes}}}

\examples{
  bayesFun()
}

\keyword{models}

\eof
\name{findID}
\alias{findID}

\title{Find ID when given an accession number}
\description{
  Search gene ID with a vector of accession number from gene names or ID
  values.
}

\usage{
findID(text, Gnames = gnames, ID = "Name")
}

\arguments{
  \item{text}{A character strings of gene names or id names}
  \item{Gnames}{An objects of \code{marrayRaw}, \code{marrayNorm},
    \code{exprSet} or data.frame of gene names information.}
  \item{ID}{The column of ID corresponding to 'text'}
}

\value{
  A numeric vector the gene ID.
}
\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{grep}}}

\examples{
library(marrayInput)
data(swirl)
findID("fb24a09", swirl, ID="ID")
findID("geno1", swirl)
}

\keyword{manip}% at least one, from doc/KEYWORDS

\eof
\name{htmlPage}
\alias{htmlPage}
\alias{table2html}

\title{Display gene list as a HTML page}
\description{
Given a set of index to a data.frame containing gene names information.
We create a web page with one element per genes that contains URLs links
to various external database links.
E.g Operon oligodatabase , Riken, GenBank and PubMed web sites. 
}

\usage{
htmlPage(genelist, filename = "GeneList.html", geneNames =
                 Gnames, mapURL = SFGL, othernames, title, table.head,
                 table.center = TRUE, disp = c("browser", "file")[1])

table2html(restable, filename = "GeneList.html", mapURL = SFGL,
                 title, table.head, table.center = TRUE, disp =
                 c("browser", "file")[1])
}

\arguments{
  \item{restable}{A data.frame that contains only the information you
    wish to display in the html file.  The rows corresponds to a
    different DNA spots.}
  \item{genelist}{A numeric vector of index to a data.frame}
  \item{filename}{The name of the file to store the HTML in. }
  \item{geneNames}{A data.frame containing the information related the
    each DNA spots. }
  \item{mapURL}{A matrix of characters containing the URL for various
    external database.  E.g \code{\link{SFGL}}.}
  \item{othernames}{A data.frame containing other information.}
  \item{title}{Title of the HTML page}
  \item{table.head}{ A character vector of column labels for the table}
  \item{table.center}{A logical indicating whether the table should be
    centered}
  \item{disp}{Either "File" or "Browser" (default is Browser). File will
    save the information in html file, while Browser will create an html
    files and display information in the user's browser.}
}
\details{
  This function is an extension to \code{\link{ll.htmlpage}}
}

\value{
  No value is return, the function produce a html file "filename" and
  output the results in a browser.
}
\author{Yee Hwa Yang }

\seealso{\code{\link{ll.htmlpage}}, \code{\link{URLstring}}, \code{\link{widget.mapGeneInfo}}}

\examples{
library(annotate)
library(marrayClasses)
data(swirl)
Gnames <- maGeneTable(swirl)
swirlmap <- mapGeneInfo(Name = "none", ID="genbank")
## htmlPage(100:110, geneNames = Gnames, mapURL = swirlmap, title="Swirl")

moreinfo <- round(maM(swirl), 2)
swirlmap <- mapGeneInfo(Name = "pubmed", ID="genbank")
htmlPage(100:110, geneNames = Gnames, mapURL = swirlmap, othernames=moreinfo, title="Swirl", disp="file")
}
\keyword{file}% at least one, from doc/KEYWORDS

\eof
\name{maBayesian}
\alias{maBayesian}

\title{Calculates an Odds Ratio for Each Gene in a Multi-slide Microarray Experiment. }

\description{This function calls the function "lm.series" and "ebayes"
  in the package "limma" to calculate the log-odds of differential
     expression by empirical Bayes shrinkage of the standard errors
     towards a common value.  }

\usage{
maBayesian(mraw, ...)
}

\arguments{
  \item{mraw}{An object of class "matrix", "dataframe",
    "marrayRaw", "marrayNorm" or "exprSet" that contains gene expression data.}
  \item{...}{arguments for the fuction \code{lm.series} and \code{ebayes}}
}

\value{
  See \code{\link{ebayes}} for details.
}

\author{Yee Hwa Yang \email{jean@biostat.ucsf.edu} \cr}

\seealso{\code{\link{lm.series}},\code{\link{ebayes}}}

\examples{
## data(swirl)
## M <- sweep(maM(swirl), 2, c(1,-1,1,-1), FUN="*")
## est <- maBayesian(M)
}

\keyword{models}
%\keyword{microarray, bayesian, lodsratio}









\eof
\name{na}

\alias{log.na}
\alias{sum.na}
\alias{mean.na}
\alias{var.na}
\alias{cor.na}
\alias{quantile.na}
\alias{length.na}
\alias{order.na}
\alias{scale.na}
\alias{prod.na}

\title{Basic Statistical Functions for Handling Missing Values}

\description{
Basic statistical functions for handling missing values or NA. \cr 
In \code{log.na}, \code{sum.na}, \code{mean.na} and \code{var.na},
\code{quantile.na}, \code{length.na}, missing values are omitted
from the calculation. \cr 
The function \code{cor.na} calls \code{cor} with the argument
\code{use="pairwise.complete.obs"}. \cr 
The function \code{order.na} only handles vector arguments and not
lists.  However, it gives the option of omitting the NAs
(\code{na.last=NA}), of placing the NAs at the start of the ordered
vector (\code{na.last=F}) or at the end (\code{na.last=T}). \cr 
The function \code{scale.na} is a modified version of
\code{\link{scale}} which allows NAs in the variance calculation. If
\code{scale = T}, the function \code{f} in \code{scale.na} uses
\code{var.na} to perform the variance calculation.
The function \code{prod.na} is similar to the \code{\link{prod}}
function with \code{na.rm=TRUE}. This function returns the product of
all the values present in its arguments, omitting any missing values.
}

\author{
  Yee Hwa Yang, \email{jean@biostat.berkeley.edu} \cr
}

\seealso{\code{\link{log}}, \code{\link{sum}}, \code{\link{mean}},
  \code{\link{var}}, \code{\link{cor}}, \code{\link{order}},
  \code{\link{scale}}, \code{link{prod}}.}

\keyword{log, sum, mean, variance, correlation, order, scale,
product, missing values, NA.} 
 

\eof
\name{maQualityMain}
\alias{maQualityMain}
\alias{maQuality}

\title{Calculate basic array wide statistics}

\description{
  This is based on GenePix output and it calculates summary statistics
  of various signal to noise ratios.
}
\usage{
maQualityMain(mraw, path=".", fname, output = FALSE)
maQuality(mraw, path=".")
}

\arguments{
  \item{mraw}{Microarray object of class `"marrayRaw"'.
    By default, plots are done for the first array in the batch.}
  \item{path}{a character string representing the data directory. By
    default this is set to the current working directory (".").
    In the case where "fname" contains the full path name, path
    should be set to NULL. }
  \item{fname}{a vector of character strings representing the name of
    the output file. This is only used when "output" is TRUE.}
  \item{output}{if TRUE, write the results to a file.}
}

\value{
  Produce a lists of various summary statistics
}

\author{Jean Yee Hwa yang}

\seealso{\code{\link{summary}}, \code{\link{maGenControls}}}

\examples{
##   data(swirl)
##   datadir <- system.file("data", package="marrayInput")
##   maControls(swirl) <- maGenControls(maGnames(swirl), id="Name")
##   maQualityMain(swirl[,1], path=datadir)
}

\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{maSelectGnames}
\alias{maSelectGnames}

\title{Select genes according to the values of a few different statistics}
\description{
  Select genes by considering the \code{\link{union}} or
  \code{\link{intersect}} of multiple statistics.
}

\usage{
maSelectGnames(statdata, crit1 = 50, crit2 = crit1, sub = TRUE, selectstat, operate = c("intersect", "union"))
}

\arguments{
  \item{statdata}{A numerical matrix where the rows corresponds to genes
    and the columns corresponds to various statistics corresponding to a
    particular gene.}
  \item{crit1}{The number of points to be selected.
   If crit1 < 1, the crit1*100\% spots with the smallest M values
   will be selected. If crit1 >= 1, the crit spots  with the
   smallest M values are selected.}  
 \item{crit2}{Similar to "crit1".   If crit2 < 1, the crit2*100\%
   spots with the largest M values will be selected. If crit2 >= 1,
   the crit2 spots with the largest M values are selected.}  
 \item{sub}{A "logical" or "numeric" vector indicating the subset of
   genes to be consider.}
 \item{selectstat}{A integer value indicating the statistics where the
   final ranking is based on.}
 \item{operate}{The operation used to combined different rankings}
}
\details{
  This functions calls \code{\link{stat.gnames}} to select say the 100
  most extreme genes from various statistics and combined the different
  gene lists by either union or intersection.
}
\value{
  A vector of numeric values.
}

\author{Jean Yee Hwa Yang}

\seealso{\code{\link{stat.gnames}}, \code{\link{order}}}

\examples{
library(marrayClasses)
X <- matrix(rnorm(1000), 100,10)
Xstat <- maStat(X, funNames=c("meanFun", "ttestFun"))
maSelectGnames(Xstat[,1:2], crit1=50)
}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{maStat}
\alias{maStat}
\alias{widget.Stat}

\title{A function to calculates various statistics}
\description{
   \code{maStat} calculates various statistcs for genes in the array
   `expr' using the functions in `funNames'.It returns an matrix of
   values.
 }
\usage{
maStat(expr, funNames, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{expr}{An object of class "matrix", "dataframe",
    "marrayRaw", "marrayNorm" or "exprSet" that contains gene expression
    data.}    
  \item{funNames}{Either a character strings containning the names of
    functions or a list of statistics functions.}
  \item{\dots}{further arguments to the functions is 'funNames'}.
}

\value{
  A matrix of values.
}

\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{meanFun}}, \code{\link{ttestFun}}}

\examples{
## X <- matrix(rnorm(1000), 100,10)
## maStat(X, funNames=c("meanFun", "ttestFun"))
## maStat(X, funNames=list(mean=meanFun(), t=ttestFun()))
}
\keyword{htest}% at least one, from doc/KEYWORDS


\eof
\name{Internal functions}
\alias{maText}
\alias{stat.gene.cluster}
\alias{plot.gene.cluster}
\alias{tablegen}
\alias{gsubAnchor}

\title{Internal marrayTools functions}
 
\description{Internal marrayTools functions}
 
\details{These are not to be called by the user.}

\keyword{methods}

\eof
\name{maTwoSamples}
\alias{maTwoSamples}
\alias{widget.TwoSamples}

\title{Changing signs for two sample analysis}
\description{
  Taking target file information and flip the dye swaps experiments.
}
\usage{
maTwoSamples(targetfile, normdata, Trt, Ctl, targetID = "TargetName", slidesID = "Slides", dyesID = "Dyes", RedID = 5, path = ".", output = TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{targetfile}{A data.frame containing target samples information.}
  \item{normdata}{A R object of class 'marrayNorm'}
  \item{Trt}{A character string representing "treatment" sample.}
  \item{Ctl}{A character string representing "controls" sample.}
  \item{targetID}{A character string representing the column name
    in 'targetfile' containing target samples information.}
  \item{slidesID}{A character string representing the column name
    in 'targetfile' containing the slide label.}
  \item{dyesID}{A character string representing the column name
    in 'targetfile' containing dye labeled information.}
  \item{RedID}{The character use to represent the Cy5 dye.}
  \item{path}{A character string representing the data directory. By
    default this is set to the current working directory ("."). }
  \item{output}{Save and tab delimited file}
}

\value{
  An objects of 'marrayNorm' with the dye assignment adjusted.
}

\author{Yee Hwa (Jean) Yang}

\keyword{manip}% at least one, from doc/KEYWORDS

\eof
\name{mapGeneInfo}
\alias{mapGeneInfo}
\alias{widget.mapGeneInfo}
\alias{URLstring}
\alias{SFGL}
\alias{UCBFGL}

\title{Creating URL strings for external database links }

\description{
  These functions are used with \code{\link{htmlPage}}.
  The function \code{mapGeneInfo}, takes all the arguments and generate
  a character matrix of two columns.  The first columns representing the
  name of the argument and the second columns represents the value of an
  argument. 
  The function \code{widget.mapGeneInfo} allows the user to enter this
  information  interactively. 
}

\usage{
mapGeneInfo(widget = FALSE, Gnames, Name = "pubmed", ID =
                 "genbank", ACC = "SMDacc", ...)
widget.mapGeneInfo(Gnames) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{widget}{A logical value specifying if widgets should be used.}
  \item{Name}{The external database for spot description, E.g. "pubmed".}
  \item{ID}{The external database for spot ID, E.g. "operon", "Riken", "locuslink".}
  \item{ACC}{The external database for gene accession number, E.g. "genebank".}
  \item{Gnames}{An object of class \code{matrix}, \code{data.frame} or \code{marrayInfo}
    which contains  description of spotted probe sequences.}
  \item{\dots}{Other column names}
}
\details{
  The function \code{mapGeneInfo} generates a character matrix with the
  first column representing the column headings of "Gnames" and the
  second column representing the corresponding names in the list
  \code{URLstring}.  For example, if a particular column in "Gnames"
  with column names "ID" contains genebank accession number, then the
  function \code{mapGeneInfo} generates a row containing "ID" in the
  first column and "genbank" in the second.  Examples are \code{SFGL}
  and \code{UCBFGL}.\cr
  
  \code{URLstring} is a list contains the URL to various external
  database, E.g. operon, Riken, genbank. \cr
  The current choices are: 
  "pubmed",  "locuslink",  "riken",   "SMDclid",    "SMDacc",    "operonh2",  "operonh1" ,
  "operonm2",  "operonm1" and  "genbank" .  
  "SMDclid" and "SMDacc" are links to Stanford Microarray Databases.
 }

 \author{Jean Yee Hwa Yang}

 \examples{
 mapGeneInfo(ID="genebank", ll="locuslink")
 mapGeneInfo(ID="locuslink", Sample.ID="riken")
}

\keyword{manip}% at least one, from doc/KEYWORDS



\eof
\name{marrayTools}
\alias{spotTools}
\alias{gpTools}

\title{Wrapper function}
\description{
  This functions will produce a directory of diagnostic plots, quality
  measures and normalization.
}
\usage{
spotTools(fnames, path = ".", galfile, bg = TRUE, plot = TRUE,
                 quality = TRUE, fill = TURE, raw = FALSE, echo =
                 TRUE, ...)

gpTools(fnames, path = ".", galfile, bg = TRUE, plot = TRUE, quality = TRUE, fill = TRUE, raw = FALSE, echo = TRUE, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
    \item{fnames}{a vector of character strings containing the file names of
    each spot quantification data file.  These typically end in \code{.spot}
    for the software \code{Spot} or \code{.gpr} for the software \code{GenePix}.}
  \item{path}{a character string representing the data directory. By
    default this is set to the current working directory (".").  In the
    case where \code{fnames} contains the full path name, path should be set
    to NULL.}
  \item{galfile}{a character string representing the Gal file.}
  \item{bg}{logical: if 'TRUE', background correction is performed before normalization}
  \item{plot}{logical: if 'TRUE', maDiagnPlots is call to generate basic
    diagnostic plot per array.}
  \item{quality}{logical: if 'TRUE', maQuality is call to calculate basic quality measures.}
  \item{fill}{logical: if `TRUE', `scan' will implicitly add empty fields
    to any lines with fewer fields than implied by `what'.}
  \item{raw}{logical: if 'TRUE', the microarray object class of
    'marrayRaw' is return rather than 'marrayNorm'.}
  \item{echo}{logical: if 'TRUE' (default), run-time
    information of the array currently being process is printed.}
  \item{\dots}{further arguments to \code{\link{scan}} or \code{\link{maNorm}}.}
}

\value{
  Jpeg files of diagnostic plots, excel files of quality measures, tab
  delimited files of normalized log-ratios and log-intensities values are
  saved to disk.
  In addition, an object of class \code{\link{marrayRaw}} or \code{\link{marrayNorm}} is return.
}

\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{read.marrayRaw}}}

\examples{
 data(swirl)
 datadir <- system.file("data", package="marrayInput")

## normdata <- spotTools(path=datadir, quality=FALSE)
}

\keyword{file}% at least one, from doc/KEYWORDS


\eof
\name{meanFun}
\alias{meanFun}

\title{A function that calculates the average of each gene in a
  multi-slide microarray experiment}

\description{
  Returns a function that calculate \code{mean}.
}

\usage{
meanFun(y = NULL, na.rm = TRUE)
}

\arguments{
  \item{y}{vector of class labels. Must consist of integers 1 and 2.}
  \item{na.rm}{If TRUE, the NA's are omit from the analysis.}
}

\value{
   Returns a function with bindings for 'y' (class labels) that will
   calculate average across slides.
}


\author{Yee Hwa (Jean) Yang }
\seealso{\code{\link{mean}}}

\examples{
## x <- rnorm(10)
## y <- meanFun()
## y(x)
}

\keyword{univar}% at least one, from doc/KEYWORDS


\eof
\name{numNAFun}
\alias{numNAFun}

\title{A function that calculates the number of NA of each gene in a
  multi-slide microarray experiment. }

\description{
  Returns a function that calculates the number of NA of each gene across
  multi-slide microarray experiment.
}

\usage{
numNAFun()
}

\arguments{
}


\value{
  Returns a function.
}


\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{is.na}}}

\examples{
x <- rnorm(10)
x[8] <- NA
y <- numNAFun()
y(x)
}
\keyword{univar}% at least one, from doc/KEYWORDS



\eof
\name{opVersionID}
\alias{opVersionID}

\title{Determine the operon oligo set ID}
\description{
  This functions looks the operon ID and determine whether it belongs to 
  "Human Genome Oligo Set V1", "Human Genome Oligo Set V2", "Mouse
  Genome Oligo Set V1" or "Mouse Genome Oligo Set V2". 
}

\usage{
opVersionID(opID)
}

\arguments{
  \item{opID}{A character strings representing operon ID}
}

\value{
  A value "operonh1", "operonh2", "operonm1" or "operonm2" to represents
  "Human Genome Oligo Set V1", "Human Genome Oligo Set V2", "Mouse
   Genome Oligo Set V1" or "Mouse Genome Oligo Set V2". 
}

\references{\url{http://oparray.operon.com/}}
\author{Jean Yee Hwa Yang}

\seealso{\code{\link{URLstring}}, \code{\link{htmlPage}}}

\examples{
 opVersionID("M000205_01")
 URLstring[opVersionID("M000205_01")]
}

\keyword{manip}% at least one, from doc/KEYWORDS

\eof
\name{rm.na}
\alias{rm.na}

\title{Remove missing values}
\description{
  Remove NA's, NAN's and INF's from a vector.
}

\usage{
rm.na(x)
}

\arguments{
  \item{x}{A numeric vector}
}

\value{
  A vector with all NA's remove.
}

\author{Jean Yang}

\examples{
x <- round(rnorm(10), 2)
x[c(2,4,5)] <- NA
x
rm.na(x)
}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{stat.confband.text}

\alias{stat.confband.text}

\title{Rank genes according to the value of a statistic.}
  
\description{
  Select values based on intensities binning.
}

\usage{
stat.confband.text(M, A, crit1=0.025, crit2=crit1, nclass=5)
}

\arguments{
 \item{A}{a vector giving the x-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          average log intensities. ie A} 
 \item{M}{a vector giving the y-coordinates of the points in the scatter
   plot. In the microarray context, this could be a vector of log
   intensity ratios.} 
 \item{crit1}{The number of points to be selected.
   If crit1 < 1, the crit1*100\% spots with the smallest M values
   will be selected. If crit1 >= 1, the crit spots  with the
   smallest M values are selected.}  
 \item{crit2}{Similar to "crit1".   If crit2 < 1, the crit2*100\%
   spots with the largest M values will be selected. If crit2 >= 1,
   the crit2 spots with the largest M values are selected.}  
 \item{nclass}{A single number giving the approximate number of
   intensity depedent groups to consider.} 
% \item{labs}{ one or more character strings or expressions specifying the
%   text to be written.  If this string is not specified, by
%   default the index of the vector `M' will be used.}
% \item{output}{logical, defaulting to `FALSE'. If `TRUE' a vector
%   containning the index to the vector `M' that are  
%   highlighted.} 
}


\value{
  A vector of selected spot index.
}

\examples{
library(marray)
data(swirl)
aveA <- apply(maA(swirl), 1, mean.na)
aveM <- apply(maM(swirl), 1, mean.na)
stat.confband.text(aveM, aveA, crit1=20, crit2=50, nclass=5)
}

\seealso{ \code{\link{stat.gnames}}}

\keyword{manip}

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-11-08 :05:09.
% Do NOT modify this file, instead modify the source (Rarray.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{stat.gnames}

\alias{stat.gnames}

\title{Sort Genes According to the Value of a Statistic}

\description{
Lists genes and corresponding statistics in decreasing order of the
statistics. This function applies to any type of statistic, including
log ratios, one and two-sample t-statistics, and F-statistics. Missing
values are ignored, as in \code{\link{sort}(..., na.last=NA)}. 
}

\usage{
stat.gnames(x, gnames, crit= 50)
}

\arguments{
 \item{x}{a numeric vector containing the statistics for each
 gene. Missing values (NAs) are allowed. }
 
\item{gnames}{a character vector containing the gene names.}

 \item{crit}{specifies the number of genes to be returned. If crit <
 1, the crit*100\% genes with the largest x values are listed. If crit
 >= 1, the crit genes with the largest x values are listed. }
}

\value{
List containing the following components 
  \item{gnames}{gene names sorted in decreasing order of the
 statistics in x.}
 \item{t}{statistics sorted in decreasing order.}
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} }

\seealso{\code{\link{order}}, \code{\link{sort}}.}

\examples{
## data(swirl)
## aveM <- apply(maM(swirl), 1, mean.na)
## Gnames <- maGeneTable(swirl)

## stat.gnames(abs(aveM), Gnames, crit=10)
## stat.gnames(aveM, Gnames, crit=0.01)
}

\keyword{misc}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{ttestFun}
\alias{ttestFun}

\title{A function that calculates the t-statistics
  of each gene in a multi-slide microarray experiment.}

\description{
  Returns a function that calculate \code{t.test}.
}
\usage{
ttestFun(y = NULL, var.equal = FALSE, alternative = c("two.sided", "less", "greater"), na.rm = TRUE)
}

\arguments{
  \item{y}{vector of class labels. Must consist of integers 1 and 2.}
  \item{var.equal}{ a logical variable indicating whether to treat the two
          variances as being equal. If `TRUE' then the pooled variance
          is used to estimate the variance otherwise the Welch
          approximation to the degrees of freedom is used.}
  \item{alternative}{ a character string specifying the alternative hypothesis,
          must be one of `"two.sided"' (default), `"greater"' or
          `"less"'.  You can specify just the initial letter.}
  \item{na.rm}{If TRUE, the NA's are omit from the analysis.}

}

\value{
  Returns a function that performs \code{t.test}.
}


\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{t.test}}}

\examples{
## x <- rnorm(10)
## y <- ttestFun()
## y(x)
}
\keyword{univar}% at least one, from doc/KEYWORDS


\eof
