\name{Cdf-class}
\docType{class}
\alias{Cdf-class}
\alias{atom}
\alias{atom<-}
\alias{name.levels}
\alias{name.levels<-}
\alias{pbase}
\alias{pbase<-}
\alias{pbase.levels}
\alias{pbase.levels<-}
\alias{tbase}
\alias{tbase<-}
\alias{tbase.levels}
\alias{tbase.levels<-}
\alias{atom,Cdf-method}
\alias{atom<-,Cdf-method}
\alias{name.levels,Cdf-method}
\alias{name.levels<-,Cdf-method}
\alias{pbase,Cdf-method}
\alias{pbase<-,Cdf-method}
\alias{pbase.levels,Cdf-method}
\alias{pbase.levels<-,Cdf-method}
\alias{tbase,Cdf-method}
\alias{tbase<-,Cdf-method}
\alias{tbase.levels,Cdf-method}
\alias{tbase.levels<-,Cdf-method}
\alias{show,Cdf-method}


\title{Class Cdf}
\description{A class describing the content a Chip Description File.}
\section{Creating Objects}{
  \code{  new('Cdf',}\cr
  \code{    cdfName      = ...., # Object of class character}\cr
  \code{    name         = ...., # Object of class matrix}\cr
  \code{    name.levels  = ...., # Object of class character}\cr
  \code{    pbase        = ...., # Object of class matrix}\cr
  \code{    pbase.levels = ...., # Object of class character}\cr
  \code{    tbase        = ...., # Object of class matrix}\cr
  \code{    tbase.levels = ...., # Object of class character}\cr
  \code{    atom         = ...., # Object of class matrix}\cr
  \code{  )}}
\section{Slots}{
  \describe{
    \item{\code{cdfName}:}{the CDF name tag. Used to link with the right
      CEL files}
    \item{\code{name}:}{Object of class "matrix" of 'factors' for the gene names corresponding to the probes.}
    \item{\code{name.levels}:}{Object of class "character" containing
      the levels corresponding to \code{name}.} 
    \item{\code{pbase}:}{Object of class "matrix" of pbase levels.}
    \item{\code{pbase.levels}:}{Object of class "character"  containing
      the levels corresponding to \code{pbase}. }
    \item{\code{tbase}:}{Object of class "matrix" of tbase levels.}
    \item{\code{tbase.levels}:}{Object of class "character" containing
      the levels corresponding to \code{tbase}.  }
    \item{\code{atom}:}{Object of class "matrix" of atom or probe numbers.}
  }
}

\details{
  The class \code{Cdf} was designed to store the content of Affymetrix's
  Chip Definition Files (CDF). This early class is no longer widely used
  in the package affy. Environments (called \code{cdfenvs}) are
  preferred to have an efficient mapping between probe set identifiers
  and indexes (needed to access/subset particular probe intensities).
  Unless one needs to access every information contained in a
  CDF file, the \code{cdfenvs} will be preferred.

  The following comments are only relevant to someone with interest in
  what is in a CDF file.
 The name associated
 to each probe is not unique, it corresponds to the gene name. It is
 very common to have a name repeated 40 times (20 perfect matches and 20
 mismatches). Probes can be grouped by pairs: a perfect
 match (PM) probe has its mismatch (MM) counterpart. The two probes in a
 pair differ by one base (usually located in the middle of the
 sequence). The information relative to this particular base are stored
 in \code{pbase} and \code{tbase}. At a given position (x,y), having
 pbase[x,y] == tbase[x,y] means having a MM while having pbase[x,y] !=
 tbase[x,y] means having a perfect mismatch if and only if one of the
 bases is A while the other is TRUE, or one is G and the other is C. The
 function 
 \code{\link{pmormm}} returns \code{TRUE} for PMs and \code{FALSE} for
 MMs.

 To know more about the file structure of a CDF file, one has to refer
 to the parsing code (mostly in C).
}
\seealso{
\code{\link{read.cdffile}},
\code{\link{make.cdf.env}},
\code{\link{make.cdf.package}}
}
\author{L. Gautier <laurent@cbs.dtu.dk>}

\section{Methods}{
  \describe{
    \item{atom}{(Cdf): An accesor function for the
      \code{ato,} slot. }
    \item{atom<-}{(Cdf):  A replacement function for
      \code{atom} slot. }
    \item{name.levels}{(Cdf):  An accesor function for the
      \code{name.levels} slot. }
    \item{name.levels<-}{(Cdf): A replacement function for
      \code{name.levels} slot. }
    \item{pbase}{(Cdf):  An accesor function for the
      \code{pbase} slot. }

    \item{pbase<-}{(Cdf): A replacement function for
      \code{pbase} slot. }
    \item{pbase.levels}{(Cdf):  An accesor function for the
      \code{pbase.levels} slot. }
    \item{pbase.levels<-}{(Cdf): A replacement function for
      \code{pbase.levels} slot. }
    \item{show}{(Cdf):  renders information about the exprSet in a concise
      way on stdout. }
    \item{tbase}{(Cdf):  An accesor function for the
      \code{tbase} slot. }
    \item{tbase<-}{(Cdf): A replacement function for
      \code{tbase} slot. }
    \item{tbase.levels}{(Cdf):  An accesor function for the
      \code{tbase.levels} slot. }
    \item{tbase.levels<-}{(Cdf): A replacement function for
      \code{tbase.levels} slot. }
  }
}
\keyword{methods}

\eof
\name{getInfoInFile}
\alias{getInfoInFile}
\title{get information from Affymetrix data files}
\description{
  Get specific information stored in Affymetrix data files (CEL or CDF).
}
\usage{
getInfoInFile(filename, type, unit, property, compress = NULL)
}
\arguments{
  \item{filename}{a file name }
  \item{type}{\code{"CEL"} or \code{"CDF"} are the only known types.}
  \item{unit}{the 'unit' to find the information}
  \item{property}{the 'property' of interest}
  \item{compress}{a boolean}
}
\details{
  The data files seem to have a structure of 'units'. A 'unit' start
  with something between square brackets (ex: "[UNIT1]"). The parameter
  \code{unit} let one specify in which unit the information of interest
  is located. The 'properties' are constituted of an identifier, the
  sign '=' and the value for the property (ex: "numCells=12000").

  If you are planning to use this function, I assume you know the what
  is in CEL and CDF files in details and that you know what are doing.
}
\value{
  a character with the value of the 'property'.
}
\note{
  The code goes through the file until the rigth 'unit' is found. Then
  it looks for the right 'property' further down (eventually going
  through the next units if the property is not found).
}
\seealso{\code{read.celfile}, \code{read.cdffile}, \code{whatcdf}}
\keyword{manip}

\eof
\name{make.cdf.env}
\alias{make.cdf.env}
\title{CDF Environment Maker}
\description{Reads an Affymetrix chip description file (CDF) and creates an
environment used as a hash table for the probe set mapping to location.}
\usage{
make.cdf.env(filename,
             cdf.path = getwd(),
             compress = FALSE,
             return.env.only = TRUE,
             verbose = TRUE)
}
\arguments{
  \item{filename}{Character. Filename of the CDF file -
    \bold{without} the path prefix!}
  \item{cdf.path}{Character. Path to the CDF file.}
  \item{compress}{Logical. If \code{TRUE}, CDF file is compressed.}
  \item{return.env.only}{Logical. If \code{TRUE} (the default),
    then the function returns an environment. Otherwise, a list with
    two elements, the first being the environment, and the second being
    a data structure that contains additional information needed for
    the package builder (see details, and vignette).}
  \item{verbose}{Logical. If \code{TRUE}, messages are shown.}
}

\value{Depending on the argument \code{return.env.only},
  either the environment, or a list with two elements,
  \code{env} and \code{syms}. See details.}

\details{Normally, this function should not be called directly. The
  preferred way to handle CDF information is to use
  \code{\link{make.cdf.package}} to build a package, and to
  install it into R. The CDF information can then either be invoked
  automatically by the package \code{affy}, or can be loaded manually by
  calling, for example, \code{library(hgu133a)}.
  
  Some R installations (typically on Windows) do not offer all the tools
  that are necessary for package building. In such situations, this
  function may be called directly. Please see the vignette for details
  - type:

  \code{openVignette("makecdfenv")}

  \bold{Return values:}  
  \code{env} is an environment, used as a hash table.
  For every probe set name we have a matrix with 2 columns. The first
  column contains the PM locations and the second column the MM
  locations. For PM only chips the MM column will have NAs.
  
  \code{syms} is a list that contains chip-specific (i.e., CDF-file
  specific) information that can be used in the construction of the help
  files for the CDF package.
}
\seealso{\code{\link{make.cdf.package}}}
\author{Rafael A. Irizarry, Wolfgang Huber}
\examples{
  env <- make.cdf.env("Hu6800.CDF.gz",
           cdf.path=system.file("extdata", package="makecdfenv"),
           compress=TRUE)
  length(ls(env))
  get("U53347_at", env)	   
}
\keyword{manip}

\eof
\name{make.cdf.package}
\alias{make.cdf.package}
\title{CDF Environment Package Maker}
\description{
This function reads an Affymetrix chip description file (CDF) and
creates an R package that when loaded has the CDF environment available
for use.}
\usage{
make.cdf.package(filename,
  packagename  = NULL,
  cdf.path     = getwd(),   
  package.path = getwd(),
  compress     = FALSE,
  author       = "The Bioconductor Project",
  maintainer   = "The Bioconductor Project <bioconductor@stat.math.ethz.ch>",
  version      = library(help=makecdfenv)$info[[2]][[2]][2],
  unlink       = FALSE,
  verbose      = TRUE)
}
\arguments{
  \item{filename}{Character. Filename of the CDF file -
    \bold{without} the path prefix!}
  \item{packagename}{Character. Name wanted for the package.}
  \item{cdf.path}{Character. Path to the CDF file.}
  \item{package.path}{Character. Path where the package will be created.}
  \item{compress}{Logical. If \code{TRUE}, CDF file is compressed.}
  \item{author}{Character. What to put in the \code{author} field of the package.}
  \item{maintainer}{Character. What to put in the \code{maintainer} field of the package.}
  \item{version}{Character. What to put in the version
   field. Should be a of the form \code{x.x.x}.}
  \item{unlink}{Logical. If \code{TRUE}, and a package directory exists
   already in \code{package.path}, that is overwritten.}
  \item{verbose}{Logical. If \code{TRUE} messages are shown.}
}
\details{The function is called for its side effect, creating a package.
By default the package name will be the name of the CDF file made lower
case and with special characters removed (i.e. only
alpha-numeric). 
  
In general one would want to use the name given in by
\code{cleancdfname(abatch@cdfName)} with \code{abatch} an
\code{\link[affy]{AffyBatch}} object obtained, for example, using
\code{\link[affy]{ReadAffy}}. This is the package name that the
\code{affy} package looks for by default.

If the user has a CEL file, called \code{filename}, the recommended
package name for the environment is
\code{cleancdfname(whatcdf(filename))}. This usually coincides with
the default.

Please see the vignette for more details.
}
\value{
If success, the function returns the name of the created package.
}
\seealso{\code{\link{make.cdf.env}}}
\author{Rafael A. Irizarry, Wolfgang Huber}
\examples{
  pkgpath <- tempdir()
  make.cdf.package("Hu6800.CDF.gz",
           cdf.path=system.file("extdata", package="makecdfenv"),
           compress=TRUE,
	   package.path = pkgpath)
  dir(pkgpath)	   
}

\keyword{manip}





\eof
\name{pmormm}
\alias{pmormm}
\title{PM or MM}
\description{
  Determing  if intensities on an array from the cdffile are PM, MM, or neither.
}
\usage{
  pmormm(cdf)
}
\arguments{
  \item{cdf}{A \code{\link[affy:Cdf-class]{Cdf}} object}
}
\details{
  The intensities on a chip fall in three categories: perfect match
  (PM), mismatch (MM) or unknown (No information about them is contained
  in the CDF file, yet they were found informative (details to come)).
  PM are coded as TRUE, MM as FALSE and unknown as NA.
}
\value{A matrix (see section 'details').}
\author{L. Gautier <laurent@cbs.dtu.dk>}
\keyword{manip}

\eof
\name{read.cdffile}
\alias{read.cdffile}
\title{Read a CDF file}
\description{Read the data contained in a CDF file}
\usage{read.cdffile(file, compress=FALSE)}
\arguments{
  \item{file}{the name of the CDF file}
  \item{compress}{whether the file is compressed or not}
}
\value{
  Returns a \code{\link{Cdf-class}} object.
}
\warnings{
  A \code{Cdf} object is not a cdf environment, which will be needed for
  the computation of expression values from the probe intensities in a
  \code{AffyBatch}. 
}
\details{This function is intended for use by
  \code{\link{make.cdf.env}}, which in turn is called by
  \code{\link{make.cdf.package}}. User may not have much
  benefit from calling this function directly.
  
  In order to save memory, the name corresponding to each value in the
  CEL is a factor. As in R \code{factor} objects
  cannot be also of type \code{matrix}, the names corresponding to the indices
  were stored in a vector of type \code{character} called
  \code{name.levels}.
  The same thing was done with the pbase and cbase information (more for
  consistency than by conviction that some memory
  could be saved here).
}
\author{Laurent Gautier (laurent@cbs.dtu.dk)}
\seealso{\code{\link{Cdf-class}}}
\keyword{file}
\examples{
fn <- system.file("extdata", "Hu6800.CDF.gz", package="makecdfenv")
mycdf <- read.cdffile(fn, compress=TRUE)
mycdf
}  

\eof
