### Name: rgb2hsv
### Title: Numeric Conversion of RGB to HSV Color Space
### Aliases: rgb2hsv
### Keywords: color

### ** Examples

set.seed(151)
256* (rgb3 <- floor(256 * matrix(runif(3*12), 3,12))/256)
(hsv3 <- rgb2hsv(rgb3))
## ["h", 2] is NA : not all RGBs exist as HSV !
ok <- !is.na(hsv3["h",])
hsv3 <- hsv3[, ok]
rgb3 <- rgb3[, ok]

rgbBack <- col2rgb(hsv(h=hsv3[1,], s=hsv3[2,], v=hsv3[3,]))
table(256*rgb3 - rgbBack)# not all 0; I had about half 1's
stopifnot(all.equal(256*rgb3, unname(rgbBack), tol = 0.01))



