\name{goTools}
\alias{EndNodeList}
\alias{CustomEndNodeList}

\title{Reference GO nodes list.}
\description{
  The function \code{EndNodeList} builds the default end node list used in
  \code{\link{ontoCompare}}}. CustomEndNodeList helps you build a list
    of children nodes starting from a GO id of interest. 
}
\usage{
EndNodeList()
CustomEndNodeList(id,rank=1)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{id}{Valid GO id: "GO:XXXXXXX".}
  \item{rank}{Number of levels of children of the GO DAG under id you
    want to add to your nodes list.}
}

\value{
  \code{EndNodeList} returns a vector of all GO ids 1 level below MF("GO:0003674"),
  BP("GO:0008150") and CC("GO:0005575"). MF, BP and CC nodes are
  included.
  \code{CustomEndNodeList} returns a vector of all GO ids children of
  \code{id}, \code{rank} levels below it. 
}

\author{Yee Hwa (Jean) Yang, Agnes Paquet}

\seealso{\code{\link{ontoCompare}}}

\examples{
# Examples use the probeID dataset. For description type ? probeID.
library(GO)
library(annotate)
data(probeID)
EndNodeList()

MFendnode <- CustomEndNodeList("GO:0003674", rank=2)
ontoCompare(affylist, probeType="hgu133a", endnode=MFendnode, goType="MF")

}

\keyword{file}% at least one, from doc/KEYWORDS
\keyword{manip}


\eof
\name{Internal functions}

\alias{getGoCategory}
\alias{getGOTerm}
\alias{getGOList}
\alias{goChildren}
\alias{parentsList}
\alias{isEndNode}
\alias{getGOID}
\alias{getGO.operon}
\alias{getGO.operon.main}
\alias{updateOligo2GO}
\alias{parentsListWraper}
\alias{parentsVectWraper}
\alias{ontoCompare.main}
\alias{goParents}
\alias{gowraper}

\title{Internal goTools functions}
 
\description{Internal goTools functions}
 
\details{These are not to be called by the user.}

\keyword{methods}

\eof
\name{goTools}
\alias{ontoCompare}
\alias{ontoPlot}

\title{Wrapper functions}
\description{
  This functions will allow you to describe and compare sets of oligo ids using
  Gene Ontology database
}
\usage{

ontoCompare(obj,  method=c("TGenes", "TIDS", "none"),
            probeType=c("GO", "operon", "hgu133a"), goType="All",
            plot=FALSE,endnode, ...)

ontoPlot(objM, beside=TRUE, las=2,legend.text=TRUE, ...)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{obj}{list of valid probe ids.}
  \item{method}{method used to evaluate the percentage of oligos for
    each end-node. 'TGenes' = for each end node, return the number of direct
  children found / total number of probe ids. (default). This includes
    oligos which do not have GO annotations. 'TIDS' = for each end node,
    return the number of direct children found / total number of GO ids
    describing the list. 'none' = for each end node, return the number of direct
    children found.}
  \item{probeType}{type of input given to the function. ontoCompare is
    expecting valid probe ids.}
  \item{goType}{help sort the data by type. If 'All' (default), all oligos
    are taken into account. 'BP' restricts information
    to Biological Process, 'CC' to Cellular Component, and 'MF' to
    Molecular Function.}
  \item{plot}{logical: if 'TRUE', results are output as a graph.}
  \item{endnode}{list of GO ids corresponding to end-nodes of interest.}
  
  \item{objM}{result from ontoCompare.}
  \item{...}{extra layout parameters to be passed to ontoPlot.}
  
  }

  \value{

    Returns the percentage of probes children of nodes contained in
    endnode. If 'plot' = TRUE, results are plotted as a pie chart or a bargraph. 
}

\author{Yee Hwa (Jean) Yang, Agnes Paquet}


\examples{
# Examples use the probeID dataset. For description type ?probeID.
library(GO)
library(annotate)
data(probeID)

ontoCompare(affylist, probeType="hgu133a", plot=TRUE)
res <- ontoCompare(operonlist["L1"], probeType="operon", method="TIDS")
ontoPlot(res, cex=0.7)
}

\keyword{file}% at least one, from doc/KEYWORDS
\keyword{hplot}


\eof
\name{probeID}
\alias{affylist}
\alias{operonlist}


\title{List of probe ids from Affymetrix hgu133a chip and Operon Version
  2 Human oligos}

\description{
  The \code{probeID} dataset consists of two lists of randomly chosen
  probe Ids. \code{affylist} contains 3 sets of ids from Affymetrix
  hgu133a. \code{operonlist} contains 2 sets of ids from Operon Version 2.}


\usage{data(probeID)}


\keyword{datasets}



\eof
