\name{affinity.spline.coefs}
\docType{instance}
\alias{affinity.spline.coefs}
\title{Spline coefficients for estimation of affinity from probe sequence}
\description{Spline coefficients for estimation of affinity from probe sequence}
\usage{data(affinity.spline.coefs)}
%\format{}
%\source{}
%\url{}
\seealso{\code{\link{compute.affinities}}}
\keyword{datasets}

\eof
\name{bg.adjust.affinities}
\alias{bg.adjust.affinities}
\alias{bg.adjust.mm}
\alias{bg.adjust.fullmodel}
\alias{bg.adjust.constant}
\alias{bg.adjust.optical}

\title{Background adjustment with sequence information (internal function)}
\description{
An internal function to be used by \code{\link{gcrma}}.
}
\usage{
bg.adjust.affinities(x,affinities,index=seq(along=x),k,Q=0.25,fast=TRUE)
}

\arguments{
  \item{x}{PM intensities after optical background correction, before non-specific-binding correction.}
  \item{index}{The index of x with known sequences. (For some types of
    arrays the sequences of a small subset of probes are not provided by
  Affymetrix.)}
  \item{affinities}{Probe affinities for probes with known sequences.}
  \item{k}{A tuning parameter. See details}
  \item{Q}{A number between 0 and 1 that determines what quantile to use
  as an estimate of the mean background noise.}
  \item{fast}{Logical value. If \code{TRUE} a faster add-hoc algorithm is
    used.}
}
\details{ Assumes PM=background1+signal,mm=background2,
  (log(background1),log(background2))' 
  follow bivariate normal distribution, signal distribution follows power
  law. 
  \code{bg.parameters.gcrma} and \code{sg.parameters.gcrma} 
  provide adhoc estimates of the parameters.

  the original gcrma uses an emprical bayes estimate. this requiers a
  complicated numerical integration. An add-hoc method tries to immitate
  the empirical bayes estimate with a PM-B but values of PM-B<\code{k}
  going to \code{k}. This can be thought as a shrunken MVUE. For more
  details see Wu et al. (2003). 
}


\value{a vector of same length as x.}
\seealso{\code{\link{gcrma}}}
\author{Rafeal Irizarry, Zhijin(Jean) Wu}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{bg.parameters.ns}
\alias{bg.parameters.ns}
\alias{left.sigma}
\alias{PAV}
\alias{average.for.PAV}
\title{Estimation of non-specific Binding Background Parameters}
\description{
An internal function to be used by \code{\link{gcrma}}
}
\usage{
bg.parameters.ns(x,affinities,order.aff=NULL,Q=.25,nbreaks=40,
                             monotonize.mu=TRUE,
                             monotonize.sigma=FALSE)
}
\arguments{
  \item{x}{PM or MM intensities after optical background correction, before non-specific-binding correction.}
  \item{affinities}{Probe affinities for probes with known sequences.}
  \item{order.aff}{The order of affinities. If \code{NULL}, it will be
    computed in this function.}
  \item{Q}{Between 0 and 1. For given affinity level, the Q-th quantile
    of log intensities is taken as the mean of the background
    distribution for this affinity level.}
  \item{nbreaks}{The number of strata of affinity levels.}
  \item{monotonize.mu} {Logical value, if \code{TRUE}, estimated mean
    background if forced to be monotonic with probe affinity level.}
   \item{monotonize.sigma} {Logical value, if \code{TRUE}, estimated
     background standard deviation if forced to be monotonic with probe
     affinity level.}
}
%\details{}
\value{a vector of same length as x.}
\seealso{\code{\link{gcrma}}}
\author{Rafeal Irizarry, Zhijin (Jean) Wu}
\keyword{manip}



\eof
\name{compute.affinities}
\alias{compute.affinities}
\alias{check.probes}
\title{Probe Affinity computation}
\description{
An internal function to calculate probe affinities from their
sequences.}
\usage{
compute.affinities(cdfname,verbose=TRUE)

check.probes(probepackage,cdfname)
}
\arguments{
  \item{cdfname}{ Object of class \code{character} representing the name of
          \code{CDF} file associated with the arrays in the \code{AffyBatch}.}
\item{probepackage}{\code{character} representing the name of the
  package with the probe sequence information.}
 \item{verbose}{Logical value. If \code{TRUE} messages about the progress of
    the function is printed.} 

}
\details{
The affinity of a probe is described as the sum of position-dependent base affinities.
Each base at each position contributes to the total affinity of a probe
in an additive fashion. For a given type of base, the positional effect
is modeled as a spline function with 5 degrees of freedom.

\code{check.probes} makes sure things are matching as they should.
}

\value{\code{compute.affinities} returns an \code{AffyBatch} with the
  affinities for PM probes in the pm locations and the affinities for MM
  probes in the mm locations. NA  will be added for probes with no
  sequence information.
}
\references{
Hekstra, D., Taussig, A. R., Magnasco, M., and Naef, F. (2003) Absolute mRNA concentrations from sequence-specific calibration of oligonucleotide array. Nucleic Acids Research, 31. 1962-1968.
}
\seealso{\code{\link{gcrma},\link{affinity.spline.coefs}}}
\author{Rafeal Irizarry}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{fast.bkg}
\alias{fast.bkg}
\alias{mem.bkg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Internal functions for justGCRMA }
\description{
  These are internal functions for justGCRMA that are called based on
  memory or speed constraints.
}
\usage{
fast.bkg(filenames, pm.affinities, mm.affinities, index.affinities,
type, minimum, optical.correct, verbose, k, rho, correction, stretch,
fast)
mem.bkg(filenames, pm.affinities, mm.affinities, index.affinities, type,
minimum, optical.correct, verbose, k, rho, correction, stretch, fast)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{filenames}{ A list of cel files. }
  \item{pm.affinities}{ Values passed from \code{compute.affinities}. }
  \item{mm.affinities}{ Values passed from \code{compute.affinities}. }
  \item{index.affinities}{ Values passed from \code{compute.affinities}. }
  \item{type}{ "fullmodel" for sequence and MM model. "affinities" for
          sequence information only. "mm" for using MM without sequence
          information. }
  \item{minimum}{ A minimum value to be used for \code{optical.correct}. }
  \item{optical.correct}{ Logical value. If \code{TRUE}, optical
    background correction is performed. }
  \item{verbose}{Logical value. If \code{TRUE}, messages about the
    progress of the function are printed. }
  \item{k}{ A tuning factor. }
  \item{rho}{ correlation coefficient of log background intensity in a pair
    of pm/mm probes. Default=.7 }
  \item{correction}{  }
  \item{stretch}{  }
  \item{fast}{ Logical value. If \code{TRUE}, then a faster ad hoc
    algorithm is used. }
}
\details{
  Note that this expression measure is given to you in log base 2
  scale. This differs from most of the other expression measure
  methods.

  The tunning factor 'k' will have different meanings if one uses
  the fast (add-hoc) algorithm or the empirical bayes approach. See
  Wu et al. (2003)
}
\value{
  An \code{exprSet}.
}

\author{ James W. MacDonald <jmacdon@med.umich.edu> }

\seealso{ \code{\link{gcrma}} }

\keyword{ internal }% at least one, from doc/KEYWORDS

\eof
\name{gcrma}
\alias{gcrma}
\alias{gcrma.bg.transformation.fast}
\alias{gcrma.bg.transformation}
\alias{gcrma.engine}
\title{Robust Multi-Array expression measure using sequence information}
\description{
  This function converts an \code{AffyBatch} into an \code{exprSet}
  using the robust multi-array average (RMA) expression measure with help of probe sequence.
}
\usage{
gcrma(object,affinity.info=NULL,
                  type=c("fullmodel","affinities","mm","constant"),
                  k=6*fast+0.5*(1-fast),stretch=1.15*fast+1*(1-fast),correction=1,
                  rho=.7,optical.correct=TRUE,verbose=TRUE,fast=TRUE)
}
\arguments{
  \item{object}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{affinity.info}{\code{NULL} or an \code{AffyBatch} containing the
    affinities in the \code{exprs} slot. This object can be created
    using the function \code{\link{compute.affinities}}.}
  \item{type}{"fullmodel" for sequence and MM model. "affinities" for
    sequence information only. "mm" for using MM without sequence
    information.}
  \item{k}{A tuning factor.}
  \item{rho}{correlation coefficient of log background intensity in a pair of pm/mm probes. Default=.7}
  \item{stretch} {.}
  \item{correction}{.}
  \item{optical.correct}{Logical value. If \code{TRUE}, optical
    background correction is performed.}
  \item{verbose}{Logical value. If \code{TRUE} messages about the progress of
    the function is printed.} 
  \item{fast}{Logicalvalue. If \code{TRUE} a faster add-hoc algorithm is
    used.}
}
\details{
  Note that this expression measure is given to you in log base 2
  scale. This differs from most of the other expression measure
  methods.

  The tunning factor \code{k} will have different meainngs if one uses
  the fast (add-hoc) algorithm or the empirical bayes approach. See Wu
  et al. (2003)
     
}
\value{
 An \code{exprSet}.
}
\author{Rafeal Irizarry}
\examples{
if(require(affydata) & require(hgu95av2probe)){
     data(Dilution)
     ai <- compute.affinities(cdfName(Dilution))
     Dil.expr<-gcrma(Dilution,affinity.info=ai,type="affinities")
}
}
\keyword{manip}


\eof
\name{justGCRMA}
\alias{justGCRMA}
\alias{just.gcrma}
\title{Compute GCRMA Directly from CEL Files}
\description{
  This function converts CEL files into an \code{exprSet}
  using the robust multi-array average (RMA) expression measure with help of probe sequences.
}
\usage{
just.gcrma <- function(..., filenames=character(0),
                       phenoData=new("phenoData"),
                       description=NULL,
                       notes="", compress=getOption("BioC")$affy$compress.cel,
                       normalize=TRUE, bgversion=2, affinity.info=NULL,
                       type=c("fullmodel","affinities","mm","constant"),
                       k=6*fast+0.5*(1-fast), stretch=1.15*fast+1*(1-fast),
                       correction=1, rho=0.7, optical.correct=TRUE,
                       verbose=TRUE, fast=TRUE, minimum=1, optimize.by=c("speed","memory"))

justGCRMA <- function(..., filenames=character(0),
                     widget=getOption("BioC")$affy$use.widgets,
                     compress=getOption("BioC")$affy$compress.cel,
                     celfile.path=getwd(),
                     sampleNames=NULL,
                     phenoData=NULL,
                     description=NULL,
                     notes="",
                     normalize=TRUE, 
                     bgversion=2, affinity.info=NULL,
                     type=c("fullmodel","affinities","mm","constant"),
                     k=6*fast+0.5*(1-fast), stretch=1.15*fast+1*(1-fast),
                     correction=1, rho=0.7, optical.correct=TRUE,
                     verbose=TRUE, fast=TRUE, minimum=1, optimize.by=c("speed","memory"))
}
\arguments{
  \item{\dots}{ file names separated by comma.}
  \item{filenames}{ file names in a character vector.}
  \item{widget}{a logical specifying if widgets should be used.}
  \item{compress}{are the CEL files compressed ?}
  \item{phenoData}{ a \code{\link[Biobase]{phenoData}} object}
  \item{description}{ a \code{\link[Biobase]{MIAME}} object}
  \item{notes}{ notes }
  \item{affinity.info}{\code{NULL} or a list of three components:
   apm,amm and index, for PM probe
    affinities, MM probe affinities, the index of probes with known
    sequence, respectively.}
  \item{type}{"fullmodel" for sequence and MM model. "affinities" for
    sequence information only. "mm" for using MM without sequence
    information.}
  \item{k}{A tuning factor.}
  \item{rho}{correlation coefficient of log background intensity in a pair of pm/mm probes. Default=.7}
  \item{stretch} {.}
  \item{correction}{.}
  \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{optical.correct}{Logical value. If \code{TRUE}, optical
    background correction is performed.}
  \item{verbose}{Logical value. If \code{TRUE} messages about the progress of
    the function is printed.} 
  \item{fast}{Logicalvalue. If \code{TRUE} a faster add-hoc algorithm is
    used.}
  \item{optimize.by}{"speed" will use a faster algorithm but more RAM, and "memory"
    will be slower, but require less RAM.}
}
\details{
  This method should require much less RAM than the conventional
  method of first creating an \code{AffyBatch} and then running
  \code{\link[gcrma]{gcrma}}.
  
  Note that this expression measure is given to you in log base 2
  scale. This differs from most of the other expression measure
  methods.

  The tuning factor \code{k} will have different meanings if one uses
  the fast (add-hoc) algorithm or the empirical bayes approach. See Wu
  et al. (2003)

  \code{fast.bkg} and \code{mem.bkg} are two internal functions.
}
\value{
 An \code{exprSet}.
}
\author{James W. MacDonald}
\examples{

}
\keyword{manip}


\eof
