\name{exprExternal-class}
\docType{class}
\alias{exprExternal-class}
\alias{coerce,exprSet,exprExternal-method}
\alias{exprs2excel,exprExternal-method}
\alias{exprs,exprExternal-method}
\alias{exprs<-,exprExternal,ANY-method}
\alias{exprs<-,exprExternal,indirectExternalMatrix-method}
\alias{initialize,exprExternal-method}
\alias{se.exprs,exprExternal-method}
\alias{se.exprs<-,exprExternal,indirectExternalMatrix-method}
\alias{write.exprs,exprExternal-method}

\title{Class exprExternal, a subclass of exprSet, and methods for
  manipulating objects of class exprExternal }
\description{ This is a class representing Microarray Data. Unlike
  its parent class \code{exprSet}, this class uses reference to an external
  matrix object for storing the gene expression data. }
\section{Creating Objects}{
  Objects can be created by either using\cr
\code{as(x, "exprExternal")}\cr
where \code{x} is an object of class \code{exprSet} or by a call of the
form\cr
\code{  new('exprExternal',}\cr
\code{    exprs.ext    = ...., # Object of class indirectExternalMatrix}\cr
\code{    se.exprs.ext = ...., # Object of class indirectExternalMatrix}\cr
\code{    phenoData    = ...., # Object of class phenoData}\cr
\code{    annotation   = ...., # Object of class character}\cr
\code{    description  = ...., # Object of class MIAME}\cr
\code{    notes        = ...., # Object of class character}\cr
\code{  )}
}
\section{Slots}{
  \describe{
    \item{\code{exprs.ext}:}{Object of class "indirectExternalMatrix".
      The observed expression levels. This contains refernce to an
      object of class \code{externalVector} of two dimensions with columns
      representing patients or cases and rows representing genes. }
    \item{\code{se.exprs.ext}:}{Object of class
      "indirectExternalMatrix". This either contains reference to an
      object of class \code{externalVector} of the same dimensions as
      \code{exprs} which contains
      standard error estimates for the estimated expression levels or
      reference to an object of class \code{externalVector} of length
      zero. }
    \item{\code{phenoData}:}{Object of class "phenoData" This is an
      instance of class \code{phenoData} 
      containing the patient (or case) level data. The columns of the
      pData slot of this entity represent
      variables and the rows represent patients or cases. }
    \item{\code{annotation}}{A character string identifying the
      annotation that may be used for the \code{exprSet} instance.}
    \item{\code{description}:}{Object of class "MIAME". For
      compatibility with previous version of this class description can
      also be a "character". The clase \code{characterOrMIAME} has been
      defined just for this.} 
    \item{\code{notes}:}{Object of class "character" Vector of
      explanatory text }
  }
}
\section{Methods}{
  \describe{
    \item{exprs}{\code{signature(object = "exprExternal")}: An accessor
      function for the exprs.ext slot. }
    \item{se.exprs}{\code{signature(object = "exprExternal")}: An accessor
      function for the se.exprs.ext slot. }
    \item{exprs2excel}{\code{signature(x = "exprExternal")}:
      Writes the expression levels to \code{csv}
      file. This file will open nicely in excel. It takes the same
      arguments as \code{\link{write.table}}. If 
      called with no arguments it is equivalent to
 \code{write.table(force(exprs(exprSet))[,],file="tmp.csv", sep = ",", col.names = NA)}.}
    \item{write.exprs}{\code{signature(x = "exprExternal")}:
      Writes the expression levels to
      file. It takes the same arguments as \code{\link{write.table}}. If
      called with no arguments it is equivalent to
      write.table(force(exprs(exprSet))[,],file="tmp.txt",quote=FALSE,sep="\t").}
    \item{coerce}{\code{signature(from = "exprSet", to = "exprExternal")}:
    Convert an object of class \code{exprSet} to an equivalent object of
    class \code{exprExternal}. This is almost never called
    directly. Instead, use\cr
\code{as(exprSet, "exprExternal")}}
  }
}
\seealso{\code{\link[Biobase]{exprSet-class}}}
\examples{
  ## Run the examples from exprSet manual page
  library('externalVector')
  library('Biobase')
  data(geneData)
  data(geneCov)
  covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
  names(covdesc) <- names(geneCov)
  pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
  pdata[1,]
  pdata[,2]

  eset <- as(new("exprSet", exprs=geneData, phenoData=pdata),
             "exprExternal")
  eset
  eset[,1:10]
  eset[,1]
  eset[1,]
  eset[1,1]
  eset[1:100,]
  eset[1:44,c(2,4,6)]
  Means <- iter(eset, f=mean)

%% Does not work: picks up mean and var from base namespace.
%   chkdich <- function(x) if(length(unique(x))!=2) stop("x not dichotomous")
%   mytt <- function(x,y) {
%      chkdich(x)
%      d <- split(y,x)
%      t.test(d[[1]],d[[2]])$p.val
%   }
  
%   Tpvals <- iter(eset, "cov1", mytt )

  sp1 <- split(eset, c(1,2))
  sp2 <- split(eset, c(rep(1,6), rep(2,7)))
}
\keyword{classes}
\keyword{methods}

\eof
