\name{Bnapus}
\alias{Bnapus}
\non_function{}
\title{Cross structure for complete Brassica napus data}
\description{
Contains genotypes and phenotypes for Brassica napus study, including 0-
4- and 8-week vernalization, survival, and 19 chromosomes.
}
\usage{data(Bnapus)}
\format{
See \code{read.cross} in \code{library(qtl)} for format.
}
\seealso{\code{\link[qtl]{read.cross}},\code{\link{plot.bim}}}
\source{
Thomas C. Osborn (\url{mailto:tcosborn@facstaff.wisc.edu}), Department of Agronomy,
UW-Madison (\url{http://agronomy.wisc.edu}).
}
\detail{
Traits included are percent winter survival for 1992-3, 1993-4,
1994-5, 1997-8, and 1999-2000 (surv92, surv93, surv94, surv97, surv99,
respectively), and days to flowering after no vernalization (flower0),
4 weeks vernalization (flower4) or 8 weeks vernalization
(flower8). Percents are of plants alive in the Fall, taken from the
middle of rows (totals unavailable). Days to flowering after
transplant are averages over four replicates from a RCB design (values
by block unavailable). First column has the trait name. The remaining
columns identify individual DH line (302-455). 

Marker genotype data for Major x Stellar double haploid (DH)
population. Double haploids have the same relation of recombination to
distance as backcrosses as there is just one meiosis tracked (in
F1). However, DH are homozygous at every locus (usually mapped as RI0
lines). Marker genotypes are coded as M = Major, S = Stellar, - =
missing. Data columns are
\item chrom = <em>B. napus</em> chromosome (N1, N2, etc.)
\item order = along chromosome
\item cM d= istance from proximal end
\item marker = marker name:
 E = AFLP;
 *ec, *tg, *wg = RFLP;
 *xxx = other markers from Arabidopsis:
Lem, eru1, eru2, fad3, isoDia, isoIdh, isoPgi, isoLap, pr2, slg6, Aca1, cor15
\item
Remaining columns are for individual DH lines (identifier 302-455).
}
\references{
  \item \url{http://www.stat.wisc.edu/~yandell/qtl/data/osborn/Bnapus}
  \item Ferreira ME, Satagopan J, Yandell BS, Williams PH, Osborn TC
  (1995) Mapping loci controlling vernalization requirement and
  flowering time in Brassica napus. Theor Appl Genet
  90: 727-732. [original source and analysis]
  \item JM Satagopan, BS Yandell, MA Newton and TC Osborn (1996)
  Markov chain Monte Carlo approach to detect polygene loci
  for complex traits. Genetics 144: 805-816.
  \url{http://www.genetics.org/cgi/content/abstract/144/2/805}
  [first MCMC for experimental crosses; analysis of B. napus N2=LG9; see
  \code{\link{vern}} data]
  \item Kole C, Thorman CE, Karlsson BH, Palta JP, Gaffney P, Yandell
  BS, Osborn TC (2001)
  Comparative mapping of loci controlling winter survival and
  related traits in oilseed Brassica rapa and B. napus.
  Molecular Breeding 1: 329-339. [refined map and reanalysis]
}
\examples{
data(Bnapus)
\testonly{library(qtl)}
summary(Bnapus)
plot(Bnapus)
\dontrun{
Bnapus.bim = run.bmapqtl(Bnapus,"log10flower8")
}
}
\keyword{datasets}

\eof
\name{bim-internal}
\alias{bim-internal}
\alias{.bmapqtl.options}
\alias{bmapqtl.options.init}
\alias{bim.cex}
\alias{bim.cross}
\alias{bim.legacy}
\alias{bim.match}
\alias{bim.prior}
\alias{bim.smooth}
\alias{plot.bim.pattern}
\title{Internal bim functions.}
\description{  These are generally not to be called by the user.
}
\usage{
.bmapqtl.options
bmapqtl.options.init()
bim.cex( bim )
bim.cross( bim )
bim.legacy( bim )
bim.match( bim, pattern )
bim.prior( bim, range )
bim.smooth( x, y )
plot.bim.pattern( x, bars, labels, barlabels, threshold, units,
  rescale, \dots )
}
\author{ Brian S. Yandell, yandell@stat.wisc.edu }
\keyword{internal}

\eof
\name{bim.effects}
\alias{bim.effects}
\alias{plot.bim.effects}
\title{Bayesian QTL map of loci and effects}
\description{
  Histogram of QTL loci plus scatter plots and smooth estimates of QTL
  effects (additive and dominance--Mather-Jinks model).
}
\usage{
plot.bim.effects(x, cross, nqtl = 1, pattern = NULL, exact = FALSE,
  chr, bw = 2, qtl = <<see below>>, cex, level = .80,
  project=<<see below>>, main=<<see below>>, mfcol=<<see below>>, \dots )
bim.effects(x, cross, nqtl = 1, pattern = NULL, exact = FALSE, chr,
  bw = 2, qtl = <<see below>>)

}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{chr}{subset of chromosomes to plot (numerical indices or
    chromosome names)} 
  \item{bw}{bandwidth for loci density}
  \item{qtl}{QTL estimate information (see value)}
  \item{cex}{ character expansion for scatter plots }
  \item{prefix}{ prefix for chromosome names, typically \code{c} }
  \item{level}{level for HPD region from \code{seq(.5,.95,by=.05)}}
  \item{project}{project identifier, default is name of \code{x} argument}
  \item{main}{title, with default \code{expression(project summaries 
      with m >= nqtl)} and substitutions for \code{project} and 
    \code{nqtl}} 
  \item{mfcol}{parameter to \code{par} set to 2 or 3 depending on if
    dominance is present}
  \item{\dots}{graphical parameters can be given as arguments to
    \code{\link[base]{plot}}} 
}
\value{
  \code{bim.effects} returns an enhanced version of the
  \code{\link{bim.qtl}} object, with additional elements
  \item{add}{additive smoothing spline by chromosome}
  \item{dom}{dominance smoothing spline by chromosome (if present)}
  \item{est}{estimates of QTL}
  The first two elements are lists of
  \code{\link[modreg]{smooth.spline}} objects, one for each chromosome.
  The third element is a data frame with the following elements, with
  one entry per QTL. The final entry is for the mean.
  \item{chrom}{chromosome name}
  \item{loci}{loci position along chromosome}
  \item{add}{additive effect}
  \item{add.sd}{SD for additive effect}
  \item{dom}{dominance effect (if present)}
  \item{dom.sd}{SD for dominance effect}
  }
\details{
Model averaging conditional on at least \code{nqtl} and at least
chromosome \code{pattern} QTL in model.
\code{bim.effects} uses \code{\link{bim.qtl}} to estimate the QTL 
First row has histogram of loci overlaid with smoothed density estimate
(blue line) and HPD regions (red circles along origin).
Second row is additive effect; third if present has dominance effect.
Smoothing spline fit along scatter plot to estimate mean effects (solid
blue line), plus or minus two SDs (dashed blue line; estimated as well
by smoothing spline). Simple linear regression used if 50 or fewer
samples for a chromosome.
Purple triangles indicate marker locations if supplied. Red circles and
vertical dashed lines at estimated loci and effects. Vertical black
lines delineate chromosomes.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{plot.bim}},\code{\link{subset.bim}},\code{\link{bim.qtl}}}

\examples{
data( vern )
data( verngeo.bim )
\testonly{library(qtl)}
vern.qtl <- bim.effects( verngeo.bim, vern, 2 )
plot.bim.effects( verngeo.bim, vern, 2, qtl = vern.qtl )
}
\keyword{models}
\keyword{hplot}

\eof
\name{bim.fdr}
\alias{bim.fdr}
\alias{plot.bim.fdr}
\title{Bayesian False Discovery Rate for QTL mapping}
\description{
Bayesian false discover rate (FDR) applied to QTL mapping. Use
plot.bim.fdr to determine FDR for HPD level used in plot.bim.effects.
}
\usage{
bim.fdr(x, cross, nqtl = 1, pattern = NULL, exact = FALSE, chr,
  \dots, levels=<<see below>>,df=3,  qtl = <<see below>>)
plot.bim.fdr(x, cross, \dots, fdr = <<see below>>,
  critical.value=<<see below>>, hpd = NULL )
}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{chr}{subset of chromosomes to plot (numerical indices or
    chromosome names)} 
  \item{levels}{probability levels for HPD regions (default every 1 percent)}
  \item{df}{degrees of freedom for smoothing spline estimator of prior
    on size}
  \item{qtl}{QTL estimate information from \code{\link{bim.qtl}}}
  \item{fdr}{object returned by call to \code{\link{bim.fdr}}}
  \item{critical.value}{pFDR guidelines (ignored if hpd provided;
    default every .05 to .25)} 
  \item{hpd}{HPD guidelines}
  \item{\dots}{graphical parameters can be given as arguments to
    \code{\link[base]{plot}}} 
}
\value{
  \code{bim.fdr} returns an enhanced version of the
  \code{\link{bim.qtl}} object, with additional elements:
  \item{levels}{HPD \code{levels}}
  \item{size}{relative size of HPD region across \code{levels}}
  \item{fdr}{false discover rate across \code{levels}}
  \item{hyp}{estiamtes for probabilities of hypotheses H0: no QTL at
    locus, M0: no QTL anywhere, M1: QTL somewhere}
  \item{prob}{cumulative prior probability}
  \item{spline}{spline estimate of cumulative prior probability}
The \code{size} and \code{fdr} objects are data frames, one element per
chromosome plus the last being \code{all} chromosomes. \code{spline} is
an object of class \code{smooth.spline}.

\code{plot.bim.fdr} returns
  \item{hyp}{estiamtes for probabilities of hypotheses H0: no QTL at
    locus, M0: no QTL anywhere, M1: QTL somewhere}
  \item{fdr}{FDR for corresponding HPD levels (chosen by \code{hpd} or
    \code{critical[value} settings)}
  }
\details{
FDR follows ideas of Storey (\url{http://www.stat.berkeley.edu/~storey})
adapted to Bayesian setting.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{plot.bim.effects}},\code{\link{bim.qtl}}}

\examples{
data( vern )
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim.fdr( verngeo.bim, vern, pattern=c(1,1) )
}
\keyword{models}
\keyword{hplot}

\eof
\name{bim.model}
\alias{bim.model}
\alias{bim.nqtl}
\alias{bim.pattern}
\title{Bayesian model selection for number and pattern of QTL across genome}
\description{
Posterior number and pattern of QTL, along with posterior/prior Bayes
factor ratios.
}
\usage{
bim.model( bim, cross, nqtl = 1, pattern=NULL, exact=FALSE,
  cutoff = 1 )
bim.nqtl( bim )
bim.pattern( bim, cross, nqtl = 1, pattern=NULL, exact=FALSE,
  cutoff = 1 )
}
\arguments{
  \item{bim}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} (extracted by
  \code{bim.cross} if not provided)}
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{cutoff}{percent cutoff for inclusion in model selection}
}
\details{
  \code{bim.model} creates results from both \code{bim.nqtl} and
  \code{bim.pattern}.
  
  \code{bim.nqtl} estimates posterior frequency of number of QTLs as the
  margine over all other model parameters.  However, note that
  posterior may be influenced by prior, while Bayes factor is
  empirically less sensitive for QTL model selection.  Bayes factors are
  ratios of \code{bf=posterior/prior} ratios. 

  \code{bim.pattern} shows at most 15 model patterns with at least
  \code{cutoff} \% posterior are returned.
  Patterns are comma-separate list of chromosomes, with asterisk 
  \code{*} for multiple QTL per chromosome.
  \code{bim} is first subsetted using \code{\link{subset.bim}}.
}
\value{
  List with items \code{nqtl} and \code{pattern}, each containing:
  \item{posterior}{posterior for number of QTL}
  \item{prior}{prior for number of QTL}
  \item{bf}{rank-ordered posterior/prior ratios rescaled so bf[1] = 1}
  \item{bfse}{approximate standard error for bf computed using binomial
    variance}
  In addition, there is an object \code{param} with values for
  \code{nqtl}, \code{pattern}, \code{exact} and \code{cutoff}.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{plot.bim}},\code{\link{plot.bim.model}},\code{\link{subset.bim}}}

\examples{
data( verngeo.bim )
\testonly{library(qtl)}
bim.model( verngeo.bim )
}
\keyword{models}

\eof
\name{bim.}
\alias{bim.qtl}
\alias{plot.bim.qtl}
\title{Bayesian QTL estimation and mapping of loci}
\description{
  Smooth density, point estimates and HPD regions for QTL loci. Loci are
  estimated at peaks of density.
}
\usage{
bim.qtl(x, cross, nqtl=1, pattern=NULL, exact=FALSE,
  chr, bw=2, levels = seq(.5,.95,by=.05) )
plot.bim.qtl(x, cross, nqtl = 1, pattern = NULL,
  exact = FALSE, chr, bw = 2, qtl=<<see below>>,
  level = 0.80, col = "black", add = FALSE, \dots) 
}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{chr}{subset of chromosomes to plot (numerical indices or chromosome names)}
  \item{bw}{bandwidth for loci density}
  \item{levels}{saved levels for HPD region}
  \item{qtl}{QTL estimate information (see value)}
  \item{level}{level for HPD region from \code{seq(.5,.95,by=.05)}}
  \item{col}{line color}
  \item{add}{create new plot if FALSE}
  \item{\dots}{graphical parameters can be given as arguments to
    \code{\link[base]{plot}}} 
}
\value{
  \code{bim.qtl} returns (and \code{plot.bim.qtl} silently returns) a
  list containing: 
  \item{loci}{data frame with \code{chr} = chromosome name, \code{x} =
    locus on chromosome, \code{y} = height of density}
  \item{dens}{list of density objects by chromosome}
  \item{hpd} {density critical values for high probability density (HPD) region}
}
\details{
Model averaging conditional on at least \code{nqtl} QTL and at least
chromosome \code{pattern} in model.  \code{bim.qtl} does estimation of
density and loci as well as high probability density (HPD) region.
\code{plot.bim.qtl} calls \code{bim.qtl} and plots the density curve.
See \code{\link{plot.bim.effects}} for enhanced plots with HPD and effects
estimates.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{plot.bim.effects}}}

\examples{
data( vern )
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim.qtl( verngeo.bim, vern, 2 )
}
\keyword{models}
\keyword{hplot}

\eof
\name{bmapqtl.options}
\alias{bmapqtl.options}
\title{Options Settings for BmapQTL}
\description{This function allows the users to set and examine the
  options and priors for reversible jump MCMC QTL model search. The
  options are stored in global hidden variable .bmapqtl.options.}

\usage{
bmapqtl.options(\dots,reset=FALSE)
}

\arguments{
  \item{reset}{reset options to default settings}
  \item{\dots}{any options can be defined, using `name = value'. The
    available options are listed below.
    \describe{
      \item{prior.nqtl}{one of \code{"poisson"}, \code{"geometric"} or
	\code{"uniform"} (partial match OK).  Default is
	\code{"geometric"}.}
      \item{mean.nqtl}{prior for number of QTL (default = 3).}
      \item{niter}{number of iterations (default = 400000).}
      \item{by}{record every \code{by} iterations (default = 400).}
      \item{burnin}{proportion of iterations for burnin (default = .05).}
      \item{preburn}{proportion of burnin used for preburn (default = .05).}
      \item{nqtl}{initial number of QTL (default = 0).}
      \item{init}{2-vector with initial mean and variance (see details).}
      \item{prior.mean}{2-vector with prior for mean (see details).}
      \item{prior.var}{2-vector with prior for variance (see details).}
      \item{prior.add}{2-vector with prior for additive effects (see details).}
      \item{prior.dom}{2-vector with prior for dominance effects (see
	details).}
      \item{seed}{Random number seed. If 0(default), seed will be generated
	randomly.}
    }
  }
}

\details{
  Initial mean and variance \code{init} are used directly if the
  variance is positive. For values \code{c(a,-b)} use mean 0 and
  variance \eqn{.5s^2}.

  Prior arguments have coded meaning as follows, with \code{a} and
  \code{b} non-negative. For the grand mean, \code{c(a,b)} signifies
  \code{Normal(a,b)}, while \code{c(a,-b)} stands for
  \code{Normal}(\eqn{\bar{Y},bS^2}), with \eqn{\bar{Y}} and
  \eqn{S^2} the phenotype mean and variance, respectively.  Additive and
  dominance priors coded  as \code{c(a,b)} have \code{Normal(a,b)}; as
  \code{c(a,-b)} have \code{Normal}(\eqn{0,aS^2}); as \code{c(-a,-b)} have
  \code{Normal}(\eqn{0,\beta S^2}) with \eqn{\beta\sim}\code{Beta(2,10)}
  if \code{a=b=0} or \eqn{\beta\sim}\code{Beta(a,b)} otherwise. Variance
  has prior inverse Gamma: \code{IG(a,b)} for \code{c(a,b)}, or
  \code{IG(a,\eqn{s^2})} for \code{c(a,-b)}.
}

\value{
  A list (in any case) with the previous values of the options
  changed, or all options when no arguments were given.
}

\author{Hao Wu, hao@jax.org}

\seealso{\code{\link[base]{options}}}

\examples{
bmapqtl.options()
bmapqtl.options(niter=100000, by=1000)
}
    
\keyword{utilities}

\eof
\name{fisch}
\alias{fisch}
\alias{fisch.bim}
\non_function{}
\title{Eight QTL Stephens and Fisch simulated data}
\description{
Contains genotypes and phenotypes for data simulated using model in
Stephens and Fisch (1998) but with 90 percent heritability.
}
\usage{
data(fisch)
data(fisch.bim)
}
\format{
  \code{fisch} is f2 (see \code{\link[qtl]{read.cross}} for format).
  \code{fisch.bim} produced by \code{link{run.bmapqtl}}.
}
\seealso{\code{\link[qtl]{read.cross}}, \code{\link{plot.bim}}, \code{\link{run.bmapqtl}}}
\author{ Brian S. Yandell, \url{mailto:yandell@stat.wisc.edu}}
\source{
Patrick J. Gaffney (\url{mailto:paga@lubrizol.com}), Lubrizol Corp.
}
\references{
\url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl}
}
\examples{
data(fisch)
data(fisch.bim)
}
\keyword{datasets}

\eof
\name{plot.bim}
\alias{plot.bim}
\title{Diagnostics plots for Bayesian interval mapping}
\description{
  Diagnostic plots highlight putative QTL loci and effects as well as
  providing graphical model assessment tools.
}
\usage{
plot.bim(x, cross, nqtl=1, pattern=NULL, exact=FALSE, ... )
}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{...}{graphical parameters can be given as arguments to \code{\link[base]{plot}}}
}
\details{
  Import object \code{cross} using \code{read.cross} and simulate
  Bayesian interval mapping sample object \code{x} using
  \code{run.bmapqtl}, respectively. This routine creates five plots via
  calls to several other plot routines for bim data.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link[base]{plot}},\code{\link[qtl]{read.cross}},\code{\link{run.bmapqtl}},
  \code{\link{plot.bim.mcmc}}, \code{\link{plot.bim.loci}},
  \code{\link{plot.bim.model}}, \code{\link{plot.bim.effects}},  \code{\link{plot.bim.diag}} }

\examples{
data( vern )
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim( verngeo.bim, vern )
}
\keyword{hplot}
\keyword{models}

\eof
\name{plot.bim.diag}
\alias{plot.bim.diag}
\title{Marginal and model-conditional summaries of Bayesian interval
  mapping diagnostics}
\description{
A density histogram is drawn for model-averaged summary diagnostics such
as LOD, variance, or heritability.
}
\usage{
plot.bim.diag(x, nqtl=1, pattern=NULL, exact=FALSE,
  items=<<see below>>, mains=items,
  mfrow=<<see below>>, \dots )
}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{items}{diagnostics to be summarized; must be column of data}
  \item{mains}{titles for items}
  \item{mfrow}{plot arrangement parameter for \code{par()} (default is
    rows = number of items by cols = 2) }
  \item{\dots}{graphical parameters can be given as arguments to \code{\link[base]{plot}}}
}
\details{
  Model-averaged density is smooth kernel estimate similar to ordinary
  histogram. A \code{\link[base]{boxplot}} (without outliers) is
  overlaid for comparison   with conditional boxplots. Conditional
  boxplots by number of QTL may   show   indication of model bias for
  small number of QTL. This and   \code{\link{bim.nqtl}} can help
  suggest the minimal model. Diagnostic   items that make sense to plot
  are \code{"LOD"}, \code{"envvar"}   (environmental variance),
  \code{"herit"} (heritability), \code{"mean"} (grand mean),
  \code{"addvar"} (variance of \code{add}), \code{"domvar"} (variance of
  \code{add}). Marginal and conditional medians are printed.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{plot.bim}}, \code{\link{density}}, \code{\link[base]{boxplot}}}

\examples{
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim.diag( verngeo.bim, 2, items = c("LOD","herit") )
}
\keyword{models}

\eof
\name{plot.bim.loci}
\alias{plot.bim.loci}
\title{Jittered plot of Bayesian QTL loci samples by chromosome}
\description{
Each point is one locus from the Bayesian QTL estimates, plotted
vertically by chromosome, jittered to give a sense of density.
}
\usage{
plot.bim.loci(x, cross, nqtl=1, pattern=NULL, exact=FALSE,
  chr, labels=TRUE, amount=.35, cex, \dots )
}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} (extracted by
  \code{bim.cross} if not provided) }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{chr}{subset of chromosomes to plot (numerical indices or chromosome names)}
  \item{labels}{include marker labels if TRUE}
  \item{amount}{amount of jitter (between 0 and .45)}
  \item{cex}{ character expansion (may be invisible if too
    small--default set by \code{bim.cex})}
  \item{\dots}{graphical parameters can be given as arguments to
    \code{\link[base]{plot}}} 
}
\details{
  Focuses attention on chromosome lengths and concentration of QTL loci
  estimates. Horizontal blue lines at markers if \code{cross}
  included. Adjust \code{amount} and \code{cex} to modify look of 
  plot. Most useful when looking at multiple chromosomes.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link[base]{jitter}},\code{\link{subset.bim}}}

\examples{
data( vern )
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim.loci( verngeo.bim, vern, 2 )
}
\keyword{models}

\eof
\name{plot.bim.mcmc}
\alias{plot.bim.mcmc}
\title{Bayesian MCMC sequence plots for burnin and iterations.}
\description{
  Plot MCMC burnin and iteration sequences for
  number of QTL, LOD score, environmental SD, and heritability.
  
}
\usage{
plot.bim.mcmc(x, element = c("burnin","iter"),
  xlab = c("burnin sequence","mcmc sequence"),
  items = <<see below>>, ylabs = items,
  types = <<see below>>, \dots )

}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{element}{ elements of \code{x} to plot}
  \item{xlab}{x-axis labels for elements}
  \item{items}{diagnostic item names to be plotted as time series
    (default is all names in \code{x$iter}}
  \item{ylabs}{labels for items}
  \item{types}{line types (default is both for first item--usually
    number of QTL--and lines for the rest)}
  \item{\dots}{graphical parameters can be given as arguments to
    \code{\link[base]{plot}}} 
}
\details{
  Plots show grey line for saved sequences, usually nearly vertical due
  to mixing, plus a smoothed curve (blue).
Burnin plots should show initial jump in number of QTL during pre-burnin
sequence, ideally settling into a well-behaved Markov chain by the end
of the burn-in. That is, look for visual evidence of stationarity as
flat blue line and even spread of grey. Trend or cyclic pattern
indicates Markov chain is not mixing well and needs to be run much
longer. No formal assessment is provided.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{run.bmapqtl}}}

\examples{
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim.mcmc( verngeo.bim )
}
\keyword{models}

\eof
\name{plot.bim.model}
\alias{plot.bim.model}
\title{Graphical model assessment for Bayesian interval mapping}
\description{
  Model-averaged posteriors and posterior/prior ratios for graphical Bayes
  factor assessment. First row concerns number of QTL, second row
  evaluates pattern of QTL across chromosomes.
}
\usage{
plot.bim.model( x, cross = NULL, nqtl = 1, pattern=NULL, exact=FALSE,
  cutoff = 1, assess = <<see below>>, \dots )
}
\arguments{
  \item{x}{ object of class \code{bim} or class \code{bim.model} }
  \item{cross}{ corresponding object of class \code{cross} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{cutoff}{percent cutoff for inclusion in model selection}
  \item{assess}{object of class \code{bim.model} from \code{\link{bim.model}}}
  \item{\dots}{graphical parameters can be given as arguments to
    \code{\link[base]{plot}}} 
}
\details{
  \code{plot.bim.model} uses results (\code{assess}) of \code{bim.model}
  and arranges plots on a single page.  If \code{x} is of class
  \code{bim.model}, then \code{assess} is set to its value and the other
  arguments are ignored. Left plot is of posterior against  model
  identifier, while right plot assesses Bayes factors.  Since Bayes
  factors are ratios of \code{posterior/prior} ratios, a semi-log plot
  of \code{posterior/prior} against model identifier (\emph{m} = number
  of QTL or \emph{M} = model pattern) provides a graphical model
  assessment tool with a BF threshold yardstick.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{bim.model}}}

\examples{
data( vern )
data( verngeo.bim )
\testonly{library(qtl)}
plot.bim.model( verngeo.bim, vern, 2 )
}
\keyword{models}

\eof
\name{read.bim}
\alias{read.bim}
\title{ Read samples from WinQTL output}
\description{
MCMC samples from WinQTL are organized into an object of class
\code{bim} for diagnostic plots and analysis. This can be used to import
MCMC samples from WinQTL or from an optional file saved by run.bmapqtl.
}
\usage{
read.bim( dir, bimfile, nvalfile = "nval.dat", na.strings="." )
}
\arguments{
  \item{dir}{ directory containing files }
  \item{bimfile}{ name of MCMC sample file (currently with \code{.z} suffix)}
  \item{nvalfile}{parameter file for \code{Bmapqtl} program (currently hard-wired)}
  \item{na.strings}{ missing value code }
}
\value{
  An object of class `bim', which is a list with components
  \item{bmapqtl}{parameter settings for \code{Bmapqtl} run}
  \item{burnin}{burnin sequence data frame, containing
    \code{niter} = iteration number,
    \code{nqtl} = number of QTL,
    \code{LOD} = LOD score based on simulated QTL genotypes,
    \code{mean} = grand mean of phenotype,
    \code{envvar} = environmental variance,
    \code{addvar} = additive variance,
    \code{domvar} = dominance variance (if included), and
    \code{herit} = heritability.}
  \item{iter}{MCMC iteration summary data frame, with same elements as
    \code{burnin}.}
  \item{loci}{data frame with MCMC estimates across loci by iteration,
    containing
    \code{niter} = iteration number,
    \code{nqtl} = number of QTL,
    \code{chrom} = chromosome number,
    \code{locus} = locus position in centi-Morgans,
    \code{add} = additive effect,
    \code{dom} = dominance effect (if included).}
}
}
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\details{Bmapqtl used to operate as a separate external command, but was
recently incorporated as a C dynamic library. However, \code{read.bim}
is still useful for output from WinQTL. For information on WinQTL visit
\url{http://statgen.ncsu.edu/qtlcart}.}

\seealso{\code{\link{plot.bim}},\code{\link{run.bmapqtl}},\code{\link{read.bmapqtl}}}

\examples{
\dontrun{verngeo.bim <- read.bim( ".", "verngeo.z" )}
}
\keyword{file}

\eof
\name{read.bmapqtl}
\alias{read.bmapqtl}
\alias{write.bmapqtl}
\title{Read and write options for WinQTL}

\description{
  write.bmapqtl takes the options and priors in current workspace from
  \code{\link{bmapqtl.options}} and write it to a (user specified) text 
  file. read.bmapqtl opens the file and read the options and priors in.
}

\usage{
write.bmapqtl( dir = ".", nvalfile = "nval.dat" )
read.bmapqtl( dir = ".", nvalfile = "nval.dat" )
}

\arguments{
  \item{dir}{ directory containing files }
  \item{nvalfile}{file name for options and priors.}
}


\value{
  There is no return value from \code{write.bmapqtl}.

  \code{read.bmapqtl} returns a list for options and priors. To replace
  the options and priors in current workspace, use
  \code{.bmapqtl.options <- read.bmapqtl()}.

}

\author{ Brian S. Yandell, yandell@stat.wisc.edu,
  Hao Wu, hao@jax.org}
\details{Bmapqtl used to operate as a separate external command using
  external file \code{nval.dat}, but was
  recently incorporated as a C dynamic library. However,
  \code{read.bmapqtl} and \code{write.bmapqtl} are still useful for
  WinQTL. For information on WinQTL visit
\url{http://statgen.ncsu.edu/qtlcart}.}
\seealso{\code{\link{read.bim}},
  \code{\link{run.bmapqtl}},
  \code{\link{bmapqtl.options}}
}

\examples{
\dontrun{
write.bmapqtl( ".", "nval.dat")
read.bmapqtl(".", "nval.dat" )
}
}

\keyword{file}

\eof
\name{run.bmapqtl}
\alias{run.bmapqtl}
\title{Run Bmapqtl reversible jump MCMC}
\description{Run Bmapqtl reversible jump MCMC
}

\usage{
run.bmapqtl(cross, pheno=1, chrom=0, result.file="")
}

\arguments{
  \item{cross}{An object of class "cross"}
  \item{pheno}{phenotypic trait number or name}
  \item{chrom}{chromosome number (0 = all). Note that at this stage,
    it can either be all chromosomes (0) or a single chromosome.}
  \item{result.file}{Result file name. If this is specified, the result
    will be written to a tab-delimited text file. If it is an empty string
    (""), result will not be output as a file.}
}

\value{
  The result is an object of class "bim", which is a list with the
  following components:
  \item{bmapqtl}{parameter settings for \code{Bmapqtl} run}
  \item{burnin}{burnin sequence data frame, containing
    \code{niter} = iteration number,
    \code{nqtl} = number of QTL,
    \code{LOD} = LOD score based on simulated QTL genotypes,
    \code{mean} = grand mean of phenotype,
    \code{envvar} = environmental variance,
    \code{addvar} = additive variance,
    \code{domvar} = dominance variance (if included), and
    \code{herit} = heritability.}
  \item{iter}{MCMC iteration summary data frame, with same elements as
    \code{burnin}.}
  \item{loci}{data frame with MCMC estimates across loci by iteration,
    containing
    \code{niter} = iteration number,
    \code{nqtl} = number of QTL,
    \code{chrom} = chromosome number,
    \code{locus} = locus position in centi-Morgans,
    \code{add} = additive effect,
    \code{dom} = dominance effect (if included).}
}

\author{Hao Wu, hao@jax.org}

\seealso{\code{\link{plot.bim}},
  \code{\link{read.bim}}
}
\references{
  \item \url{http://www.stat.wisc.edu/~yandell/qtl/data/osborn/Bnapus}
  \item JM Satagopan, BS Yandell, MA Newton and TC Osborn (1996)
  Markov chain Monte Carlo approach to detect polygene loci
  for complex traits. Genetics 144: 805-816.
  \url{http://www.genetics.org/cgi/content/abstract/144/2/805}
  [first MCMC for experimental crosses; analysis of B. napus N2=LG9 (see
  \code{\link{vern}} data)]
  \item JM Satagopan and BS Yandell (1996)
  Estimating the number of quantitative trait loci via
  Bayesian model determination.
  Special Contributed Paper Session on Genetic Analysis of
  Quantitative Traits and Complex Diseases, Biometrics Section,
  Joint Statistical Meetings, Chicago, IL.
  \url{ftp://ftp.stat.wisc.edu/pub/yandell/revjump.html}
[first RJ-MCMC for experimental crosses; analysis of B. napus N2=LG9; see
  \code{\link{vern}} data]
  \item Gaffney PJ (2001)
     An efficient reversible jump Markov chain Monte Carlo approach to
     detect multiple loci and their effects in inbred crosses.
     PhD Dissertation, Dept of Statist, UW-Madison.
\url{http://wwwlib.umi.com/dissertations/fullcit/301245}

}

\examples{
data(vern)
\dontrun{
bim = run.bmapqtl(vern)
plot(bim)
}
}

\keyword{models}


\eof
\name{subset.bim}
\alias{subset.bim}
\title{Subsetting Bayesian interval mapping data}
\description{
Subset Bayesian interval mapping iterations on number of QTL and/or
chromosome pattern of QTL, using exact match or inclusive subsetting.
}
\usage{
subset.bim(x, cross, nqtl=1, pattern=NULL, exact=FALSE, chr, \dots )
}
\arguments{
  \item{x}{ object of class \code{bim} }
  \item{cross}{ corresponding object of class \code{cross} }
  \item{nqtl}{subset on number of QTL}
  \item{pattern}{subset on chromosome pattern of QTL}
  \item{exact}{subset on exact pattern or number of QTL if true}
  \item{chr}{subset of chromosomes to plot (numerical indices or
    chromosome names)}
  \item{\dots}{additional arguments to \code{\link[base]{subset}}}
}
\details{
Subset to include only iterations with at least \code{nqtl} number of
QTL and at least the \code{pattern} across chromosomes. \code{pattern}
  is a vector of chromosome identices, with repeats for
  multiple linked QTL on a chromosome. If \code{exact=FALSE}, then all
  iterations with at least the given \code{pattern} and \code{nqtl} are
  included. \code{nqtl} will be reset to \code{length(pattern)} if it is
  smaller than this value. Note that \code{pattern} should be number
  codes corresponding to those used in the \code{x} object. At
  present, chromosome names are not allowed. Further subsets to only
  include QTL from these iterations that are on chromosomes \code{chr}.
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{read.bim}}}

\examples{
\dontrun{
bim223 <- subset.bim( bim, pattern = c(2,2,3) )}
}
\keyword{utilities}

\eof
\name{summary.bim}
\alias{summary.bim}
\alias{summary.bim.model}
\alias{summary.bim.qtl}
\title{Summary of Bayesian interval mapping samples}
\description{
Quick summary of Bayesian interval mapping samples.
}
\usage{
summary.bim( object, \dots )
summary.bim.model( object, \dots )
summary.bim.qtl( object, \dots )
}
\arguments{
  \item{object}{ object of class \code{bim} (from \code{\link{run.bmapqtl}}),
    \code{bim.model} (from \code{\link{bim.model}}), or \code{bim.qtl} (from
    \code{\link{bim.qtl}} or \code{\link{bim.effects}})}
  \item{\dots}{additional arguments to \code{\link[base]{summary}}}
}
\references{ \url{http://www.stat.wisc.edu/~yandell/qtl/software/Bmapqtl} }
\author{ Brian S. Yandell, yandell@stat.wisc.edu }

\seealso{\code{\link{run.bmapqtl}},\code{\link{bim.model}},\code{\link{bim.qtl}},
  \code{\link{bim.effects}}}

\examples{
data( verngeo.bim )
\testonly{library(qtl)}
summary( verngeo.bim )
verngeo.model <- bim.model( verngeo.bim )
summary( verngeo.model )
## estimate QTL density and locate peak(s)
verngeo.qtl <- bim.qtl( verngeo.bim )
## augment bim.qtl with estimates of effects
verngeo.qtl <- bim.effects( verngeo.bim, qtl = verngeo.qtl )
## same idea but with just one call
verngeo.qtl <- bim.effects( verngeo.bim )
}
\keyword{utilities}

\eof
\name{vern}
\alias{vern}
\alias{verngeo.bim}
\alias{vernpois.bim}
\non_function{}
\title{Eight week vernalization data for Brassica napus}
\description{
Contains genotypes and phenotypes for 8-week vernalization study used in
Satagopan et al. (1996).
}
\usage{
data(vern)
data(verngeo.bim)
data(vernpois.bim)
}
\format{
See \code{\link[qtl]{read.cross}} for format of
\code{vern}. \code{verngeo.bim} and \code{vernpois.bim} created by
setting \code{prior.nqtl} to \code{"geometric"} and \code{"poisson"}, respectively.
}
\seealso{\code{\link[qtl]{read.cross}}, \code{\link{plot.bim}},
\code{\link{run.bmapqtl}}, \code{\link{bmapqtl.options}}}
\source{
Thomas C. Osborn (\url{mailto:tcosborn@facstaff.wisc.edu}), Department of Agronomy,
UW-Madison. 
}
\references{
  \item \url{http://www.stat.wisc.edu/~yandell/qtl/data/osborn/Bnapus}
  \item Ferreira ME, Satagopan J, Yandell BS, Williams PH, Osborn TC
  (1995) Mapping loci controlling vernalization requirement and
  flowering time in Brassica napus. Theor Appl Genet
  90: 727-732. [original source and analysis]
  \item Kole C, Thorman CE, Karlsson BH, Palta JP, Gaffney P, Yandell
  BS, Osborn TC (2001)
  Comparative mapping of loci controlling winter survival and
  related traits in oilseed Brassica rapa and B. napus.
  Molecular Breeding 1: 329-339. [refined map and reanalysis]
  \item JM Satagopan, BS Yandell, MA Newton and TC Osborn (1996)
  Markov chain Monte Carlo approach to detect polygene loci
  for complex traits. Genetics 144: 805-816.
  \url{http://www.genetics.org/cgi/content/abstract/144/2/805}
  [first MCMC for experimental crosses; analysis of B. napus N2=LG9; see
  \code{\link{vern}} data]
}
\examples{
data(vern)
data(verngeo.bim)
data(vernpois.bim)
## or use run.bmapqtl to create bim objects:
\dontrun{
bmapqtl.options(prior.nqtl="geometric")
verngeo.bim = run.bmapqtl(vern)
bmapqtl.options(prior.nqtl="poisson")
vernpois.bim = run.bmapqtl(vern)
}
}
\keyword{datasets}

\eof
