### Name: slideMerge
### Title: Averaging of two colour microarray replicas
### Aliases: slideMerge
### Keywords: utilities

### ** Examples


  indGreen=1:2
  indRed=3:4
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprsMatrix <- matrix(rep(1:10,4),nrow=10,ncol=4,byrow=FALSE)
  phenoMatrix <- matrix(c(c(1,2),c(3,3),c(5,5)),nrow=2,ncol=3,byrow=FALSE)
  colnames(phenoMatrix) <- c("one","two","usedForMerge")
  phenoMatrix <- rbind(phenoMatrix,phenoMatrix)
  eSA <- new("exprSetRG", exprs=exprsMatrix, phenoData=
             new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM <- slideMerge(exprSetRGObject=eSA, slideMergeColumn="usedForMerge")
  eSAOne <- slideSubset(eSA,j=c(1))
  stopifnot( all(exprs(eSAOne) == exprs(eSM) ))
  stopifnot( all( se.exprs(eSM) == 0 ) )

 ## Don't show: 

  eSA2 <- new("exprSetRG", exprs=exprsMatrix, se.exprs=exprsMatrix,
              phenoData= new("phenoData", pData=data.frame(phenoMatrix),
              varLabels=as.list(colnames(phenoMatrix))),
              channels=channels)
  eSM2 <- slideMerge(exprSetRGObject=eSA2, slideMergeColumn="usedForMerge")
  eSA2One <- slideSubset(eSA2,j=c(1))
  stopifnot( all(exprs(eSA2One) == exprs(eSM2) ) )
  stopifnot( all(sqrt(0.5*((se.exprs(eSA2One)*se.exprs(eSA2One))+(se.exprs(eSA2One)*se.exprs(eSA2One)))) == se.exprs(eSM2)) ) 

  indGreen=1:4
  indRed=5:8
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprsMatrix <- matrix(c(rep(1:10,3),rep(rep(0,10),5)),
                        nrow=10,ncol=8,byrow=FALSE)
  phenoMatrix <- matrix(c(c(1:8),rep(1,8),c(1,2,1,3,1,2,1,3)),
                        nrow=8,ncol=3,byrow=FALSE)
  colnames(phenoMatrix) <- c("one","two","usedForMerge")
  eSA3 <- new("exprSetRG", exprs=exprsMatrix, phenoData=
             new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM3 <- slideMerge(exprSetRGObject=eSA3, slideMergeColumn="usedForMerge")

  eSM3One <- slideSubset(eSM3,j=c(1))
  eSM3Two <- slideSubset(eSM3,j=c(2))
  eSM3Three <- slideSubset(eSM3,j=c(3))
  stopifnot( all(exprs(eSM3Three) == 0) )
  stopifnot( all( is.na(se.exprs(eSM3Three)) ) )

  stopifnot( all( is.na(se.exprs(eSM3Two)) ) )
  stopifnot( exprs(getExprSetGreen(eSM3Two)) == c(1:10) )
  stopifnot( all(exprs(getExprSetRed(eSM3Two)) == 0) )
  stopifnot( exprs(getExprSetGreen(eSM3One)) == (c(1:10)) )
  stopifnot( all(exprs(getExprSetRed(eSM3One)) == 0) )
  stopifnot( all(se.exprs(eSM3One) == 0) )

  exprsMatrix <- matrix(c(rep(1:10,2),rep(rep(0,10),6)),
                      nrow=10,ncol=8,byrow=FALSE)
  eSA3 <- new("exprSetRG", exprs=exprsMatrix, phenoData=
             new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM3 <- slideMerge(exprSetRGObject=eSA3, slideMergeColumn="usedForMerge")
  eSM3One <- slideSubset(eSM3,j=c(1))
  eSM3Two <- slideSubset(eSM3,j=c(2))
  eSM3Three <- slideSubset(eSM3,j=c(3))
  stopifnot( all(exprs(eSM3Three) == 0 ))
  stopifnot( all( is.na(se.exprs(eSM3Three)) ) )

  stopifnot( all( is.na(se.exprs(eSM3Two)) ) )
  stopifnot( exprs(getExprSetGreen(eSM3Two)) == c(1:10) )
  stopifnot( all(exprs(getExprSetRed(eSM3Two)) == 0) )
  stopifnot( exprs(getExprSetGreen(eSM3One)) == 0.5*(c(1:10)) )
  stopifnot( all(exprs(getExprSetRed(eSM3One)) == 0 ))
  stopifnot( all(se.exprs(getExprSetRed(eSM3One)) == 0 ))
  stopifnot( (se.exprs(getExprSetGreen(eSM3One)) == apply(cbind(rep(0,10),c(1:10)),1,sd) ))


  indGreen=1:4
  indRed=5:8
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprsMatrix <- matrix(c(rep(1:10,3),rep(rep(0,10),5)),
                        nrow=10,ncol=8,byrow=FALSE)
  se.exprsMatrix <- array(1, dim(exprsMatrix) )
  phenoMatrix <- matrix(c(c(1:8),rep(1,8),c(1,2,1,3,1,2,1,3)),
                        nrow=8,ncol=3,byrow=FALSE)
  colnames(phenoMatrix) <- c("one","two","usedForMerge")
  eSA4 <- new("exprSetRG", exprs=exprsMatrix, se.exprs=se.exprsMatrix,
              phenoData= new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM4 <- slideMerge(exprSetRGObject=eSA4, slideMergeColumn="usedForMerge")

  eSM4One <- slideSubset(eSM4,j=c(1))
  eSM4Two <- slideSubset(eSM4,j=c(2))
  eSM4Three <- slideSubset(eSM4,j=c(3))
  stopifnot( all(exprs(eSM4Three) == 0) )
  stopifnot( all(se.exprs(eSM4Three) == 1 ) ) 
  stopifnot( all(se.exprs(eSM4Two) == 1 ) ) 
  stopifnot( exprs(getExprSetGreen(eSM4Two)) == c(1:10) )
  stopifnot( all(exprs(getExprSetRed(eSM4Two)) == 0) )
  stopifnot( exprs(getExprSetGreen(eSM4One)) == (c(1:10)) )
  stopifnot( all(exprs(getExprSetRed(eSM4One)) == 0) )
  stopifnot( all(se.exprs(eSM4One) == 1) ) 

  indGreen=1:4
  indRed=5:8
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  myMatrix <- matrix(c(1:8,rep(1:4,2),c(1,1,1,4,2,2,2,2),c(2,2,2,2,4,1,1,1) ,rep(c(1,1,2,2),2)),nrow=8,ncol=5,byrow=FALSE)
  colnames(myMatrix) <- c("one","two","three","four","merge")
  exprsMatrix <-  matrix(rep(1:10,4), ncol=8, nrow=5, byrow=FALSE) 
  eSA <- new("exprSetRG", exprs=exprsMatrix, phenoData=
                new("phenoData", pData=data.frame(myMatrix),
                varLabels=as.list(colnames(myMatrix))),
              channels=channels)
  eSM <- slideMerge(exprSetRGObject=eSA, slideMergeColumn="merge")
  stopifnot( all(  dim(exprs(eSM)) == c(5,4) ) )
  stopifnot( all(as.matrix(pData((phenoDataSlide(eSM)[,which(varLabels(phenoDataSlide(eSM)) == "slidesInGroup")]))) == matrix(c("1;2","3;4"),ncol=1,nrow=2)) )
          exprs(eSM)
  stopifnot( all(exprs(getExprSetGreen(eSM)) == cbind(rowMeans(exprs(getExprSetGreen(eSA))[,1:2]), rowMeans(exprs(getExprSetGreen(eSA))[,3:4]))))
  stopifnot( all(exprs(getExprSetRed(eSM)) == cbind(rowMeans(exprs(getExprSetRed(eSA))[,1:2]), rowMeans(exprs(getExprSetRed(eSA))[,3:4]))))
  stopifnot(se.exprs(getExprSetGreen(eSM)) == cbind(as.matrix(apply((exprs(getExprSetGreen(eSA))[,1:2]),1,sd)), as.matrix(apply((exprs(getExprSetGreen(eSA))[,3:4]),1,sd))))
  stopifnot(se.exprs(getExprSetRed(eSM)) == cbind(as.matrix(apply((exprs(getExprSetRed(eSA))[,1:2]),1,sd)), as.matrix(apply((exprs(getExprSetRed(eSA))[,3:4]),1,sd))))
  stopifnot( all( match( unlist(varLabels(phenoDataSlide(eSM))), c("two", "greenSpecific_three", "greenSpecific_four", "redSpecific_three", "redSpecific_four", "merge", "slidesInGroup", "redSpecific_one", "greenSpecific_one")) ) )
  ## End Don't show

        


