### Name: rowFtests
### Title: F-test and t-test for rows of a matrix
### Aliases: rowFtests rowttests
### Keywords: math

### ** Examples

   x  = matrix(runif(9700), ncol=97)
   k2 = floor(runif(ncol(x))*2)
   k7 = floor(runif(ncol(x))*7)

   t1 = rowttests(x)
   t2 = rowttests(x, factor(k2))
   ft = rowFtests(x, factor(k7))

   if(require(multtest)) {
     fs = mt.teststat(x, k7, test="f")
     stopifnot(all(abs(fs - ft$statistic) < 1e-6))

     ts2 = mt.teststat(x, k2, test="t.equalvar")
     stopifnot(all(abs(ts2 - t2$statistic) < 1e-6))

     ts1 = apply(x, 1, function(x) t.test(x)$statistic)
     stopifnot(all(abs(ts1 - t1$statistic) < 1e-6))
   }



