### Name: arrayData-class
### Title: Class arrayData, a simple container for raw data and related
###   information
### Aliases: arrayData-class arrayData intensities<- weights<- spotAttr<-
###   hybAttrList<- getIntensities getWeights getSpotAttr getHybAttr
###   getHybAttrGreen getHybAttrRed getHybAttrList
###   intensities<-,arrayData-method weights<-,arrayData-method
###   spotAttr<-,arrayData-method hybAttrList<-,arrayData-method
###   getIntensities,arrayData-method getWeights,arrayData-method
###   getSpotAttr,arrayData-method getHybAttr,arrayData-method
###   getHybAttrGreen,arrayData-method getHybAttrRed,arrayData-method
###   getHybAttrList,arrayData-method initialize,arrayData-method
###   [,arrayData-method show,arrayData-method
### Keywords: methods classes

### ** Examples


intensities <- array(data=runif(120),dim=c(20,2,3))
dimnames(intensities) <- list(NULL, c("green","red"), NULL)
spotAttr <- data.frame(Name=I(rep(c("x","y","k","l","z"),4)),
                       Index=c(1:20))
arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                       spotAttr=spotAttr, hybAttrList=NULL)
print(arrayDataObject)
hybs <- c(1,3)
spots <- c(1:10, 14)
aD <- arrayDataObject[spots,hybs]
print(aD)
stopifnot( all( getIntensities(arrayDataObject)[spots, , hybs] == getIntensities(aD) ) )
stopifnot( all( getWeights(arrayDataObject)[spots, hybs] == getWeights(aD) ) )
stopifnot( all( getSpotAttr(arrayDataObject)[spots, ] == getSpotAttr(aD) ) )

hybAttr <- data.frame(Name=I(c("hx","hy","hz")),
                      Index=c(1:3))
arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                       spotAttr=spotAttr, hybAttrList=list(green=hybAttr,red=hybAttr))
hybAttrGreen <- data.frame(Name=I(c("hx","hy","hz")),
                      Index=c(4:6))
aDObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                       spotAttr=spotAttr, hybAttrList=list(green=hybAttrGreen,red=hybAttr))
print(arrayDataObject)
cbind(aDObject,aDObject)
hybs <- c(1)
spots <- c(1)
aD <- arrayDataObject[spots,hybs]
print(aD)
stopifnot( all( getIntensities(arrayDataObject)[spots, , hybs] == getIntensities(aD) ) )
stopifnot( all( getWeights(arrayDataObject)[spots, hybs] == getWeights(aD) ) )
stopifnot( all( getSpotAttr(arrayDataObject)[spots, ] == getSpotAttr(aD) ) )
stopifnot( all( getHybAttr(arrayDataObject)[spots, ] == getHybAttr(aD) ) )
stopifnot( all( getHybAttrRed(arrayDataObject)[spots, ] == getHybAttrRed(aD) ) )
stopifnot( all( getHybAttrGreen(arrayDataObject)[spots, ] == getHybAttrGreen(aD) ) )

stopifnot( all( getHybAttrRed(aDObject) == hybAttr) )
stopifnot( all( getHybAttrGreen(aDObject) == hybAttrGreen) )
stopifnot( all( getHybAttr(aDObject) == data.frame(Name=I(c("hx","hy","hz"))) ) )
weights(aDObject) <- intensities[,2,]
intensities(aDObject) <- intensities
spotAttr(aDObject) <- spotAttr
hybAttrList(aDObject) <- list(green=hybAttr,red=hybAttrGreen)
aD <- new("arrayData")
stopifnot(is(aD, "arrayData"))
 ## Don't show: 
 print(aD)
 xAD<-cbind(aD,aD)
 weights(aD) <- matrix(1,nrow=2,ncol=3)
 xAD<-cbind(aD,aD)
 spotAttr(aD) <- data.frame(hallo=c("a","b"))
 xAD<-cbind(aD,aD)
 hybAttrRed <- data.frame(colour=1:3)
 hybAttrGreen <- data.frame(colour=10:12)
 hybAttrList <- list(red=hybAttrRed,green=hybAttrGreen)
 hybAttrList(aD) <- hybAttrList
 xAD<-cbind(aD,aD)
 intensities <- array(data=c(1:12),dim=c(2,2,3))
 dimnames(intensities) <- list(NULL, c("green","red"), NULL)
 intensities(aD) <- intensities
 xAD<-cbind(aD,aD)
 i <- intensities * 0
 aD2<- aD
 intensities(aD2) <- i
 weights(aD2) <- getWeights(aD2) * 0.5
 xAD2 <- cbind(aD, aD2)
 stopifnot( all( getIntensities(xAD2[,1:3])  == getIntensities(aD) ) )
 stopifnot( all( getIntensities(xAD2[,4:6])  == getIntensities(aD2) ) )
 stopifnot( all( getWeights(xAD2[,1:3])  == getWeights(aD) ) )
 stopifnot( all( getWeights(xAD2[,4:6])  == getWeights(aD2) ) )
 aDThreeA <- cbind(aD,aD,aD)
 aDThreeB <- cbind( aD, cbind(aD,aD) )
 aDThreeC <- cbind( cbind(aD,aD), aD)
 stopifnot( identical( aDThreeA, aDThreeC ) )
 stopifnot( all( getSpotAttr(aDThreeA)[,1,drop=FALSE] == getSpotAttr(aD) ) )
 stopifnot( identical(getSpotAttr(aDThreeA), getSpotAttr(aDThreeB) ) )
 stopifnot( identical(getWeights(aDThreeA), getWeights(aDThreeB) ) )
 stopifnot( identical(getIntensities(aDThreeA), getIntensities(aDThreeB)))
 stopifnot( all(getHybAttrGreen(aDThreeA) == getHybAttrGreen(aDThreeB)))
 stopifnot( all(getHybAttrGreen(aDThreeA) == getHybAttrGreen(aDThreeB)))
 
## End Don't show



