\name{HTMLPage-class}
\docType{class}
\alias{HTMLPage-class}
\alias{HTMLPage}
\alias{FramedHTMLPage}
\alias{FramedHTMLPage-class}
\alias{fileName}
\alias{mainPage}
\alias{sidePage}
\alias{pageText}
\alias{toFile}
\alias{topPage}
\alias{pageTitle}
\alias{HTMLPage,HTMLPage-method}
\alias{FramedHTMLPage,HTMLPage-method}
\alias{fileName,HTMLPage-method}
\alias{mainPage,HTMLPage-method}
\alias{sidePage,HTMLPage-method}
\alias{pageText,HTMLPage-method}
\alias{toFile,HTMLPage-method}
\alias{topPage,HTMLPage-method}
\alias{pageTitle,HTMLPage-method}
\alias{show,HTMLPage-method}
\alias{initialize,FramedHTMLPage-method}
\alias{mainPage,FramedHTMLPage-method}
\alias{show,FramedHTMLPage-method}
\alias{sidePage,FramedHTMLPage-method}
\alias{toFile,FramedHTMLPage-method}
\alias{topPage,FramedHTMLPage-method}
\title{Classes to represent HTML pages}
\description{Class \code{HTMLPage} and \code{FramedHTMLPage} are a pair
  of experimental classes used to explore concepts of representing HTML
  pages using S4 objects.}
\section{Slots}{
  \describe{
    \item{\code{fileName}:}{Object of class \code{"character"} The
      filename of the HTML page}
    \item{\code{pageText}:}{Object of class \code{"character"} The text
      of the HTML page}
    \item{\code{pageTitle}:}{Object of class \code{"character"} The
      title of the HTML page}
    \item{\code{topPage}:}{Object of class \code{"HTMLPage"} The header
      page for a FramedHTMLPage}
    \item{\code{sidePage}:}{Object of class \code{"HTMLPage"} The side
      index page for a FramedHTMLPage}
    \item{\code{mainPage}:}{Object of class \code{"HTMLPage"} The
      primary page for a FramedHTMLPage}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "HTMLPage")}: Describes
      information about the page}
    \item{fileName}{\code{signature(object = "HTMLPage")}: Gets the
      fileName slot}
    \item{pageText}{\code{signature(object = "HTMLPage")}: Gets the
      pageText slot}
    \item{pageTitle}{\code{signature(object = "HTMLPage")}: Gets the
      pageTitle slot}
    \item{toFile}{\code{signature(object = "HTMLPage")}: Writes the page
    out to the file designated by the fileName slot}
  }
}
\author{Jeff Gentry}
\note{
  These classes are currently experimental.

  FramedHTMLPage is modeled after the framing layout of the Bioconductor
  website (www.bioconductor.org).
}

\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{UniGeneQuery}
\alias{UniGeneQuery}
\title{Create a Query String for a UniGene Identifier  }
\description{
Given a set of UniGene identifiers this function creates a set of URLs
that an be used to either open a browser to the requested location or
that can be used as anchors in the construction of HTML output.
}
\usage{
UniGeneQuery(query, UGaddress="UniGene/", type="CID")
}
\arguments{
  \item{query}{The UniGene identifiers. }
  \item{UGaddress}{ The address of UniGene, within the NCBI repository.}
  \item{type}{What type of object is being asked for; eithe CID or SID }
}
\details{
  Using published details from NCBI we construct an appropriate string
  for directing a web browser to the information available at the NCBI
  for that genomic product (usually an EST).
}
\value{
A character vector containing the query string.
}
\references{NCBI, \url{http://www.ncbi.nih.gov/} }
\author{Robert Gentleman}
\note{Be very careful about automatically querying this resource. It is
  considered antisocial behavior by the owners. }

\seealso{\code{\link{locuslinkQuery}}}

\examples{
  q1<-UniGeneQuery(c("Hs.293970", "Hs.155650"))
  q1
  if( interactive())
    browseURL(q1[1])

}
\keyword{interface}

\eof
\name{accessionToUID}
\alias{accessionToUID}
\title{A function to convert accession values to NCBI UIDs.}
\description{
  Given one or more accession values, this function will attempt to
  convert them into NCBI UID values.
}
\usage{
accessionToUID(...,db=c("genbank","pubmed"))
}
\arguments{
  \item{...}{Accession numbers to be transformed.}
  \item{db}{Which database this accession number refers to, defaults to Genbank}
}
\details{
  Utilizes the PubMed tool pmqty.cgi to convert an accession number
  into a valid NCBI UID number.

  WARNING:  The powers that be at NCBI have been known to ban the IP
  addresses of users who abuse their servers (currently defined as less
  then 2 seconds between queries).  Do NOT put this function in a type
  loop or you may find your access revoked.
}
\value{
  Returns either a valid NCBI UID value or NULL (if there was nothing
  available).
}
\author{Jeff Gentry}
\seealso{\code{\link{pubmed}}, \code{\link{locuslinkByID}},
  \code{\link{locuslinkQuery}}, \code{\link{xmlTreeParse}}}
\examples{

     ## The two returns from genbank should be the same
     genbank("U03397",type="accession",disp="data")
     x <- accessionToUID("U03397",db="genbank")
     genbank(x, type="uid",disp="data")

     ## Can handle multiple inputs
     accessionToUID("M16653","U892893",db="pubmed")
}
\keyword{interface}

\eof
\name{buildChromLocation}
\alias{buildChromLocation}
\title{A function to generate an instantiation of a chromLocation class }
\description{
  This function will take the name of a data package and build a
  chromLocation object representing that data set.
}
\usage{
  buildChromLocation(dataPkg)
}
\arguments{
  \item{dataPkg}{The name of the data package to be used}
}
\details{
  The requested data set must be available in the user's
  \code{.libPaths()}, and the function will throw an error if this is
  not the case.

  If the data package is present, the necessary information will be
  extracted from the data package and a \code{chromLocation} object will
  be created.
}
\value{
  A \code{chromLocation} object representing the specified data set.
}

\author{ Jeff Gentry }

\examples{
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require(hgu95av2)) {
     z <- buildChromLocation("hgu95av2")
   } else print("This example requires the hgu95av2 data package")
}
\keyword{ utilities }

\eof
\name{buildPubMedAbst}
\alias{buildPubMedAbst}
\title{A function to generate an instantiation of a pubMedAbst class }
\description{
  This function will take in a XML tree object and will create an
  instance of a pubMedAbst class.  This instance is returned to the caller.
}
\usage{
  buildPubMedAbst(xml)
}
\arguments{
  \item{xml}{A XMLTree object that corresponds to a Pubmed abstract.}
}
\value{
  This function returns an instantiation of a pubMedAbst object to the
  caller.
}

\author{ Jeff Gentry }
\seealso{\code{\link{pubmed}},\code{\link{genbank}}}
\examples{
   x <- pubmed("9695952","8325638","8422497")
   a <- xmlRoot(x)
   numAbst <- length(xmlChildren(a))
   absts <- list()
   for (i in 1:numAbst) {
      absts[[i]] <- buildPubMedAbst(a[[i]])
   }

}
\keyword{ utilities }

\eof
\name{chromLocation-class}
\docType{class}
\alias{chromLocation-class}
\alias{organism}
\alias{dataSource}
\alias{nChrom}
\alias{chromNames}
\alias{chromLocs}
\alias{chromLengths}
\alias{probesToChrom}
\alias{geneSymbols}
\alias{chromInfo}
\alias{organism,chromLocation-method}
\alias{dataSource,chromLocation-method}
\alias{nChrom,chromLocation-method}
\alias{chromNames,chromLocation-method}
\alias{chromLocs,chromLocation-method}
\alias{chromLengths,chromLocation-method}
\alias{probesToChrom,chromLocation-method}
\alias{geneSymbols,chromLocation-method}
\alias{chromInfo,chromLocation-method}
\alias{show,chromLocation-method}
\title{Class chromLocation, a class for describing genes and their
  chromosome mappings.}
\description{  This class provides chromosomal information provided by a
  Bioconductor metadata package.  By creating the object once for a
  particular package, it can be used in a variety of locations without
  the need to recomputed values repeatedly. 
}
\section{Creating Objects}{
\code{  new('chromLocation',}\cr
\code{    organism     = ...., # Object of class character}\cr
\code{    dataSource    = ...., # Object of class character}\cr
\code{    chromLocs    = ...., # Object of class list}\cr
\code{    probesToChrom  = ...., # Object of class environment}\cr
\code{    chromInfo    = ...., # Object of class numeric}\cr
\code{    geneSymbols  = ...., # Object of class environment}\cr
\code{  )}}
\section{Slots}{
  \describe{
    \item{\code{organism}:}{Object of class "character".  The organism
      that these genes correspond to. }
    \item{\code{dataSource}:}{Object of class "character".  The source of
    the gene data. }
    \item{\code{chromLocs}:}{Object of class "list".  A list which
      provides specific location information for every gene. }
    \item{\code{probesToChrom}:}{Object of class "genEnv".  A hash table
      which will translate a probe identifier to chromosome it belongs to. }
    \item{\code{chromInfo}:}{A numerical vector representing each
      chromosome, where the names are the names of the chromosomes and
      the values are their lengths}
    \item{\code{geneSymbols}:}{An environment that maps a probe ID to
      the appropriate gene symbol}
  }
}
\section{Methods}{
  \describe{
    \item{chromLengths}{(chromLocation): Gets the lengths of the
      chromosome for this organism}
    \item{chromLocs}{(chromLocation): Gets the 'chromLocs' attribute. }
    \item{chromNames}{(chromLocation): Gets the name of the chromosomes
      for this organism}
    \item{dataSource}{(chromLocation): Gets the 'dataSource' attribute. }
    \item{probesToChrom}{(chromLocation): Gets the 'probesToChrom' attribute. }
    \item{nChrom}{(chromLocation): gets the number of chromosomes this
      organism has}
    \item{organism}{(chromLocation): gets the 'organism' attribute. }
    \item{chromInfo}{Gets the 'chromInfo' attribute. }
    \item{geneSymbols}{Gets the 'geneSymbols' attribute. }
  }
}
\seealso{\code{\link{buildChromLocation}}}
\examples{
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
   if (require("hgu95av2")) {
     z <- buildChromLocation("hgu95av2")

     ## find the number of chromosomes
     nChrom(z)

     ## Find the names of the chromosomes
     chromNames(z)

     ## get the organism this object refers to
     organism(z)

     ## get the lengths of the chromosomes in this object
     chromLengths(z)

   } else print("This example requires the hgu95av2 data package")
}
\keyword{classes}

\eof
\name{findNeighbors}
\alias{findNeighbors}
\alias{checkArgs}
\alias{findChr4LL}
\alias{getValidChr}
\alias{getBoundary}
\alias{weightByConfi}
\title{A function to locate neighboring genes within a defined range
  around a target gene represented by a LocusLink id }
\description{
  Give a data package with mappings between LocsuLink ids and their
  locations on chromosomes, this function locates genes that are
  within a defined range on a given chromosome. If a LocusLink id is
  passed as one of the arguments, genes located will be neighbors to the
  gene represented by the LocusLink id within a defined range on the
  chromosome the target gene resides
}
\usage{
findNeighbors(chrLoc, llID, chromosome, upBase, downBase, mergeOrNot = TRUE)
checkArgs(llID, chromosome, upBase, downBase)
findChr4LL(llID, chrEnv, organism)
getValidChr(organism)
getBoundary(loc, base, lower = TRUE)
weightByConfi(foundLLs)
} 
\arguments{
  \item{chrLoc}{\code{chrLoc} a character string for the name of the
    data package that contains mappings between LocusLink ids and their
    locations on chromosomes. For each chromosome, there assumed to be
    mappings for the start and end locations of genes represented by
    LocusLink ids. The data package needs to be built using
    chrLocPkgBuilder of AnnBuilder}
  \item{llID}{\code{llID} a character string for the LocusLink id
    representing a gene whose nighbors are sought. llID can be missing}
  \item{chromosome}{\code{chromosome} a character string for the number
    of the chromosome of interest. chromosome is only required for
    locating genes within a range on the chromosome}
  \item{upBase}{\code{upBase} a numeric or character string for the
    number of base pairs that defines the upper limit of the range to
    locate genes. If neighbors of a given gene is sourght, the value
    will be the distance in number of base pairs from the target gene
    upstream, to which search for genes will be conducted. Otherwise, the
    value will be the upper limit in number of base pairs from the p arm,
    to which search for genes will be conducted}
  \item{downBase}{\code{downBase} a numeric or character string for the
    number of base pairs that defines the lower limit of the range to
    locat gene. If neighbors of a given gene is sourght, the value
    will be the distance in number of base pairs from the target gene
    downstream, to which search for genes will be conducted. Otherwise, the
    value will be the lower limit in number of base pairs from the p arm,
    to which search for genes will be conducted}
  \item{organism}{\code{organism} a character string for the name of the
    organism of interest}
  \item{chrEnv}{\code{chrEnv} an environment object with keys for
    LocusLink ids and values for the chromosomes where genes reside}
  \item{loc}{\code{loc} a numeric of character string for the
    chromosomal location of gene of interest}
  \item{base}{\code{base} either a \code{downBase} or \code{upBase}}
  \item{lower}{\code{lower} a boolean indicating whether the lower or
    upper boundary of search limit is sought}
  \item{mergeOrNot}{\code{mergeOrNot} a boolean to indicate whether gene
    found up and down streams will be merged (TRUE)}
  \item{foundLLs}{\code{foundLLs} a vector of character strings for
    LocusLink ids}
}
\details{
  A chrLoc data package can be created using function
  chrLocPkgBuilder of AnnBuilder, in which locusLink ids
  are mapped to location data on individual chromosomes.

  Genes are considered to be neighbors to a given target gene or within
  a given range when the transcription of genes start and end within the
  given range.

  findNeighbors, checkArgs, findChr4LL, getValidChr, and getBoundary are
  accessory functions called by findNeighbors and may not have real
  values outside.  
}
\value{
  The function returns a list of named vectors. The length of the list
  is one when genes in a given rwgion are sought but varies depending on
  whether a given gene can be mapped to one or more chromosomes when
  neighoring genes of a target gene are sought. Names of vector can be
  "Confident" when a gene can be confidently placed on a chromosome or
  "Unconfident" when a gene can be placed on a chromosome but its exact
  location can not be determined with great confidence.
}
\references{\url{http://www.genome.ucsc.edu/goldenPath/}}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide bioinformatics functionalities through R}

\examples{
if(require("humanCHRLOC")){
   findNeighbors("humanCHRLOC", "10228", upBase = 600000, downBase = 600000)
}else{
   print("Can not find neighbors without the required data package")
}
}
\keyword{manip}


\eof
\name{genbank}
\alias{genbank}
\title{A function to open the browser to Genbank with the selected gene. }
\description{
  Given a vector of Genbank accession numbers or NCBI UIDs, the user can
  either have a browser display a URL showing a Genbank query for those
  identifiers, or a XMLdoc object with the same data.  
}
\usage{
genbank(...,disp=c("data","browser"), type=c("accession","uid"),
        pmaddress=.pmfetch("Nucleotide", disp, type))
}
\arguments{
  \item{...}{Vectorized set of Genbank accession numbers or NCBI UIDs}
  \item{disp}{Either "Data" or "Browser" (default is data).  Data
    returns a XMLDoc, while Browser will display information in the
    user's browser.}
  \item{type}{Denotes whether the arguments are accession numbers or
    UIDS.  Defaults to accession values.}
  \item{pmaddress}{Specific path to the pubmed pmfetch engine from the
    NCBI website.}

}
\details{
  A simple function to retrieve Genbank data given a specific ID, either
  through XML or through a web browser.  This function will accept
  either Genbank accession numbers or NCBI UIDs (defined as a Pubmed
  ID or a Medline ID) - although the types must not be mixed in a single
  call. 

  WARNING:  The powers that be at NCBI have been known to ban the IP
  addresses of users who abuse their servers (currently defined as less
  then 2 seconds between queries).  Do NOT put this function in a tight
  loop or you may find your access revoked.
}
\value{
  If the option "data" is used, an object of type XMLDoc is returned,
  unless there was an error with the query in which case an object of
  type try-error is returned.

  If the option "browser" is used, nothing is returned.
}

\author{R. Gentleman }

\seealso{\code{\link{pubmed}}, \code{\link{locuslinkByID}},
  \code{\link{locuslinkQuery}}, \code{\link{xmlTreeParse}}}

\examples{
   ## Use UIDs to get data in both browser & data forms

   if ( interactive() ) {
      disp <- c("data","browser")
   } else {
      disp <- "data"
   }

   for (dp in disp)
     genbank("12345","9997",disp=dp,type="uid")

   ## Use accession numbers to retrieve browser info
   if ( interactive() )
       genbank("U03397","AF030427",disp="browser")
}
\keyword{interface }

\eof
\name{genelocator}
\alias{genelocator}
\title{A function to identify genes by their LocusLink (or other id).  }
\description{
   This function uses \code{locator} to provide some interaction with an
   \code{image} plot of genetic data. It is currently not implemented
   except in skeleton form.
}
\usage{
genelocator(x)
}
\arguments{
  \item{x}{Undeterimined }
}
\details{
}
\value{
  This function is executed mainly for its side effect. When an image
  plot is active then \code{genelocator} can be called. When the image
  is clicked on, using the left mouse button, the users web browser is
  activated and a web page (determined by one of the arguments to
  \code{genelocator}) will be displayed.
}

\author{ R. Gentleman }
\note{ }

\seealso{ \code{\link{locator}}}

\examples{
## This is an interactive function so the examples won't work!
}
\keyword{ iplot }

\eof
\name{getPMInfo}
\alias{getPMInfo}
\title{extract publication details and abstract from annotate::pubmed function output  }
\description{
extract publication details and abstract from annotate::pubmed function output  
}
\usage{
getPMInfo(x)
}
\arguments{
  \item{x}{ an object of class xmlDocument; assumed to be result of a pubmed() call}
}
\details{
uses xmlDOMApply to extract and structure key features of the XML tree returned
by annotate::pubmed()
}
\value{
a list with one element per pubmed id processed by pubmed.  Each element of
the list is in turn a list with elements for author list, title, journal
info, and abstract text.
}
\references{  }
\author{Vince Carey <stvjc@channing.harvard.edu>}
\note{this should be turned into a method returning an instance of
a formal class representing articles.    }


\seealso{  }

\examples{
demo <- pubmed("11780146", 
    "11886385", "11884611")
getPMInfo(demo)
}
\keyword{ models }

\eof
\name{getSYMBOL}
\alias{getSYMBOL}
\alias{getGO}
\alias{getGOdesc}
\alias{getPMID}
\alias{getLL}
\alias{lookUp}
\alias{getUniqAnnItem}
\title{Functions to deal with Data Packages}
\description{
  The functions documented here are intended to make it easier to map
  from a set of manufacturers identifiers (such as you will get from the
  chips etc) to other identifiers.
}
\usage{
getSYMBOL(x, data)
getLL(x, data)
getGO(x, data)
getPMID(x, data)
getGOdesc(x, which)
lookUp(x, data, what)
getUniqAnnItem()
}
\arguments{
  \item{x}{The identifiers to be mapped (usually manufacturer)}
  \item{data}{The basename of the meta-data package to be used. }
  \item{what}{\code{what} a character string for the name of an
    annotation element of an annotation data package}
  \item{which}{\code{which} a character string in the form of MF, BP,
    CC, or ANY to indicated the GO category of interests}
}
\details{
  Users must supply the basename of the meta-data package that they
  want to use to provide the mappings. The name of the meta-data
  package is the same as the basename.
  
  Appropriate translations are done. In some cases such as \code{getLL}
  and \code{getSYMBOL} there will only be one match and a vector is
  returned. In other cases such as \code{getPMID} and \code{getGO} there
  may be multiple matches and a list is returned.

  For \code{getGOdesc} the input vector is GO identifiers (not
  manufacturer identifiers) and in the output any identifier that does
  not have a description in the selected GO hierarchy (MF, BP or CC) is
  dropped.

  \code{lookUp} is a general function that can be used to look
  up matches. All other translation functions use \code{lookUp}

  A BioC annotation data package contains annotation data environments
  whose names are package name (e. g. hgu95av2) + element name
  (e. g. PMID). \code{what} must be one of the element names for the
  given data package. 

  \code{getUniqAnnItem} keeps track of the annotation elements that have
  one to one mappings.   
}
\value{
  Either a vector or a list depending on whether multiple values per
  input are possible.
}
\author{R. Gentleman}
\seealso{\code{\link{mget}}}
\examples{
  data(eset)
  gN <- geneNames(eset)[100:105]
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
  if( require("hgu95av2", character.only=TRUE)
       && require("GO", character.only=TRUE) ) {
      lookUp(gN, "hgu95av2", "SYMBOL")
      # Same as lookUp for SYMBOL except the return is a vector
      getSYMBOL(gN,"hgu95av2" )
      gg<- getGO(gN, "hgu95av2")
      lookUp(gg[[2]][[1]][["GOID"]], "GO", "TERM")
      # Same as lookUp for TERM
      getGOdesc(gg[[2]][[1]][["GOID"]], "ANY")
      # For BP only
      getGOdesc(gg[[2]][[1]][["GOID"]], "BP")
      getLL(gN, "hgu95av2")
      getPMID(gN, "hgu95av2")
  } else
   cat("could not run all examples\n")
}
\keyword{manip}

\eof
\name{getTDRows}
\alias{getTDRows}
\alias{getQueryLink}
\alias{getQuery4UG}
\alias{getQuery4LL}

\title{Functions to create hypertext links that can be placed in a table
  cell of a HTML file} 
\description{
  Given a vector of ids, the functions will create a vector of hypertext
  links to a defined public repositories such as LocusLink, UniGene
  .... The linkages can be placed in a html file constructed by
  \code{\link{ll.htmlpage}} 
}
\usage{
getTDRows(ids, repository = "ug")
getQueryLink(ids, repository = "ug")
getQuery4UG(ids)
getQuery4LL(ids)
}

\arguments{
  \item{ids}{\code{ids} a vector of character string for ids that will
    used to construct hypertext links}
  \item{repository}{\code{repository} A character string for the name of
    a public repositories. Valid values include "ll", "ug"} 
}
\details{
  \code{\link{getQuery4LL}} constructs hypertext links to LocusLink
  using the provided ids. 

  \code{\link{getQuery4UG}} constructs hypertext links to UniGene using
  the provided ids.

  \code{\link{getQueryLink}} directs calls to construct hypertext links
  using the provided ids.

  \code{getTDRows}} directs calls to construct hypertext links
  using the provided ids and then places the links in table cells.
}
\value{
  Returns a vector of character strings representing the hypertext links.
}

\author{Jianhua Zhang}
\note{The functions are part of Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{\link{ll.htmlpage}}}
\examples{
ids <- c("Hs.78713", "Hs.11184", "Hs.281866","Hs.31314")
getTDRows(ids)  
}
\keyword{manip}

\eof
\name{hgByChroms}
\alias{hgByChroms}
\non_function{}
\title{ A dataset to show the human genome base pair locations per
  chromosome. }
\usage{data(hgByChroms)}
\format{
  A list, with the names consisting of the names of the chromosomes in
  the human genome (thus 24 elements).  Each element consists of a named
  vector of +/- values - where each value represents the location of a
  base pair (the numeric value is the location, while the +/- denotes
  the strand value), with the name providing the name of the base pair.
}
\description{
  The data is described above.
}
\source{
  Cheng Li of the Dana-Farber Cancer Institute.
}
\examples{
 data(hgByChroms)
}
\keyword{datasets}

\eof
\name{hgCLengths}
\alias{hgCLengths}
\non_function{}
\title{ A dataset which contains the lengths (in base pairs) of the
  human chromosomes. }
\usage{data(hgCLengths)}
\format{A vector containing 24 values, each corresponding to the total
chromosome length. }
\description{
  The data is described above.
}
\source{
  UCSC Human Genome Project
}
\examples{
  data(hgCLengths)
}
\keyword{datasets}

\eof
\name{hgu95AProbLocs}
\docType{instance}
\alias{hgu95AProbLocs}
\title{chromLocation instance hgu95AProbLocs, an example of a chromLocation 
object}
\description{  gives chromosome locations for Affy U95 probes }
\section{Slots}{
  \describe{
    \item{\code{species}:}{Object of class character, value: 'Human'}
    \item{\code{datSource}:}{Object of class character, value}
    \item{\code{nChrom}:}{Object of class numeric, value: 24}
    \item{\code{chromNames}:}{Object of class character, value: 1:22, X,Y}
    \item{\code{chromLocs}:}{Object of class list, value: long: sense and antisense locations
      associated with affy identifiers}
    \item{\code{chromLengths}:}{Object of class numeric, }
    \item{\code{geneToChrom}:}{Object of class environment}
    \item{\code{class}:}{Object of class character, value: 'chromLocation'}
  }
}
\keyword{methods}

\eof
\name{hgu95Achroloc}
\alias{hgu95Achroloc}
\non_function{}

\title{Annotation data for the Affymetrix HGU95A GeneChip}
\usage{data(hgu95Achroloc)}

\format{
  These data sets provide environments with mappings from the Affymetrix
  identifiers to chromosomal location, in bases.
  The environments function like hashtables and can be accessed using
  \code{multiget}.
  If the returned value is \code{NA} then the current 
  mapping was unable to identify this. Mappings and data sources are
  constantly evolving so updating often is recommended.

}
\description{Data, in the form of environments for the Affymetrix U95A
 chip.}

\source{The \code{AnnBuilder} package.}

\examples{
 data(hgu95Achroloc)
 data(eset)
 multiget(geneNames(eset)[330:340], env=hgu95Achroloc)

}
\keyword{datasets}

\eof
\name{hgu95Achrom}
\non_function{}
\docType{data}
\alias{hgu95Achrom}

\title{Annotation data for the Affymetrix HGU95A GeneChip}

\usage{data(hgu95Achrom)
}

\format{
  This data set provides an environment (treat as a hashtable)
  with mappings from the Affymetrix
  identifiers to chromosome number/name.
  The environment functions like a hashtable and can be accessed using
  \code{multiget}.
  If the returned value is \code{NA} then the current 
  mapping was unable to identify this. Mappings and data sources are
  constantly evolving so updating often is recommended.
}
\description{Data, in the form of environments for the Affymetrix U95A
 chip.}

\source{The \code{AnnBuilder} package.}

\examples{
 data(hgu95Achrom)
 data(eset)
 multiget(geneNames(eset)[330:340], env=hgu95Achrom)
}
\keyword{datasets}

\eof
\name{hgu95All}
\non_function{}
\docType{data}
\alias{hgu95All}

\title{Annotation data for the Affymetrix HGU95A GeneChip}

\usage{data(hgu95All)}
\description{Data, in the form of environments for the Affymetrix U95A
 chip.}


\format{
  These data sets provide environments with mappings from the Affymetrix
  identifiers to LocusLink identifiers.
  The environment functions like a hashtable and can be accessed using
  \code{multiget}.
  If the returned value is \code{NA} then the current 
  mapping was unable to identify this. Mappings and data sources are
  constantly evolving so updating often is recommended.
}

\source{The \code{AnnBuilder} package.}

\examples{
 data(hgu95All)
 data(eset)
 multiget(geneNames(eset)[330:340], env=hgu95All)

}
\keyword{datasets}

\eof
\name{hgu95Asym}
\non_function{}
\docType{data}
\alias{hgu95Asym}

\title{Annotation data for the Affymetrix HGU95A GeneChip}

\usage{data(hgu95Asym)}

\format{
  This data set provides an environment with mappings from the Affymetrix
  identifiers to gene symbol.
  The environment functions like a hashtables and can be accessed using
  \code{multiget}.
  If the returned value is \code{NA} then the current 
  mapping was unable to identify this. Mappings and data sources are
  constantly evolving so updating often is recommended.
}
\description{Data, in the form of environments for the Affymetrix U95A
 chip.}

\source{The \code{AnnBuilder} package.}

\examples{
 data(hgu95Asym)
 data(eset)
 multiget(geneNames(eset)[330:340], env=hgu95Asym)
}
\keyword{datasets}

\eof
\name{installDataPackage}
\alias{installDataPackage}
\title{A function to install data packages from the Internet}
\description{
  This function can be used to easily download and install a data
  package from the Bioconductor website.
}
\usage{
installDataPackage(pkga, liba = .libPaths()[1])
}
\arguments{
  \item{pkga}{The name of the desired data package}
  \item{liba}{The install library, defaulting to the base library}
}
\details{
  installDataPackage uses the \code{reposTools} package to perform the
  actual download and install - this function is mainly just a
  simplified wrapper for \code{install.packages2}.  It connects to the
  data package repository at \url{http://www.bioconductor.org/data/dataRepos},
  and attempts to get the requested package.
}
\author{Jeff Gentry}
\seealso{\code{\link{install.packages2}}}
\examples{
  z <- tempfile()
  dir.create(z)
  installDataPackage("GO", liba=z)
}
\keyword{utilities}

\eof
\name{ll.htmlpage}
\alias{ll.htmlpage}
\title{ Turn LocusLink ID's into a Clickable Web Page }
\description{
  Given a set of LocusLink accession numbers we create a web page with
  one element per gene that is clickable and produces the LL webpage for
  that gene.
}
\usage{
ll.htmlpage(genelist, filename, title, othernames, table.head,
     table.center = TRUE, repository = "ll" )
)
}
\arguments{
  \item{genelist}{A character vector of gene names for LocusLink. }
  \item{filename}{The name of the file to store the HTML in. }
  \item{title}{A title for the web page}
  \item{othernames}{Other values to be included in the table}
  \item{table.head}{A character vector of column labels for the table}
  \item{table.center}{A logical indicating whether the table should be
    centered}
  \item{repository}{A character string for the name of a public
    repositories. Valid values include "ll", "ug"} 
}
\details{
  A simple markup is used to provide clickable entries.
  Anyone that is energetic could greatly improve this.
}
\value{
  No value is returned. The function is evaluated solely for the side
  effect of producing the file \code{filename}.
}

\author{R. Gentleman }

\examples{
 gnames <- as.character(6810:6820)
 ll.htmlpage(gnames, "fff.html")

 file.remove("fff.html")
}
\keyword{ file }


\eof
\name{locuslinkByID}
\alias{locuslinkByID}

\title{A function to open the browser to Locuslink with the selected gene. }
\description{
  Given one or more Locuslink accession numbers the browser is given a
  URL to query for that \em{gene}. 
}
\usage{
locuslinkByID(..., lladdress="LocusLink/", browse=TRUE)
}
\arguments{
  \item{...}{The Locuslink accession numbers. }
  \item{lladdress}{The subdirectory off of the NCBI site for LocusLink. }
  \item{browse}{If TRUE, will open the URL in a web browser}
}
\details{
  A simple function to open the appropriate web page in the users
  browser.  If the user supplies more then one accession number, the
  other results will be accessible through the LocusLink page under the
  "View" pulldown menu on the page.
}
\value{
  If \code{browse} is \code{TRUE}, the user's web browser is directed to
  that URL. The URL found is returned if \code{browse} is \code{FALSE}.
}

\author{Jeff Gentry }

\seealso{\code{\link{genbank}} \code{\link{pubmed}}
  \code{\link{locuslinkQuery}}}

\examples{
  if( interactive() )
      locuslinkByID(7531,9025,2315)
}
\keyword{ interface }

\eof
\name{locuslinkQuery}
\alias{locuslinkQuery}
\title{A function to open the browser to Locuslink using a provided
  search query. }
\description{Given a search string, will query the Locuslink site and
  passes the returned page to the browser.}
\usage{
locuslinkQuery(query,...,lladdress="LocusLink/", browse=TRUE)
}
\arguments{
  \item{query}{The search query to use}
  \item{...}{The species to search on.  Defaults to "Hs" - human.}
  \item{lladdress}{The subdirectory off of the NCBI site for
    LocusLink. }
  \item{browse}{If TRUE, will open the URL in a web browser}

}
\details{
  A simple function which takes a search string and a set of species,
  and will perform a locuslink query, returning the results to the
  browser.  Tips on creating good search strings, as well as current
  species abbreviations can be found at: \code{http://www.ncbi.nih.gov/LocusLink/help.html}
}
\value{
  If \code{browse} is TRUE, the user's web browser is directed to that URL.
  The URL found is returned if \code{browse} is FALSE.  

}
\author{Jeff Gentry }
\seealso{\code{\link{genbank}} \code{\link{pubmed}} \code{\link{locuslinkByID}}}
\examples{
   if( interactive() )
      locuslinkQuery("abc","Hs","Mm")
}
\keyword{ interface }

\eof
\name{makeAnchor}
\alias{makeAnchor}
\title{A Function To Generate HTML Anchors}
\description{
  This function will take a set of links and titles and will generate
  HTML anchor tags out of these values
}
\usage{
makeAnchor(link, title, toMain = FALSE)
}
\arguments{
  \item{link}{A vector of URLs}
  \item{title}{A vector of website names}
  \item{toMain}{Used for frame pages}
}
\value{
  A vector of HTML anchor tags
}
\author{Jeff Gentry}
\examples{
makeAnchor("http://www.bioconductor.org","Bioconductor")
}
\keyword{utilities}

\eof
\name{neighborGeneFinder}
\alias{neighborGeneFinder}
\title{A widget for locating genes neighboring a target gene}
\description{
  Given a set of data (matrix) with entries for LocusLink or UniGene
  ids, the neighboring genes of a gene selected from a list on the
  interface can be located.
}
\usage{
neighborGeneFinder(geneData, keyName = c("unigene", "locuslink"),
organism = c("human", "mouse", "rat")) 
}
\arguments{
  \item{geneData}{\code{geneData} a matrix with columns named. The name
    for one of the columns has to be either "locuslink" or "unigene"}
  \item{keyName}{\code{keyName} a character string for the name of the
    key columns of \code{geneData}. Has to be either "locuslink" or
    "unigene"} 
  \item{organism}{\code{organism} a character string for the name of the
    organism of interest. Has to be "human", "mouse", or "rat"} 
}
\details{
  Bioconductor's data package XXXCHRLLOC has to be instatlled for the
  widget to work. If \code{keyName} is "unigene", XXXLLMappings is
  required, where XXX is the name of the organism of interest.
}
\value{
  This function returns a list of lists. Elements of the top level list
  are either LocusLink or UniGene ids. A sublist is inturn a list of
  lists whose top level elements are chromosome numbers, each of which
  is a list with an "upstream" and "downstream" elements.
}
\author{Jianhua Zhang}
\note{This function is part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\examples{
  if(interactive()){
     require("annotate", character.only = TRUE) ||
     stop("Package annotate is not availble")
     geneData <- cbind(paste("100", 1:16, "_at", sep = ""), c(1, 50,
                       10044, 51, 71, 51371, 81, 51426, 188, 293, 360,
                       364, 375, 387, 513, 10572))
     colnames(geneData) <- c("Probe", "locuslink")
     neighborGeneFinder(geneData, "locuslink", "human")
  }
  
}
\keyword{interface}


\eof
\name{pm.abstGrep}
\alias{pm.abstGrep}
\title{An interface to grep for PubMed abstracts.  }
\description{
  A user friendly interface to the functionality provided by
 \code{pubmed}. 
}
\usage{
pm.abstGrep(pattern, absts, ...)
}
\arguments{
  \item{pattern}{A pattern for the call to \code{grep}. }
  \item{absts}{A list containing abstracts downloaded using \code{pubmed} or
  equivalent. }
  \item{\dots}{Extra arguments passed to \code{grep}. }
}
\details{
  The \code{absts} are a list of PubMed XML objects that have been downloaded 
  and parsed. This function lets the user quickly search the abstracts
  for any regular expression. The returned value is a logical vector
  indicating which of the abstracts contain the regular expression.
}
\value{
 The returned value is a logical vector
  indicating which of the abstracts contain the regular expression.
}
\author{ Robert Gentleman }

\seealso{ \code{\link{pm.getabst}}, \code{\link{pm.titles}}}

\examples{
  hoxa9 <- "37809_at"

   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
  if( require(hgu95av2) ) {
     absts <- pm.getabst(hoxa9, "hgu95av2")

     pm.abstGrep("NUP98", absts[[1]])

     pm.abstGrep("apoptosis", absts[[1]])
  }

}
\keyword{ manip }

\eof
\name{pm.getabst}
\alias{pm.getabst}
\title{ Obtain the abstracts for a set PubMed list. }
\description{
 The data provided by PubMed is reduced to a small set. This set is 
then suitable for further rendering.
}
\usage{
pm.getabst(geneids, basename)
}
\arguments{
  \item{geneids}{The identifiers used to find Abstracts }
  \item{basename}{The base name of the annotation package to use. }
}
\details{
We rely on the annotation in the package associated with the 
\code{basename} to provide PubMed identifiers for the genes described by
the gene identifiers.
With these in hand we then use the \code{pmfetch} utility to download the
PubMed abstracts in XML form. These are then translated (transformed) to a 
shorter version containing a small subset of the data provided by PubMed.

This function has the side effect of creating an environment in 
\code{.GlobalEnv} that contains the mapping for the requested data.
This is done for efficiency -- so we don't continually read in the data
when there are many different queries to be performed.
}
\value{
 A list of lists containing objects of class \code{pubMedAbst}.
 There will be one element of the list for each identifier.
 Each of these elements is a list containing one abstract (of
 class \code{pubMedAbst} for each PubMed identifier associated with
 the gene identifier.
}
\author{ Robert Gentleman }

\seealso{ \code{\link{pm.abstGrep}}, \code{\link{pm.titles}} }

\examples{
hoxa9 <- "37809_at"
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)

if( require(hgu95av2) )
    absts <- pm.getabst(hoxa9, "hgu95av2")

}
\keyword{ manip }

\eof
\name{pm.titles}
\alias{pm.titles}
\title{Obtain the titles of the PubMed abstracts.  }
\description{
 This function returns the titles from a list of PubMed abstracts.
}
\usage{
pm.titles(absts)
}
\arguments{
  \item{absts}{The list of PubMed abstracts. }
}
\details{
  It simply uses \code{sapply}
}
\value{
A character vector of length equal to the number of abstracts. Each
element is the title of the corresponding abstract.
}
\author{ Robert Gentleman }

\seealso{ \code{\link{pm.abstGrep}} }

\examples{
 hoxa9 <- "37809_at"
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)

 if( require(hgu95av2) ) {
    absts <- pm.getabst(hoxa9, "hgu95av2")
    pm.titles(absts)
 }
}
\keyword{ manip }

\eof
\name{pmAbst2HTML}
\alias{pmAbst2HTML}
\title{HTML Generation for PubMed Abstracts}
\description{
  This function will take a \code{pubMedAbst} object, or a list of these
  objects and generate a web page that will list the titles of
  the abstracts and link to their full page on PubMed
}
\usage{
pmAbst2HTML(absts, filename, title, frames = FALSE, table.center = TRUE)
}
\arguments{
  \item{absts}{A list of \code{pubMedAbst} (or a single object)}
  \item{filename}{The output filename.  If \code{frames} is
    \code{FALSE}, this is the name of the single output file and
    defaults to \code{absts.html}.  Otherwise, this is taken to be the
    base of a set of filenames, and the default base is the empty
    string.  See \code{value} for more information on output files.}
  \item{title}{ Extra title information for your listing}
  \item{frames}{If \code{frames} is \code{TRUE}, the resulting page will
  use HTML frames, resulting in a more complex set of output pages.}
  \item{table.center}{If TRUE, will center the listing of abstracts}
}
\details{
  This function uses the \code{Entrez} functionality provided by NCBI to
  retrieve the abstract URL at the PubMed site.  It will then create a
  tabular webpage which will list the titles of the abstracts provided
  and have them link to the appropriate PubMed page.  If \code{frames}
  is \code{TRUE}, the table of links will be on the left hand side of
  the page and the right hand will link directly to the appropriate
  PubMed page.
}
\value{
  If \code{frames} is \code{FALSE}, a simple HTML file is created with
  the name specified by \code{filename}.

  If \code{frames} is \code{TRUE}, then there are four HTML files
  created, of the form \code{XXXtop.html}, \code{XXXside.html},
  \code{XXXmain.html} and \code{XXXindex.html}, where \code{XXX} is the
  string provided by \code{filename}.
}
\author{Jeff Gentry}
\note{ This function is part of the Bioconductor project at the Dana-Farber
  Cancer Institute to provide Bioinformatics functionalities through R}

\seealso{\code{pubMedAbst}}
\examples{
        x <- pubmed("9695952","8325638","8422497")
        a <- xmlRoot(x)
        numAbst <- length(xmlChildren(a))
        absts <- list()
        for (i in 1:numAbst) {
           absts[[i]] <- buildPubMedAbst(a[[i]])
        }
        ## First try it w/o frames - using a temporary
        ## file for the output
        fname <- tempfile()
        pmAbst2HTML(absts,filename=fname)

        if (interactive())
          browseURL(paste("file://",fname,sep=""))

        ## Now try it w/ frames, using temporary files again.
        fnameBase <- tempfile()
        pmAbst2HTML(absts,filename=fnameBase, frames=TRUE)

        if (interactive())
          browseURL(paste("file://",fnameBase,"index.html",sep=""))

}
\keyword{utilities}

\eof
\name{pmidQuery}
\alias{pmidQuery}
\title{A function to query PubMed}
\description{
  Given a PMID, will create a URL which can be used to open a
  browser and retrieve the specified information from PubMed.
}
\usage{
pmidQuery(query)
}
\arguments{
  \item{query}{ The PubMed ID (or IDs)}
}
\details{
  Using ublished details from NCBI we construct an appropriate string
  for directing a web browser to the information available at the NCBI.
}
\value{
  A character string containing the appropriate URL
}
\references{NCBI, \url{http://www.ncbi.nih.gov/} }
\author{Jeff Gentry}

\seealso{\code{\link{UniGeneQuery}}, \code{\link{locuslinkQuery}}}
\examples{
  a <- "9695952"
  pmidQuery(a)
}
\keyword{interface}


\eof
\name{probesByLL}
\alias{probesByLL}

\title{A function that groups probe ids by LocusLink ids}
\description{
  This  function takes the name of a platform specific annotation data
  package (e. g. an Affymetrix chip) and returns a list of vectors of
  character string with LocusLink ids as the names of the lists of
  vectors and probe ids corresponding to the LocusLink ids as values.
}
\usage{
probesByLL(baseName)
}

\arguments{
  \item{baseName}{\code{baseName} a character string for the name of
    platform specific annotation data package}
}
\details{
  Each platform specific annotation data package has a LOCUSID
  environment that maps probe ids to LocusLink ids. This function does
  reverse mappings by grouping probe ids under unique LocusLink ids and
  returns the mappings as a list.
}
\value{
  This function returns a list of vectors of character strings with
  unique LocusLink ids as the names and probe ids corresponding to the
  LocsuLink ids as values.
}

\author{Jianhua Zhang}

\examples{
    if(require("hgu95av2")){
        tt <- probesByLL("hgu95av2")
        tt[1:4]
    }
}
\keyword{ manip }

\eof
\name{pubMedAbst-class}
\docType{class}
\alias{pubMedAbst-class}
\alias{pubMedAbst}
\alias{authors}
\alias{abstText}
\alias{articleTitle}
\alias{journal}
\alias{pubDate}
\alias{abstUrl}
\alias{pmid}
\alias{pubMedAbst,pubMedAbst-method}
\alias{authors,pubMedAbst-method}
\alias{abstText,pubMedAbst-method}
\alias{articleTitle,pubMedAbst-method}
\alias{journal,pubMedAbst-method}
\alias{pubDate,pubMedAbst-method}
\alias{abstUrl,pubMedAbst-method}
\alias{pmid,pubMedAbst-method}
\alias{show,pubMedAbst-method}  
\title{Class pubMedAbst, a class to handle PubMed abstracts, and methods
for processing them.}
\description{  This is a class representation for PubMed abstracts. }
\section{Creating Objects}{
  \code{ new('pubMedAbst',}\cr
  \code{  authors      = ...., # Object of class vector}\cr
  \code{  pmid         = ...., # Object of class character}\cr
  \code{  abstText     = ...., # Object of class character}\cr
  \code{  articleTitle = ...., # object of class character}\cr
  \code{  journal      = ...., # Object of class character}\cr
  \code{  pubDate      = ...., # Object of class character}\cr
  \code{  abstUrl      = ...., # Object of class character}\cr
  \code{  )}}
\section{Slots}{
  \describe{
    \item{\code{pmid}:}{Object of class \code{"character"} The PubMed ID
      for this paper. }
    \item{\code{authors}:}{Object of class \code{"vector"} The authors
      of the paper. }
    \item{\code{abstText}:}{Object of class \code{"character"} The
      contained text of the abstract.  }
    \item{\code{articleTitle}:}{Object of class \code{"character"} The
      title of the article the abstract pertains to. }
    \item{\code{journal}:}{Object of class \code{"character"} The journal
      the article was published in. }
    \item{\code{pubDate}:}{Object of class \code{"character"} The date the
    journal was published. }
    \item{\code{abstUrl}:}{Object of class \code{"character"} A URL, if
      one is provided, contained in the abstract. }
  }
}

\section{Methods}{
  \describe{
    \item{pmid}{\code{signature(object = "pmid")}: An accessor function
      for \code{pmid}}
    \item{abstText}{\code{signature(object = "pubMedAbst")}: An accessor
    function for \code{abstText}}
    \item{abstUrl}{\code{signature(object = "pubMedAbst")}: An accessor
      function for \code{abstUrl} }
    \item{articleTitle}{\code{signature(object = "pubMedAbst")}: An accessor
      function for \code{articleTitle} }
    \item{authors}{\code{signature(object = "pubMedAbst")}: An accessor
      function for \code{authors} }
    \item{journal}{\code{signature(object = "pubMedAbst")}: An accessor
      function for \code{journal} }
    \item{pubDate}{\code{signature(object = "pubMedAbst")}: An accessor
      function for \code{pubDate}}
  }
}
\author{ Jeff Gentry }

\seealso{\code{\link{pubmed}}, \code{\link{genbank}}}
\examples{
   x <- pubmed("9695952","8325638","8422497")
   a <- xmlRoot(x)
   numAbst <- length(xmlChildren(a))
   absts <- list()
   for (i in 1:numAbst) {
      absts[[i]] <- buildPubMedAbst(a[[i]])
   }
}
\keyword{classes}

\eof
\name{pubmed}
\alias{pubmed}

\title{A function to open the browser to Pubmed with the selected gene. }
\description{
  Given a vector of Pubmed identifiers or accession numbers, the user
  can either have a browser display a URL showing a Pubmed query for
  those identifiers, or a XMLdoc object with the same data.
}
\usage{
pubmed(...,disp=c("data","browser"), type=c("uid","accession"),
       pmaddress=.pmfetch("PubMed", disp, type))
}
\arguments{
  \item{...}{Vectorized set of Pubmed ID's}
  \item{disp}{Either "Data" or "Browser" (default is data).  Data
    returns a XMLDoc, while Browser will display information in the
    user's browser.}
  \item{type}{Denotes whether the arguments are accession numbers or
    UIDS.  Defaults to uids.}
  \item{pmaddress}{Specific path to the pubmed pmfetch engine from the
    NCBI website.}
}
\details{
  A simple function to retrieve Pubmed data given a specific ID, either
  through XML or through a web browser.  This function will accept
  either pubmed accession numbers or NCBI UIDs (defined as a Pubmed
  ID or a Medline ID) - although the types must not be mixed in a single
  call. 

  WARNING:  The powers that be at NCBI have been known to ban the IP
  addresses of users who abuse their servers (currently defined as
  less then 2 seconds between queries).  Do NOT put this function in
  a type loop or you may find your access revoked.
}
\value{
  If the option "data" is used, an object of type XMLDoc is returned,
  unless there was an error with the query in which case an object of
  type try-error is returned.

  If the option "browser" is used, nothing is returned.
}

\author{R. Gentleman }

\seealso{\code{\link{genbank}}, \code{\link{locuslinkByID}},
  \code{\link{locuslinkQuery}}, \code{\link{xmlTreeParse}}}

\examples{
   if( interactive() )
    opts <- c("data","browser") else
    opts <- "data"
   for (dp in opts)
     pubmed("11780146","11886385","11884611",disp=dp)
}
\keyword{ interface }

\eof
\name{usedChromGenes}
\alias{usedChromGenes}
\title{A function to select used genes on a chromosome from an exprSet.}
\description{
  Given an instance of an \code{exprSet}, a \code{chromLocation} object
  and the name of a chromosome this function returns all genes represented
  in the \code{exprSet} on the specified chromosome.
}
\usage{
usedChromGenes(eSet, chrom, specChrom)
}
\arguments{
  \item{eSet}{An instance of an \code{exprSet} object.}
  \item{chrom}{The name of the chromosome of interest.}
  \item{specChrom}{An instance of a \code{chromLocation} object.}
}
\value{
  Returns a vector of gene names that represent the genes from the
  \code{exprSet} that are on the specified chromosome.
}
\author{ Jeff Gentry}
\examples{
    data(eset)
    data(hgu95AProbLocs)
    usedChromGenes(eset,"1",hgu95AProbLocs)
}
\keyword{interface}

\eof
