### Name: read.affybatch
### Title: Read CEL files into an AffyBatch
### Aliases: read.affybatch ReadAffy
### Keywords: manip

### ** Examples

if(require(affydata)){
     celpath <- paste(.path.package("affydata"),"celfiles",sep="/")
     fns <- list.celfiles(path=celpath,full.names=TRUE)
 
     cat("Reading files:\n",paste(fns,collapse="\n"),"\n")
     ##read a binary celfile
     abatch <- ReadAffy(filenames=fns[1])
     ##read a text celfile
     abatch <- ReadAffy(filenames=fns[2])
     ##read all files in that dir
     abatch <- ReadAffy(celfile.path=celpath)
}



