\name{AffyBatch-class}
\docType{class}
\alias{AffyBatch-class}
\alias{AffyBatch}
\alias{probes}
\alias{geneNames}
\alias{geneNames<-}
\alias{getCdfInfo}
\alias{image}
\alias{indexProbes}
\alias{intensity<-}
\alias{intensity}
\alias{pmindex}
\alias{mmindex}
\alias{probeset}
\alias{$.AffyBatch}
\alias{cdfName}
\alias{cdfName,AffyBatch-method}
\alias{probes,AffyBatch-method}
\alias{geneNames,AffyBatch-method}
\alias{geneNames<-,AffyBatch-method}
\alias{getCdfInfo,AffyBatch-method}
\alias{image,AffyBatch-method}
\alias{indexProbes,AffyBatch-method}
\alias{intensity<-,AffyBatch-method}
\alias{intensity,AffyBatch-method}
\alias{pmindex,AffyBatch-method}
\alias{mmindex,AffyBatch-method}
\alias{probeset,AffyBatch-method}
\alias{boxplot,AffyBatch-method}
\alias{nrow,AffyBatch-method}
\alias{ncol,AffyBatch-method}
\alias{show,AffyBatch-method}
\alias{pm,AffyBatch-method}
\alias{pm<-,AffyBatch,ANY-method}
\alias{mm,AffyBatch-method}
\alias{mm<-,AffyBatch,ANY-method}
\alias{probeNames,AffyBatch-method}
\alias{hist,AffyBatch-method}
\alias{[<-,AffyBatch-method}
\alias{[,AffyBatch-method}
\alias{[[,AffyBatch-method}
\alias{length,AffyBatch-method}
\alias{bg.correct,AffyBatch,character-method}
\alias{indexProbes,AffyBatch,character-method}
\alias{computeExprSet,AffyBatch,character,character-method}
\alias{cdfName,AffyBatch-method}
\title{Class AffyBatch}
\description{This is a class representation for Affymetrix GeneChip probe
  level data. The main component are the intensities from multiple
  arrays of the same \code{CDF} type. In extends \code{\link[Biobase]{exprSet-class}}.}
\section{Objects from the Class}{
  Objects can be created using the function \code{\link{read.affybatch}}
  or the wrapper \code{\link{ReadAffy}}.}
\section{Slots}{
  \describe{
    \item{\code{cdfName}:}{Object of class \code{"character"} representing the name of
      \code{CDF} file associated with the arrays in the \code{AffyBatch}.}
    \item{\code{nrow}:}{Object of class \code{"numeric"} representing
      the physical number of rows in the arrays.}
    \item{\code{ncol}:}{Object of class \code{"numeric"} representing
      the physical number of columns in the arrays.}
    \item{\code{exprs}:}{Object of class "matrix" inherited from
      \code{exprSet}. The matrix contains one probe per row and one chip
    per column.}
    \item{\code{se.exprs}:}{Object of class "matrix" inherited from \code{exprSet}.}
    \item{\code{phenoData}:}{Object of class "phenoData" inherited from
      \code{exprSet}.}
    \item{\code{annotation}}{A character string identifying the
      annotation that may be used for the \code{exprSet} instance.}
    \item{\code{description}:}{Object of class "MIAME". For
      compatibility with previous version of this class description can
      also be a "character". The class \code{characterOrMIAME} has been
      defined just for this.} 
    \item{\code{notes}:}{Object of class "character" Vector of
      explanatory text }
  }
}
\section{Extends}{
Class \code{"exprSet"}, directly.
}
\section{Methods}{
  \describe{
    \item{cdfName}{\code{signature(object = "AffyBatch")}: Obtains the
      cdfName slot.}
    \item{pm<-}{\code{signature(object = "AffyBatch")}: replaces the
      perfect match intensities }
    \item{pm}{\code{signature(object = "AffyBatch")}: extracts the pm intensities. }
    \item{mm<-}{\code{signature(object = "AffyBatch")}: replaces the
      mismatch intensities.}
    \item{mm}{\code{signature(object = "AffyBatch")}: extracts the mm intensities. }
    \item{probes}{\code{signature(object = "AffyBatch", which)}: extract the
      perfect match or mismatch probe intensities. Uses which can be "pm"
    and "mm".}
    \item{[<-}{\code{signature(x = "AffyBatch")}: replaces subsets. }
    \item{[}{\code{signature(x = "AffyBatch")}: subsets by array.}
    \item{[[}{\code{signature(x = "AffyBatch")}: extracts each array as
      an \code{\link[affy:Cel-class]{Cel}} instance.}
    \item{boxplot}{\code{signature(x = "AffyBatch")}:  creates a
      \code{\link{boxplot}s of log base 2 intensities. }
      \item{hist}{\code{signature(x = "AffyBatch")}:  creates a
       plot showing all the histograms of the pm,mm or both data. See
       \code{\link{plot.density}}}
     \item{computeExprSet}{\code{signature(x = "AffyBatch",
	summary.method = "character")}: For each probe set computes an
      expression value using \code{summary.method}. }
    \item{geneNames}{\code{signature(object = "AffyBatch")}: return the
      probe set names also referred to as the Affymetrix IDs. Notice
      that one can not assign geneNames. You must do this by changing
      the cdfenvs.}
    \item{getCdfInfo}{\code{signature(object = "AffyBatch")}: retrieve
      the environment that defines the location of probes by probe set. }
    \item{image}{\code{signature(x = "AffyBatch")}: creates an image for
      each sample.}
    \item{indexProbes}{\code{signature(object = "AffyBatch", which =
	"character")}: returns a list with locations of the probes in
      each probe set. The affyID corresponding to the probe set to
      retrieve can be specified in an optional parameter
      \code{genenames}. By default, all the affyIDs are retrieved.
      The names of the elements in the list returned are the affyIDs.
      \code{which} can be "pm", "mm", or "both". If "both" then
      perfect match locations are given followed by mismatch locations.} 
    \item{intensity<-}{\code{signature(object = "AffyBatch")}: a
      replacement method for the \code{exprs} slot, i.e. the intensities. }
    \item{intensity}{\code{signature(object = "AffyBatch")}: extract the
      \code{exprs} slot, i.e. the intensities. }
    \item{length}{\code{signature(x = "AffyBatch")}: returns the number
      of samples. }
    \item{pmindex}{\code{signature(object = "AffyBatch")}: return the
      location of perfect matches in the intensity matrix.}
    \item{mmindex}{\code{signature(object = "AffyBatch")}: return the
      location of the mismatch intensities. }
    \item{ncol}{\code{signature(x = "AffyBatch")}: An accessor function
      for \code{ncol}.}
    \item{nrow}{\code{signature(x = "AffyBatch")}: an accessor function
      for \code{nrow}}.}
    \item{normalize}{\code{signature(object = "AffyBatch")}: a method to
      \code{\link{normalize}}. The method accepts an argument
      \code{method}. The default methods is specified in package options
      (see the main vignette).
    }
    \item{normalize.methods}{\code{signature(object = "AffyBatch")}:
      returns the normalization methods defined for this class. See \code{\link{normalize}}.}
    \item{probeNames}{\code{signature(object = "AffyBatch")}: returns
      the probe set associated with each row of the intensity matrix. }
    \item{probeset}{\code{signature(object = "AffyBatch",genenames=NULL,
	locations=NULL)}: Extracts \code{\link[affy:ProbeSet-class]{ProbeSet}} objects related to
      the probe sets given in genenames. If an alternative set of
      locations defining pms and mms a list with those locations should
      be passed via the \code{locations} argument.}
    \item{bg.correct}{\code{signature(object = "AffyBatch",
	method="character")}} applies background correction methods
    defined by method.
  }
}
\note{This class is better described in the vignette.}
\seealso{  related methods \code{\link{merge.AffyBatch}},
  \code{\link{split.AffyBatch}} and \code{\link{pairs.AffyBatch}}, and related classes \code{\link[affy:Cel-class]{Cel}},
  \code{\link[affy:Cdf-class]{Cdf}} and 
  \code{\link[Biobase]{exprSet-class}}} 

\examples{
## load example
data(affybatch.example)

## nice print
print(affybatch.example)

pm(affybatch.example)[1:5,]
mm(affybatch.example)[1:5,]

## get indexes for the PM probes for the affyID "A28102_at" 
mypmindex <- pmindex(affybatch.example,"A28102_at")
## same operation using the primitive
mypmindex <- indexProbes(affybatch.example, which="pm", genenames="A28102_at")[[1]]
## get the probe intensities from the index
intensity(affybatch.example)[mypmindex, ]

## load bigger example (try 'help(Dilution)' )
data(affybatch.example)
description(affybatch.example) ##we can also use the methods of exprSet
sampleNames(affybatch.example)
abstract(affybatch.example)
}

\keyword{classes}

\eof
\name{AffyRNAdeg}
\alias{AffyRNAdeg}
\alias{summaryAffyRNAdeg}
\alias{plotAffyRNAdeg}
\title{Function to assess RNA degradation in Affymetrix GeneChip data. }
\description{
  Uses ordered probes in probeset to detect possible RNA degradation.
  Plots and statistics used for evaluation.
}
\usage{
AffyRNAdeg(abatch,log.it=TRUE)
summaryAffyRNAdeg(rna.deg.obj,signif.digits=3)
plotAffyRNAdeg(rna.deg.obj, transform = "shift.scale", cols = NULL,
                 ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{abatch}{An object of class \code{\link{AffyBatch-class}}.}
  \item{log.it}{A logical argument: If log.it=T, then probe data is log2 tranformed}
  \item{rna.deg.obj}{Output from AffyRNAdeg}
  \item{signif.digits}{Number of significant digits to show.}
  \item{transform}{Possible choices are "shift.scale","shift.only", and "neither".  "Shift" vertically staggers the plots for individual chips, to make the display easier to read. "Scale" normalizes so that standard deviation is equal to 1.    }
  \item{cols}{A vector of colors for plot, length = number of chips}
  \item{...}{further arguments for \code{\link{plot}} function.}
}
\details{Within each probeset, probes are numbered directionally from
  the 5' end to the 3' end. Probe intensities are averaged by probe
  number, across all genes.   If log.it=\code{FALSE} and
  transform="Neither", then 
  plotAffyRNAdeg  simply shows these means for each chip.  Shifted and
  scaled versions of the plot can make it easier to see.   
 
}
\value{
  \code{AffyRNAdeg} returns a list with the following components:
  \item{sample.names }{names of samples, derived from affy batch object}
  \item{means.by.number}{average intensity by probe position}
  \item{ses}{standard errors for probe position averages}
  \item{slope}{from linear regression of means.by.number}
  \item{pvalue}{from linear regression of means.by.number}
}
\examples{
data(affybatch.example)
RNAdeg<-AffyRNAdeg(affybatch.example)
plotAffyRNAdeg(RNAdeg)

}
\author{ Leslie Cope }
\keyword{hplot}% at least one, from doc/KEYWORDS
\keyword{manip}% at least one, from doc/KEYWORDS

\eof
\name{MAplot}
\alias{ma.plot}
\alias{Mbox}
\alias{MAplot}
\alias{Mbox,AffyBatch-method}
\alias{MAplot,AffyBatch-method}

\title{Relative M vs. A plots}
\description{
  Create boxplots of M or M vs A plots. Where M is determined relative
  to a specified chip or to a pseudo-median reference chip.
}
\usage{
MAplot(object,...)
Mbox(object,...)
ma.plot(A,M,subset=sample(1:length(M),min(c(10000, length(M)))),show.statistics=TRUE,span=2/3,family.loess="gaussian",cex=2,...)
}

\arguments{
  \item{object}{An \code{\link{AffyBatch-class}}}
  \item{...}{Additional parameters for the routine}
  \item{A}{A vector to plot along the horizonal axis}
  \item{M}{A vector to plot along vertical axis}
  \item{subset}{A set of indices to use when drawing the loess curve}
  \item{show.statistics}{If true some summary statistics of the M values
    are drawn}
  \item{span}{span to be used for loess fit.}
  \item{family.loess}{\code{"guassian"} or \code{"symmetric"} as in
    \code{\link[modreg]{loess}}.}
  \item{cex}{Size of text when writing summary statistics on plot}
  }
\examples{
   data(affybatch.example)
   MAplot(affybatch.example)
   Mbox(affybatch.example)
}

\seealso{\code{\link{mva.pairs}}}
\keyword{hplot}

\eof
\name{ProbeSet-class}
\docType{class}
\alias{ProbeSet-class}
\alias{mm,ProbeSet-method}
\alias{mm<-,ProbeSet,matrix-method}
\alias{pm<-,ProbeSet,matrix-method}
\alias{pm,ProbeSet-method}
\alias{show,ProbeSet-method}
\alias{barplot,ProbeSet-method}
\alias{colnames,ProbeSet-method}
\alias{express.summary.stat,ProbeSet,character,character-method}
\alias{sampleNames,ProbeSet-method}


\title{Class ProbeSet}
\description{A simple class that contains the PM and MM data for a probe
  set from one or more samples} }
\section{Objects from the Class}{
Objects can be created by applying the method \code{\link{probeset}} to
instances of AffyBatch.}
\section{Slots}{
  \describe{
    \item{\code{id}:}{Object of class \code{"character"} containing the
      probeset ID}
    \item{\code{pm}:}{Object of class \code{"matrix"} containing the PM
      intensities. Columns represent samples and rows the different probes.}
    \item{\code{mm}:}{Object of class \code{"matrix"} containing the MM intensities}
  }
}

\section{Methods}{
  \describe{
    \item{colnames}{\code{signature(x = "ProbeSet")}: the column names
      of the \code{pm} matrices which  are the sample names}
    \item{express.summary.stat}{\code{signature(x = "ProbeSet",
	pmcorrect = "character", summary = "character")}: applies a summary statistic to the probe set.}
    \item{sampleNames}{\code{signature(object = "ProbeSet")}: the column names
      of the \code{pm} matrices which  are the sample names}
  }
}
\note{More details are cotained in the vignette}

\seealso{ \code{\link{probeset}}, \code{\link{AffyBatch-class}}}

\examples{
data(affybatch.example)
ps <- probeset(affybatch.example,geneNames(affybatch.example)[1:2])
names(ps)
print(ps[[1]])
}
\keyword{classes}

\eof
\name{ProgressBarText-class}
\docType{class}
\alias{ProgressBarText-class}
\alias{close,ProgressBarText-method}
\alias{initialize,ProgressBarText-method}
\alias{open,ProgressBarText-method}
\alias{update,ProgressBarText-method}

\title{Class "ProgressBarText" }
\description{ A class to handle progress bars in text mode}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("ProgressBarText", steps)}.
}
\section{Slots}{
  \describe{
    \item{\code{steps}:}{Object of class \code{"integer"}. The total number of
      steps the progress bar should represent}
    \item{\code{barsteps}:}{Object of class \code{"integer"}. The size
      of the progress bar.}
    \item{\code{internals}:}{Object of class \code{"environment"}. For internal use.}
  }
}
\section{Methods}{
  \describe{
    \item{close}{\code{signature(con = "ProgressBarText")}: Terminate
      the progress bar (i.e. print what needs to be printed). Note that
      closing the instance will ensure the progress bar is plotted to
      its end.}
    \item{initialize}{\code{signature(.Object = "ProgressBarText")}:
      initialize a instance.}
    \item{open}{\code{signature(con = "ProgressBarText")}: Open a
      progress bar (i.e. print things). In the case open is called on
      a progress bar that was 'progress', the progress bar is resumed
      (this might be useful when one wishes to insert text output while
      there is a progress bar running).}
    \item{update}{\code{signature(object = "ProgressBarText")}: Update
      the progress bar (see examples).}
  }
}
\author{ Laurent }
\examples{
f <- function(x, header = TRUE) {
  pbt <- new("ProgressBarText", length(x), barsteps = as.integer(20))

  open(pbt, header = header)

  for (i in x) {
    Sys.sleep(i)
    update(pbt)
  }
  close(pbt)
}

## if too fast on your machine, change the number
x <- runif(15)

f(x)
f(x, header = FALSE)

## 'cost' of the progress bar:
g <- function(x) {
  z <- 1
  for (i in 1:x) {
    z <- z + 1
  }
}
h <- function(x) {
  pbt <- new("ProgressBarText", as.integer(x), barsteps = as.integer(20))
  open(pbt)
  for (i in 1:x) {
    update(pbt)
  }
  close(pbt)
}

system.time(g(10000))
system.time(h(10000))

}
\keyword{classes}

\eof
\name{SpikeIn}
\alias{SpikeIn}
\alias{concentrations}
\title{SpikeIn Experiment Data: ProbeSet Example}
\description{
This \code{\link[affy:ProbeSet-class]{ProbeSet}} represents part of SpikeIn experiment
data set. 
}
\usage{data(SpikeIn)}
\format{\code{SpikeIn} is \code{\link[affy:ProbeSet-class]{ProbeSet}} containing the
  $PM$ and $MM$ intensities for a gene spiked in at different
  concentrations (given in the vector \code{colnames(pm(SpikeIn))}) in 12
  different arrays.}
\source{This comes from an experiments where 11 different cRNA
fragments have been added to the hybridization mixture of the GeneChip
arrays at different pM concentrations.  The 11 control cRNAs were BioB-5,
BioB-M, BioB-3, BioC-5, BioC-3, BioDn-5 (all {\it E. coli}), CreX-5, CreX-3
(phage P1), and  DapX-5, DapX-M, DapX-3 ({\it B. subtilis})
The cRNA were chosen to match the target sequence for each of the
Affymetrix control probe sets. For example, for DapX (a {\it B. subtilis}
gene), the 5', middle and 3' target sequences (identified by DapX-5,
DapX-M, DapX-3) were each synthesized separately and spiked-in at a
specific concentration. Thus, for example, DapX-3 target sequence may be
added to the total hybridization solution of 200 $\mu$l to give a final
concentration of 0.5 pM.

For this example we have the $PM$ and $MM$ for BioB-5
obtained from the arrays where it was spiked in at
0.0, 0.5, 0.75, 1, 1.5, 2, 3, 5, 12.5, 25, 50, and 150
pM.

For more information see Irizarry, R.A., et al. (2001)
\url{http://biosun01.biostat.jhsph.edu/~ririzarr/papers/index.html}}

\keyword{datasets}

\eof
\name{affy-options}
\alias{affy-options}
\title{Options for the affy package}
\description{
  Description of the options for the affy package.
}
\note{
  The affy package options are contained in the Bioconductor options.
  The options are:
  \begin{itemize}
  \item \code{use.widgets}: a logical used to decide on the default of
  widget use.
  \item \code{compress.cel}: a logical
  \item \code{compress.cdf}: a logical
  \item \code{probes.loc}: a list. Each element of the list is it self a
  list with two elements {\it what} and {\it where}. When looking for
  the informations about the locations of the probes on the array, the
  elements in the list will be looked at one after the other. The first
  one for which {\it what} and {\it where} lead to the matching
  locations information is used. The element {\it what} can be one of
  {\it package}, {\it environment} or {\it file}. The element {\it where}
  depends on the corresponding element {\it what}.
  \begin{itemize}
  \item if {\it package}: location for the package (like it would be for
  the argument \code{lib.loc} for the function \code{library}.
  \item if {\it environment}: an \code{environment} to look for the
  information
  (like the argument \code{env} for the function \code{get}).
  \item if {\it file}: a \code{character} with the path in which a CDF
  file can be found.
  \end{itemize}
  \end{itemize}
}
\examples{
## get the options
opt <- getOption("BioC")
affy.opt <- opt$affy

## list their names
names(affy.opt)

## set the option compress.cel
affy.opt$compress.cel <- TRUE
options(BioC=opt)
}
\keyword{manip}

\eof
%%%THIS FUNCTION SHOULD BE In BIOBASE or SOMEWHERE ELSE... NEXT RELEASE
%% LG: In such a case, I assume the long awaited agreement about
%% normalization methods will be here and all the normalization methods
%% will be stored together
\name{affy.scalevalue.exprSet}
\alias{affy.scalevalue.exprSet}
\title{Scale normalization for expreSets}
\description{
  Normalizes expression values using the method described in the
  Affymetrix user manual.
}
\usage{
affy.scalevalue.exprSet(eset, sc = 500, analysis="absolute")
}
\arguments{
  \item{eset}{An \code{\link[affy:exprSet-class]{exprSet}} object.}
  \item{sc}{Value at which all arrays will be scaled to.}
  \item{analysis}{should we do absolute or comparison analysis, although
  "comparison" is still not implemented.}
}
\details{
  This is function was implemented from the Affymetrix technical
  documentation for MAS 5.0. It can be downloaded from the website of
  the company. Please refer to this document for details.
}
\author{Laurent}
\value{
  A normalized \code{\link[Biobase]{exprSet}}}
\keyword{manip}


\eof
\name{affybatch.example}
\docType{instance}
\alias{affybatch.example}
\title{AffyBatch instance affybatch.example}
\description{
  This is an artifical data set. It shows values subset from the
  Dilution dataset to make 100x100 chips.
}
%\usage{data(affybatch.example)}
\format{An \code{\link[affy:AffyBatch-class]{AffyBatch}} of three samples.}
\code{\link{cdfenv.example}}}
\seealso{\code{\link[affydata]{Dilution}},\code{\link{cdfenv.example}}
}
\keyword{methods}




\eof
\name{barplot.ProbeSet}
\alias{barplot.ProbeSet}
\title{show a ProbeSet as barplots}
\description{
  displays the probe intensities in a ProbeSet as a barplots
}
\usage{
barplot.ProbeSet(height, xlab = "Probe pair", ylab = "Intensity", main =
NA, col.pm = "red", col.mm = "blue", beside = TRUE, names.arg = "pp",
ask = TRUE, scale, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{height}{an object of class \code{ProbeSet} }
  \item{xlab}{ label for x axis }
  \item{ylab}{ label for y axis }
  \item{main}{ main label for the figure }
  \item{col.pm}{ color for the `pm' intensities }
  \item{col.mm}{ color for the `mm' intensities }
  \item{beside}{ bars beside eachothers or not }
  \item{names.arg}{  }
  \item{ask}{ ask before ploting the next barplot }
  \item{scale}{ put all the barplot to the same scale }
  \item{\dots}{ extra parameters to be passed to \code{\link{barplot}} }
}
\details{
  
}
\examples{
data(affybatch.example)
gn <- geneNames(affybatch.example)
pps <- probeset(affybatch.example, gn[1])[[1]]

barplot.ProbeSet(pps)
}
\keyword{hplot}


\eof
\name{bg.adjust}
\alias{bg.adjust}
\alias{bg.parameters}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Background ajustment (internal function)}
\description{
An internal function to be used by \code{\link{bg.correct.rma}}.
}
\usage{
bg.adjust(pm, n.pts = 2^14, ...)
bg.parameters(pm, n.pts = 2^14)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{pm}{a pm matrix}
  \item{n.pts}{number of points to use in call to \code{density}.}
  \item{...}{extra arguments to pass to bg.adjust.}
}
\details{Assumes PMs are a convolution of normal and exponentional. So we
  observe X+Y where X is backround and Y is signal. \code{bg.adjust}
    returns E[Y|X+Y, Y>0] as our backround corrected
    PM. \code{bg.parameters} provides adhoc estimates of the parameters
    of the normal and exponential distributions.}
\value{a matrix}
\seealso{\code{\link{bg.correct.rma}}}

\keyword{manip}% at least one, from doc/KEYWORDS





\eof
\name{bg.correct}
\alias{bg.correct}
\alias{bg.correct-methods}
\alias{bg.correct.methods}
\alias{bgcorrect.methods}
\alias{bg.correct.none} %took out .pmonly casue rma is pm-only
%\alias{bg.correct.subtractmm}
\alias{bg.correct.rma}
\alias{bg.correct.rma2}
\alias{bg.correct.mas}
\title{Background Correction}
\description{
Background corrects probe intensities in an object of class
\code{\link[affy:AffyBatch-class]{AffyBatch}}.
}
\usage{
bg.correct(object, method, ...)

bg.correct.rma(object,...)
bg.correct.mas(object, griddim)
bg.correct.none(object, ...)
}

\arguments{
  \item{object}{An object of class \code{\link[affy:AffyBatch-class]{AffyBatch}}.}
  \item{method}{A \code{character} that defines what background
    correction method will be used. Available methods are given by
    \code{bg.correct.methods}. }  
  \item{griddim}{grid dimension used for mas background estimate. The array
    is divided into griddm equal parts. Default is 16.}
  \item{...}{arguments to pass along to the engine function.}
}
\details{
  The name of the method to apply must be double-quoted.
  Methods provided with the package are currently:
  \begin{itemize}
  \item bg.correct.none: returns \code{object} unchanged.
  \item bg.correct.chipwide: noise correction as described in a
  `white paper' from Affymetrix.
  \item bg.correct.rma: the model based correction used by the RMA
  expression measure.
  \end{itemize}

  They are listed in the variable \code{bg.correct.methods}. The user must
  supply the word after "bg.correct", i.e none, subtractmm, rma, etc...

  More details are available in the vignette.

  \code{bg.correct.rma2} gives access to the older background method
  that was used by the \code{\link{rma}} function in version 1.1
  bioconductor releases. For the 1.2 release \code{\link{rma}} performs
  the same background adjustment as \code{bg.correct.rma}. Unless you
  wish to duplicate older results in which case
  you should use \code{bg.correct.rma}.
  
  Details on the internal fucntions used by \code{bg.correct.rma} are in
  \code{\link{bg.adjust}}.
  
}  
\value{
  An \code{\link[affy:AffyBatch-class]{AffyBatch}} for which the
  intensities have been background adjusted.
  For some methods (RMA), only PMs are corrected and the MMs remain the
  same. 
}

\examples{
    data(affybatch.example)

    ##bgc will be the bg corrected version of affybatch.example 
    bgc <- bg.correct(affybatch.example,method="rma") 

    ##This plot shows the tranformation
    plot(pm(affybatch.example)[,1],pm(bgc)[,1],log="xy",
	main="PMs before and after background correction")

}
\keyword{manip}









\eof
\name{cdfFromBioC}
\alias{cdfFromBioC}
\alias{cdfFromData}
\alias{cdfFromLibPath}
\alias{cdfFromEnvironment}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{Functions to obtain CDF files}
\description{
  A set of functions to obtain CDF files from various locations.
}
\usage{
cdfFromBioC(cdfname, lib = .libPaths()[1], verbose = TRUE)
cdfFromData(cdfname, pkg, verbose=TRUE)
cdfFromLibPath(cdfname, lib = NULL, verbose=TRUE)
cdfFromEnvironment(cdfname, where, verbose=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{cdfname}{ The CDF desired }
  \item{lib}{ Directory to install the CDF package to }
  \item{pkg}{What package to search}
  \item{where}{What environment to search}
  \item{verbose}{Controls extra output}  
}
\details{
  These functions all take a requested CDF environment name and will
  attempt to locate that environment in the appropriate location (a
  package's data directory, as a CDF package in the .libPaths(), from a
  loaded environment or on the Bioconductor website.  If the environment
  can not be found, it will return a list of the methods tried that failed.
}
\value{
  The CDF environment or a list detailing the failed locations.
}
\author{Jeff Gentry}
\examples{
}
\keyword{utilities}

\eof
\name{cdfenv.example}
\alias{cdfenv.example}
\title{Example cdfenv}
\description{
  Example cdfenv
  (environment containing the probe locations).
}
\usage{data(cdfenv.example)}
\format{An \code{\link[affy:AffyBatch-class]{AffyBatch}} object
  \code{affybatch.example} containing experimental data and an
  \code{\link{environment}} \code{cdfenv.example} containing the probe
  locations}
\source{Affymetrix CDF file for the array Hu6800}
\seealso{affybatch.example}
\keyword{datasets}

\eof
\name{cleancdfname}
\alias{cleancdfname}
\alias{mapCdfName}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Clean Affymetrix's CDF name}
\description{
This function converts Affymetrix's names for CDF files to the names
used in the annotation pacakge and in all Bioconductor.
}
\usage{
cleancdfname(cdfname, addcdf = TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{cdfname}{A \code{character} denoting Affymetrix'x CDF file name }
  \item{addcdf}{A \code{logical}. If \code{TRUE} it adds the string
    "cdf" at the end of the cleaned CDF name. This is used to name the
    \code{cdfenvs} packages.}
}
\details{
  This function takes a CDF filename obtained from an Affymetrix file
  (from a CEL file for example) and
  convert it to a convention of ours: all small caps
  and only alphanumeric characters. The details of the rule can be seen
  in the code.
  We observed exceptions that made us create a set of special cases for
  mapping CEL to CDF. The object \code{mapCdfName} holds information
  about these cases. It is a
  \code{data.frame} of three elements: the 
  first is the name as found in the CDF file, the second the name in the
  CEL file and the third the name in bioconductor. \code{mapCdfName} can
  bne loaded using \code{data(mapCdfName)}.
}
\value{
A \code{character}
}

\examples{
cdf.tags <- c("HG_U95Av2", "HG-133A")
for (i in cdf.tags)
  cat(i, "becomes", cleancdfname(i), "\n")
}
\keyword{character}% at least one, from doc/KEYWORDS


\eof
\name{debug.affy123}
\docType{instance}
\alias{debug.affy123}
\title{Debugging Flag}
\description{
For developmental use only
}
\keyword{methods}




\eof
\name{expresso}
\alias{expresso}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{ From raw probe intensities to expression values }
\description{
  Goes from raw probe intensities to expression values
}
\usage{
expresso(
        afbatch,
    # background correction
        bg.correct = TRUE,
        bgcorrect.method = NULL,
        bgcorrect.param = list(),
    # normalize
        normalize = TRUE,
        normalize.method = NULL,
        normalize.param = list(),
    # pm correction
        pmcorrect.method = NULL,
        pmcorrect.param = list(),
    # expression values
        summary.method = NULL,
        summary.param = list(),
        summary.subset = NULL,
    # misc.
        verbose = TRUE,
%        warnings = TRUE,
        widget = FALSE)
}

\arguments{
  \item{afbatch}{ An \code{\link[affy:AffyBatch-class]{AffyBatch}} object }
  \item{bg.correct}{a boolean to express whether background correction
    is wanted or not.}
  \item{bgcorrect.method}{the name of the background adjustment method}
  \item{bgcorrect.param}{a list of parameters for bgcorrect.method (if needed/wanted)}
  \item{normalize}{ normalization step wished or not.}
  \item{normalize.method}{the normalization method to use}
  \item{normalize.param}{a list of parameters to be passed to the
    normalization method (if wanted).}
  \item{pmcorrect.method}{the name of the PM adjustement method}
  \item{pmcorrect.param}{a list of parameters for pmcorrect.method (if needed/wanted)}
  \item{summary.method}{the method used for the computation of expression values}
  \item{summary.param}{ a list of parameters to be passed to the
    \code{summary.method} (if wanted).}
  \item{summary.subset}{a list of 'affyids'. If \code{NULL}, a
    expression summary value is computed for everything on the chip.}
  \item{verbose}{logical value. If \code{TRUE} it writes out some
    messages.}
%  \item{warnings}{warning when something goes wrong}
  \item{widget}{a boolean to specify the use of widgets (the package
    tkWidget is required).}
}
\details{
    Some arguments can be left to \code{NULL} if the \code{widget=TRUE}.
  In this case, a widget pops up and let the user choose with the mouse.
  The arguments are: \code{AffyBatch},
  \code{bgcorrect.method}, \code{normalize.method}, \code{pmcorrect.method} and \code{summary.method}.

  For the mas 5.0 and 4.0 methods ones need to normalize after obtaining
  expression. The function \code{\link{affy.scalevalue.exprSet}} does this.

  For the Li and Wong summary method notice you will not get
  the same results as you would get with dChip. dChip is not open source
  so it is not easy to reproduce. 
  Notice also that this iterative algorithm will not always converge.
  If you run the algorithm on thousands of probes expect some non-convergence
  warnings. These are more likely when few arrays are used. We recommend
  using this method only if you have 10 or more arrays.
  Please refer to the \code{\link{fit.li.wong}} help page for more details.

}
\value{
  An object of class \code{\link[Biobase]{exprsSet}}, with an attribute
  \code{pps.warnings} as returned by the method \code{\link{computeExprSet}}.
}
\seealso{\code{\link[affy:AffyBatch-class]{AffyBatch}}}
\examples{
data(affybatch.example)

eset <- expresso(affybatch.example, bgcorrect.method="rma",
                 normalize.method="constant",pmcorrect.method="pmonly",
                 summary.method="avgdiff")
}
\keyword{ manip }


\eof
\name{expressoWidget}
\alias{expressoWidget}
\title{A widget for users to pick correction methods}
\description{
  This widget is called by expresso to allow users to select
  correction methods that will be used to process affy data.
}
\usage{
expressoWidget(BGMethods, normMethods, PMMethods, expMethods, BGDefault,
normDefault, PMDefault, expDefault) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{BGMethods}{\code{BGMethods} a vector of character strings for
    the available methods that can be used as a background correction
    method of affy data}
  \item{normMethods}{\code{normMethods} a vector of character strings for
    the available methods that can be used as a normalization method of
    affy data}
  \item{PMMethods}{\code{PMMethods} a vector of character strings for
    the available methods that can be used as a PM correction method of
    affy data}
  \item{expMethods}{\code{expMethods}a vector of character strings for
    the available methods that can be used as a summary method of affy data}
  \item{BGDefault}{\code{BGDefault} a character string for the name of a
    default background correction method}
  \item{normDefault}{\code{normDefault} a character string for the name
    of a default normalization method}
  \item{PMDefault}{\code{PMDefault} a character string for the name of a
    default PM correction method}
  \item{expDefault}{\code{expDefault} a character string for the name of
    a default summary method}
}
\details{
  The widget will be invoked when expresso is called with argument
  "widget" set to TRUE. Default values can be changed using the drop
  down list boxes. Double clicking on an option from the dropdown list
  makes an selection. The first element of the list for available methods
  will be the default method if no default is provided.
}
\value{
  The widget returns a list of selected correction methods.
  \item{BG}{background correction method}
  \item{NORM}{normalization method}
  \item{PM}{PM correction method}
  \item{EXP}{summary method}
}
\references{Documentations of affy package}
\author{Jianhua Zhang}
\note{The functions are part of the Bioconductor project at Dana-Farber
  Cancer Institute to provide Bioinformatic functionalities through R}

\seealso{\code{\link{expresso}}}
\examples{
if(interactive()){
  require(widgetTools)
  expressoWidget(c("mas", "none", "rma"), c("constant", "quantiles"),
c("mas", "pmonly"), c("liwong", "playerout"))
}
}
\keyword{interface}

\eof
\name{fit.li.wong}
\alias{fit.li.wong}
\alias{li.wong}

\title{Fit Li and Wong Model to a Probe Set}
\description{Fits the model described in Li and Wong (2001) to a probe
  set with I chips and J probes.}
}
\usage{
fit.li.wong(data.matrix, remove.outliers=TRUE, normal.array.quantile=0.5,
            normal.resid.quantile=0.9, large.threshold=3, large.variation=0.8,
            outlier.fraction=0.14, delta=1e-06, maxit=50,
            outer.maxit=50,verbose=FALSE, ...)

li.wong(data.matrix,remove.outliers=TRUE, normal.array.quantile=0.5,
            normal.resid.quantile=0.9, large.threshold=3, large.variation=0.8,
            outlier.fraction=0.14, delta=1e-06, maxit=50,
            outer.maxit=50,verbose=FALSE)

}
\arguments{
  \item{data.matrix}{an I x J matrix containing the probe set
    data. Typically the i,j entry will contain the PM-MM value for probe
    pair j in chip i. Another possible use, is to use PM instead of PM-MM.}
  \item{remove.outliers}{logical value indicating if the algorithm
    will remove outliers according to the procedure described in Li and
    Wong (2001).}
  \item{large.threshold}{used to define outliers.}
  \item{normal.array.quantile}{quantile to be used when determining what
    a normal SD is. probes or chips having estimates with SDs bigger
    than the quantile \code{normal.array.quantile} of all SDs x
    \code{large.threshold} }
  \item{normal.resid.quantile}{any residual  bigger than the
    \code{normal.resid.quantile} quantile of all residuals x
    \code{large.threshold} is considered an outlier}
  \item{large.variation}{any probe or chip describing more than this
    much total variation is considered an outlier}
  \item{outlier.fraction}{this is the maximum fraction of single
    outliers that can be in the same probe or chip.}
  \item{delta}{ numerical value used to define the stopping
    criterion. }
  \item{maxit}{ maximum number of iterations when fitting the model.}
  \item{outer.maxit}{ maximum number of iterations of defined outliers.}
  \item{verbose}{logical value. If \code{TRUE} information is given of
    the status of the algorithm.}
  \item{...}{       }
}
\details{
  This is Bioconductor's implementation of the Li and Wong algorithm. The
  Li and Wong PNAS 2001 paper was followed. However, you will not get
  the same results as you would get with dChip. dChip is not open source
  so it is not easy to reproduce. 

  Notice that this iterative algorithm will not always converge.
  If you run the
  algorithm on thousands of probes expect some non-convergence
  warnings. These are more likely when few arrays are used. We recommend
  using this method only if you have 10 or more arrays.

  Please refer to references for more details.
}

\value{\code{li.wong} returns a vector of expression measures (or column
  effects) followed by their respective standard error estimates. It
  was designed to work with \code{express} which is no longer part of
  the package.

  \code{fit.li.wong} returns much more. Namely, a list containing the
  fitted parameters and relevant information. 
  \item{theta}{fitted thetas.}
  \item{phi}{fitted phis.}
  \item{sigma.eps}{estimated standard deviation of the error term.}
  \item{sigma.theta}{estimated standard error of theta.}
  \item{sigma.phi}{estimated standard error of phis.}
  \item{theta.outliers}{logical vector describing which chips (thetas) are considered
    outliers (\code{TRUE}).}
  \item{phi.outliers}{logical vector describing which probe sets (phis) are
    considered outliers (\code{TRUE})}
  \item{convergence1}{logical value. If \code{FALSE} the algorithm did
    not converge when fitting the phis and thetas.}
  \item{convergence2}{logical value. If \code{FALSE} the algorithm did
    not converge in deciding what are outliers.}
  \item{iter}{number of iterations needed to achieve convergence.}
  \item{delta}{difference between thetas when iteration stopped.}
}
\examples{

    x <- sweep(matrix(2^rnorm(600),30,20),1,seq(1,2,len=30),FUN="+")
    fit1 <- fit.li.wong(x)
    plot(x[1,])
    lines(fit1$theta)
  }
\references{
  Li, C. and Wong, W.H. (2001) \emph{Genome Biology} \bold{2}, 1--11.\cr

  Li, C. and Wong, W.H. (2001) \emph{Proc. Natl. Acad. Sci USA}
  \bold{98}, 31--36.
}
\author{Rafael A. Irizarry, Cheng Li, Fred A. Wright, Ben Bolstad}
\seealso{ \code{\link{li.wong}}, \code{\link{expresso}}}
\keyword{manip}
\keyword{models}



\eof
\name{generateExprSet-method}
\docType{methods}
\alias{generateExprSet-methods}
\alias{computeExprSet}
\alias{generateExprSet.methods}

\title{generate a set of expression values}
\description{
  Generate a set of expression values from the probe pair
  information. The set of expression is returned as an exprSet object.
}
\usage{
  computeExprSet(x, pmcorrect.method, summary.method, ...)

  generateExprSet.methods
}
\arguments{
  \item{x}{a \code{\link[affy:AffyBatch-class]{AffyBatch}} holding the probe level
    informations to generate the expression values.}
  \item{pmcorrect.method}{the method used to correct PM values (see
    section 'details').}
  \item{summary.method}{the method used to generate the expression value (see
    section 'details').}
  \item{...}{any of the options of the normalization you would like to modify}
}
\details{
  An extra argument \code{ids=} can be passed. It must be a vector of
  affids. The expression values will only be computed and returned for
  these affyids.
  
  The different methods available through this mecanism can be accessed
  by calling the method \code{generateExprSet.methods} with an object of
  call \code{Cel.container} as an argument.

  In the Affymetrix design, \emph{MM} probes were included to measure
  the noise (or background signal). The original algorithm for
  background correction was to subtract the \emph{MM} signal to the
  \emph{PM} signal. The methods currently inclluded in the package are
  "bg.correct.subtractmm", "bg.correct.pmonly" and "bg.correct.adjust".

}
\seealso{
  method \code{generateExprSet} of the class
  \code{\link[affy:AffyBatch-class]{AffyBatch}}\cr
  \code{\link{expresso}} 
}
\examples{
 data(affybatch.example)

 ids <- c( "A28102_at","AB000114_at")
  
  eset <- computeExprSet(affybatch.example, pmcorrect.method="pmonly",
summary.method="avgdiff", ids=ids)
}
\keyword{manip}




\eof
\name{generateExprVal}
\alias{generateExprVal}
\alias{generateExprVal-methods}
\alias{generateExprVal.methods}
\alias{express.summary.stat}
\alias{express.summary.stat-methods}
\alias{express.summary.stat.methods}

\title{Compute a summary expression value from the probes intensities}
\description{
  Compute a summary expression value from the probes intensities
}
\usage{
generateExprVal.methods # vector of names of methods

express.summary.stat(x, pmcorrect, summary, ...)
express.summary.stat.methods # vector of names of methods
}
\arguments{
  \item{x}{a (\code{ProbeSet}}
  \item{pmcorrect}{the method used to correct the PM values before
    summarizing to an expression value.}
  \item{summary}{the method used to generate the expression value.}
  \item{...}{other parameters the method might need... (see the
    corresponding methods below...)}
}
\value{
  Returns a vector of expression values.
}
\examples{
data(affybatch.example)

p <- probeset(affybatch.example, "A28102_at")[[1]]

par(mfcol=c(5,2))
mymethods <- express.summary.stat.methods
nmet <- length(mymethods)
nc <- ncol(pm(p))

layout(matrix(c(1:nc, rep(nc+1, nc)), nc, 2), width = c(1, 1))

barplot(p)

results <- matrix(0, nc, nmet)
rownames(results) <- paste("sample", 1:nc)
colnames(results) <- mymethods

for (i in 1:nmet) {
  ev <- express.summary.stat(p, summary=mymethods[i], pmcorrect="pmonly")
  if (mymethods[[i]] != "medianpolish")
    results[, i] <- 2^(ev$exprs)
  else
    results[, i] <- ev$exprs
}

dotchart(results, labels=paste("sample", 1:nc))

}
\keyword{}

\eof
\name{generateExprVal.method.avgdiff}
\alias{generateExprVal.method.avgdiff}
\alias{generateExprVal.method.medianpolish}
\alias{generateExprVal.method.liwong}
\alias{generateExprVal.method.mas}



\title{Generate an expression value from the probes informations}
\description{
  Generate an expression from the probes
}
\usage{
generateExprVal.method.avgdiff(probes, ...)
generateExprVal.method.medianpolish(probes, ...)
generateExprVal.method.liwong(probes, ...)
generateExprVal.method.mas(probes, ...)

}
\arguments{
  \item{probes}{a matrix of probe intesities with rows representing
    probes and columns representing
    samples. Usually \code{pm(probeset)} where \code{probeset} is a
    of class \code{\link[affy:ProbeSet-class]{ProbeSet}}}
  \item{...}{extra arguments to pass to the respective function}
}
\value{
  A list containing entries:
  \item{exprs}{The expression values.}
  \item{se.exprs}{The standard error estimate.}
}
\examples{
  data(SpikeIn) ##SpikeIn is a ProbeSets
  probes <- pm(SpikeIn) 
  avgdiff <- generateExprVal.method.avgdiff(probes)
  medianpolish <- generateExprVal.method.medianpolish(probes)
  liwong <- generateExprVal.method.liwong(probes)
  playerout <- generateExprVal.method.playerout(probes)
  mas <- generateExprVal.method.mas(probes)
  
  concentrations <- as.numeric(sampleNames(SpikeIn))
  plot(concentrations,avgdiff$exprs,log="xy",ylim=c(50,10000),pch="a",type="b")
  points(concentrations,2^medianpolish$exprs,pch="m",col=2,type="b",lty=2)
  points(concentrations,liwong$exprs,pch="l",col=3,type="b",lty=3)
  points(concentrations,playerout$exprs,pch="p",col=4,type="b",lty=4)
  points(concentrations,mas$exprs,pch="p",col=4,type="b",lty=4)

  
}
\seealso{
  \code{\link{generateExprSet-methods},\code{\link{generateExprVal.method.playerout}}, \code{\link{li.wong}}, \code{\link{medianpolish}}}
}
\keyword{manip}

\eof
\name{generateExprVal.method.playerout}
\alias{generateExprVal.method.playerout}
\alias{playerout.costfunction}
\title{Generate an expression value from the probes informations}
\description{
  Generate an expression from the probes
}
\usage{
  generateExprVal.method.playerout(probes, weights=FALSE, optim.method="L-BFGS-B")
}
\arguments{
  \item{probes}{a list of \code{probes} slots from \code{PPSet.container}}
  \item{weights}{Should the resulting weights be returned ?}
  \item{optim.method}{see parameter 'optim' for the function \code{\link{optim}}}
}
\value{
  A vector of expression values.
}
\details{
A non-parametrical method to weight each perfect match
  probe in the set and to compute a weighted mean of the perfect match
  values. One will notice this method only makes use of the perfect
  matches. (see function \code{playerout.costfunction} for the cost function).
}
\author{
  Laurent <laurent@cbs.dtu.dk>\cr
  (Thanks to E. Lazaridris for the original playerout code and the
  discussions about it)
}
\references{
   \item Emmanuel N. Lazaridis, Dominic Sinibaldi, Gregory Bloom, Shrikant Mane and Richard Jove
  A simple method to improve probe set estimates from oligonucleotide
  arrays, Mathematical Biosciences, Volume 176, Issue 1, March 2002, Pages 53-58
}
\keyword{manip}



\eof
\name{hlog}
\alias{hlog}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Hybrid Log}
\description{Given a constant \code{c} this function returns
\code{x} if \code{x} is less than \code{c} and \code{sign(x)*(c*log(abs(x)/c)
  + c)} if its not. Notice this is a continuos odd ( f(-x)=-f(x) )
function with
continous first derivative. The main purpose is to perform log
transformation when 
one has negative numbers, for example for PM-MM.}
\usage{
hlog(x, constant=1)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a number.}
  \item{constant}{the constant c (see description).}
  }
\details{
If \code{constant} is less than or equal to 0 \code{log(x)} is
returned for all \code{x}. If \code{constant} is infinity \code{x} is
returned for all \code{x}. 
}
\author{Rafael A. Irizarry}
\keyword{math}

\eof
\name{justRMA}
\alias{justRMA}
\alias{just.rma}
\title{ Read CEL files into an AffyBatch}
\description{
  Read CEL files and compute an expression measure using affybatch.}
\usage{
just.rma(..., filenames = character(0),
               phenoData = new("phenoData"),
               description = NULL,
               notes = "",
               compress = getOption("BioC")$affy$compress.cel,
               rm.mask = FALSE, rm.outliers = FALSE, rm.extra = FALSE,
               verbose=FALSE, background=TRUE, normalize=TRUE,
               bgversion=2, destructive=FALSE)

justRMA(..., filenames=character(0),
              widget=getOption("BioC")$affy$use.widgets,
              compress=getOption("BioC")$affy$compress.cel,
              celfile.path=getwd(),
              sampleNames=NULL,
              phenoData=NULL,
              description=NULL,
              notes="",
              rm.mask=FALSE, rm.outliers=FALSE, rm.extra=FALSE,
              hdf5=FALSE, hdf5FilePath=NULL,verbose=FALSE,
              normalize=TRUE, background=TRUE, 
              bgversion=2, destructive=FALSE))
}
\arguments{
  \item{\dots}{ file names separated by comma.}
  \item{filenames}{ file names in a character vector.}
  \item{phenoData}{ a \code{\link[Biobase]{phenoData}} object}
  \item{description}{ a \code{\link[Biobase]{MIAME}} object }
  \item{notes}{ notes }
  \item{compress}{are the CEL files compressed ?}
  \item{rm.mask}{ should the spots marked as 'MASKS' set to \code{NA} ? }
  \item{rm.outliers}{ should the spots marked as 'OUTLIERS' set to \code{NA} }
  \item{rm.extra}{ if \code{TRUE}, overrides what is in \code{rm.mask} and \code{rm.oultiers} }
  \item{hdf5}{ use of hdf5 ? (not available yet)}
  \item{hdf5FilePath}{ a filename to use with hdf5 (not available yet)}
  \item{verbose}{ verbosity flag }
  \item{widget}{a logical specifying if widgets should be used.}
  \item{celfile.path}{a character denoting the path \code{ReadAffy}
    should look for cel files}
  \item{sampleNames}{a character vector of sample names to be used in
    the \code{AffyBatch}}
    \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{background}{logical value. If \code{TRUE} background correct
    using RMA background correction}
  \item{bgversion}{integer value indicating which RMA background to use
    1: use background similar to pure R rma background given in affy version 1.0 - 1.0.2
    2: use background similar to pure R rma background given in affy version 1.1 and above}
   \item{destructive}{logical value. If \code{TRUE} works on the PM matrix in place as much as possible, good for large datasets.}

}

\details{
\code{justRMA} is a wrapper for \code{just.rma} that permits the
user to read in phenoData, MIAME information, and CEL files using
widgets. One can also define files where to read phenoData and MIAME
information.

If the function is call with no arguments \code{justRMA()} then all the CEL
files in the working directory are read, converted to an expression
measure using RMA and put into an \code{exprSet}.
However, the arguments give the user great flexibility.
  
\code{phenoData} is read using \code{\link[Biobase]{read.phenoData}}. If a
character is given it tries to read the file with that name
to obtain the phenoData
object as described in \code{\link[Biobase]{read.phenoData}}. If left
\code{NULL} but \code{widget=TRUE} then widgets are used. If left
\code{NULL} and \code{widget=FALSE} then a default object is created.
It will be an object of class \code{\link[Biobase]{phenoData}} with
   \code{new("phenoData",pData=data.frame(x=1:length(CELfiles)),varLabels=list(x="arbitrary number"))}
}

\code{description} is read using \code{\link[Biobase]{read.MIAME}}. If a
character is given it tries to read the file with that name to obtain a
\code{MIAME} instance. If left
\code{NULL} but \code{widget=TRUE} then widgets are used. If left
\code{NULL} and \code{widget=FALSE} then an empty instance of
\code{MIAME} is created..


The arguments \code{rm.masks}, \code{rm.outliers}, \code{rm.extra} are
passed along to the function \code{\link{read.celfile}}.

}
\value{
  An \code{exprSet} object.
}

\author{In the beginning: James MacDonald <jmacdon@med.umich.edu>
Supporting routines, maintainence and just.rma: Ben Bolstad <bolstad@stat.berkeley.edu>}
\seealso{\code{\link[affy]{rma}},\code{\link[affy]{ReadAffy}}}

\examples{

}
\keyword{manip}


\eof
\name{list.celfiles}
\alias{list.celfiles}
\title{List the Cel Files in a Directory/Folder}
\description{
This function produces a vector containing the names of files in the
named directory/folder ending in .cel or .CEL. 
}
\usage{
list.celfiles(...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{\dots}{arguments to  pass along to
    \code{\link[base]{list.files}}}
}
\value{
A character vector of file names.
}
\seealso{list.files}

\examples{
list.celfiles()
}
\keyword{character}% at least one, from doc/KEYWORDS

\eof
\name{loess.normalize}
\alias{loess.normalize}

\title{Normalize arrays}
\description{
This function treats PM and MM as the raw data on each chip. It fits
loess curves to MVA plots and tries to
normalize the chips with respect to each other by forcing log ratios to
be scattered around the same constant.}
\usage{
loess.normalize(mat, subset = sample(1:(dim(mat)[2]), 5000), epsilon
                 = 10^-2, maxit = 1, log.it = TRUE, verbose = TRUE,
                 span = 2/3, family.loess = "symmetric")
}

\arguments{
  \item{mat}{a matrix with columns containing the values of the chips
    to normalize.}
  \item{subset}{a subset of the data to fit a loess to.}
  \item{epsilon}{small value used for the stopping criterion.}
  \item{maxit}{maximum number of iterations.}
  \item{log.it}{logical. If \code{TRUE} it takes the log2 of \code{mat}}
  \item{verbose}{logical. If \code{TRUE} displays current pair of chip being
    worked on.}
  \item{span}{span to be used by loess}
  \item{family.loess}{\code{"gaussian"} or \code{"symmetric"}
    as in \code{\link[modreg]{loess}}}
}
\details{
Experience shows that you only need 1-2 iterations to obtain useful
results. This function is not written in an efficient way. In order to
make it faster, loess is fit to a sample of the data which we then use to
predict the curve for all the data. By setting
\code{family.loess="gaussian"} the function is faster, but you risk
losing information on differentially expressed genes. The function
\code{\link{normalize.quantiles}} is faster. 
}

\value{A matrix with normalized values for chips in columns.}

\seealso{\code{\link{normalize.quantiles}}, \code{\link{maffy.normalize}},
  \code{\link{maffy.subset}}}
\author{Rafael A. Irizarry}
\keyword{smooth}

\eof
\name{maffy.normalize}
\alias{maffy.normalize}
\alias{normalize.contrast}
\title{Normalize Itensities}
\description{Normalizes feauture intensities from
  \code{\link[affy:AffyBatch-class]{AffyBatch}}s}
\usage{
maffy.normalize(data,subset,verbose=FALSE,span=0.25,family="symmetric",log.it=TRUE)}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{an matrix of intensities.}
  \item{subset}{a vector of indexes describing which probes to use for normalising.}
  \item{verbose}{logical value.}
  \item{span}{See \code{\link[modreg]{loess}}.}
  \item{family}{See \code{\link[modreg]{loess}}.}
  \item{log.it}{logical value.}
}
\details{
Please refer to references.
}

}
\value{
The normalized intensities.
}
\references{
Astrand, M. (2003) \url{http://www.math.chalmers.se/~magnusaa/maffy/}}
\author{Magnus Astrand}
\seealso{ \code{\link{maffy.subset}}}
\examples{
     data(affybatch.example)
     x <- pm(affybatch.example)[1:2000,1:3]
     mva.pairs(x)
     x <- maffy.normalize(x,subset=1:nrow(x))
     mva.pairs(x)
}
\keyword{internal}






\eof
\name{maffy.subset}
\alias{maffy.subset}
\title{Select Subset}
\description{Select a subset of rows with small rank-range over columns.}
\usage{
maffy.subset(data,subset.size=5000,maxit=100,
             subset.delta=max(round(subset.size/100),25),verbose=FALSE)}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{a matrix}
  \item{subset.size}{desired size of subset}
  \item{maxit}{maximum number of iterations}
  \item{subset.delta}{maximum deviation from subset.size}
  \item{verbose}{logical value.}
}
\details{
Please refer to references.
}

}
\value{ 
A list with component
\item{subset}{the indexes for subset.}
}
\references{strand, M. (2001) \url{http://www.math.chalmers.se/~magnusaa/maffy/}}}
\author{Magnus strand}
\seealso{ \code{\link{maffy.normalize}}}
\examples{
     #data(Dilution)
     #x <- log2(pm(Dilution)[,1:3])
     #Index <- maffy.subset(x,subset.size=100)$subset
     #mva.pairs(x[Index,])
}
\keyword{internal}



\eof
\name{mas5}
\alias{mas5}
\title{MAS 5.0 expression measure}
\description{
  This function converts an instance of \code{\link{AffyBatch-class}}
  into an instance of \code{\link[Biobase]{exprSet-class}} using
  our implementation of Affymetrix's MAS 5.0 expression measure.
}
\usage{
mas5(object, normalize = TRUE, sc = 500, analysis = "absolute", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{an instance of \code{\link{AffyBatch-class}}}
  \item{normalize}{logical. If \code{TRUE} scale normalization is used
    after we obtain an instance of \code{\link[Biobase]{exprSet-class}}}
  \item{sc}{Value at which all arrays will be scaled to.}
  \item{analysis}{should we do absolute or comparison analysis, although
    "comparison" is still not implemented.}
  \item{\dots}{other arguments to be passed to \code{\link{expresso}}.}
}
\details{
  This function is a wrapper for  \code{\link{expresso}} and \code{\link{affy.scalevalue.exprSet}}.}
\value{
  \code{\link[Biobase]{exprSet-class}} 

  The methods used by this function
  were implemented based upon available documentation. In
  particular a useful reference is Statistical Algorithms Description
  Document by Affymetrix.
  Our implementation is based on what is written
  in the documentation and as you might appreciate there are places
  where the documentation is less than clear. This function does not
  give exactly the same results.
  All source code of our implementation is available. You are free to
  read it and suggest fixes. 

  For more information visit this URL:
  http://stat-www.berkeley.edu/users/bolstad/
    
}
\seealso{\code{\link{expresso}},\code{\link{affy.scalevalue.exprSet}}}
\examples{
  data(affybatch.example)
  eset <- mas5(affybatch.example)
}
\keyword{manip}% at least one, from doc/KEYWORDS


\eof
\name{mas5calls}
\alias{mas5calls,AffyBatch-method}
\alias{mas5calls,ProbeSet-method}
\alias{mas5calls}
\alias{mas5.detection}
\alias{mas5calls.AffyBatch}
\alias{mas5calls.ProbeSet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{MAS 5.0 Absolute Detection}
\description{
 Performs the Wilcoxon signed rank-based gene expression presence/absence 
 detection algorithm first implemented in the Affymetrix Microarray Suite
 version 5.
}
\usage{
mas5calls(object,...)

mas5calls.AffyBatch(object, ids = NULL, verbose = TRUE, tau = 0.015,
                    alpha1 = 0.04, alpha2 = 0.06,
                    ignore.saturated=TRUE) 

mas5calls.ProbeSet(object, tau = 0.015, alpha1 = 0.04, alpha2 = 0.06,
                   ignore.saturated=TRUE) 

mas5.detection(mat, tau = 0.015, alpha1 = 0.04, alpha2 = 0.06,
               exact.pvals = FALSE, cont.correct = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{An object of class \code{AffyBatch} or \code{ProbeSet}}
  \item{ids}{probeset IDs for which you want to compute calls}
  \item{mat}{an n-by-2 matrix of paired values (pairs in rows), PMs first col}
  \item{verbose}{logical. It \code{TRUE} status of processing is reported}
  \item{tau}{a small positive constant }
  \item{alpha1}{a significance threshold in (0,alph2)}
  \item{alpha2}{a significance threshold in (alpha1,0.5) }
  \item{exact.pvals}{a boolean controlling whether exact p-values are computed
    (irrelevant if n<50 and there are no ties).  Otherwise the
    normal approximation is used}
  \item{ignore.saturated}{ if true do the saturation correction described in the paper, with a saturation level of 46000 }
  \item{cont.correct}{a boolean controlling whether continuity
    correction is used in the p-value normal approximation  }
  \item{...}{any of the above arguments that applies}
    
}
\details{
 This function performs the hypothesis test:

  H0: median(Ri) = tau, corresponding to absence of transcript
  H1: median(Ri) > tau, corresponding to presence of transcript

where Ri = (PMi - MMi) / (PMi + MMi) for each i a probe-pair in the 
probe-set represented by data.

Currently exact.pvals=TRUE is not supported, and cont.correct=TRUE works but
 does not give great results (so both should be left as FALSE).  The defaults
 for tau, alpha1 and alpha2 correspond to those in MAS5.0.

 The p-value that is returned estimates the usual quantity:

   Pr(observing a more "present looking" probe-set than data | data is absent)

 So that small p-values imply presence while large ones imply absence of 
 transcript.  The detection call is computed by thresholding the p-value as 
 in:

 call "P" if p-value < alpha1
 call "M" if alpha1 <= p-value < alpha2
 call "A" if alpha2 <= p-value

 This implementation has been validated against the original MAS5.0
 implementation with the following results (for exact.pvals and cont.correct
 set to F):

   Average Relative Change from MAS5.0 p-values:38\%
   Proportion of calls different to MAS5.0 calls:1.0\%

 where "average/proportion" means over all probe-sets and arrays, where 
 the data came from 11 bacterial control probe-sets spiked-in over a range
 of concentrations (from 0 to 150 pico-mols) over 26 arrays.  These are
 the spike-in data from the GeneLogic Concentration Series Spikein Dataset.

 Clearly the p-values computed here differ from those computed by MAS5.0 --
 this will be improved in subsequent releases of the affy package.   However
 the p-value discrepancies are small enough to result in the call being very
 closely aligned with those of MAS5.0 (99 percent
 were identical on the validation
 set) -- so this implementation will still be of use.
 
The function \code{mas5.detect} is no longer the engine function for the
others. C code is no available that computes the wilcox test faster. THe
function is kept so that people can look at the R code (instead of C)}
}
\value{\code{mas5.detect} returns a list containing the following components:
  \item{pval}{	a real p-value in [0,1] equal to the probability of
    observing probe-level intensities that are more present looking than
    data assuming the data represents an absent transcript; that is a
    transcript is more likely to be present for p-values closer 0.} 
  \item{call}{either "P", "M" or "A" representing a call of present,
    marginal or absent; computed by simply thresholding pval using
    alpha1 and} 

  The \code{mas5calls} method for \code{AffyBatch} returns an
  \code{exprSet} with calls in the \code{exprs} slot and p-values in the
  \code{se.exprs}. The code{mas5calls} for \code{ProbeSet} returns a
  list with vectors of calls and pvalues.
}
\references{

Liu, W. M. and Mei, R. and Di, X. and Ryder, T. B. and Hubbell, E. and Dee,
S. and Webster, T. A. and Harrington, C. A. and Ho, M. H. and Baid, J. and
Smeekens, S. P. (2002) Analysis of high density expression microarrays with
signed-rank call algorithms, Bioinformatics, 18(12), pp. 1593--1599.

Liu, W. and Mei, R. and Bartell, D. M. and Di, X. and Webster, T. A. and
Ryder, T. (2001) Rank-based algorithms for analysis of microarrays,
Proceedings of SPIE, Microarrays: Optical Technologies and Informatics, 4266.

Affymetrix (2002) Statistical Algorithms Description Document, Affymetrix
Inc., Santa Clara, CA,
whitepaper.
\url{http://www.affymetrix.com/support/technical/whitepapers/sadd_whitepaper.pdf},
\url{http://www.affymetrix.com/support/technical/whitepapers/sadd_whitepaper.pdf}
}
\author{Crispin Miller, Benjamin I. P. Rubinstein, Rafael A. Irizarry}
\examples{

data(affybatch.example)
PACalls <- mas5calls(affybatch.example)
}
\keyword{manip}

\eof
\name{merge.AffyBatch}
\alias{merge.AffyBatch}

\title{ merge two AffyBatch objects }
\description{
  merge two AffyBatch objects into one.
}
\usage{
merge.AffyBatch(x, y, annotation = paste(annotation(x),
                 annotation(y)), description = NULL, notes =
                 paste(x@notes, y@notes), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ an \code{AffyBatch} }
  \item{y}{ an \code{AffyBatch} }
  \item{annotation}{ a \code{character} }
  \item{description}{ a \code{characterORmiame}, eventualy \code{NULL}}
  \item{notes}{ a \code{character} }
  \item{\dots}{ ~~Describe \code{\dots} here~~ }
}
\details{
  To be done.
}
\value{
  A object if class \code{\link[affy:AffyBatch-class]{AffyBatch}}.
}

\seealso{ \code{\link{AffyBatch-class}} }

\examples{
data(affybatch.example)
m.abatch <- merge(affybatch.example, affybatch.example)
}
\keyword{ manip }





\eof
\name{multiloess}
\alias{multiloess}
\title{Local Polynomial Regression Fitting}
\description{A modified version of of loess. 
Perform loess for every column of Y, but with the robust weights calculated using all columns}
\usage{
multiloess(formula, data=NULL, weights, subset, na.action, model = FALSE,
	 span = 0.75, enp.target, degree = 2,
	 normalize = TRUE,
	 family = c("gaussian", "symmetric"),
	 method = c("loess", "model.frame"),
	 control = loess.control(...), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
See \code{\link[modreg]{loess}}.}
}
\details{
Please refer to \code{\link[modreg]{loess}}.
}

}
\value{
  See \code{\link[modreg]{loess}}.
 }
\references{strand, M. (2001) \url{http://www.math.chalmers.se/~magnusaa/maffy/}}
\author{Magnus strand}
\seealso{ \code{\link{loess}}}
\keyword{internal}



\eof
\name{mva.pairs}
\alias{mva.pairs}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{M vs. A Matrix}
\description{
 A matrix of M vs. A plots is produced. Plots are made on the upper
 triangle and the IQR of the Ms are displayed in the lower triangle}
}
\usage{
mva.pairs(x, labels=colnames(x), log.it=TRUE,span=2/3,family.loess="gaussian",
          digits=3,line.col=2,main="MVA plot",...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{A matrix containing the chip data in the columns.}
  \item{labels}{the names of the variables.}
  \item{log.it}{logical. If \code{TRUE} uses log scale.}
  \item{span}{span to be used for loess fit.}
  \item{family.loess}{\code{"guassian"} or \code{"symmetric"} as in \code{\link[modreg]{loess}}.}
  \item{digits}{number of digits to use in the display of IQR.}
  \item{line.col}{color of the loess line.}
  \item{main}{an overall title for the plot.}
  \item{\dots}{graphical parameters can be given as arguments to \code{mva.plot}}}
\examples{
    
    x <- matrix(rnorm(4000),1000,4)
    x[,1] <- x[,1]^2
    dimnames(x) <- list(NULL,c("chip 1","chip 2","chip 3","chip 4"))
    mva.pairs(x,log=FALSE,main="example")
}

\seealso{\code{\link{pairs}}}
\keyword{hplot}



\eof
\name{normalize-methods}
\title{Normalize Affymetrix Probe Level Data - methods}
\docType{methods}
\alias{normalize.AffyBatch}
\alias{normalize.methods}
\alias{normalize.AffyBatch.methods}
\alias{normalize,AffyBatch-method}
\alias{normalize.methods,AffyBatch-method}

\description{
  Method for normalizing Affymetrix Probe Level Data}
}
\usage{
normalize.methods(object)
}
\arguments{
  \item{object}{An \code{\link[affy:AffyBatch-class]{AffyBatch}}.}
%  \item{...}{Optional arguments to be passed along. See details.}
}
\details{

  If \code{object} is an
  \code{\link[affy:AffyBatch-class]{AffyBatch}} then
  \code{normalize(object)} returns an
  \code{\link[affy:AffyBatch-class]{AffyBatch}} with the intensities
  normalized using the methodology specified by
  \code{getOption("BioC")$affy$normalize.method}. The affy package
  default is \code{quantiles}.

  Other methodologies can be used by specifying them with the
  \code{method} argument. For example to use the invariant set
  methodology described by Li and Wong (2001) one would type:
  \code{normalize(object, method="invariantset")}.

  Further arguments passed by \code{...}, apart from \code{method},  are
  passed along to the 
  function responsible for the methodology defined by the \code{method}
  argument. 
  
  A character vector of \emph{nicknames} for the 
  methodologies available is returned by
  \code{normalize.methods(object))}, where \code{object} 
  is an  \code{\link[affy:AffyBatch-class]{AffyBatch}}, or simply by
  typing \code{normalize.AffyBatch.methods}. If the nickname of a method
  is called "loess", the help page for that 
  specific methodology can
  be accessed by typing \code{?normalize.loess}. 

  For more on the normalization methodologies currently implemented
  please refer to the vignette `Custom Processing Methods'.

  To add your own normalization procedures please
  refer to the customMethods vignette.

}
\seealso{
  \code{\link{AffyBatch-class}}, \code{\link{normalize}}.
}
\examples{
data(affybatch.example)
normalize.methods(affybatch.example)
}
\keyword{manip}




\eof
\name{normalize}
\alias{normalize}
\title{Normalize - generic}
\description{
A generic function which normalizes microarray data.
Normalization is intended to remove from the intensity measures any
systematic trends which arise from the microarray technology rather than
from differences between the probes or between the target RNA samples
hybridized to the arrays. 
}
\usage{
normalize(object, ...)
}
\arguments{
  \item{object}{a data object containing microarray data}
  \item{...}{any other arguments}
}
\seealso{
  Type \code{showMethods("normalize")} at the R prompt to see what
  methods are available. Help on individual methods is generally available
  as \code{normalize}.<class> where <class> is the class of the data
  object. For example, for the main class in the \code{affy} package use \code{?normalize.AffyBatch}.

  Other Bioconductor packages include some related generic functions:
  \code{\link[LIMMA]{normalizeWithinArrays}}, and 
  \code{\link[LIMMA]{normalizeBetweenArrays}}, in the LIMMA package, and 
  \code{\link[marrayNorm]{maNorm}} in the marrayNorm package.
}
\keyword{models}


\eof
\name{normalize.constant}
\alias{normalize.constant}
\alias{normalize.AffyBatch.constant}
\title{Scale probe intensities}
\description{
  Scale array intensities in a \code{\link[affy:AffyBatch-class]{AffyBatch}}.
}
\usage{
normalize.AffyBatch.constant(abatch, refindex=1, FUN=mean, na.rm=TRUE)
normalize.constant(x, refconstant, FUN=mean, na.rm=TRUE)
}
\arguments{
  \item{abatch}{ an instance of the \code{\link{AffyBatch-class}}.}
  \item{x}{a vector of intensities on a chip (to normalize to the reference).}
  \item{refindex}{the index of the array used as a reference.}
  \item{refconstant}{the constant used as a reference}
  \item{FUN}{A function generating a value from the intensities on an
    array. Typically \code{mean} or \code{median}.}
  \item{na.rm}{Paramater passed to the function FUN.}
}
\value{
  %A \code{\link[Biobase]{container-class}} of normalized objects.
  An \code{\link[affy:AffyBatch-class]{AffyBatch}} with an attribute "constant"
  holding the value of the factor used for scaling.
}
\author{
  L. Gautier <laurent@cbs.dtu.dk>
}
\seealso{
  \code{\link[affy:AffyBatch-class]{AffyBatch}}
}
%\examples{
%  
%}
\keyword{manip}

\eof
\name{normalize.contrasts}
\alias{normalize.contrasts}
\alias{normalize.AffyBatch.contrasts}
\title{Normalize intensities using the contrasts method}
\description{
  Scale chip objects in an \code{\link{AffyBatch-class}}.
}
\usage{
%normalize.contrast() ## currenlt maffy.normalize
normalize.AffyBatch.contrasts(abatch,span=2/3,choose.subset=TRUE,
                              subset.size=5000,verbose=TRUE,
                              family="symmetric",type=c("together","pmonly","mmonly","separate"))
}
\arguments{
  \item{abatch}{ an \code{\link{AffyBatch-class}}}
  \item{span}{parameter to be passed to the function \code{\link[modreg]{loess}}.}
  \item{choose.subset}{}
  \item{subset.size}{}
  \item{verbose}{verbosity flag}
  \item{family}{parameter to be passed to the function \code{\link[modreg]{loess}}.}
  \item{type}{A string specifying how the normalization should be
    applied.}

}
\value{
  An object of the same class as the one passed.
}
\examples{
}

\seealso{
  \code{\link{maffy.normalize}}
  }
%\examples{
%  
%}
\keyword{manip}


\eof
\name{normalize.invariantset}
\alias{normalize.invariantset}
\alias{normalize.AffyBatch.invariantset}
\title{Invariante Set normalization}
\description{
Normalize arrays in an  \code{\link[affy:AffyBatch-class]{AffyBatch}} using an invariant set.
}
\usage{
normalize.AffyBatch.invariantset(abatch,
                   prd.td=c(0.003, 0.007), verbose=FALSE,baseline.type=c("mean","median","pseudo-mean","pseudo-median"),type=c("separate","pmonly","mmonly","together"))

normalize.invariantset(data, ref, prd.td=c(0.003,0.007))
}
\arguments{
  \item{abatch}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{data}{a vector of intensities on a chip (to normalize to the reference).}
  \item{ref}{a vector of reference intensities.}
  \item{prd.td}{cutoff parameter (details in the bibliographic
    reference)}
  \item{baseline.type}{Specify how to determine the baseline array}
  \item{type}{A string specifying how the normalization should be
    applied. See details for more.}
  \item{verbose}{A flag to have a dumps throughout the normalization}
}
\value{
  Respectively a \code{\link[affy:AffyBatch-class]{AffyBatch}} of normalized objects, or
  a vector of normalized intensities, with an attribute "invariant.set"
  holding the indexes of the 'invariant' intensities.
}
\details{
  The set of invariant intensities between \code{data} and
  \code{ref} is found through an iterative
  process (based on the respective ranks the intensities).
  This set of intensities is used to generate a normalization curve by
  smoothing.

  The \code{type} argument should be one of
  \code{"separate","pmonly","mmonly","together"} which indicates whether
  to normalize only one probe type (PM,MM) or both together or separately.
  
}
\author{
  L. Gautier <laurent@cbs.dtu.dk>
  (Thanks to Cheng Li for the discussions about the algorithm.)
}
\references{
  Cheng Li and Wing Hung Wong, Model-based analysis of
  oligonucleotides arrays: model validation, design issues and
  standard error application. Genome Biology 2001, 2(8):research0032.1-0032.11
}
\seealso{
  \code{\link{normalize}} to normalize \code{\link[affy:AffyBatch-class]{AffyBatch}} objects.
}

}
\keyword{manip}

\eof
\name{normalize.loess}
\alias{normalize.loess}
\alias{normalize.AffyBatch.loess}
\title{Scale microarray data}
\description{Normalizes arrays using loess.}
\usage{
normalize.loess(mat, subset = sample(1:(dim(mat)[1]), min(c(5000,
                 nrow(mat)))), epsilon = 10^-2, maxit = 1, log.it =
                 TRUE, verbose = TRUE, span = 2/3, family.loess =
                 "symmetric")
normalize.AffyBatch.loess(abatch,type=c("together","pmonly","mmonly","separate"), ...)
}
\arguments{
  \item{mat}{a matrix with columns containing the values of the chips
    to normalize.}
  \item{abatch}{an \code{\link[affy:AffyBatch-class]{AffyBatch}} object.}
  \item{subset}{a subset of the data to fit a loess to.}
  \item{epsilon}{a tolerance value (supposed to be a small value - used
    as a stopping criterium).}
  \item{maxit}{maximum number of iterations.}
  \item{log.it}{logical. If \code{TRUE} it takes the log2 of \code{mat}}
  \item{verbose}{logical. If \code{TRUE} displays current pair of chip being
    worked on.}
  \item{span}{parameter to be passed the function \code{\link[stats]{loess}}}
  \item{family.loess}{parameter to be passed the function
    \code{\link[stats]{loess}}. \code{"gaussian"} or \code{"symmetric"}
    are acceptable values for this parameter.}
  \item{type}{A string specifying how the normalization should be
    applied. See details for more.}
  \item{...}{any of the options of normalize.loess you would like to
    modify (described above).}
}
\details{
  The type arguement should be one of
  \code{"separate","pmonly","mmonly","together"} which indicates whether
  to normalize only one probe type (PM,MM) or both together or separately.
}
\seealso{
  \code{\link{normalize}}
}
\examples{
     #require(affy)
     #data(Dilution)
     #x <- pm(Dilution[,1:3])
     #mva.pairs(x)
     #x <- normalize.loess(x,subset=1:nrow(x))
     #mva.pairs(x)
}
\keyword{smooth}



\eof
\name{normalize.qspline}
\alias{qspline-normalize}
\alias{normalize.qspline}
\alias{normalize.AffyBatch.qspline}
\title{Normalize arrays}
\description{
  normalizes arrays in an AffyBatch each other or to a set of target intensities
}
\usage{
normalize.AffyBatch.qspline(abatch,type=c("together", "pmonly", "mmonly",
                 "separate"), ...)

normalize.qspline(x, target = NULL, samples = NULL, 
                  fit.iters = 5, min.offset = 5, 
                  spline.method = "natural", smooth = TRUE,
                  spar = 0, p.min = 0, p.max = 1.0, 
                  incl.ends = TRUE, converge = FALSE, 
                  verbose = TRUE, na.rm = FALSE)
}
\arguments{
  \item{x}{a \code{data.matrix} of intensities}
  \item{abatch}{an \code{AffyBatch}}
  \item{target}{numerical vector of intensity values to normalize to.
                (could be the name for one of the celfiles in 'abatch')}
  \item{samples}{numerical, the number of quantiles to be used for spline.
                 if (0,1], then it is a sampling rate}
  \item{fit.iters}{number of spline interpolations to average}
  \item{min.offset}{minimum span between quantiles (rank difference) for the
                    different fit iterations}
  \item{spline.method}{specifies the type of spline to be used. Possible values are 
                       `"fmm"', `"natural"', and `"periodic"'.}
  \item{smooth}{logical, if `TRUE', smoothing splines are used on the quantiles}
  \item{spar}{smoothing parameter for `splinefun', typically in (0,1].}
  \item{p.min}{minimum percentile for the first quantile}
  \item{p.max}{maximum percentile for the last quantile}
  \item{incl.ends}{include the minimum and maximum values from the normalized
                   and target arrays in the fit}
  \item{converge}{(currently unimplemented)}
  \item{verbose}{logical, if `TRUE' then normalization progress is reported}
  \item{na.rm}{logical, if `TRUE' then handle NA values (by ignoring
    them)}
  \item{type}{A string specifying how the normalization should be
    applied. See details for more.}
  \item{...}{Optional parameters to be passed through}
}
\value{
  a normalized \code{AffyBatch}.
}
\details{
  This normalization method uses the quantiles from each array and the 
  target to fit a system of cubic splines to normalize the data. The 
  target should be the mean (geometric) or median of each probe but could 
  also be the name of a particular chip in the \code{abatch} object.

  Parameters setting can be of much importance when using this method.
  The parameter \code{fit.iter} is used as a starting point to find a
  more appropriate value. Unfortunately the algorithm used do not
  converge in some cases. If this happens, the \code{fit.iter} value is
  used and a warning is thrown. Use of different settings for the
  parameter \code{samples} was reported to give good results. More
  specifically, for about 200   data points use
  \code{samples = 0.33}, for about 2000  data points use
  \code{samples = 0.05}, for about 10000 data points use
  \code{samples = 0.02}
  (thanks to Paul Boutros).
  
  The \code{type} argument should be one of
  \code{"separate","pmonly","mmonly","together"} which indicates whether
  to normalize only one probe type (PM,MM) or both together or separately.
  

  
}
\author{
  Laurent and Workman C.
}
\references{
  Christopher Workman, Lars Juhl Jensen, Hanne Jarmer, Randy Berka,
     Laurent Gautier, Henrik Bj{\o}rn Nielsen, Hans-Henrik Saxild, Claus
     Nielsen, S{\o}ren Brunak, and Steen Knudsen. A new non-linear normal-
     ization method for reducing variability in dna microarray experiments.
     Genome Biology, accepted, 2002
}
%\seealso{
%}
%\examples{
%
%  ## TO DO...  
%}
\keyword{}

\eof
\name{normalize.quantiles}
\alias{normalize.quantiles}
\alias{normalize.AffyBatch.quantiles}
\title{Quantile Normalization}
\description{
  Using a normalization based upon quantiles, this function
  normalizes a matrix of probe level intensities.
}
\usage{
  normalize.quantiles(x,copy=TRUE)
  normalize.AffyBatch.quantiles(abatch, type=c("separate","pmonly","mmonly","together"))
}
\arguments{
  \item{x}{A matrix of intensities where each column corresponds to a
    chip and each row is a probe.}
  \item{copy}{Make a copy of matrix before normalizing. Usually safer to
    work with a copy}
  \item{abatch}{An \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{type}{A string specifying how the normalization should be
    applied. See details for more.}
}
\details{This method is based upon the concept of a quantile-quantile
  plot extended to n dimensions. No special allowances are made for
  outliers. If you make use of quantile normalization either through
  \code{\link{rma}} or \code{\link{expresso}}
  please cite Bolstad et al, Bioinformatics (2003).

  The type arguement should be one of
  \code{"separate","pmonly","mmonly","together"} which indicates whether
  to normalize only one probe type (PM,MM) or both together or separately.
  
}

\value{
  A normalized \code{AffyBatch}.
}
\references{
  Bolstad, B (2001) \emph{Probe Level Quantile Normalization of High Density
    Oligonucleotide Array Data}. Unpublished manuscript
  \url{http://oz.berkeley.edu/~bolstad/stuff/qnorm.pdf}

  Bolstad, B. M., Irizarry R. A., Astrand, M, and Speed, T. P. (2003)
  \emph{A Comparison of Normalization Methods for High Density
    Oligonucleotide Array Data Based on Bias and Variance.}
   Bioinformatics 19(2) ,pp 185-193. \url{http://www.stat.berkeley.edu/~bolstad/normalize/normalize.html}
  }

\author{Ben Bolstad, \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link{normalize}}}

\keyword{manip}

\eof
\name{normalize.quantiles.robust}
\alias{normalize.quantiles.robust}
\alias{normalize.AffyBatch.quantiles.robust}
\title{Robust Quantile Normalization}
\description{Using a normalization based upon quantiles, this function
  normalizes a matrix of probe level intensities. Allows weighting of chips}
\usage{
      normalize.quantiles.robust(x,weights=NULL,
                remove.extreme=c("variance","mean","both","none"),
                n.remove=1,approx.meth = FALSE,use.median=FALSE,use.log2=FALSE)
}

\arguments{
  \item{x}{A matrix of intensities, columns are chips, rows are probes}
  \item{weights}{A vector of weights, one for each chip}
  \item{remove.extreme}{If weights is null, then this will be used for
  determining which chips to remove from the calculation of the
  normalization distribution, See details for more info}
  \item{n.remove}{number of chips to remove}
  \item{approx.meth}{Use the approximation method. Not currently
    implememnted}
  \item{use.median}{if TRUE use the median to compute normalization
    chip, otherwise use a weighted median}
  \item{use.log2}{work on log2 scale. This means we will be using the
    geometric mean rather than ordinary mean}
}
\details{This method is based upon the concept of a quantile-quantile 
  plot extended to n dimensions. Note that the matrix is of intensities
  not log intensities. The function performs better with raw
  intensities.
  
  Choosing \bold{variance} will remove chips with variances much higher
  or lower than the other chips, \bold{mean} removes chips with the mean
  most different from all the other means, \bold{both} removes first
  extreme variance and then an extreme mean. The option \bold{none} does
  not remove any chips, but will assign equal weights to all chips.
  
}
\note{This function is still experimental.}
\value{a matrix of normalized intensites}
\author{Ben Bolstad, \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link{normalize}}, \code{\link{normalize.quantiles}}}
\keyword{manip}





\eof
\name{pairs.AffyBatch}
\alias{pairs.AffyBatch}
\title{plot intensities using 'pairs'}
\description{
  Plot intensities using the function 'pairs'
}
\usage{
  pairs.AffyBatch(x, panel=points, ..., transfo=I, main=NULL, oma=NULL,
                  font.main = par("font.main"),
                  cex.main = par("cex.main"), cex.labels = NULL, 
                  lower.panel=panel, upper.panel=NULL, diag.panel=NULL,
                  font.labels = 1, row1attop = TRUE, gap = 1)
}
\arguments{
  \item{x}{ an \code{\link[affy:AffyBatch-class]{AffyBatch}} object }
  \item{panel}{ a function to produce a plot (see \code{\link{pairs}}) }
  \item{...}{ extra parameters for the 'panel' function}
  \item{transfo}{ a function to transform the intensity values before
    generating the plot. 'log' and 'log2' are popular choices. }
  \item{main}{title for the plot}
  \item{oma}{see 'oma' in \code{\link{par}}.}
  \item{font.main}{see \code{\link{pairs}}}
  \item{cex.main}{see \code{\link{pairs}}}
  \item{cex.labels}{see \code{\link{pairs}}}
  \item{lower.panel}{a function to produce the plots in the lower
triangle (see \code{\link{pairs}}).}
  \item{upper.panel}{a function to produce the plots in the upper
triangle (see \code{\link{pairs}}).}
  \item{diag.panel}{a function to produce the plots in the diagonal (see \code{\link{pairs}}).}
  \item{font.labels}{see \code{\link{pairs}}}
  \item{row1attop}{see \code{\link{pairs}}}
  \item{gap}{see \code{\link{pairs}}}
}
\details{
  Plots with several chips can represent zillions of points. They require
a lot of memory and can be very slow to be displayed. You may want to
try to split of the plots, or to plot them in a device like 'png' or
'jpeg'. 
}
\examples{
}
\keyword{hplot}



\eof
\name{plot.ProbeSet}
\alias{plot.ProbeSet}
\title{ plot a probe set}
\description{
  
}
\usage{
plot.ProbeSet(x, which=c("pm", "mm"), xlab = "probes", type = "l", ylim = NULL, ...)
}

\arguments{
  \item{x}{ a \code{ProbeSet} }
  \item{which}{ get the PM or the MM}
  \item{xlab}{ label on x-axis }
  \item{type}{ plot type }
  \item{ylim}{ range of the y-axis }
  \item{\dots}{ optional arguments to be passed to \code{matplot} }
}
\details{
  
}
\value{
  This function is only used for its (graphical) side-effect.
}

\seealso{\code{\link[affy:ProbeSet-class]{ProbeSet}}}

\examples{
data(SpikeIn)
plot(SpikeIn)
}
\keyword{ hplot }% at least one, from doc/KEYWORDS

\eof
%\name{matdensity}
\name{plotDensity}
%\alias{matdensity}
\alias{plotDensity}
\alias{plotDensity.AffyBatch}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Plot Densities}
\description{
Plots the non-parametric density estimates using values contained in the
columns of a matrix.
}
\usage{
%matdensity(mat, ylab = "density", xlab="x", type="l", ...)

plotDensity(mat, ylab = "density", xlab="x", type="l", col=1:6,...)

plotDensity.AffyBatch(x, col = 1:6, log=TRUE,
which=c("pm","mm","both"), ylab = "density", xlab = NULL, ...)

}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{mat}{A matrix containing the values to make densities in the columns.}
  \item{x}{A object of clase \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{log}{logical value. If \code{TRUE} the log of the intensities in
    the \code{AffyBatch} are plotted.}
  \item{which}{should a histogram of the PMs, MMs, or both be made?}
  \item{col}{The colors to use fot the different arrays}
  \item{ylab}{a title for the y axis.}
  \item{xlab}{ a title for the x axis.}
  \item{type}{ type for the plot.}
  \item{\dots}{graphical parameters can be given as arguments to \code{\link{plot}}}
}
%\details{
%  The function \code{plotDensity} is being deprecated.
%  The function \code{matdensity} should be preferred. It is felt to belong to the same family
%  than the functions \code{matplot} and \code{matlines}. It returns
%  invisibly a list of two matrices `x' and `y'.
%  This can be convenient for large
%  input matrices (the computation of the densities can take some time).
%}
\author{Ben Bolstad and Laurent}
\examples{
data(affybatch.example)

m <- exprs(affybatch.example)

plotDensity(exprs(affybatch.example))

}
\keyword{hplot}% at least one, from doc/KEYWORDS







\eof
\name{plotLocation}
\alias{plotLocation}
\title{Plot a location on a cel image}
\description{
  Plots a location on a previously plotted cel image. This can be used
  to locate the physical location of probes on the array.
}
\usage{
plotLocation(x, col="green", pch=22, ...)
}
\arguments{
  \item{x}{a `location'. It can be obtained by the method of \code{AffyBatch}
    \code{indexProbes}, or made elsewhere (basically a location is nrows and
    two columns array. The first column corresponds to the x positions
    and the second columns corresponds to the y positions of n elements
    to locate)}
  \item{col}{colors for the plot}
  \item{pch}{plotting type (see function \code{plot})}
  \item{...}{Other parameters passed to the function \code{points}}
  }
}
\author{
  Laurent
}
\seealso{
  \code{\link[affy:AffyBatch-class]{AffyBatch}}
}
\examples{
  ## loading data
  data(affybatch.example)

  ## image of the celfile
  image(affybatch.example[1])

  ## genenames, arbitrarily pick the 101th
  n <- geneNames(affybatch.example)[101]

  ## get the location for the gene n
  l <- indexProbes(affybatch.example, "both", n)[[1]]
  ## convert the index to X/Y coordinates
  xy <- indices2xy(l, abatch=affybatch.example) 

  ## plot
  plotLocation(xy)

}
\keyword{aplot}




\eof
\name{pmcorrect}
\alias{pmcorrect}
\alias{pmcorrect.methods}
\alias{pmcorrect.pmonly} %took out .pmonly casue rma is pm-only
\alias{pmcorrect.mas}
\alias{pmcorrect.subtractmm}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{PM Correction}
\description{
  Corrects the PM intensities in a \code{\link[affy:ProbeSet-class]{ProbeSet}}
    for nonspecific binding.
  }
\usage{
pmcorrect.pmonly(object)

pmcorrect.subtractmm(object)

pmcorrect.mas(object, contrast.tau=0.03, scale.tau=10, delta=2.0e-20)
}
\arguments{
  \item{object}{An object of class \code{\link[affy:ProbeSet-class]{ProbeSet}}.}
  \item{contrast.tau}{a number denoting the contrast tau parameter in
    the MAS 5.0 
    pm correction algorithm.}
  \item{scale.tau}{a number denoting the scale tau parameter in
    the MAS 5.0 
    pm correction algorithm.}
  \item{delta}{a number denoting the detla parameter in
    the MAS 5.0 
    pm correction algorithm.}
}
\details{
These are the pm correction methods perfromed by Affymetrix MAS 4.0
(subtractmm) and MAS 5.0 (mas). See the Affymetrix Manual for details.}
  
pmonly does what you think: does not change the PM values.}  
\value{
  A \code{\link[affy:ProbeSet-class]{ProbeSet}} for which the \code{pm} slot contains the
  corrected
  PM values.
}
\references{Affymetrix MAS 4.0 and 5.0 manual}

\examples{
data(affybatch.example)
gn <- geneNames(affybatch.example)
pps <- probeset(affybatch.example, gn[1])[[1]]

pps.pmonly <- pmcorrect.pmonly(pps)
pps.subtractmm <- pmcorrect.subtractmm(pps)
pps.mas5 <- pmcorrect.mas(pps)
par(mfrow=c(2,2))
#plot(pm(pps.pmonly), pm(pps.subtractmm))
#plot(pm(pps.pmonly),pm(pps.mas5))
#plot(pm(pps.subtractmm),pm(pps.mas5))
}
\keyword{manip}




\eof
\name{ppsetApply}
\alias{ppsetApply}
\alias{ppset.ttest}
\title{ Apply a function over the ProbeSets in an AffyBatch }
\description{
  Apply a function over the ProbeSets in an AffyBatch
}
\usage{
ppsetApply(abatch, FUN, genenames = NULL, ...)

ppset.ttest(ppset, covariate, pmcorrect.fun = pmcorrect.pmonly, ...)
}
\arguments{
  \item{abatch}{ An object inheriting from \code{AffyBatch}.}
  \item{ppset}{ An object of class \code{ProbeSet}.}
  \item{covariate}{ the name a covariate in the slot \code{phenoData}.}
  \item{pmcorrect.fun}{ a function to corrrect PM intensities}
  \item{FUN}{ A function working on a \code{ProbeSet} }
  \item{genenames}{ A list of Affymetrix probesets ids to work with. All
  probe set ids used when \code{NULL}.}
  \item{\dots}{ Optional parameters to the function \code{FUN} }
}
\details{
  
}
\value{
  Returns a \code{list} of objects, or values, as returned by the
  function \code{FUN}
  for each \code{ProbeSet} it processes.
}
\author{Laurent Gautier <laurent@cbs.dtu.dk>}
\seealso{\code{\link[affy]{ProbeSet-class}} }
\examples{
ppset.ttest <- function(ppset, covariate, pmcorrect.fun = pmcorrect.pmonly, ...) {
  probes <- do.call("pmcorrect.fun", list(ppset))
  my.ttest <- function(x) {
    y <- split(x, get(covariate))
    t.test(y[[1]], y[[2]])$p.value
  }
  r <- apply(probes, 1, my.ttest)
  return(r)
}

## craft a dataset
data(affybatch.example)
abatch <- merge(affybatch.example, affybatch.example)
intensity(abatch) <- jitter(intensity(abatch))
chip.variate <- c("a", "b", "a", "a", "b", "a", "a")
pData(abatch) <- data.frame(whatever = chip.variate)

## run a test over _all_ probes.
all.ttest <- ppsetApply(abatch, ppset.ttest, covariate="whatever")

}
\keyword{ manip }

\eof
\name{probeMatch-methods}
\docType{methods}
\title{Methods for accessing perfect matches and mismatches}
\alias{probeMatch-methods}
\alias{probeMatch}
\alias{pm}
\alias{pm<-}
\alias{mm}
\alias{mm<-}
\description{Methods for perfect matches and mismatches probes}
\section{Methods}{\describe{
    \item{object = AffyBatch}{All the \emph{perfect match} (pm) or
      \emph{mismatch} (mm) probes on the
      arrays the object represents are returned.}
    \item{object = ProbeSet}{The \code{pm} or \code{mm} of the object are returned}
  }
}
\keyword{methods}

\eof
\name{probeNames-methods}
\docType{methods}
\title{Methods for accessing the Probe Names}
\alias{probeNames-methods}
\alias{probeNames}
\alias{probeNames<-}
%\alias{probeName}
%\alias{probeName<-}
\description{Methods for accessing Probe Names}
\section{Methods}{\describe{
\item{object = Cdf}{ An accesor function for the
      \code{name} slot.}
\item{object = probeNames}{Returns the probe names associated with the
  rownames of the intensity matrices one gets with the \code{pm} and
  \code{mm} methods.}
}}
\keyword{methods}

\eof
\name{read.affybatch}
\alias{read.affybatch}
\alias{ReadAffy}
\title{Read CEL files into an AffyBatch}
\description{
  Read CEL files into an Affybatch
}
\usage{
read.affybatch(..., filenames = character(0),
               phenoData = new("phenoData"),
               description = NULL,
               notes = "",
               compress = getOption("BioC")$affy$compress.cel,
               rm.mask = FALSE, rm.outliers = FALSE, rm.extra = FALSE,
               verbose = FALSE)

ReadAffy(..., filenames=character(0),
              widget=getOption("BioC")$affy$use.widgets,
              compress=getOption("BioC")$affy$compress.cel,
              celfile.path=getwd(),
              sampleNames=NULL,
              phenoData=NULL,
              description=NULL,
              notes="",
              rm.mask=FALSE, rm.outliers=FALSE, rm.extra=FALSE,
              verbose=FALSE)
}
\arguments{
  \item{\dots}{ file names separated by comma.}
  \item{filenames}{ file names in a character vector.}
  \item{phenoData}{ a \code{\link[Biobase]{phenoData}} object}
  \item{description}{ a \code{\link[Biobase]{MIAME}} object }
  \item{notes}{ notes }
  \item{compress}{are the CEL files compressed ?}
  \item{rm.mask}{ should the spots marked as 'MASKS' set to \code{NA} ? }
  \item{rm.outliers}{ should the spots marked as 'OUTLIERS' set to \code{NA} }
  \item{rm.extra}{ if \code{TRUE}, overrides what is in \code{rm.mask} and \code{rm.oultiers} }
  \item{verbose}{ verbosity flag }
  \item{widget}{a logical specifying if widgets should be used.}
  \item{celfile.path}{a character denoting the path \code{ReadAffy}
    should look for cel files}
  \item{sampleNames}{a character vector of sample names to be used in
    the \code{AffyBatch}}
}

\details{
\code{ReadAffy} is a wrapper for \code{read.affybatch} that permits the
user to read in phenoData, MIAME information, and CEL files using
widgets. One can also define files where to read phenoData and MIAME
information.

If the function is call with no arguments \code{ReadAffy()} all the CEL
files in the working directory are read and put into an
\code{AffyBatch}.
However, the arguments give the user great flexibility.
  
\code{phenoData} is read using \code{link[Biobase]{read.phenoData}}. If a
character is given it tries to read the file with that name
to obtain the phenoData
object as described in \code{link[Biobase]{read.phenoData}}. If left
\code{NULL} but \code{widget=TRUE} then widgets are used. If left
\code{NULL} and \code{widget=FALSE} then a default object is created.
It will be a data frame with
   \code{new("phenoData",pData=data.frame(x=1:length(CELfiles)),varLabels=list(x="arbitrary number"))}
}

\code{description} is read using \code{\link[Biobase]{read.MIAME}}. If a
character is given it tries to read the file with that name to obtain a
\code{MIAME} instance. If left
\code{NULL} but \code{widget=TRUE} then widgets are used. If left
\code{NULL} and \code{widget=FALSE} then an empty instance of
\code{MIAME} is created..


The arguments \code{rm.masks}, \code{rm.outliers}, \code{rm.extra} are
passed along to the function \code{\link{read.celfile}}.

  
  

}
\value{
  An \code{AffyBatch} object.
}
\author{Ben Bolstad \email{bolstad@stat.berkeley.edu} (read.affybatch),
  Laurent Gautier,
  and Rafael A. Irizarry (ReadAffy)}

\seealso{\code{\link[affy:AffyBatch-class]{AffyBatch}}}

\examples{
if(require(affydata)){
     celpath <- paste(.path.package("affydata"),"celfiles",sep="/")
     fns <- list.celfiles(path=celpath,full.names=TRUE)
 
     cat("Reading files:\n",paste(fns,collapse="\n"),"\n")
     ##read a binary celfile
     abatch <- ReadAffy(filenames=fns[1])
     ##read a text celfile
     abatch <- ReadAffy(filenames=fns[2])
     ##read all files in that dir
     abatch <- ReadAffy(celfile.path=celpath)
}
}
\keyword{manip}













\eof
\name{read.probematrix}
\alias{read.probematrix}
\title{Read CEL file data into PM or MM matrices}
\description{
  Read CEL data into matrices.
}
\usage{
read.probematrix(..., filenames = character(0),
               phenoData = new("phenoData"),
               description = NULL,
               notes = "",
               compress = getOption("BioC")$affy$compress.cel,
               rm.mask = FALSE, rm.outliers = FALSE, rm.extra = FALSE,
               verbose = FALSE,which="pm")

}
\arguments{
  \item{\dots}{ file names separated by comma.}
  \item{filenames}{ file names in a character vector.}
  \item{phenoData}{ a \code{\link[Biobase]{phenoData}} object}
  \item{description}{ a \code{\link[Biobase]{MIAME}} object }
  \item{notes}{ notes }
  \item{compress}{are the CEL files compressed ?}
  \item{rm.mask}{ should the spots marked as 'MASKS' set to \code{NA} ? }
  \item{rm.outliers}{ should the spots marked as 'OUTLIERS' set to \code{NA} }
  \item{rm.extra}{ if \code{TRUE}, overrides what is in \code{rm.mask} and \code{rm.oultiers} }
  \item{verbose}{ verbosity flag }
  \item{which}{should be either "pm", "mm" or "both"}
}

\details{
}
\value{
  A list of one or two matrices. Each matrix is either PM or MM data. No
  \code{\link[affy:AffyBatch-class]{AffyBatch}} is created.
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link[affy:AffyBatch-class]{AffyBatch}}, \code{\link[affy:read.affybatch]{read.affybatch}}}

\examples{

}
\keyword{manip}

\eof
\name{rma}
\alias{rma}
\title{Robust Multi-Array Average expression measure}
\description{
  This function converts an \code{\link[affy:AffyBatch-class]{AffyBatch}} into an
  \code{\link[Biobase]{exprSet}} using
the robust multi-array average (RMA) expression measure.
}
\usage{
rma(object,subset=NULL, verbose=TRUE, destructive = TRUE,normalize=TRUE,background=TRUE,bgversion=2,...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{subset}{a character vector with the the names of the probesets
    to be used in expression calculation.}
  \item{verbose}{logical value. If \code{TRUE} it writes out some messages. (Curently ignored)}
  \item{destructive}{logical value. If \code{TRUE} works on the PM matrix in place as much as possible, good for large datasets.}
  \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{background}{logical value. If \code{TRUE} background correct
    using RMA background correction}
  \item{bgversion}{integer value indicating which RMA background to use
1: use background similar to pure R rma background given in affy version 1.0 - 1.0.2
2: use background similar to pure R rma background given in affy version 1.1 and above}
  \item{\dots}{further arguments to be passed (not currently implemented - stub for future use)}
}
\details{
This function computes the RMA (Robust Multichip Average) expression measure described in Irizarry et al
Biostatistics (2003).

Note that this expression measure is given to you in log base 2
scale. This differs from most of the other expression measure methods.

Please note that the default background adjustment method was changed during the lead up
to the bioconductor 1.2 release. This means that this function and
\code{\link{expresso}} should give results that directly agree.

}
\value{
An \code{\link[affy:exprSet-class]{exprSet}}
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\references{
  Rafael. A. Irizarry, Benjamin M. Bolstad, Francois Collin, Leslie M. Cope, Bridget Hobbs and Terence P. Speed (2003), Summaries of Affymetrix GeneChip probe level data Nucleic Acids Research 31(4):e15

  Bolstad, B.M., Irizarry R. A., Astrand M., and Speed, T.P. (2003), A Comparison of Normalization Methods for High Density Oligonucleotide Array Data Based on Bias and Variance. Bioinformatics 19(2):185-193

  Irizarry, RA, Hobbs, B, Collin, F, Beazer-Barclay, YD, Antonellis, KJ, Scherf, U, Speed, TP (2003) Exploration, Normalization, and Summaries of High Density Oligonucleotide Array Probe Level Data. Biostatistics .Vol. 4, Number 2: 249-264 
}
\seealso{\code{\link{expresso}} }

\examples{
data(affybatch.example)
eset <- rma(affybatch.example)
}
\keyword{manip}


\eof
\name{simplemultiLoess}
\alias{simplemultiLoess}
\title{Internal function for multiloess}
\description{A modified version of of simpleLoess. 
Perform loess for every column of Y, but with the robust weights calculated using all columns}
\usage{
simplemultiLoess(y, x, weights, span = 0.75, degree = 2,
	   normalize = TRUE,
	   statistics = "approximate", surface = "interpolate",
	   cell = 0.2, iterations = 1, trace.hat = "exact")
}
%- maybe also `usage' for other objects documented here.
\arguments{
See  \code{\link[modreg]{loess}}.
}
\details{
Please refer to  \code{\link[modreg]{loess}}.}

}
\value{
See  \code{\link[modreg]{loess}}.
}
\references{strand, M. (2001) \url{http://www.math.chalmers.se/~magnusaa/maffy/}}
\author{Magnus strand}
\seealso{ \code{\link[modreg]{loess}}}
\keyword{internal}



\eof
\name{split.AffyBatch}
\alias{split.AffyBatch}

\title{split an AffyBatch }
\description{
  split an AffyBatch
}
\usage{
split.AffyBatch(x, f)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an AffyBatch }
  \item{f}{a factor or list of factors}
}
\details{
  This works just like the \code{\link{split}} function from
  base. Please refers ot its documentation to learn more about the
  parameter \code{f}.
}
\value{
  A \code{list} of \code{AffyBatch} objects.
}
\seealso{ \code{\link{split}} }

\examples{
data(affybatch.example)

f <- factor(c("a", "a", "b"))

s.a <- split(affybatch.example, f)


}
\keyword{ manip }


\eof
\name{summary}
\alias{summary}
\alias{medianpolish}
\alias{tukeybiweight}
\alias{avdiff}
\title{Probe Set Summarizing Functions}
\description{
  These were used with the function \code{express} which is no longer
  part of the package. Some are still used by the generateExprVal functions.
  But you should avoid using them directly.
}  
\seealso{\code{\link{expresso}}}

\keyword{manip}% at least one, from doc/KEYWORDS






\eof
\name{tukey.biweight}
\alias{tukey.biweight}

\title{ One-step Tukey's biweight}
\description{
  One-step Tukey's biweight on a matrix
}
\usage{
tukey.biweight(x, c = 5, epsilon = 1e-04)
}
\arguments{
  \item{x}{ a matrix }
  \item{c}{ tuning constant (see details)}
  \item{epsilon}{ fuzz value to avoid division by zero (see details)}
}
\details{
  The details can be found in the given reference.
}
\value{
  a vector of values (one value per column in the input matrix).
}
\references{ Statistical Algorithms Description Document, 2002, Affymetrix. }

\seealso{ \code{\link{pmcorrect.mas}} and \code{\link{generateExprVal.method.mas}} }
}
\keyword{ manip }


\eof
\name{whatcdf}
\alias{whatcdf}

\title{Find which CDF corresponds}
\description{
  Find which kind of CDF corresponds to a CEL file.
}
\usage{
whatcdf(filename, compress = getOption("BioC")$affy$compress.cel)
}
\arguments{
  \item{filename}{a '.CEL' file name}
  \item{compress}{boolean (file compressed or not}
}
\details{
  Information concerning the corresponding CDF file seems to be found in
  CEL files. This allows us to try to link CDF information automatically.
}
\value{
  a \code{character} with the name of the CDF
}
\seealso{\code{getInfoInAffyFile}, \code{read.celfile}}

\keyword{manip}


\eof
\name{xy2indices}
\alias{xy2indices}
\alias{indices2xy}
\title{ Functions to convert indices to x/y (and reverse)}
\description{
  Functions to convert indices to x/y (and reverse)
}
\usage{
xy2indices(x, y, nr = NULL, cel = NULL, abatch = NULL, xy.offset = NULL)
indices2xy(i, nr = NULL, cel = NULL, abatch = NULL, xy.offset = NULL)
}
\arguments{
  \item{x}{ \code{X} position for the probes }
  \item{y}{ \code{Y} position for the probes }
  \item{i}{ indices in the \code{AffyBatch} for the probes }
  \item{nr}{ total number of \code{Xs} on the chip }
  \item{cel}{ a corresponding object of class \code{\link[affy:Cel-class]{Cel}} }
  \item{abatch}{ a corresponding object of class
    \code{\link[affy:AffyBatch-class]{AffyBatch}} }
  \item{xy.offset}{an eventual offset for the XY coordinates. See Details}
}
\details{
  The probes intensities for given probe set ids are extracted from an
  \code{AffyBatch} object using the indices stored in the corresponding
  \code{cdfenv}.

  The parameter \code{xy.offset} is there for compatibility.
  For historical reasons, the xy-coordinates for the features
  on Affymetrix chips were decided to start at 1 (one) rather than 0
  (zero). One can set the offset to 1 or to 0. Unless the you \_really\_
  know what you are doing, it is advisable to let it at the default
  value \code{NULL}. This way the package-wide option code{xy.offset} is
  always used.
}
\value{
  A vector of indices or a two-columns matrix of Xs and Ys. 
}
\author{ L. }
\warnings{ Even if one _really_ knows what is going on, playing with the
  parameter \code{xy.offset} could be risky. Changing the package-wide
  option \code{xy.offset} appears much more sane.}
\seealso{\code{\link{indexProbes}}}
\examples{
data(affybatch.example)

pm.i <- indexProbes(affybatch.example, which="pm", genenames="AFFX-BioC-5_at")[[1]]
mm.i <- indexProbes(affybatch.example, which="mm", genenames="AFFX-BioC-5_at")[[1]]

pm.i.xy <- indices2xy(pm.i, abatch = affybatch.example)
mm.i.xy <- indices2xy(mm.i, abatch = affybatch.example)

image(affybatch.example[1], transfo=log2)
## plot the pm in red
plotLocation(pm.i.xy, col="red")
plotLocation(mm.i.xy, col="blue")


}
\keyword{ manip }

\eof
