\name{PLMset-class}
\docType{class}
\alias{PLMset-class}
\alias{PLMset}
\alias{weights<-}
\alias{coefs}
\alias{coefs<-}
\alias{se}
\alias{se<-}
\alias{coefs.probe}
\alias{coefs.const}
\alias{se.probe}
\alias{se.const}
\alias{Mbox}
\alias{normvec}
\alias{varcov}
\alias{residSE}
\alias{resid<-}
\alias{residuals<-}
\alias{indexProbesProcessed}
\alias{model.description}
\alias{sampleNames<-}
\alias{coefs,PLMset-method}
\alias{weights<-,PLMset-method}
\alias{weights,PLMset-method}
\alias{coefs<-,PLMset-method}
\alias{se,PLMset-method}
\alias{se<-,PLMset-method}
\alias{coefs.probe,PLMset-method}
\alias{coefs.const,PLMset-method}
\alias{se.probe,PLMset-method}
\alias{se.const,PLMset-method}
\alias{Mbox,PLMset-method}
\alias{image,PLMset-method}
\alias{show,PLMset-method}
\alias{boxplot,PLMset-method}
\alias{getCdfInfo,PLMset-method}
\alias{indexProbes,PLMset,character-method}
\alias{cdfName,PLMset-method}
\alias{normvec,PLMset-method}
\alias{resid,PLMset-method}
\alias{residuals,PLMset-method}
\alias{resid<-,PLMset-method}
\alias{residuals<-,PLMset-method}
\alias{residSE,PLMset-method}
\alias{varcov,PLMset-method}
\alias{indexProbesProcessed,PLMset-method}
\alias{model.description,PLMset-method}
\alias{summary,PLMset-method}
\alias{sampleNames<-,PLMset-method}


\title{Class PLMset}
\description{This is a class representation for Probe level Linear
  Models fitted to Affymetrix GeneChip probe level data.}
\section{Objects from the Class}{
  Objects can be created using the function \code{\link{fitPLM}}}
\section{Slots}{
  \describe{
    \item{\code{probe.coefs}:}{Object of class "matrix". Contains model
      coefficients related to probe effects}
    \item{\code{se.probe.coefs}:}{Object of class "matrix". Contains
      standard error estimates for the probe coefficients}  
    \item{\code{chip.coefs}:}{Object of class "matrix". Contains model
      coefficients related to chip (or chip level) effects for each fit.}
    \item{\code{se.chip.coefs}:}{Object of class "matrix". Contains
      standard error estimates for the chip coefficients}
    \item{\code{model.description}:}{Object of class "character". This
      string describes the probe level model fitted.}
    \item{\code{weights}:}{Object of class "matrix". Contains probe
      weights for each fit. The matrix has columns for chips and rows
      are probes}
    \item{\code{phenoData}:}{Object of class "phenoData" This is an
      instance of class \code{phenoData} 
      containing the patient (or case) level data. The columns of the
      pData slot of this entity represent
      variables and the rows represent patients or cases. }
    \item{\code{annotation}}{A character string identifying the
      annotation that may be used for the \code{exprSet} instance.}
    \item{\code{description}:}{Object of class "MIAME". For
      compatibility with previous version of this class description can
      also be a "character". The class \code{characterOrMIAME} has been
      defined just for this.}
    \item{\code{cdfName}:}{A character string giving the name of the
      cdfFile}
    \item{\code{nrow}:}{Object of class "numeric". Number of rows in chip}
    \item{\code{ncol}:}{Object of class "numeric". Number of cols in chip}
    \item{\code{notes}:}{Object of class "character" Vector of
      explanatory text }
    \item{\code{varcov}:}{Object of class "list". A list of
      variance/covariance matrices}
    \item{\code{residualSE}:}{Object of class "matrix". Contains residual
      standard error and df}
    \item{\code{residuals}:}{Object of class "matrix". Contains
      residuals from model fit (if stored)}
  }
}
\section{Extends}{
Class \code{"exprSet"}, directly.
}
\section{Methods}{
  \describe{
    \item{weights<-}{\code{signature(object = "PLMset")}: replaces the weights }
    \item{weights}{\code{signature(object = "PLMset")}: extracts the
      model fit weights}
    \item{coefs<-}{\code{signature(object = "PLMset")}: replaces the
      chip coefs.  }
    \item{coefs}{\code{signature(object = "PLMset")}: extracts the
      chip coefs. }
    \item{se}{\code{signature(object = "PLMset")}: extracts the
      standard error estimates of the chip coefs. }
    \item{se<-}{\code{signature(object = "PLMset")}: replaces the
      standard error estimates of the chip coefs. }
    \item{coefs.probe}{\code{signature(object = "PLMset")}: extracts the
      probe coefs. }
    \item{se.probe}{\code{signature(object = "PLMset")}: extracts the standard error estimates of the probe coefs. }    
    \item{coefs.const}{\code{signature(object = "PLMset")}: extracts the
      intercept coefs. }
    \item{se.const}{\code{signature(object = "PLMset")}: extracts the standard error estimates of the intercept coefs. }
    \item{getCdfInfo}{\code{signature(object = "PLMset")}: retrieve
      the environment that defines the location of probes by probe set. }
    \item{image}{\code{signature(x = "PLMset")}: creates an
      image of the robust linear model fit weights for
      each sample.}
    \item{indexProbes}{\code{signature(object = "PLMset", which =
	"character")}: returns a list with locations of the probes in
      each probe  set. The list names defines the probe set
      names. \code{which} can be "pm", "mm", or "both". If "both" then
      perfect match locations are given followed by mismatch locations.}
    \item{Mbox}{\code{signature(object = "PLMset")}: gives a boxplot of
      M's for each chip. The M's are computed relative to a "median"
      chip.}
    \item{normvec}{will return the normalization vector (if it has been
      stored)}
    \item{residSE}{will return the residual SE (if it has been stored)}
 }
}
\note{This class is better described in the vignette.}

\author{B. M. Bolstad \email{bolstad@stat.berkeley.edu}}


\examples{
}

\keyword{classes}

\eof
\name{PLMset2exprSet}
\alias{PLMset2exprSet}
\alias{pset2eset}
\title{Convert a PLMset to an exprSet}
\description{
  This function converts a PLMset to an exprSet. This is often useful
  since many Bioconductor functions operate on exprSet objects.
}
\usage{
PLMset2exprSet(pset)
pset2eset(pset)
}

\arguments{
  \item{pset}{The \code{\link{PLMset}} to convert to \code{\link[Biobase]{exprSet}}}
}
\details{
  These functions convert  PLMset objects to exprSet objects. This is often useful
  since many Bioconductor functions operate on exprSet objects. Note
  that the finction \code{pset2eset} is a wrapper for \code{PLMset2exprSet}.
}

\value{
  returns a \code{\link[Biobase]{exprSet}}
  }



\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link[Biobase]{exprSet}}}

\examples{
data(affybatch.example)
Pset <- fitPLM(affybatch.example)
eset <- pset2eset(Pset)
}
\keyword{manip}

\eof
\name{internal functions}

\alias{bg.correct.shift}
\alias{bg.correct.stretch}

\title{Internal AffyExtensions functions}

\description{Internal AffyExtensions functions}

\details{These are not to be called by the user and/or are undergoing testing}

\keyword{internal}

\eof
\name{bg.correct.LESN}
\alias{bg.correct.LESN}
\title{LESN - Low End Signal is Noise Background corrections}
\description{
  This function background corrects PM probe data using LESN - Low End
  Signal is Noise concepts.
}
\usage{
bg.correct.LESN(object,method = 2,baseline = 0.25, theta=4)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{an \code{\link[affy]{AffyBatch}}}
  \item{method}{an integer code specifying which method to use}
  \item{baseline}{A baseline value to use}
  \item{theta}{A parameter used in the background correction process}
}
\details{
  This method will be more formally documented at a later date.

  The basic concept is to consider that the lowest end of intensites is
  most likely just noise (and should be heavily corrected) and the
  highest end signals are most likely signal and should have little
  adjustment. Low end signals are made much smaller while high end
  signals get less adjustment relative adjustment.
}
\value{
An \code{\link[affy]{AffyBatch}}
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\examples{
data(affybatch.example)
affybatch.example.bgcorrect <- bg.correct.LESN(affybatch.example)
}
\keyword{manip}


\eof
\name{fitPLM}
\alias{fitPLM}
\title{Fit a Probe Level Model to Affymetrix Genechip Data.}
\description{
  This function converts an \code{\link[affy]{AffyBatch}} into an
  \code{\link{PLMset}} by fitting a specified robust linear model to the
  probe level data}
}
\usage{
fitPLM(object,model=PM ~ -1 + probes +samples,
variable.type=c(default="factor"),
constraint.type=c(default="contr.treatment"),
background=TRUE, normalize=TRUE, background.method = "RMA.2",normalize.method = "quantile",background.param=list(),normalize.param=list(),output.param=list(),model.param=list())
}

\arguments{
  \item{object}{an \code{\link[affy]{AffyBatch}}}
  \item{model}{A formula describing the model to fit. This is slightly
    different from the standard method of specifying formulae in R. Read
    the description below}
  \item{variable.type}{a way to specify whether variables in the model
    are factors or standard variables}
  \item{constraint.type}{should factor variables sum to zero or have
    first variable set to zero (endpoint constraint)}
  \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{background}{logical value. If \code{TRUE} background correct
    using RMA background correction}
  \item{background.method}{name of background method to use.}
  \item{normalize.method}{name of normalization method to use.}
  \item{background.param}{A list of parameters for background routines}
  \item{normalize.param}{A list of parameters for normalization
    routines}
  \item{output.param}{A list of parameters controlling optional output
    from the routine.}
  \item{model.param}{A list of parameters controlling model procedure}
}
\details{
  This function fits robust Probe Level Linear models to all the probesets in
  an \code{\link[affy]{AffyBatch}}.
}
\value{
  An \code{\link{PLMset}}
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\references{Under Preparation}
\seealso{\code{\link[affy]{express}},\code{\link[affy]{expresso}},
  \code{\link[affy]{rma}}, \code{\link{threestep}}}

\examples{
data(affybatch.example)
Pset <- fitPLM(affybatch.example,model=PM ~ -1 + probes + samples)
se(Pset)[1:5,]


# A larger example testing weight image function
data(Dilution)
Pset <- fitPLM(Dilution,model=PM ~ -1 + probes + samples)
image(Pset)
boxplot(Pset)

#now lets try a wider class of models
Pset <- fitPLM(Dilution,model=PM ~ -1 + probes +liver,normalize=FALSE,background=FALSE)
coefs(Pset)[1:10,]

Pset <- fitPLM(Dilution,model=PM ~ -1 + probes + liver + scanner,normalize=FALSE,background=FALSE)
coefs(Pset)[1:10,]

#try liver as a covariate
logliver <- log2(c(20,20,10,10))
Pset <- fitPLM(Dilution,model=PM~-1+probes+logliver+scanner,normalize=FALSE,background=FALSE,variable.type=c(logliver="covariate"))
coefs(Pset)[1:10,]


#try a different se.type
Pset <- fitPLM(Dilution,model=PM~-1+probes+scanner,normalize=FALSE,background=FALSE,model.param=list(se.type=2))
se(Pset)[1:10,]
Pset <- fitPLM(Dilution,model=PM~-1+probes+scanner,normalize=FALSE,background=FALSE,model.param=list(se.type=3))
se(Pset)[1:10,]
}

\keyword{manip}


\eof
\name{normalize.exprSet}
\alias{normalize.exprSet.quantiles}
\alias{normalize.exprSet.loess}
\alias{normalize.exprSet.contrasts}
\alias{normalize.exprSet.qspline}
\alias{normalize.exprSet.invariantset}
\alias{normalize.exprSet.scaling}
\alias{normalize.exprSet.methods}

\title{Normalization applied to exprSets}
\description{
  Allows the user to apply normalization routines to exprSets.
}
\usage{
  normalize.exprSet.quantiles(eset,transfn=c("none","log","antilog"))
  normalize.exprSet.loess(eset,transfn=c("none","log","antilog"),...)
  normalize.exprSet.contrasts(eset, span = 2/3, choose.subset = TRUE, subset.size = 5000, verbose = TRUE, family = "symmetric",transfn=c("none","log","antilog"))
  normalize.exprSet.qspline(eset,transfn=c("none","log","antilog"),...)
  normalize.exprSet.invariantset(eset,prd.td = c(0.003, 0.007),verbose=FALSE,transfn=c("none","log","antilog"),baseline.type=c("mean","median","pseudo-mean","pseudo-median"))
normalize.exprSet.scaling(eset,trim=0.02,baseline=-1,transfn=c("none","log","antilog"))
}
\arguments{
  \item{eset}{An \code{\link[Biobase:exprSet-class]{exprSet}}}
  \item{span}{parameter to be passed to the function \code{\link[modreg]{loess}}.}
  \item{choose.subset}{}
  \item{subset.size}{}
  \item{verbose}{verbosity flag}
  \item{family}{parameter to be passed to the function
    \code{\link[modreg]{loess}}.}
  \item{prd.td}{cutoff parameter (details in the bibliographic
    reference)}
  \item{trim}{How much to trim from the top and bottom before computing
    the mean when using the scaling normalization}
  \item{baseline}{Index of array to use as baseline, negative values
    (-1,-2,-3,-4) control different baseline selection methods}
  \item{transfn}{Transform the exprSet before normalizing. Useful when
    dealing with expression values that are log-scale}
  \item{baseline.type}{A method of selecting the baseline array}
  \item{...}{Additional parameters that may be passed to the
    normalization routine}
  
}
\details{
  This function carries out normalization of expression values. In
  general you should either normalize at the probe level or at the
  expression value level, not both.

  Typing \code{normalize.exprSet.methods} should give you a list of
  methods that you may use. note that you can also use the
  \code{normalize} function on exprSets. Use \code{method} to select the
  normalization method.
}

\value{
  A normalized \code{\link[Biobase:exprSet-class]{exprSet}}.
}

\examples{
data(affybatch.example)
eset <- rma(affybatch.example,normalize=FALSE,background=FALSE)
normalize(eset)
}


\author{Ben Bolstad, \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link[affy]{normalize}}}

\keyword{manip}

\eof
\name{normalize.quantiles.probeset}
\alias{normalize.AffyBatch.quantiles.probeset}
\title{Quantile Normalization applied to probesets}
\description{
  Using a normalization based upon quantiles, this function
  normalizes a matrix of probe level intensities.
}
\usage{
  normalize.AffyBatch.quantiles.probeset(abatch,type=c("separate","pmonly","mmonly","together"),use.median=FALSE,use.log=TRUE)
}
\arguments{
  \item{abatch}{An \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{type}{how should MM and PM values be handled}
  \item{use.median}{use median rather than mean}
  \item{use.log}{take logarithms, then normalize}
}
\details{
  This function applies the \link[affy:normalize.quantiles]{quantile} method in a probeset specific manner.

  In particular a probeset summary is normalized using the quantile
  method and then the probes adjusted accordingly.

}

\value{
  A normalized \code{AffyBatch}.
}
\references{
  Bolstad, B (2001) \emph{Probe Level Quantile Normalization of High Density
    Oligonucleotide Array Data}. Unpublished manuscript
  \url{http://oz.berkeley.edu/~bolstad/stuff/qnorm.pdf}

  Bolstad, B. M., Irizarry R. A., Astrand, M, and Speed, T. P. (2003)
  \emph{A Comparison of Normalization Methods for High Density
    Oligonucleotide Array Data Based on Bias and Variance.}
   Bioinformatics 19(2) ,pp 185-193. \url{http://www.stat.berkeley.edu/~bolstad/normalize/normalize.html}
  }

\author{Ben Bolstad, \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link[affy]{normalize}},\code{\link[affy:normalize.quantiles]{normalize.quantiles}}}

\keyword{manip}

\eof
\name{normalize.scaling}
\alias{normalize.scaling}
\alias{normalize.AffyBatch.scaling}

\title{Scaling normalization}
\description{
  Allows the user to apply scaling normalization.
}
\usage{
normalize.scaling(X,trim=0.02,baseline=-1)
normalize.AffyBatch.scaling(abatch,type=c("together","pmonly","mmonly","separate"),trim=0.02,baseline=-1)
}
\arguments{
  \item{X}{A matrix. The columns of which are to be normalized}
  \item{abatch}{An \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{type}{A parameter controlling how normalization is applied to
    the Affybatch}
  \item{trim}{How much to trim from the top and bottom before computing
    the mean when using the scaling normalization}
  \item{baseline}{Index of array to use as baseline, negative values
    (-1,-2,-3,-4) control different baseline selection methods}
  
}
\details{
  These function carries out scaling normalization of expression values.
}

\value{
  A normalized \code{\link[Biobase:exprSet-class]{exprSet}}.
}

\examples{
data(affybatch.example)
normalize.AffyBatch.scaling(affybatch.example)
}


\author{Ben Bolstad, \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link[affy]{normalize}}}

\keyword{manip}

\eof
\name{pseudo.coloring}
\alias{pseudoColorBar}
\alias{pseudoPalette}
\title{Coloring pseudo chip images}
\description{
  These are routines used for coloring pseudo chip images.
}
\usage{
  pseudoPalette(low = "white", high = c("green", "red"), mid = NULL,k =50) 
  pseudoColorBar(x, horizontal = TRUE, col = heat.colors(50), scale = 1:length(x),k = 11, log.ticks=FALSE,...)
  
}
\arguments{
  \item{low}{color at low end of scale}
  \item{high}{color at high end of scale}
  \item{mid}{color at exact middle of scale}
  \item{k}{number of colors to have}
  \item{x}{A data series}
  \item{horizontal}{If \code{TRUE} then color bar is to be draw
    horizontally}
  \item{col}{colors for color bar}
  \item{scale}{tickmarks for \code{x} if \code{x} is not numeric}
  \item{log.ticks}{use a log type transformation to assign the colors}
  \item{...}{additional parameters to plotting routine}
}

\details{
  Adapted from similar tools in maPlots pacakge.
}



\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\seealso{\code{\link[affy:AffyBatch-class]{AffyBatch}}, \code{\link[affy:read.affybatch]{read.affybatch}}}

\examples{

}
\keyword{manip}

\eof
\name{rmaPLM}
\alias{rmaPLM}
\title{Fit a RMA to Affymetrix Genechip Data as a PLMset}
\description{
  This function converts an \code{\link[affy]{AffyBatch}} into an
  \code{\link{PLMset}} by fitting a multichip model. In particular we
  concentrate on the RMA model.}
}
\usage{
rmaPLM(object,normalize=TRUE,background=TRUE,background.method="RMA.2",normalize.method="quantile",background.param = list(),normalize.param=list(),output.param=list(),model.param=list())
}

\arguments{
  \item{object}{an \code{\link[affy]{AffyBatch}}}
  \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{background}{logical value. If \code{TRUE} background correct
    using RMA background correction}
  \item{background.method}{name of background method to use.}
  \item{normalize.method}{name of normalization method to use.}
  \item{background.param}{A list of parameters for background routines}
  \item{normalize.param}{A list of parameters for normalization
    routines}
  \item{output.param}{A list of parameters controlling optional output
    from the routine.}
  \item{model.param}{A list of parameters controlling model procedure}
}
\details{
  This function fits the RMA as a Probe Level Linear models to all the probesets in
  an \code{\link[affy]{AffyBatch}}.
}
\value{
  An \code{\link{PLMset}}
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\references{Under Preparation}
\seealso{\code{\link[affy]{express}},\code{\link[affy]{expresso}},
  \code{\link[affy]{rma}}, \code{\link{threestep}}},\code{\link{fitPLM}}}

\examples{
# A larger example testing weight image function
data(Dilution)
Pset <- rmaPLM(Dilution,output.param=list(weights=TRUE))
image(Pset)
}

\keyword{manip}

\eof
\name{threestep}
\alias{threestep}
\title{Three Step expression measures}
\description{
  This function converts an \code{\link[affy]{AffyBatch}} into an
  \code{\link[Biobase]{exprSet}} using
 a three step expression measure.
}
\usage{
threestep(object,subset=NULL, verbose=TRUE, normalize=TRUE,background=TRUE,background.method="RMA.2",normalize.method="quantile",summary.method="median.polish",background.param = list(),normalize.param=list(),summary.param=list())
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{subset}{an indexing vector with the the probe sets to be
    converted to expression. (not currently implemented)}
  \item{verbose}{logical value. If \code{TRUE} it writes out some messages. (Curently ignored)}
  \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{background}{logical value. If \code{TRUE} background correct
    using RMA background correction}
  \item{background.method}{name of background method to use.}
  \item{normalize.method}{name of normalization method to use.}
  \item{summary.method}{name of summary method to use.}
  \item{background.param}{list of parameters for background correction methods}
  \item{normalize.param}{list of parameters for normalization methods}
  \item{summary.param}{list of parameters for summary methods}
	    
}
\details{
  This function computes the expression measure using threestep methods.
}
\value{
An \code{\link[Biobase]{exprSet}}
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\references{Irizarry et al. Biostatistics 2003}
\seealso{\code{\link[affy]{express}},\code{\link[affy]{expresso}}, \code{\link[affy]{rma}}}

\examples{
data(affybatch.example)

# should be equivalent to rma()
eset <- threestep(affybatch.example)

# Using Tukey Biweight summarization
eset <- threestep(affybatch.example,summary.method="tukey.biweight")

# Using Average Log2 summarization
eset <- threestep(affybatch.example,summary.method="average.log")

# Using IdealMismatch background and Tukey Biweight and no normalization.
eset <- threestep(affybatch.example,normalize=FALSE,background.method="IdealMM",summary.method="tukey.biweight")

# Using average.log summarization and no background or normalization.
eset <- threestep(affybatch.example,background=FALSE,normalize=FALSE,background.method="IdealMM",summary.method="tukey.biweight")

# Use threestep methodology with the rlm model fit
eset <- threestep(affybatch.example,summary.method="rlm")

# Use threestep methodology with the log of the average
eset <- threestep(affybatch.example,summary.method="log.average")

# Use threestep methodology with log 2nd largest method
eset <- threestep(affybatch.example,summary.method="log.2nd.largest")

eset <- threestep(affybatch.example,background.method="LESN2")
}
\keyword{manip}


\eof
\name{threestepPLM}
\alias{threestepPLM}
\title{Three Step expression measures returned as a PLMset}
\description{
  This function converts an \code{\link[affy]{AffyBatch}} into an
  \code{\link{PLMset}} using a three step expression measure.
}
\usage{
threestepPLM(object, normalize=TRUE,background=TRUE,background.method="RMA.2",normalize.method="quantile",summary.method="median.polish",background.param = list(),normalize.param=list(),output.param=list(), model.param=list())
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{an \code{\link[affy:AffyBatch-class]{AffyBatch}}}
  \item{normalize}{logical value. If \code{TRUE} normalize data using
    quantile normalization}
  \item{background}{logical value. If \code{TRUE} background correct
    using RMA background correction}
  \item{background.method}{name of background method to use.}
  \item{normalize.method}{name of normalization method to use.}
  \item{summary.method}{name of summary method to use.}
  \item{background.param}{list of parameters for background correction methods}
  \item{normalize.param}{list of parameters for normalization methods}
  \item{output.param}{list of parameters for output methods}
  \item{model.param}{list of parameters for model methods}
}
\details{
  This function computes the expression measure using threestep
  methods. It returns a \code{\link{PLMset}}. The most important
  difference is that the PLMset allows you to access the residuals
  which the \code{\link{threestep}} function does not do.
}
\value{
An \code{\link{PLMset}}
}

\author{Ben Bolstad \email{bolstad@stat.berkeley.edu}}

\references{Under preparation}
\seealso{\code{\link[affy]{express}},\code{\link[affy]{expresso}},
  \code{\link[affy]{rma}}, \code{\link{threestep}}}

\examples{
data(affybatch.example)

# should be equivalent to rma()
eset <- threestepPLM(affybatch.example)
}
\keyword{manip}


\eof
