### Name: fitPLM
### Title: Fit a Probe Level Model to Affymetrix Genechip Data.
### Aliases: fitPLM
### Keywords: manip

### ** Examples

data(affybatch.example)
Pset <- fitPLM(affybatch.example,model=PM ~ -1 + probes + samples)
se(Pset)[1:5,]

# A larger example testing weight image function
data(Dilution)
Pset <- fitPLM(Dilution,model=PM ~ -1 + probes + samples)
image(Pset)
boxplot(Pset)

#now lets try a wider class of models
Pset <- fitPLM(Dilution,model=PM ~ -1 + probes +liver,normalize=FALSE,background=FALSE)
coefs(Pset)[1:10,]

Pset <- fitPLM(Dilution,model=PM ~ -1 + probes + liver + scanner,normalize=FALSE,background=FALSE)
coefs(Pset)[1:10,]

#try liver as a covariate
logliver <- log2(c(20,20,10,10))
Pset <- fitPLM(Dilution,model=PM~-1+probes+logliver+scanner,normalize=FALSE,background=FALSE,variable.type=c(logliver="covariate"))
coefs(Pset)[1:10,]

#try a different se.type
Pset <- fitPLM(Dilution,model=PM~-1+probes+scanner,normalize=FALSE,background=FALSE,model.param=list(se.type=2))
se(Pset)[1:10,]
Pset <- fitPLM(Dilution,model=PM~-1+probes+scanner,normalize=FALSE,background=FALSE,model.param=list(se.type=3))
se(Pset)[1:10,]



