### Name: plotvalGenome.func
### Title: clustering and heatmap
### Aliases: plotvalGenome.func plotvalChrom.func plotValGenome
###   plotValChrom plotChrom
### Keywords: hplot cluster

### ** Examples
 
data(colorectal)

#cluster all samples using imputed data on all chromosomes (autosomes and X):

plotvalGenome.func(colorectal)

#cluster samples within sex groups based on 3 chromosomes individually. 
#use non-imputed data and  do not show dendogram. Indicate amplifications and 
#homozygous deletions.

plotvalGenome.func(colorectal, response = phenotype(colorectal)$sex,
                   byclass = TRUE, showaber = TRUE, vecchrom = c(4,8,9),
                   dendPlot = FALSE, imp = FALSE)

#cluster samples based on each chromosome individualy and display age. Show
#gains in red and losses in green. Show aberrations and use values < -1
#to identify homozgous deletions. Do not show dendogram.

pdf("plotimages.pdf", width = 11, height = 8.5)
for (i in 1:23)
    plotvalGenome.func(colorectal,
                       response = phenotype(colorectal)$age,
                       chrominfo = human.chrom.info.Jul03,
                       cutoff = 1, ncolors = 50, lowCol="green",
                       highCol="red", midCol="black", byclass = FALSE,
                       showaber = TRUE, homdel = -1, vecchrom = i,
                       titles = "Image Plot", methodS = "ward",
                       dendPlot = FALSE, categoricalPheno = FALSE)
dev.off()




